# scopes.py

`scopes.py` is a script that takes ibnetdiscover utility output and generates 'full' scope_info file (i.e. file containing all compute nodes).
The only required argument is a filename containing ibnetdiscover output (or - to use stdin).
`-f` switch sets filename fo the full scope_info file (or print to stdout if omitted).

scope_info file will contain one scope for every TOR switch (which is a switch having at least 4 nodes connected) and all nodes connected to that switch
will be in that scope.

If `-d <filename>` switch is given, additional file will be created. That file will contain distances (in number of links) between all pairs of TOR switches.
WARNING! Calculating distances may be long (tens of minutes) for large networks.

If `-o <filename>` switch is given, the script creates order_info file which can be used as input to ClusterKit. This order_info file instructs ClusterKit to perform one test
for scopes corresponding to TOR switches with distance of 2 InfiniBand links, one test for distance 4, etc. (if the topology is not FatTree, odd distances will be included too).

If `-a` switch is given, the script will generate order_info file using all possible pairs of TOR switches, creating as many runs as needed, instead of one set per distance.

If `-t <topofile>` is given, the script will extract topology data (essentialy an oversubscription ratio for every TOR switch) and write it to file <topofile>.

# run_scopes.sh

`run_scopes.sh` is a wrapper script around `scopes.py`. It accepts the same cli arguments as `scopes.py`. Additionally it may accept `-i <args>` switch instead of
ibnetdiscover output filename. In this case it runs ibnetdiscover with the given args and passes its output to the `scopes.py` script.
