#!/usr/bin/bash
 
HPCX_DIR=$HPCX_DIR
HOSTFILE=$HPCX_DIR/clusterkit/hostfile.txt
CK_DIR=$HPCX_DIR/clusterkit
 
 
hcas=( 0 1 2 3 6 7 8 9 )
 
declare -A hca_name
 
hca_name["0"]=mlx5_0
hca_name["1"]=mlx5_1
hca_name["2"]=mlx5_2
hca_name["3"]=mlx5_3
hca_name["6"]=mlx5_6
hca_name["7"]=mlx5_7
hca_name["8"]=mlx5_8
hca_name["9"]=mlx5_9
 
mpi_opt+="-x CK_OUTPUT_SUBDIR -x CLUSTERKIT_HCA"
DATE=$(date "+%Y%m%d_%H%M%S")
CK_DATE_DIR=$CK_DIR/$DATE
 
 
for i in "${hcas[@]}"; do
    device=${hca_name[${i}]}
    export CK_OUTPUT_SUBDIR=${CK_DATE_DIR}_${device}
    export HCA_TAG=${device}
 
    export CLUSTERKIT_HCA=$i
    $CK_DIR/bin/clusterkit.sh --mpi_opt "$mpi_opt" -r $HPCX_DIR -f $HOSTFILE --mapper $CK_DIR/bin/core_to_hca_dgx100.sh --exe_opt "-d bw -d lat --unidirectional " # --biters=200
done
