#!/usr/bin/bash

# map DGX1 HCA to core, so that processes have affinity to the HCA they are assigned.
# Assume we only run # of ranks that corresponds to the number of HCAs

# cat  /sys/class/infiniband/mlx5_*/device/local_cpulist
# 0-19,40-59
# 0-19,40-59
# 20-39,60-79
# 20-39,60-79


case $OMPI_COMM_WORLD_LOCAL_RANK in
      0) core=0,40;    export UCX_NET_DEVICES=mlx5_0:1 ;;
      1) core=1,41;    export UCX_NET_DEVICES=mlx5_1:1 ;;
      2) core=20,60;   export UCX_NET_DEVICES=mlx5_2:1 ;;
      3) core=21,61;   export UCX_NET_DEVICES=mlx5_3:1 ;;
esac

      taskset -c $core $*

