/*
 * SPDX-FileCopyrightText: Copyright (c) 2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: LicenseRef-NvidiaProprietary
 *
 * This software is available to you under a choice of one of two
 * licenses.  You may choose to be licensed under the terms of the GNU
 * General Public License (GPL) Version 2, available from the file
 * COPYING in the main directory of this source tree, or the
 * OpenIB.org BSD license below:
 *
 *     Redistribution and use in source and binary forms, with or
 *     without modification, are permitted provided that the following
 *     conditions are met:
 *
 *      - Redistributions of source code must retain the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer.
 *
 *      - Redistributions in binary form must reproduce the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

#pragma once

#include "csv_parser.h"
#include "fabric_graph.h"
#include "file_parser_fabric_abs.h"

using VecFabricFileParserPtr = std::vector<std::unique_ptr<FileParserFabricAbs>>;

class FilesParserManager
{
    FabricGraph m_fabric_graph_;
    pthread_t m_parser_thread_;

    VecFabricFileParserPtr m_fabric_file_parser_vec;

   public:
    // Constructor
    FilesParserManager(CommandManager* command_manager_ptr) : m_fabric_graph_(command_manager_ptr), m_parser_thread_(0) {}

    // destructor
    ~FilesParserManager();

    FabricGraph& GetFabricGraph() { return m_fabric_graph_; }

    int Start();

    CsvParser m_csv_parser;

   private:
    static void* MainLoop(void* p_parser);
    int CreateFileParsers();
};
