# IBDIAGNET 2.19

&copy; Copyright 2022-2024, NVIDIA CORPORATION & AFFILIATES. All Rights Reserved.

October 2024

Packages:

| Package       | Version |
| ------------- | ------- |
| Mellanox OFED | 24.10   |
| DOCA-HOST     | 2.9.0   |
| UFM           | 6.19.x  |

## Main features

- Support XDR
- Automatic validation of SM configuration on HCAs
- Fetch Port Receive Data Histogram



## XDR Limitation

- DF+ topology validation doesn't supported
- Rail validation doesn't supported
- Auto scope builder doesn't supported
- Unhealthy port reporting doesn't supported



## Changes

- Excluded special ports from  PortGeneralCounters fetch
- Disabled BER validation for XDR devices (all devices of 5nm)
- Updated Physical Hierarchy Info (Template GUID 0x01)



## Changes in command line parameters

### ibdiagnet

| Parameter name    | Values             | Status          | Description                                                  |
| :---------------- | ------------------ | --------------- | ------------------------------------------------------------ |
| `--ls`            | 200                | Added new value | Specifies the expected link speed 200 for XDR                |
| `--skip`          | hca_cfg_check      | Added new value | Skip the report of automatic validation of SM configuration on HCAs |
| `--m_key_files`   |                    | Deprecated*     | See --security_keys                                          |
| `--pm_key_file`   |                    | Deprecated*     | See --security_keys                                          |
| `--vs_key_file`   |                    | Deprecated*     | See --security_keys                                          |
| `--cc_key_file`   |                    | Deprecated*     | See --security_keys                                          |
| `--m2n_key_file`  |                    | Deprecated*     | See --security_keys                                          |
| `--security_keys` | `<path to folder>` | New             | Specifies the path to the directory with the key files (guid2lid, guid2mkey, neighbors, guid2vskey, guid2cckey, guid2_m2n_key, guid2_pm_key) |





## Bug fixes

- Fix HCA selection by the "Auto Scope Builder" (--host_file & --node_descr_filter)



# IBDIAGNET 2.18

&copy; Copyright 2022-2024, NVIDIA CORPORATION & AFFILIATES. All Rights Reserved.

July 2024

Packages:

| Package       | Version |
| ------------- | ------- |
| Mellanox OFED | 24.07   |
| UFM           | 6.18.x  |

## Main features

- Fetch Chassis Info
- Fetch Queue Depth Histograms
- Fetch Port General Counters (ICRC Payload Corruption Detection)




### PHY plugin

- Updated 7nm registers
- Updated 5nm registers
- Updated PPCNT registers
- Updated MPCNT registers
- Updated PDDR registers



## Changes

- Removed deprecated command line options

  



## Changes in command line parameters

### ibdiagnet

| Parameter name  | Values                        | Status  | Description               |
| :-------------- | ----------------------------- | ------- | ------------------------- |
| `--fec_mode`    |                               | Removed | Deprecated                |
| `--deep_help`   |                               | Removed | Deprecated                |
| `--routers`     |                               | Removed | Deprecated                |
| `--enable_spst` |                               | Removed | Deprecated                |
| `--skip`        | `<[vs_cap_smp] [vs_cap_gmp]>` | Changed | Removed deprecated values |



## Bug fixes

- Fixed PortVLXmitTimeCongExt counter fetch
- Fixed FLIDs validation
- Fixed Unhealthy reporting mode
- Fixed dump dv_csv sections when scope exist





# IBDIAGNET 2.17

&copy; Copyright 2022-2024, NVIDIA CORPORATION & AFFILIATES. All Rights Reserved.

April 2024

Packages:

| Package       | Version |
| ------------- | ------- |
| Mellanox OFED | 24.04   |
| UFM           | 6.17.x  |

## Main features

- Support NVLink5 MADs
- Support compression ratio for FLIDs
- Support PFRN for FLIDs
- Enabled PRTL registers for calculation cable length
- Support auto build scope by hosts list (--host_file & --node_descr_filter)




### PHY plugin

- Support MPCNT register
- Allowed MRCS register for HCAs



## Changes

- Deprecated and removed ibdiagpath

  


## Changes in command line parameters

### ibdiagnet

| Parameter name        | Values | Status | Description                                                  |
| :-------------------- | ------ | ------ | ------------------------------------------------------------ |
| `--host_file`         |        | New    | Specifies a file of hosts to be applied for a scope.         |
| `--node_descr_filter` |        | New    | (if --host_file option selected) regular expression to filter HCA nodes taken from the host file.<br/>To be applied to HCAs node descriptions. |
|                       |        |        |                                                              |

## Bug fixes

- Fixed issue related to the execute from switches
- Fixed issue with multiple CC counters fetch
- Fixed PEMI register handling
- Fixed SLRIP register
- Fixed PDDR registers layouts





# IBDIAGNET 2.16

&copy; Copyright 2022-2024, NVIDIA CORPORATION & AFFILIATES. All Rights Reserved.

January 2024

Packages:

| Package       | Version |
| ------------- | ------- |
| Mellanox OFED | 24.01   |
| UFM           | 6.16.x  |



### PHY plugin

- Support MRCS register
- Support PRTL register
- Updated PDDR register



### Cable plugin

- Reduced false-positive errors about invalid port in cable plugin for splitted switches.



## Changes

- Cable info fetch priority changed from cable plugin to phy plugin

  


## Changes in command line parameters

### ibdiagpath

| Parameter name | Values | Status | Description                                            |
| :------------- | ------ | ------ | ------------------------------------------------------ |
| `--lids_list`  |        | New    | Lids the utility will be using for creating scope file |
|                |        |        |                                                        |

## Bug fixes

- Fixed issue related to the execute from switches
- Fixed issue with multiple CC counters fetch



# IBDIAGNET 2.15

&copy; Copyright 2022-2023, NVIDIA CORPORATION & AFFILIATES. All Rights Reserved.

October 2023

Packages:

| Package       | Version |
| ------------- | ------- |
| Mellanox OFED | 23.10   |
| UFM           | 6.15.x  |

## Main features

- Support PPCNT InfiniBand General Counters

- Support DGX-H100 systems in Rail Validation

  


## Changes

- Report to the db_csv file if no BER threshold is found for a port

- SLRG register excluded from default PHY list 

- Updated MSPS register (added power_consumption field to the dump)

  

## Changes in command line parameters

### ibdiagnet

| Parameter name | Values | Status     | Description                                                  |
| :------------- | ------ | ---------- | ------------------------------------------------------------ |
| `--skip`       |        | Deprecated | vs_cap_smp & vs_cap_gmp values will be ignored.<br />SMP & GMP capabilities will be retrieve every time. |
|                |        |            |                                                              |

### ibdiagpath

| Parameter name       | Values | Status | Description                                                 |
| :------------------- | ------ | ------ | ----------------------------------------------------------- |
| `--adaptive_routing` |        | New    | Using adaptive routing tables to look up for possible paths |
|                      |        |        |                                                             |

## Bug fixes

- Fixed the issue related to loading the 'HWInfo.technology' field from a file.
- Removed 'PERF' records duplicates in the 'db_csv' file.



## Known issues

- Current version doesn't work on switches



# IBDIAGNET 2.14

&copy; Copyright 2022-2023, NVIDIA CORPORATION & AFFILIATES. All Rights Reserved.

July 2023

Packages:

| Package       | Version |
| ------------- | ------- |
| Mellanox OFED | 23.07   |
| UFM           | 6.14.x  |

## Main features

- Introduced a new report on PCI-E connectivity health, based on a comparison of enabled/active speed and width


## Changes

- Removed validation of transceiver firmware versions on the same cable
- Changed internal format of BER threshold table


## Bug fixes

- Addressed the problem with retrieving RX/TX Power fields in the cable report




# IBDIAGNET 2.13

&copy; Copyright 2022-2023, NVIDIA CORPORATION & AFFILIATES. All Rights Reserved.

Apr 2023

Packages:

| Package       | Version |
| ------------- | ------- |
| Mellanox OFED | 23.04   |
| UFM           | 6.13.x  |

## Main features

- "Fast Link Recovery" counters
- On Demand Paging (ODP) counters
- Reporting mismatch in cable FW versions
- Cable length reporting




## Changes

- Renamed "ARTrails" to "ARTrials" (typo error)
- Changed internal format of BER threshold table
- Separated & updated BER threshold values for HDR & NDR



## Changes in command line parameters

### ibdiagnet

| Parameter name    | Values | Status | Description                                                  |
| :---------------- | ------ | ------ | ------------------------------------------------------------ |
| `--fast_recovery` |        | New    | Activate new stage Fast Recovery.<br />Retrieve information about Fast Recovery configuration |
|                   |        |        |                                                              |



## Bug fixes

- Fixed: Crash in SHARP stage in case if one or more switches was reset





# IBDIAGNET 2.12

&copy; Copyright 2022-2023, NVIDIA CORPORATION & AFFILIATES. All Rights Reserved.

Jan 2023

Packages:

| Package       | Version |
| ------------- | ------- |
| Mellanox OFED | 5.9.x   |
| UFM           | 6.12.x  |

## Main features

- Fetching Programable Port Congestion Control counters  (PPCC)
- FLID support
- Support for "ad-hoc" trees for SHARP


## Changes

- Added: new dump file in format if iblinkinfo



## Changes in command line parameters

### ibdiagnet

| Parameter name | Values                       | Status  | Description                                                  |
| :------------- | ---------------------------- | ------- | ------------------------------------------------------------ |
| `--sharp_opt`  | `<[csc][dsc][dscp][ad_hoc]>` | Changed | Added new option:<br/> - [ad_hoc]: Indicates that SHARP support ad-hoc trees, avoid warnings for tree_id duplication in the fabric |
|                |                              |         |                                                              |



# IBDIAGNET 2.11

&copy; Copyright 2022, NVIDIA CORPORATION & AFFILIATES. All Rights Reserved.

October 2022

Packages:

| Package       | Version |
| ------------- | ------- |
| Mellanox OFED | 5.8.x   |
| UFM           | 6.11.x  |

## Main features

- Technical preview: Fetching Programable Port Congestion Control counters  (PPCC)
- Technical preview: FLID support
- Experimental feature: Sending GMP MADs from user-space (Kernel bypass)
- In-band auto-discovery for switch management IP. This feature is avaliable only in UFM package



### PHY plugin

- Support for IB cable/transceiver diagnostics: SNR and EOM (PEMI)



## Changes

- Added: ibdiagnet's runtime statistics (CPU utilization, Stage duration, MAD statistics)



## Changes in command line parameters

### ibdiagnet

| Parameter name | Values                    | Status       | Description                                                  |
| :------------- | ------------------------- | ------------ | ------------------------------------------------------------ |
| `--ppcc`       | `<filename|path|pattern>` | New          | This parameters enables fetching PPCC (Port Programable Congestion Control) counters. Possible values:<br/>\- File path: In this cases ibdiagnet loads from file PPCC Algorithms<br/>\- Folder path: ibdiagnet loads all files from the directory<br/>\- Wildcard: ibdiagnet loads files according to wildcard matching. For more information on the supported wildcard syntax refer to the manual page by typing `man 7 glob` |
| `--verbs`      |                           | Experimental | Send and receive GMPs via ibverbs instead of ibumad library. |



## Bug fixes

- Fixed: DB_CSV contains non ascii chars





# IBDIAGNET 2.10

&copy; Copyright 2022, NVIDIA CORPORATION & AFFILIATES. All Rights Reserved.

July 2022

Packages:

| Package       | Version |
| ------------- | ------- |
| Mellanox OFED | 5.7.x   |
| UFM           | 6.10.x  |

## Main features

- Fetching cable info from CMIS (Common Management Interface Specification) compatible cables connected to HCA. Switch to switch cables are supported since version 2.9
- smparquery utility is moved from deprecated package "ar_info" to "ibutils2" package. Now, location of the binary file is "/usr/bin/smparquery" , instead of "/usr/sbin/smparquery"
- Support for more than 4 HCA systems is added to topodiff fool (example: DGX A100 system)



## Changes

- "Routers stage" will be launched by default
- Auto-detection of outgoing IB port is improved

  

  

# IBDIAGNET 2.9.0

&copy; Copyright 2022, NVIDIA CORPORATION & AFFILIATES. All Rights Reserved.

April 2022

Packages:

| Package       | Version |
| ------------- | ------- |
| Mellanox OFED | 5.6.x   |
| UFM           | 6.9.x   |

## Main features

- Support for Proactive FRN (pFRN) configuration and counters

- Support for HashBasedForwarding (HBF)

- Support for Hierarchy Info (A15 InfiniBand spec)

  - Port Hierarchy Info
  - Physical Hierarchy Info

- Support for vendor spec PortVLXmitWait 64bit

  

### PHY plugin

- Support up to 16 fans (START_FANS_SPEED section)



## Changes in command line parameters

### ibdiagnet

| Parameter name         | Values                            | Status     | Description                                                  |
| :--------------------- | --------------------------------- | ---------- | ------------------------------------------------------------ |
| `--r_opt`              | `skip_far`                        | Deprecated | The same functionality is supported by --disable_output option |
|                        | `vs`, `far`, `rn`, `drnc`, `crnc` | Removed    |                                                              |
| `--pm_get_all`         |                                   | New        | Get all PM counters by activate the following flags: `--per_slvl_cntrs` `--sc` `--extended_speeds` `pm_per_lane` |
| `--pm_clear_all`       |                                   | New        | Clear all PM counters by activate the following flags: `--scr`  `--pc` |
| `--ft_roots_regex_opt` | `<regular expression>`            | New        | Regular expression to select topology root nodes. To be applied to switch descriptions. |



## Bug fixes

- Fixed: PCIe plugin doesn't support scope file
- Fixed: Wrong number of SHARP active jobs in fabric summary



## Changes

- Added new validations for SHARP trees in fat-tree topology with "parallel" links between switches
- Support VL Arbitration 
- Cables: Using human readable format for temperature thresholds
- Added PMPortSamplesControl to db_csv
- FDBS file is created by default
- Improved DFP dump file
- Performance improvements in dump file creation





# IBDIAGNET 2.8.0

&copy; Copyright 2021, NVIDIA CORPORATION & AFFILIATES. All Rights Reserved.

November 2021

Packages:

| Package | Version |
| ------- | ------- |
| MOFED   | 5.5.x   |
| UFM     | 6.8.x   |

## Main features
- Support CMIS cable
- Support PortVLXmitFlowCtlUpdateErrors
- Support PortVLXmitWait

### PHY plugin
- Updated SLRG_16 and SLTP_16 registers
- Support PCI Diagnostic Data Pages

## Changes in command line parameters

### ibdiagnet
| Parameter name | Values  | Status    | Description                                                  |
| :------------- | --------|---------- | ------------------------------------------------------------ |
| `--r_opt`      | `dump_only_skip_routing_tables` |Added | Skips routing tables (LFTs) retrieving    |
| `--r_opt`      | `rn`    |Deprecated | Dumps routing notification data to file (enabled by default) |
| `--r_opt`      | `drnc`  |Deprecated | Dumps routing notification port counters to file (enabled by default)  |



## Bug fixes
- Fixed: Unexpected exit when detected HCAs with invalid GUID in discovery stage
- Fixed: HCA with invalid LID may corrupt ibdaignet reporting for other nodes
- Fixed: Possible crash in SHARP validation mode when SHARP version is not specified in command line paramters
- Fixed: Wrong values in "switchguid" and in "remote port" fields in ibnetdiscover file

## Changes

- List of Socket-Direct HCAs is added to DB_CSV
- Socket-Direct HCAs are excluded from Rail-Optimized Topology validation
- PM Stage reports overflow & threshold for 3 counters only
  - SyncHeaderErrorCounter
  - UnknownBlockCounter
  - port_fec_uncorrectable_block_counter
- Fat Tree Validation: "Connectivity group" detection is improved
- ibnetdiscover file will not be generated when scope file is used
- Fabric Summary now includes number of Socket-Direct HCAs
- Error/warning reporting to screen and log files is limited by 5 of each type, DB_CSV includes all errors


# IBDIAGNET 2.7.0

Copyright (c) 2021 NVIDIA CORPORATION & AFFILIATES. All rights reserved.

June 2021

Packages:

| Package     | Version |
| ----------- | ------- |
| MOFED       | 5.4.x   |
| UFM         | 6.7.x   |

## Main features
- NDR support
- Fat Tree topology validation tool

## Changes in command line parameters

### ibdiagnet

| Parameter name  | Status     | Description                                                     |
| :-------------- | ---------- | --------------------------------------------------------------- |
| `--ft`          | New        | Enables Fat Tree Topology Validation (default - disabled)           |
| `--aguid`       | New        | Collects AGUIDs                                                 |
| `--enable_spst` | Removed    | SPST mode is enabled by default. Option was deprecated in 2.6.1 |

## Bug fixes

## Changes
- Virtualization stage redesigned to asynchronous mode
- AGUID stage is disabled by default. Use '--aguid' for enabling
- db_csv will contain information about connected ports only


# IBDIAGNET 2.6.2

Copyright (c) 2021 NVIDIA CORPORATION & AFFILIATES. All rights reserved.

March 2021

Packages:

| Package     | Version |
| ----------- | ------- |
| MOFED       | 5.3.x   |

## Main features
- Experimental NDR support

### PHY plugin
- Dump of MPCNT register is aligned to latest PRM

## Changes in command line parameters

### ibdiagnet

| Parameter name  | Status     | Description                                                                                      |
| :-------------- | ---------- | ------------------------------------------------------------------------------------------------ |
| `--ls`          | Changed    | "EDR20" is removed from the list of expected speeds                                              |
| `-u|--fat_tree` | Deprecated | Indicates that UpDown credit loop checking should be done against automatically determined roots |

### ibtopodiff

| Parameter name     | Status | Description                                                                        |
| :----------------- | ------ | ---------------------------------------------------------------------------------  |
| `-n|--smart_names` | New    | Search switch node by description, if the node wasn't found by name (experimental) |

## Bug fixes

- Fixed: ibdiagnet reports wrong number of running SHARP jobs, when IB fabric either mix of different switches, or SHARP is not enabled in some switches
- Fixed: ibdmchk reports wrong size of multicast group, if SHARP is enabled
- Fixed: ibdiagnet reports congestion control counters for nodes with disabled congestion control 

## Changes

- phy_effective_errors and phy_symbol_errors in ibdiagnet2.net_dump_ext are reported from registers instead of PM counters
- Only 3 counters will be reported as error: SyncHeaderErrorCounter, UnknownBlockCounter, port_fec_uncorrectable_block_counter (only if PLR is disabled)
- ibdiagnet reports timestamps of input and output files
- PPCNT ZL_FEC_COUNTERS (DiagnosticData page 244) is removed from PHY plugin
- PHY plug-in: "Not supported" warnings are suppressed in log file, only total amount of warnings is reported. List of the warnings can be found in db_csv file
- "Aggregation Node" information in ibdiagnet2.sharp and in ibdiagnet2.sharp_an_info will include Switch GUID and node description


# IBDIAGNET 2.6.1

&copy; Copyright 2021, Mellanox Technologies, Inc. All Rights Reserved.

January 2021

Packages:

| Package     | Version |
| ----------- | ------- |
| UFM         | 6.6.x   |
| MOFED       | 5.2.x   |

MOFED 5.2.x also includes changes introduced by IBDIAGNET 2.5.0 .

## Main features

### ibdiagnet

- Adaptive Routing validation
- Performance improvement of routing checking
- New counters and diagnostic information:
  - SHARP: "SAT" ("Streaming Aggregation") counters
  - PHY: Max PLR per second field in PPCNT
  - PHY: SLLM register
  - PHY: New SymbolBER thresholds
  - Adaptive Routing: PortARTrails counter
- Support for SHARP security (AMKEY)
- Support for Congestion Control security (CCKEY)
- Support for Vendor Specific security (VSKEY)
- Reporting port counter differences when used `--pm_pause_time` (`PM_DELTA` section in db_csv)
- Dragonfly+ Topology Validation (`--dfp`, `--dfp_opt [<max_cas>]` ).


### ibtopodif

- Support for "stable" names of RDMA devices based on PCI/slot/function location

## Changes in command line parameters

### ibdiagnet

| Parameter name                  | Status                                | Description                                                                                             |
| :------------------------------ | ------------------------------------- | ------------------------------------------------------------------------------------------------------- |
| `--smp_window`                  | Upper limit and default are changed   | Max: 256;  default: 16                                                                                  |
| `--gmp_window`                  | Upper limit and default are changed   | Max: 16384; default: 256                                                                                |
| `--am_key`                      | New                                   | Specifies default AMKEY for the fabric                                                                  |
| `--am_key_file`                 | New                                   | Specifies the path to file (AMKEY per GUID)                                                             |
| `--smdb`                        | New                                   | Specifies the path to OpenSM SMDB file (required for Adaptive Routing & Dragonfly+ Topology validation) |
| `--ber_threshold_table`         | New                                   | Specifies the path to BER thresholds table file (BER per FEC)                                           |
| `--create_ber_threshold_table`  | New                                   | Creates template file of BER threshold table                                                            |
| `--enable_spst`                 | Deprecated                            | SPST mode is enabled by default                                                                         |
| `--dfp`                         | New                                   | Enabling DFP Topology Validation (default - disabled)                                                   |
| `--dfp_opt`                     | New                                   | Specifies comma separated DFP Topology Validation options                                               |
| `--cc_key`                      | New                                   | Specifies default Congestion Control key for the fabric                                                 |
| `--cc_key_file`                 | New                                   | Specifies the path to file (Congestion Control key per GUID)                                            |
| `--vs_key`                      | New                                   | Specifies default Vendor Specific key for the fabric                                                    |
| `--vs_key_file`                 | New                                   | Specifies the path to file (Vendor Specific key per GUID)                                               |


#### --dfp_opt

| Parameter name                | Description                                                                                                                     |
| :---------------------------- | ------------------------------------------------------------------------------------------------------------------------------- |
| `<max_cas>`                   | Specifies max number of CAs for "Root" switch in Dragonfly+ island (default: 1). This parameter is mutual exclusive with --smdb |


### ibdmchk

| Parameter name                | Status                 | Description                                                      |
| :---------------------------- | ---------------------- | ---------------------------------------------------------------- |
| `--FAR`                       | New                    | Adds support for input FAR file                                  |



## Bug fixes

- Fixed: ibtopodiff doesn't recognize IB Routers
- Fixed: Reset flow for PHY/PCI counters

## Changes

- ibdiagnet reports version on screen and in log file
- ibnetdiscover dump file, created by ibdiagnet, includes Virtual Port info


# IBDIAGNET 2.6.0

&copy; Copyright 2020, Mellanox Technologies, Inc. All Rights Reserved.

December 2020

Packages:

| Package     | Version |
| ----------- | ------- |
| UFM         | 6.6.x   |
| MOFED       | 5.2.x   |

MOFED 5.2.x also includes changes introduced by IBDIAGNET 2.5.0 .

## Main features

### ibdiagnet

- Adaptive Routing validation
- Performance improvement of routing checking
- New counters and diagnostic information:
  - SHARP: "SAT" ("Streaming Aggregation") counters
  - PHY: Max PLR per second field in PPCNT
  - PHY: SLLM register
  - PHY: New SymbolBER thresholds
  - Adaptive Routing: PortARTrails counter
- Support for SHARP security (AMKEY)
- Reporting port counter differences when used `--pm_pause_time` (`PM_DELTA` section in db_csv)

### ibtopodif

- Support for "stable" names of RDMA devices based on PCI/slot/function location

## Changes in command line parameters

### ibdiagnet

| Parameter name                  | Status                                | Description                                                                         |
| :------------------------------ | ------------------------------------- | ----------------------------------------------------------------------------------- |
| `--smp_window`                  | Upper limit and default are changed   | Max: 256;  default: 16                                                              |
| `--gmp_window`                  | Upper limit and default are changed   | Max: 16384; default: 256                                                            |
| `--am_key`                      | New                                   | Specifies default AMKEY for the fabric                                              |
| `--am_key_file`                 | New                                   | Specifies the path to file (AMKEY per GUID)                                         |
| `--smdb`                        | New                                   | Specifies the path to OpenSM SMDB file (required for Adaptive Routing validation)   |
| `--ber_threshold_table`         | New                                   | Specifies the path to BER thresholds table file (BER per FEC)                       |
| `--create_ber_threshold_table`  | New                                   | Creates template file of BER threshold table                                        |
| `--enable_spst`                 | Deprecated                            | SPST mode is enabled by default                                                     |


### ibdmchk

| Parameter name                | Status                 | Description                                                      |
| :---------------------------- | ---------------------- | ---------------------------------------------------------------- |
| `--FAR`                       | New                    | Adds support for input FAR file                                  |



## Bug fixes

- Fixed: ibtopodiff doesn't recognize IB Routers
- Fixed: Reset flow for PHY/PCI counters

## Changes

- ibdiagnet reports version on screen and in log file
- ibnetdiscover dump file, created by ibdiagnet, includes Virtual Port info


# IBDIAGNET 2.5.0

&copy; Copyright 2020, Mellanox Technologies, Inc. All Rights Reserved.

September 2020

Packages:

| Package     | Version |
| ----------- | ------- |
| UFM         | 6.5.2   |

## Main features

- Rail Optimized Topology Validation (`--rail_validation`, `--rail_validation_opt [<regex>]` ). Checking links between compute nodes and leaf switches to provide rail optimized topology
- Customization SL for GMP MADs in ibdiagnet (`--sl`)



## Changes in command line parameters

### ibdiagnet

| Parameter name                | Status     | Description                                                           |
| :---------------------------- | ---------- | --------------------------------------------------------------------- |
| `--sl`                        | New        | Specifies the SL to be used (default=0)                               |
| `--rail_validation`           | New        | Enabling Rail Optimized Topology Validation (default - disabled)      |
| `--rail_validation_opt`       | New        | Specifies comma separated Rail Optimized Topology Validation options  |
| `--clear_congestion_counters` | New        | Dumping Congestion Counters and clearing them                         |
| `--fec_mode`                  | Deprecated | FEC_MODE section will be dump to "db_csv" by default                  |


#### --rail_validation_opt

| Parameter name                | Description                                                                                            |
| :---------------------------- | ------------------------------------------------------------------------------------------------------ |
| `<regex>`                     | Specifies regular expression to filter HCA nodes from reports. To be applied to HCAs node descriptions |


## Bug fixes

- Fixed: Correct print errors/warning status in stages
- Fixed: Critical error in case duplicate names with HCA/mlx patterns

## Changes

- Add output similar to the result of the "ibnetdiscovery"
- ibdiagnet: Disable output by default for AR/FDBS files in routing stage
- Move SHARP performance counters to db_csv
- Dump by default FEC_MODE section in db_csv
- Improve AR connectivity check 


# IBDIAGNET 2.4.1

&copy; Copyright 2020, Mellanox Technologies, Inc. All Rights Reserved.

September 2020

Packages:

| Package     | Version |
| ----------- | ------- |
| UFM         | 6.5.2   |

## Main features

- Rail Optimized Topology Validation (`--rail_validation`, `--rail_validation_opt [<regex>]` ). ibdianget will validate cabling between hosts and "leaf" switches in "Rail Optimized Topology".
  For multi-ports compute nodes, "Rail Optimisation" means: 'leaf' switch serves only HCAs belonging the same "rail" (HCA position in compute node)
- Now, ibdiagnet can use custom (non-zero) SL for sending GMP MADs (`--sl`)

## Changes in command line parameters

### ibdiagnet

| Parameter name                | Status     | Description                                                           |
| :---------------------------- | ---------- | --------------------------------------------------------------------- |
| `--sl`                        | New        | specifies SL for sending GMP MADs (default: 0)                        |
| `--rail_validation`           | New        | enables Rail Optimized Topology Validation (default: disabled)        |
| `--rail_validation_opt`       | New        | specifies comma separated Rail Optimized Topology Validation options  |
| `--clear_congestion_counters` | New        | dumps Congestion Counters and clears them                             |
| `--fec_mode`                  | Deprecated | "FEC_MODE" section will be dump to "db_csv" by default                |

#### --rail_validation_opt

This option allows to provide additional parameters to Rail Optimized Topology Validation. Now, only "regex" option is supported.
"regex" is an expression in "POSIX Extended Regular Expression" format. Only nodes with node description matching this regex are subject for Rail Optimized
Topology Validation.

Example:

``` bash
$ ibdiagnet --rail_validation --rail_validation_opt regex='dgx*'
```

## Bug fixes

- Fixed: ibdiagnet fails to discovery IB fabric with duplicated node descriptions matching patterns: "HCA-N", or "mxl-N". Case number: 00870180

## Changes

- ibdignet will output a human readable topology file in format similar to "ibnetdiscovery".
  This file will include virtual ports and split cables information
- ibdiagnet will not output by default AR/FDBS files in "routing" stage
- SHARP performance counters are moved from separate file to db_csv (`SHARP_PM_COUNTERS` section)
- ibdiagnet will dump FEC_MODE section in db_csv by default. `--fec_mode` parameter is deprecated
- Performance of AR (Adaptive Routing) connectivity check is improved


# IBDIAGNET 2.4.0

July 2020

&copy; Copyright 2020, Mellanox Technologies, Inc. All Rights Reserved.

Packages:

| Package     | Version |
| ----------- | ------- |
| MLNX_OFED   | 5.1     |
| UFM         | 6.5.0   |

## Main features

- Flexible output control options (`--enable_output` , `--disable_output`, `--path`)
- Discovery only mode (`--discovery_only`)
- Support for MLNX Congestion Control counters

## Performance improvements

The performance of following steps in ibdiagnet has been improved:
- Routing validation
- Network discovery
- Virtualization stage
- Dump creation

## Changes in command line parameters

### ibdiagnet

| Parameter name     | Status                 | Description                                                  |
| :----------------- | ---------------------- | ------------------------------------------------------------ |
| `--enable_output`  | New                    | Enable creation of specific dump file                        |
| `--disable_output` | New                    | Disable specific dump file                                   |
| `--path`           | New                    | Set custom path for specific dump file                       |
| `--discovery_only` | New                    | Discover IB fabric, save topology information into "db_csv" file and exit |
| `--smp_window`     | Upper limit is changed | New max is 128                                               |
| `--gmp_window`     | Upper limit is changed | New max is 8192                                              |

### ibtopodiff

| Parameter name | Status | Description             |
| -------------- | ------ | ----------------------- |
| `--ibnl_dir`   | New    | Set path for IBNL files |


* * *

## Bug fixes

- Fixed: ibdiagnet skips PCIe counters for some HCAs, if more than one HCA is installed in the host
- Fixed: ibdiagnet reports wrong value for SLRG 16nm register
- Fixed: ibdiagnet reports wrong value in SMP access register
- Fixed: ibdiagnet reports wrong number of "Aggregation Nodes" in "Fabric Summary" table

## Changes:

- "Fabric Summary" is enabled by default
- Dates and versions in "nodes_info" file are printed in human-readable format
- Dump files include ibdiagnet version and command line parameters
- Added split mode to IBNL for "InfiniBand Smart Director Switches" (CS8500)

