<NodesDefinition>
<config  field_mand="name, descr, size" />
<config  field_attr="name" type="ascii" />
<config  field_attr="descr" type="ascii" />
<config  field_attr="size" type="hexa" />
<config  field_attr="type" type="ascii" />
<config  field_attr="rw" type="enum" >
	<enum  name="OP" value="OP" />
	<enum  name="ReadOnly" value="RO" />
	<enum  name="ReadWrite" value="RW" />
	<enum  name="WriteOnly" value="WO" />
</config>
<config  field_attr="access" type="enum" >
	<enum  name="Index" value="INDEX" />
	<enum  name="OP" value="OP" />
	<enum  name="ReadOnly" value="RO" />
	<enum  name="ReadWrite" value="RW" />
	<enum  name="WriteOnly" value="WO" />
</config>
<config  field_attr="enum" type="enumval" />
<config  big_endian_arr="1" />
<config  field_attr="selected_by" type="ascii" used_for="node" />
<config  field_attr="union_selector" type="ascii" used_for="node" />
<config  field_attr="mlxconfig_desc" type="ascii" />
<config  field_attr="mlxconfig_name" type="ascii" />
<config  field_attr="xuefi" type="ascii" />
<config  field_attr="supported_from_version" type="ascii" />
<config  field_attr="dependency" type="ascii" />
<config  field_attr="valid_bit" type="ascii" />
<config  field_attr="tempvars" type="ascii" />
<config  field_attr="minval" type="ascii" />
<config  field_attr="maxval" type="ascii" />
<config  field_attr="rule" type="ascii" />
<config  field_attr="regex" type="ascii" />
<config  field_attr="capability" type="ascii" />
<config  field_attr="target" type="ascii" />
<config  field_attr="version" type="ascii" />
<info source_doc_name="" source_doc_version="Rev 0.025" />
<node name="MICM_ext" descr="" size="0x28.0" >
	<field name="interrupts_mask" descr="Interrupts Mask\;Enabling or disabling bits in the MICM register will determine whether the interrupt GPIO is triggered when an interrupt occurs. The status of any interrupt bit can always be read (or cleared) via the MICV register. By default all interrupts are enabled." access="RW" high_bound="7" low_bound="0" offset="0x4.0" size="0x20.0" />
</node>

<node name="MICV_ext" descr="" size="0x24.0" >
	<field name="op" descr="Operation\;0: Read\;1: Read and clear" access="OP" offset="0x0.0" size="0x0.4" />
	<field name="int_vec" descr="Interrupts Vector\;bit0: Thermal. For more info read also Table 167, &quot;MTEWE - Management Temperature Extended Warning Event Register Layout,&quot; on page 218\;bit1: Ready for PVS setting\;bit2: Reserved\;bit3: Graceful reset Ack\;bit6-31: Reserved\;Other bits are reserved" access="RO" high_bound="7" low_bound="0" offset="0x4.0" size="0x20.0" />
</node>

<node name="MRFV_CVB_ext" descr="" size="0x8.0" >
	<field name="cvb_data_index" descr="CVB Voltage = -4 + 0.5 * cvb_data_index\;cvb_data_index valid values 0 .. 15\;Process Sigma &lt;-&gt; DVDD (mV)\;-4.0: 856.00\;-3.5: 847.75\;-3.0: 839.50\;-2.5: 831.25\;-2.0: 823.00\;-1.5: 814.75\;-1.0: 806.50\;-0.5: 798.25\;0 (nominal): 790.00\;0.5: 781.75\;1.0: 773.50\;1.5: 765.25\;2.0: 757.00\;2.5: 748.75\;3.0: 740.50\;3.5: 732.25\;4.0: 724.00\;Reserved when selector = 1" access="RO" offset="0x0.0" size="0x0.5" />
	<field name="selector" descr="0: cvb_data_index is valid\;1: cvb_voltage is valid\;\;" access="RO" offset="0x0.31" size="0x0.1" />
	<field name="cvb_voltage" descr="CVB Voltage\;Returns required CVB voltage in mV.\;\;Reserved when selector = 0" access="RO" offset="0x4.0" size="0x0.10" />
	<field name="tav_cvb_voltage" descr="DWIP\;TAV CVB Voltage\;Returns required TAV CVB voltage in mV.\;Used in Retimer only.\;Reserved when selector = 0" access="RO" offset="0x4.20" size="0x0.10" />
</node>

<node name="MRFV_PVS_MAIN_ext" descr="" size="0x4.0" >
	<field name="pvs_main_data" descr="PVS Data\;Range 0.675 - 0.75\;Vdd = 750mV - (fuse value - 1)*5mV" access="RO" offset="0x0.0" size="0x0.7" />
</node>

<node name="MRFV_PVS_TILE_ext" descr="" size="0x4.0" >
	<field name="pvs_tile_data" descr="PVS tile Data\;Range 0.675 - 0.72\;Vdd = 750mV - (fuse value - 1)*5mV" access="RO" offset="0x0.0" size="0x0.7" />
</node>

<node name="MRFV_ULT_ext" descr="" size="0xc.0" >
	<field name="ult_lot_digit_1" descr="" access="RO" offset="0x0.0" size="0x0.8" />
	<field name="ult_lot_digit_2" descr="" access="RO" offset="0x0.8" size="0x0.8" />
	<field name="ult_lot_digit_3" descr="" access="RO" offset="0x0.16" size="0x0.8" />
	<field name="ult_lot_digit_4" descr="" access="RO" offset="0x0.24" size="0x0.8" />
	<field name="ult_lot_digit_5" descr="" access="RO" offset="0x4.0" size="0x0.8" />
	<field name="ult_lot_digit_6" descr="" access="RO" offset="0x4.8" size="0x0.8" />
	<field name="ult_lot_digit_7" descr="" access="RO" offset="0x4.16" size="0x0.8" />
	<field name="ult_lot_digit_8" descr="" access="RO" offset="0x4.24" size="0x0.8" />
	<field name="ult_y" descr="" access="RO" offset="0x8.0" size="0x0.8" />
	<field name="ult_x" descr="" access="RO" offset="0x8.8" size="0x0.8" />
	<field name="ult_wafer_number" descr="" access="RO" offset="0x8.16" size="0x0.8" />
	<field name="ult_err_detection" descr="" access="RO" offset="0x8.29" size="0x0.3" />
</node>

<node name="MRFV_data_auto_ext" descr="" attr_is_union="1" size="0xc.0" >
	<field name="MRFV_CVB_ext" descr="" subnode="MRFV_CVB_ext" offset="0x0.0" selected_by="cvb" size="0x8.0" />
	<field name="MRFV_ULT_ext" descr="" subnode="MRFV_ULT_ext" offset="0x0.0" selected_by="ULT" size="0xc.0" />
	<field name="MRFV_PVS_MAIN_ext" descr="" subnode="MRFV_PVS_MAIN_ext" offset="0x0.0" selected_by="pvs_main_die" size="0x4.0" />
	<field name="MRFV_PVS_TILE_ext" descr="" subnode="MRFV_PVS_TILE_ext" offset="0x0.0" selected_by="pvs_tile_0" size="0x4.0" />
</node>

<node name="MRFV_ext" descr="" size="0x40.0" >
	<field name="fuse_id" descr="Fuse Index\;0: cvb - CVB Main Die, used for Retimer\;1: ULT - used for Retimer\;2: pvs_main_die - (used for SPC-4)\;3: pvs_tile_0 - (used for SPC-4)\;4: pvs_tile_1 - (used for SPC-4)\;5: pvs_tile_2 - (used for SPC-4)\;6: pvs_tile_3 - (used for SPC-4)\;7: pvs_tile_4 - (used for SPC-4)\;8: pvs_tile_5 - (used for SPC-4)\;9: pvs_tile_6 - (used for SPC-4)\;10: pvs_tile_7 - (used for SPC-4)\;Other values reserved\;Reserved when fm = 1" access="INDEX" enum="cvb=0x0,ULT=0x1,pvs_main_die=0x2,pvs_tile_0=0x3,pvs_tile_1=0x4,pvs_tile_2=0x5,pvs_tile_3=0x6,pvs_tile_4=0x7,pvs_tile_5=0x8,pvs_tile_6=0x9,pvs_tile_7=0xa" offset="0x0.0" size="0x0.8" />
	<field name="fm" descr="Fuse Mismatch\;0: No fuse mismatch\;1: Fuse mismatch found\;2-3: Reserved" access="RO" offset="0x0.24" size="0x0.2" />
	<field name="v" descr="Valid bit\;0: Fuse reading is not supported for this system\;1: Response is valid\;2-3: Reserved\;Reserved when fm = 1" access="RO" offset="0x0.30" size="0x0.2" />
	<field name="data" descr="Data\;See Table 283, &quot;MRFV entry - CVB Layout,&quot; on page 309\;See Table 285, &quot;MRFV entry - ULT Layout,&quot; on page 311\;See Table 287, &quot;MRFV entry - PVS_MAIN Layout,&quot; on page 312\;See Table 289, &quot;MRFV entry - PVS_Tile Layout,&quot; on page 313\;Reserved when fm = 1" subnode="MRFV_data_auto_ext" access="RO" offset="0x10.0" size="0xc.0" union_selector="$(parent).fuse_id" />
</node>

<node name="access_reg_summary_ctrl_ext" descr="" attr_is_union="1" size="0x4.0" >
	<field name="id" descr="" subnode="enum_entry" enum="SLTP=0x5027,SLTPv2=0x502f,SLRG=0x5028,PDDR=0x5031,PPHCR=0x503e,MFDE=0x9200,MGCR=0x903a,MICV=0x917a,MICM=0x917b,MTECR=0x9109,MTMP=0x900a,MTEWE=0x910b,MVCR=0x900c,MRSR=0x9023,MBTR=0x9077,MCQS=0x9060,MCQI=0x9061,MCC=0x9062,MCDA=0x9063,MQIS=0x9064,MGIR=0x9020,MDIR=0x911a,MCAM=0x907f,MECCC=0x905f,MRFV=0x906d,MDSR=0x9110,MFSV=0x9115,MTCQ=0x9065,MFMC=0x9013,RTCAP=0x6c7f,RTCC=0x6c03,RTDPC=0x6c08,RTEDC=0x6c04,RTPSL=0x6c06,RTPTYS=0x6d00,RTPAOS=0x6d01,RTSFC=0x6d02,RTPTPR=0x6d20,RTTSPC=0x6d21,RTLTC=0x6d22,RTCDE=0x6d23,RTFCR=0x6d24,RTPPLR=0x6d30,RTPPRT=0x6d31,RTPPTT=0x6d32,RTPCNT=0x6d33" offset="0x0.0" size="0x4.0" />
</node>

<node name="access_reg_summary_ext" descr="" attr_is_union="1" size="0x10c" >
	<field name="sltp_reg" descr="" subnode="sltp_reg_ext" capability="0" offset="0x0.0" selected_by="SLTP" size="0x4c" />
	<field name="sltpv2_reg" descr="" subnode="sltpv2_reg_ext" capability="0" offset="0x0.0" selected_by="SLTPv2" size="0x10c" />
	<field name="slrg_reg" descr="" subnode="slrg_reg_ext" capability="0" offset="0x0.0" selected_by="SLRG" size="0x28" />
	<field name="pddr_reg" descr="" subnode="pddr_reg_ext" capability="0" offset="0x0.0" selected_by="PDDR" size="0x100" />
	<field name="pphcr" descr="" subnode="pphcr_ext" capability="0" offset="0x0.0" selected_by="PPHCR" size="0x50" />
	<field name="mfde" descr="" subnode="mfde_ext" capability="0" offset="0x0.0" selected_by="MFDE" size="0xb0" />
	<field name="mgcr_reg" descr="" subnode="mgcr_reg_ext" capability="0" offset="0x0.0" selected_by="MGCR" size="0x20" />
	<field name="MICV" descr="" subnode="MICV_ext" capability="0" offset="0x0.0" selected_by="MICV" size="0x24" />
	<field name="MICM" descr="" subnode="MICM_ext" capability="0" offset="0x0.0" selected_by="MICM" size="0x28" />
	<field name="mtecr" descr="" subnode="mtecr_ext" capability="0" offset="0x0.0" selected_by="MTECR" size="0x60" />
	<field name="mtmp" descr="" subnode="mtmp_ext" capability="0" offset="0x0.0" selected_by="MTMP" size="0x20" />
	<field name="mtewe" descr="" subnode="mtewe_ext" capability="0" offset="0x0.0" selected_by="MTEWE" size="0x5c" />
	<field name="mvcr" descr="" subnode="mvcr_ext" capability="0" offset="0x0.0" selected_by="MVCR" size="0x18" />
	<field name="mrsr" descr="" subnode="mrsr_ext" capability="0" offset="0x0.0" selected_by="MRSR" size="0x8" />
	<field name="mbtr" descr="" subnode="mbtr_ext" capability="0" offset="0x0.0" selected_by="MBTR" size="0x8" />
	<field name="mcqs_reg" descr="" subnode="mcqs_reg_ext" capability="0" offset="0x0.0" selected_by="MCQS" size="0x10" />
	<field name="mcqi_reg" descr="" subnode="mcqi_reg_ext" capability="0" offset="0x0.0" selected_by="MCQI" size="0x94" />
	<field name="mcc_reg" descr="" subnode="mcc_reg_ext" capability="0" offset="0x0.0" selected_by="MCC" size="0x20" />
	<field name="mcda_reg" descr="" subnode="mcda_reg_ext" capability="0" offset="0x0.0" selected_by="MCDA" size="0x90" />
	<field name="mqis_reg" descr="" subnode="mqis_reg_ext" capability="0" offset="0x0.0" selected_by="MQIS" size="0x18" />
	<field name="mgir" descr="" subnode="mgir_ext" capability="0" offset="0x0.0" selected_by="MGIR" size="0xa0" />
	<field name="mdir_reg" descr="" subnode="mdir_reg_ext" capability="0" offset="0x0.0" selected_by="MDIR" size="0x40" />
	<field name="mcam_reg" descr="" subnode="mcam_reg_ext" capability="0" offset="0x0.0" selected_by="MCAM" size="0x48" />
	<field name="meccc" descr="" subnode="meccc_ext" capability="0" offset="0x0.0" selected_by="MECCC" size="0x14" />
	<field name="MRFV" descr="" subnode="MRFV_ext" capability="0" offset="0x0.0" selected_by="MRFV" size="0x40" />
	<field name="mdsr_reg" descr="" subnode="mdsr_reg_ext" capability="0" offset="0x0.0" selected_by="MDSR" size="0x30" />
	<field name="mfsv_reg" descr="" subnode="mfsv_reg_ext" capability="0" offset="0x0.0" selected_by="MFSV" size="0x30" />
	<field name="mtcq_reg" descr="" subnode="mtcq_reg_ext" capability="0" offset="0x0.0" selected_by="MTCQ" size="0x70" />
	<field name="mfmc_reg" descr="" subnode="mfmc_reg_ext" capability="0" offset="0x0.0" selected_by="MFMC" size="0x1c" />
	<field name="rtcap_reg" descr="" subnode="rtcap_reg_ext" capability="0" offset="0x0.0" selected_by="RTCAP" size="0x14" />
	<field name="rtcc_reg" descr="" subnode="rtcc_reg_ext" capability="0" offset="0x0.0" selected_by="RTCC" size="0x24" />
	<field name="rtdpc_reg" descr="" subnode="rtdpc_reg_ext" capability="0" offset="0x0.0" selected_by="RTDPC" size="0x8" />
	<field name="rtedc_reg" descr="" subnode="rtedc_reg_ext" capability="0" offset="0x0.0" selected_by="RTEDC" size="0x14" />
	<field name="rtpsl_reg" descr="" subnode="rtpsl_reg_ext" capability="0" offset="0x0.0" selected_by="RTPSL" size="0x2c" />
	<field name="rtptys_reg" descr="" subnode="rtptys_reg_ext" capability="0" offset="0x0.0" selected_by="RTPTYS" size="0x24" />
	<field name="rtpaos_reg" descr="" subnode="rtpaos_reg_ext" capability="0" offset="0x0.0" selected_by="RTPAOS" size="0xc" />
	<field name="rtsfc_reg" descr="" subnode="rtsfc_reg_ext" capability="0" offset="0x0.0" selected_by="RTSFC" size="0x20" />
	<field name="rtptpr_reg" descr="" subnode="rtptpr_reg_ext" capability="0" offset="0x0.0" selected_by="RTPTPR" size="0xc" />
	<field name="rttspc_reg" descr="" subnode="rttspc_reg_ext" capability="0" offset="0x0.0" selected_by="RTTSPC" size="0x4" />
	<field name="rtltc_reg" descr="" subnode="rtltc_reg_ext" capability="0" offset="0x0.0" selected_by="RTLTC" size="0xc" />
	<field name="rtcde_reg" descr="" subnode="rtcde_reg_ext" capability="0" offset="0x0.0" selected_by="RTCDE" size="0x14" />
	<field name="rtfcr_reg" descr="" subnode="rtfcr_reg_ext" capability="0" offset="0x0.0" selected_by="RTFCR" size="0x8" />
	<field name="rtpplr_reg" descr="" subnode="rtpplr_reg_ext" capability="0" offset="0x0.0" selected_by="RTPPLR" size="0xc" />
	<field name="rtpprt_reg" descr="" subnode="rtpprt_reg_ext" capability="0" offset="0x0.0" selected_by="RTPPRT" size="0x34" />
	<field name="rtpptt_reg" descr="" subnode="rtpptt_reg_ext" capability="0" offset="0x0.0" selected_by="RTPPTT" size="0x1c" />
	<field name="rtpcnt_reg" descr="" subnode="rtpcnt_reg_ext" capability="0" offset="0x0.0" selected_by="RTPCNT" size="0xe8" />
</node>

<node name="access_reg_summary_selector_ext" descr="" attr_is_union="1" size="0x10c" >
	<field name="access_reg_summary" descr="" subnode="access_reg_summary_ext" offset="0x0.0" size="0x10c" union_selector="$(parent).ctrl.id" />
	<field name="ctrl" descr="" subnode="access_reg_summary_ctrl_ext" offset="0x0.0" size="0x4.0" />
</node>

<node name="code_fetch_error_ext" descr="" size="0x18.0" >
	<field name="err_type" descr="Error Type\;0 - allocation error\;1 - authentication error" access="RO" offset="0x0.0" size="0x0.4" />
	<field name="mem_type" descr="Memory Type\;0 - flash\;1 - host memory" access="RO" offset="0x0.6" size="0x0.2" />
	<field name="page_size" descr="Page Size:\;0 - 512B\;1 - 1KB\;2 - 2KB" access="RO" offset="0x0.24" size="0x0.2" />
	<field name="page_type" descr="Page Type:\;0 - data page\;1 - hash page" access="RO" offset="0x0.31" size="0x0.1" />
	<field name="instruction_address" descr="Instruction Address:\;the address that generated the code fetch error aligned to page size\;" subnode="uint64" access="RO" offset="0x8.0" size="0x8.0" />
	<field name="physical_memory_address" descr="The physical address in the memory that contain the code." subnode="uint64" access="RO" offset="0x10.0" size="0x8.0" />
</node>

<node name="crspace_timeout_ext" descr="" size="0xa0.0" >
	<field name="log_address" descr="crspace address accessed, which resulted in timeout" access="RO" offset="0x0.0" size="0x4.0" />
	<field name="log_id" descr="which irisc triggered the timeout" access="RO" offset="0x4.0" size="0x0.4" />
	<field name="tile_index" descr="When tile_v=1 the tile_index that caused the timeout.\;\;[DWIP] Superseded by top level tile_v and tile_index. Kept for backwards compatibility." access="RO" offset="0x4.16" size="0x0.6" />
	<field name="tile_v" descr="Tile valid:\;0: The timeout was from main\;1: The timeout was from a tile\;\;[DWIP] Superseded by top level tile_v and tile_index. Kept for backwards compatibility." access="RO" offset="0x4.23" size="0x0.1" />
	<field name="oe" descr="Old Event:\;0: New event\;1: Old event, found during MFGD activation" access="RO" offset="0x4.24" size="0x0.1" />
	<field name="is_yu" descr="Timeout came from YU" access="RW" offset="0x4.29" size="0x0.1" />
	<field name="is_iron" descr="Timeout came from IRON" access="RW" offset="0x4.30" size="0x0.1" />
	<field name="is_main_farm" descr="timeout came from Main Fram" access="RW" offset="0x4.31" size="0x0.1" />
	<field name="log_ip" descr="IP (instruction pointer) that triggered the timeout" subnode="uint64" access="RO" offset="0x8.0" size="0x8.0" />
</node>

<node name="date_time_layout_ext" descr="" size="0x8.0" >
	<field name="hours" descr="hour (UTC) - 2 packed BCD digits" access="RW" offset="0x0.8" size="0x0.8" />
	<field name="minutes" descr="minutes - 2 packed BCD digits" access="RW" offset="0x0.16" size="0x0.8" />
	<field name="seconds" descr="seconds - 2 packed BCD digits" access="RW" offset="0x0.24" size="0x0.8" />
	<field name="day" descr="day - 2 packed BCD digits" access="RW" offset="0x4.0" size="0x0.8" />
	<field name="month" descr="month - 2 packed BCD digits" access="RW" offset="0x4.8" size="0x0.8" />
	<field name="year" descr="year - 4 packed BCD digits" access="RW" offset="0x4.16" size="0x0.16" />
</node>

<node name="enum_entry" descr="" size="0x4.0" >
</node>

<node name="fatal_cause_ext" descr="" size="0xa0.0" >
	<field name="cause_id" descr="HW / FW cause ID\;\;FW Causes (When fw_cause = 1):\;1: Core PLL lock failure\;\;When test = 1 AND fw_cause = 0, cause ID = 0xCAFE" access="RO" offset="0x0.0" size="0x0.20" />
	<field name="fw_cause" descr="0: cause_id reflects HW cause ID\;1: cause_id reflects FW cause (event)" access="RW" offset="0x0.30" size="0x0.1" />
	<field name="test" descr="Test:\;0: real cause ID\;1: test cause ID" access="RO" offset="0x0.31" size="0x0.1" />
	<field name="tile_index" descr="When tile_v=1 the tile_index that caused the assert.\;\;[DWIP] Superseded by top level tile_v and tile_index. Kept for backwards compatibility." access="RO" offset="0x4.16" size="0x0.6" />
	<field name="tile_v" descr="Tile valid:\;0: The assert was from main\;1: The assert was from a tile\;\;[DWIP] Superseded by top level tile_v and tile_index. Kept for backwards compatibility." access="RO" offset="0x4.23" size="0x0.1" />
</node>

<node name="fw_assert_ext" descr="" size="0xa0.0" >
	<field name="assert_var0" descr="This is the 1st variable passed to assert" access="RO" offset="0x0.0" size="0x4.0" />
	<field name="assert_var1" descr="This is the 2nd variable passed to assert" access="RO" offset="0x4.0" size="0x4.0" />
	<field name="assert_var2" descr="This is the 3rd variable passed to assert" access="RO" offset="0x8.0" size="0x4.0" />
	<field name="assert_var3" descr="This is the 4th variable passed to assert" access="RO" offset="0xC.0" size="0x4.0" />
	<field name="assert_var4" descr="This is the 5th variable passed to assert" access="RO" offset="0x10.0" size="0x4.0" />
	<field name="assert_exinstptr" descr="this is instruction pointer when assert was triggered" access="RO" offset="0x14.0" size="0x4.0" />
	<field name="assert_callra" descr="This is the next return address after triggering assert" access="RO" offset="0x18.0" size="0x4.0" />
	<field name="ext_synd" descr="Extended syndrome" access="RO" offset="0x1C.0" size="0x0.16" />
	<field name="tile_index" descr="When tile_v=1 the tile_index that caused the assert.\;\;[DWIP] Superseded by top level tile_v and tile_index. Kept for backwards compatibility." access="RO" offset="0x1C.16" size="0x0.6" />
	<field name="tile_v" descr="Tile valid:\;0: The assert was from main\;1: The assert was from a tile\;\;[DWIP] Superseded by top level tile_v and tile_index. Kept for backwards compatibility." access="RO" offset="0x1C.23" size="0x0.1" />
	<field name="oe" descr="Old Event:\;0: New event\;1: Old event, found during MFGD activation" access="RO" offset="0x1C.24" size="0x0.1" />
	<field name="test" descr="Test:\;0: real cause ID\;1: test cause ID (cause ID = 0xCAFE)" access="RO" offset="0x1C.31" size="0x0.1" />
	<field name="assert_string" descr="String provided by the device\;Endianity:\;Offset 04h[31:24] - byte0\;Offset 04h[23:16] - byte1\;Offset 04h[15:8] - byte2\;Offset 04h[7:0] - byte3\;Offset 08h[31:24] - byte4\;etc." access="RO" high_bound="31" low_bound="0" offset="0x20.0" size="0x80.0" />
</node>

<node name="histogram_counters_ext" descr="" size="0x50.0" >
	<field name="bin" descr="value of FEC histogram [i].\;For bin ranges values, query PPHCR PRM register.\;Note: bit 63 (last bit) it an indication for counter overflow. if bit63==1 then the counter has reached overflow." subnode="uint64" access="RO" high_bound="9" low_bound="0" offset="0x0.0" size="0x50.0" />
</node>

<node name="kvd_im_stop_ext" descr="" size="0xa0.0" >
	<field name="pipes_mask" descr="Bit per kvh pipe" access="RO" offset="0x0.0" size="0x0.16" />
	<field name="oe" descr="Old Event:\;0: New event\;1: Old event, found during MFGD activation" access="RO" offset="0x0.24" size="0x0.1" />
</node>

<node name="l1_general_counters_data_high_ext" descr="" size="0xe0.0" >
	<field name="l1_entry_lane4_high" descr="" access="RO" offset="0x0.0" size="0x4.0" />
	<field name="l1_entry_lane4_low" descr="" access="RO" offset="0x4.0" size="0x4.0" />
	<field name="l1_entry_lane5_high" descr="" access="RO" offset="0x8.0" size="0x4.0" />
	<field name="l1_entry_lane5_low" descr="" access="RO" offset="0xC.0" size="0x4.0" />
	<field name="l1_entry_lane6_high" descr="" access="RO" offset="0x10.0" size="0x4.0" />
	<field name="l1_entry_lane6_low" descr="" access="RO" offset="0x14.0" size="0x4.0" />
	<field name="l1_entry_lane7_high" descr="" access="RO" offset="0x18.0" size="0x4.0" />
	<field name="l1_entry_lane7_low" descr="" access="RO" offset="0x1C.0" size="0x4.0" />
	<field name="l1_exit_lane4_high" descr="" access="RO" offset="0x20.0" size="0x4.0" />
	<field name="l1_exit_lane4_low" descr="" access="RO" offset="0x24.0" size="0x4.0" />
	<field name="l1_exit_lane5_high" descr="" access="RO" offset="0x28.0" size="0x4.0" />
	<field name="l1_exit_lane5_low" descr="" access="RO" offset="0x2C.0" size="0x4.0" />
	<field name="l1_exit_lane6_high" descr="" access="RO" offset="0x30.0" size="0x4.0" />
	<field name="l1_exit_lane6_low" descr="" access="RO" offset="0x34.0" size="0x4.0" />
	<field name="l1_exit_lane7_high" descr="" access="RO" offset="0x38.0" size="0x4.0" />
	<field name="l1_exit_lane7_low" descr="" access="RO" offset="0x3C.0" size="0x4.0" />
	<field name="l1_1024ns_sleeping_lane4_high" descr="" access="RO" offset="0x40.0" size="0x4.0" />
	<field name="l1_1024ns_sleeping_lane4_low" descr="" access="RO" offset="0x44.0" size="0x4.0" />
	<field name="l1_1024ns_sleeping_lane5_high" descr="" access="RO" offset="0x48.0" size="0x4.0" />
	<field name="l1_1024ns_sleeping_lane5_low" descr="" access="RO" offset="0x4C.0" size="0x4.0" />
	<field name="l1_1024ns_sleeping_lane6_high" descr="" access="RO" offset="0x50.0" size="0x4.0" />
	<field name="l1_1024ns_sleeping_lane6_low" descr="" access="RO" offset="0x54.0" size="0x4.0" />
	<field name="l1_1024ns_sleeping_lane7_high" descr="" access="RO" offset="0x58.0" size="0x4.0" />
	<field name="l1_1024ns_sleeping_lane7_low" descr="" access="RO" offset="0x5C.0" size="0x4.0" />
	<field name="l1_1024ns_wake_lane4_high" descr="" access="RO" offset="0x60.0" size="0x4.0" />
	<field name="l1_1024ns_wake_lane4_low" descr="" access="RO" offset="0x64.0" size="0x4.0" />
	<field name="l1_1024ns_wake_lane5_high" descr="" access="RO" offset="0x68.0" size="0x4.0" />
	<field name="l1_1024ns_wake_lane5_low" descr="" access="RO" offset="0x6C.0" size="0x4.0" />
	<field name="l1_1024ns_wake_lane6_high" descr="" access="RO" offset="0x70.0" size="0x4.0" />
	<field name="l1_1024ns_wake_lane6_low" descr="" access="RO" offset="0x74.0" size="0x4.0" />
	<field name="l1_1024ns_wake_lane7_high" descr="" access="RO" offset="0x78.0" size="0x4.0" />
	<field name="l1_1024ns_wake_lane7_low" descr="" access="RO" offset="0x7C.0" size="0x4.0" />
</node>

<node name="l1_general_counters_data_low_ext" descr="" size="0xe0.0" >
	<field name="l1_entry_lane0_high" descr="" access="RO" offset="0x0.0" size="0x4.0" />
	<field name="l1_entry_lane0_low" descr="" access="RO" offset="0x4.0" size="0x4.0" />
	<field name="l1_entry_lane1_high" descr="" access="RO" offset="0x8.0" size="0x4.0" />
	<field name="l1_entry_lane1_low" descr="" access="RO" offset="0xC.0" size="0x4.0" />
	<field name="l1_entry_lane2_high" descr="" access="RO" offset="0x10.0" size="0x4.0" />
	<field name="l1_entry_lane2_low" descr="" access="RO" offset="0x14.0" size="0x4.0" />
	<field name="l1_entry_lane3_high" descr="" access="RO" offset="0x18.0" size="0x4.0" />
	<field name="l1_entry_lane3_low" descr="" access="RO" offset="0x1C.0" size="0x4.0" />
	<field name="l1_exit_lane0_high" descr="" access="RO" offset="0x20.0" size="0x4.0" />
	<field name="l1_exit_lane0_low" descr="" access="RO" offset="0x24.0" size="0x4.0" />
	<field name="l1_exit_lane1_high" descr="" access="RO" offset="0x28.0" size="0x4.0" />
	<field name="l1_exit_lane1_low" descr="" access="RO" offset="0x2C.0" size="0x4.0" />
	<field name="l1_exit_lane2_high" descr="" access="RO" offset="0x30.0" size="0x4.0" />
	<field name="l1_exit_lane2_low" descr="" access="RO" offset="0x34.0" size="0x4.0" />
	<field name="l1_exit_lane3_high" descr="" access="RO" offset="0x38.0" size="0x4.0" />
	<field name="l1_exit_lane3_low" descr="" access="RO" offset="0x3C.0" size="0x4.0" />
	<field name="l1_1024ns_sleeping_lane0_high" descr="" access="RO" offset="0x40.0" size="0x4.0" />
	<field name="l1_1024ns_sleeping_lane0_low" descr="" access="RO" offset="0x44.0" size="0x4.0" />
	<field name="l1_1024ns_sleeping_lane1_high" descr="" access="RO" offset="0x48.0" size="0x4.0" />
	<field name="l1_1024ns_sleeping_lane1_low" descr="" access="RO" offset="0x4C.0" size="0x4.0" />
	<field name="l1_1024ns_sleeping_lane2_high" descr="" access="RO" offset="0x50.0" size="0x4.0" />
	<field name="l1_1024ns_sleeping_lane2_low" descr="" access="RO" offset="0x54.0" size="0x4.0" />
	<field name="l1_1024ns_sleeping_lane3_high" descr="" access="RO" offset="0x58.0" size="0x4.0" />
	<field name="l1_1024ns_sleeping_lane3_low" descr="" access="RO" offset="0x5C.0" size="0x4.0" />
	<field name="l1_1024ns_wake_lane0_high" descr="" access="RO" offset="0x60.0" size="0x4.0" />
	<field name="l1_1024ns_wake_lane0_low" descr="" access="RO" offset="0x64.0" size="0x4.0" />
	<field name="l1_1024ns_wake_lane1_high" descr="" access="RO" offset="0x68.0" size="0x4.0" />
	<field name="l1_1024ns_wake_lane1_low" descr="" access="RO" offset="0x6C.0" size="0x4.0" />
	<field name="l1_1024ns_wake_lane2_high" descr="" access="RO" offset="0x70.0" size="0x4.0" />
	<field name="l1_1024ns_wake_lane2_low" descr="" access="RO" offset="0x74.0" size="0x4.0" />
	<field name="l1_1024ns_wake_lane3_high" descr="" access="RO" offset="0x78.0" size="0x4.0" />
	<field name="l1_1024ns_wake_lane3_low" descr="" access="RO" offset="0x7C.0" size="0x4.0" />
</node>

<node name="mbtr_ext" descr="" size="0x8.0" >
	<field name="cmd" descr="Command\;0: Perform_graceful_reset_procedure -  Not supported for query operations. Will return BAD_PARAM.\;1: PVS_tuning_was_set" access="WO" enum="Perform_graceful_reset_procedure=0x0,PVS_tuning_was_set=0x1" offset="0x0.0" size="0x0.8" />
	<field name="status" descr="0: Success\;1: ADC_value_is_out_of_limit\;2: ADC_cant_be_compared_due_to_fuse_not_burned \;3: ADC_cant_be_compared_due_to_invalid_fuse_value\;Valid only if cmd = 1" access="RO" enum="Success=0x0,ADC_value_is_out_of_limit=0x1,ADC_cant_be_compared_due_to_fuse_not_burned=0x2,ADC_cant_be_compared_due_to_invalid_fuse_value=0x3" offset="0x4.0" size="0x0.8" />
</node>

<node name="mcam_reg_ext" descr="" size="0x48.0" >
	<field name="access_reg_group" descr="Access Register ID groups \;0: First_128_REG_ID - Register IDs 0x9001 - 0x907F)\;1: Register_IDs_0x9080 - 0x90FF (bit 0 in mng_access_reg_cap_mask represent register ID 0x9080 while bit 127 represents register ID 0x90FF).\;2: Register_IDs_0x9100 - 0x917F (bit 0 in mng_access_reg_cap_mask represent register ID 0x9100 while bit 127 represents register ID 0x917F).\;3: Register_IDs_0x9180 - 0x91FF (bit 0 in mng_access_reg_cap_mask represent register ID 0x9180 while bit 127 represents register ID 0x91FF)." access="INDEX" enum="First_128_REG_ID=0x0,Register_IDs_0x9080=0x1,Register_IDs_0x9100=0x2,Register_IDs_0x9180=0x3" offset="0x0.0" size="0x0.8" />
	<field name="feature_group" descr="Feature list mask index: \;0: enhanced_features" access="INDEX" enum="enhanced_features=0x0" offset="0x0.16" size="0x0.8" />
	<field name="mng_access_reg_cap_mask" descr="Supported management&apos;s access register bitmask. Based on access_reg_group index. \;When bit is set, the register is supported in the device. \;For example:\;Bit 1: MFCR_0x9001\;Bit 2: MFSC_0x9002\;Bit 3: MFSM_0x9003\;Bit 4: MFSL_0x9004\;Bit 58: MGCR_0x903A\;Bit 73: MPPF_0x9049\;Bit 127: MCAP_0x907F" access="RO" enum="MFCR_0x9001=0x2,MFSC_0x9002=0x4,MFSM_0x9003=0x8,MFSL_0x9004=0x10,MGCR_0x903A=0x4000000,MPPF_0x9049=0x200,MCAP_0x907F=0x80000000" high_bound="3" low_bound="0" offset="0x8.0" size="0x10.0" />
	<field name="mng_feature_cap_mask" descr="Supported port&apos;s enhanced features.Based on feature_group index.\;When bit is set, The feature is supported in the device: \;Bit 0: MPCNT counter group- PCIE performance counters supported\;Bit 1: mtpps_fs - If set, field_select field in MTPPS register is supported.\;Bit 2: mtpps_enhanced_out_periodic_adjustment - If set, enhanced_out_periodic_adjustment field in MTPPS register is supported.\;Bit 3: tx_lossy_overflow_oper - If set, tx_overflow_buffer_pkt counter in MPCNT register is supported.\;Bit 4: pcie_outbound_stalled - if set, outbound_stalled_reads, outbound_stalled_writes, outbound_stalled_reads_events and outbound_stalled_writes_events counters in MPCNT are supported.\;Bit 5: Management pass through is supported\;Bit 6: sensor_map - If set, sensor_map is supported in MTCAP register.\;Bit 7: if set, module_status bit 8 (Module Low Power) in MCION register is supported. \;Bit 8: beacon_capability_disable - If set, beacon feature, as appears in MLCR register, in not supported by the device. \;Bit 9: dynamic_tx_overflow - If set, tx_overflow_sense field is supported in MPEGC register. \;Bit 10: mark_tx_action_cqe is supported if set to &apos;1&apos;.\;Bit 11: mark_tx_action_cnp is supported if set to &apos;1&apos;.\;Bit 12: dev_info is supported in  register is set to &apos;1&apos;.\;Bit 13: sensor_count field is 12bit size in MTMP and MTBR\;Bit 14: cs_tokens_supported is supported \;Bit 15: debug_fw_tokens_supported\;Bit 16: long_keys is supported \;Bit 17: pwr_status and pci_power are supported in MPEIN\;Bit 18: If set, accessing through device_type and device_index is supported in MCC, MCQI and MCQS\;Bit 19: pcie_sync_for_fw_update_supported is set to &apos;1&apos;\;Bit 20: ptpCyc2Realtime_modify - If set, the cycle to realtime translation offload is supported\;Bit 21: If set to &apos;1&apos;, reset_state in MFRL is supported\;Bit 22: If set to &apos;1&apos;, link_peer_max_speed is supported in MPEIN Register\;Bit 23: If set to &apos;1&apos;, slot_index field is supported in: MCIA, MCAS, MCION, MQSP, MTCAP, MTECR, MTMP, MTEWE, MTBR, MVCAP, MVCR, MGPIR, MDDT, MDCR.\;Bit 24: If set, transceiver burn flow is supported in MCC, MCQI and MCQS.\;Bit 26: If set, progress field is supported in MCQS\;Bit 28: If set, number_of_slots field is supported in MGPIR.\;Bit 29: If set, virtual hot plug / unplug is supported in MPEGC.\;Bit 30: If set, my_pf_number is supported in MPPF.\;Bit 31: If set, sdee is supported in MTMP\;Bit 34: If set, MCIA supports 32 D-words. Otherwise, 12 D-words.\;Bit 35: If set, MGIR.hw_info.technology is supported. \;Bit 37: If set, lp_msb is supported for MLCR, MPIR \;Bit 39: If set, MRCS and RMDT tokens are supported in MCQS\;Bit 40: If set, &apos;encryption&apos; field in MGIR is supported\;Bit 43: If set, MFCR supports tacho_active_msb field\;Bit 44: If set, FORE supports fan_under_limit_msb and fan_over_limit_msb fields\;Bit 45: If set, MFRL.pci_rescan_required is supported\;Bit 46: time_adjust_range_extended - if set, the MTUTC.time_adjustment range is extended to --125,000 to 125,000\;Bit 47: If set, MTUTC.freq_adj_units=1 is supported\;Bit 48: If set, MRSR.command=6 is supported\;Bit 49: If set, MCQS.identifier support CRCS and CRDT tokens\;Bit 51: If set, MTUTC.freq_adj_units=2 is supported\;Bit 53: If set, Mlx mlxfwreset with downstream port is supported by FW [Internal]: NIC only, FW rejects reset till user committed that traffic is disabled\;Bit 59: If set, MCC.component_specific_error_code is valid for LinkX devices\;Bit 60: If set, MGNLE.clr is supported\;Bit 61: If set, MGIR supports life_cycle_msb and pds fields in FW info and development field in HW info.\; \;\;Bit 65: If set, MVCR support current_sensor_value_msb\;Bit 66: If set. MFRL supports pci_reset_req_method, pci_switch_exist fields. [DWIP]\;Bit 67: If set, MRSR.cmd = 6 works with SBR\;Bit 68: If set, supports MSCI version_type field [DWIP]\;" access="RO" high_bound="3" low_bound="0" offset="0x28.0" size="0x10.0" />
</node>

<node name="mcc_reg_ext" descr="" size="0x20.0" >
	<field name="instruction" descr="Command to be executed by the FSM\;0x1: LOCK_UPDATE_HANDLE\;0x2: RELEASE_UPDATE_HANDLE \;0x3: UPDATE_COMPONENT\;0x4: VERIFY_COMPONENT\;0x6: ACTIVATE\;0x7: READ_COMPONENT\;0x8: CANCEL\;0x9: CHECK_UPDATE_HANDLE\;0xA: FORCE_HANDLE_RELEASE\;0xB: READ_PENDING_COMPONENT\;0xC: DOWNSRTEAM_DEVICE_TRANSFER\;Other values are reserved. Applicable for write operation only." access="RW" enum="LOCK_UPDATE_HANDLE=0x1,RELEASE_UPDATE_HANDLE=0x2,UPDATE_COMPONENT=0x3,VERIFY_COMPONENT=0x4,ACTIVATE=0x6,READ_COMPONENT=0x7,CANCEL=0x8,CHECK_UPDATE_HANDLE=0x9,FORCE_HANDLE_RELEASE=0xa,READ_PENDING_COMPONENT=0xb,DOWNSRTEAM_DEVICE_TRANSFER=0xc" offset="0x0.0" size="0x0.8" />
	<field name="activation_delay_sec" descr="This is a configuration that delays the activation of the component in seconds. Relevant only for activate command.\;This configuration is volatile." access="RW" offset="0x0.8" size="0x0.8" />
	<field name="time_elapsed_since_last_cmd" descr="The number of seconds elapsed since the update_handle owner last issued a command. The time saturates at 0xFFF." access="RO" offset="0x0.16" size="0x0.12" />
	<field name="component_index" descr="Index of the accessed component. \;Value from MCQS.component_index\;Valid for \;UPDATE_COMPONENT, ACTIVATE_COMPONENET, READ_COMPONENT and READ_PENDING_COMPONENT instructions. Otherwise, this field is reserved." access="INDEX" offset="0x4.0" size="0x0.16" />
	<field name="update_handle" descr="Token representing the current flow executed by the FSM." access="RW" offset="0x8.0" size="0x0.24" />
	<field name="auto_update" descr="Auto-update to all matching downstream devices is requested." access="WO" offset="0x8.31" size="0x0.1" />
	<field name="control_state" descr="Current Update FSM state\;0x0: IDLE\;0x1: LOCKED\;0x2: INITIALIZE\;0x3: DOWNLOAD\;0x4: VERIFY\;0x5: APPLY\;0x6: ACTIVATE\;0x7: UPLOAD\;0x8: UPLOAD_PENDING\;0x9: DOWNSRTEAM_DEVICE_TRANSFER\;Other values are reserved" access="RO" enum="IDLE=0x0,LOCKED=0x1,INITIALIZE=0x2,DOWNLOAD=0x3,VERIFY=0x4,APPLY=0x5,ACTIVATE=0x6,UPLOAD=0x7,UPLOAD_PENDING=0x8,DOWNSRTEAM_DEVICE_TRANSFER=0x9" offset="0xC.0" size="0x0.4" />
	<field name="error_code" descr="Indicates the successful completion of the instruction, or the reason it failed. \;0x0: OK\;0x1: ERROR\;0x2: REJECTED_DIGEST_ERR\;0x3: REJECTED_NOT_APPLICABLE\;0x4: REJECTED_UNKNOWN_KEY\;0x5: REJECTED_AUTH_FAILED\;0x6: REJECTED_UNSIGNED\;0x7: REJECTED_KEY_NOT_APPLICABLE\;0x8: REJECTED_BAD_FORMAT\;0x9: BLOCKED_PENDING_RESET\;0xA: REJECTED_NOT_A_SECURED_FW\;0xB: REJECTED_MFG_BASE_MAC_NOT_LISTED\;0xC: REJECTED_NO_DEBUG_TOKEN\;0xD: REJECTED_VERSION_NUM_MISMATCH\;0xE: REJECTED_USER_TIMESTAMP_MISMATCH\;0xF: REJECTED_FORBIDDEN_VERSION\;0x10: FLASH_ERASE_ERROR\;0x11: REJECTED_REBURN_RUNNING_AND_RETRY\;0x12: REJECTED_LINKX_TYPE_NOT_SUPPORTED\;0x13: REJECTED_HOST_STORAGE_IN_USE\;0x14: REJECTED_LINKX_TRANSFER (see module index in rejected_device_index)\;0x15: REJECTED_LINKX_ACTIVATE (see module index in rejected_device_index)\;0x16: REJECTED_INCOMPATIBLE_FLASH\;0x17: REJECTED_TOKEN_ALREADY_APPLIED\;0x18: REJECTED_FW_BURN_DRAM_NOT_AVAILABLE\;0x19: FW_BURN_REJECTED_INVALID_SECURITY_VERSION\;0x1A: FW_BURN_REJECTED_CERT_CER509 \;0x1B: FW_BURN_REJECTED_CERT_SIGNATURE\;0x1C: FW_BURN_REJECTED_CERT_METADATA\;0x1D: FW_BURN_REJECTED_CERT_INTERNAL_ERROR_0 \;0x1E: FW_BURN_REJECTED_CERT_NO_PLACE\;0x1F: FW_BURN_REJECTED_CERT_REMOVAL_NO_MATCH_CERT_UIDD\;0x20: FW_BURN_REJECTED_CERTI_INTERNAL_ERROR_1 0x21: FW_BURN_REJECTED_CERT_INTERNAL_ERROR_2 0x22: FW_BURN_REJECTED_CERT_OF_NUM_OF_SWAP\;0x23: FW_BURN_REJECTED_CERT_INTERNAL_ERROR_3 \;0x24: FW_BURN_REJECTED_CERT_INTERNAL_ERROR_4 0x25: FW_BURN_REJECTED_CERT_NOT_ALLOWED_SAME_CERT_UIDD \;0x26: FW_BURN_REJECTED_CERTIFICATE_INTERNAL_ERROR_5 \;0x27: FW_BURN_REJECTED_CERTIFICATE_INTERNAL_ERROR_6 \;0x28: REJECTED_FLASH_WP\;0x29: FW_BURN_REJECTED_CERTIFICATE_INTERNAL_ERROR_7 0x2A: FW_BURN_REJECTED_CERTIFICATE_INTERNAL_ERROR_8 0x2B: FW_BURN_REJECTED_CERTIFICATE_INTERNAL_ERROR_9Other values should be treated as an unknown error." access="RO" offset="0xC.8" size="0x0.8" />
	<field name="control_progress" descr="Indicates the estimated progress status of the current operation executed by the FSM. Valid values are 0..100.\;101 indicates that progress reporting is not supported for this update state." access="RO" offset="0xC.16" size="0x0.7" />
	<field name="handle_owner_host_id" descr="For handle_owner_type BMC, command-interface and ICMD, indicates the identifier of the host of the handle owner.\;Otherwise reserved" access="RO" offset="0xC.24" size="0x0.4" />
	<field name="handle_owner_type" descr="Type of entity holding the update handle:\;0x0: unspecified\;0x1: Chassis BMC\;0x2: MAD\;0x3: BMC\;0x4: command interface\;0x5: ICMD \;Other values are reserved." access="RO" offset="0xC.28" size="0x0.4" />
	<field name="component_size" descr="Component size in bytes. \;Valid for UPDATE_COMPONENT instruction. Specifying the size may shorten the update time.\;Value 0x0 means that size is unspecified." access="WO" offset="0x10.0" size="0x4.0" />
	<field name="device_type" descr="Peripheral device type:\;0: Switch_or_NIC\;1: Gearbox" access="INDEX" enum="Switch_or_NIC=0x0,Gearbox=0x1" offset="0x14.0" size="0x0.8" />
	<field name="device_index" descr="Device number.\;For gearboxes, the index represents the gearbox die. \;For cables, the index represents the module index starting at index 1. Index 0 indicates the host device." access="INDEX" offset="0x14.16" size="0x0.12" />
	<field name="device_index_size" descr="In multiple downstream devices action, the action will be executed starting on device_index and ending on device_index + device_index_size - 1." access="RW" offset="0x18.0" size="0x0.12" />
	<field name="rejected_device_index" descr="The device index that the action has been rejected to." access="RO" offset="0x18.16" size="0x0.12" />
	<field name="component_specific_err_code" descr="[DWIP]:\;Component Specific Error Code\;Relevant only for Linkx failed updates" access="RO" offset="0x1C.0" size="0x4.0" />
</node>

<node name="mcda_reg_ext" descr="" size="0x90.0" >
	<field name="update_handle" descr="Update handle registered when the FSM was activated." access="RW" offset="0x0.0" size="0x0.24" />
	<field name="offset" descr="Offset of accessed address relative to component start. Accesses must be in accordance to log_mcda_word_size in Table 226, &quot;MCQI CAPABILITIES Info Layout,&quot; on page 267" access="RW" offset="0x4.0" size="0x4.0" />
	<field name="size" descr="Size of the data accessed, given in bytes" access="RW" offset="0x8.0" size="0x0.16" />
	<field name="data" descr="Data block accessed" access="RW" high_bound="31" low_bound="0" offset="0x10.0" size="0x80.0" />
</node>

<node name="mcqi_activation_method_ext" descr="" size="0x7c.0" >
	<field name="all_hosts_sync" descr="When set, the operation needed to move the component form ACTIVE_PENDING_RESET to ACTIVE should happen simultaneously on all hosts." access="RO" offset="0x0.0" size="0x0.1" />
	<field name="auto_activate" descr="This component will be ACTIVE or ACTIVE_PENDING_RESET after the APPLY state." access="RO" offset="0x0.1" size="0x0.1" />
	<field name="pending_fw_reset" descr="This component goes to ACTIVE_PENDING_RESET after activation.\;A FW reset will move it to ACTIVE state." access="RO" offset="0x0.2" size="0x0.1" />
	<field name="pending_server_reboot" descr="This component goes to ACTIVE_PENDING_RESET state after activation.\;A server reset (PCIe PERST#), will move it ACTIVE state." access="RO" offset="0x0.3" size="0x0.1" />
	<field name="pending_server_dc_power_cycle" descr="This component goes to ACTIVE_PENDING_RESET state after activation.\;DC power cycle (power cycle of PCI power rails), will move it ACTIVE state." access="RO" offset="0x0.4" size="0x0.1" />
	<field name="pending_server_ac_power_cycle" descr="This component goes to ACTIVE_PENDING_RESET state after activation.\;AC power cycle (power cycle for both PCI power rails and AUX power), will move it ACTIVE state." access="RO" offset="0x0.5" size="0x0.1" />
	<field name="self_activation" descr="When set, the component supports self activation. For cables, please refer to activation_type in LINKX_PROPERTIES data for more details." access="RO" offset="0x0.6" size="0x0.1" />
</node>

<node name="mcqi_cap_ext" descr="" size="0x7c.0" >
	<field name="supported_info_bitmask" descr="Bitmask indicating which info_type(s) are supported for this component. Set bit indicates the property set is supported\;bit 1: VERSION\;bit 5: ACTIVATION_METHOD\;Other bits are reserved. CAPABILITIES set is always supported.\;bit 6: LinkX\;bit 7: Clock Synchronizer\;" access="RO" offset="0x0.0" size="0x4.0" />
	<field name="component_size" descr="The size of the component given in bytes. Value 0x0 indicates that the size in unknown.\;For some components, size may only be available in the READ_COMPONENT state." access="RO" offset="0x4.0" size="0x4.0" />
	<field name="max_component_size" descr="Maximum size for this component, given in bytes." access="RO" offset="0x8.0" size="0x4.0" />
	<field name="mcda_max_write_size" descr="Maximal write size for MCDA" access="RO" offset="0xC.0" size="0x0.16" />
	<field name="log_mcda_word_size" descr="Log 2 of the access word size in bytes.\;Read and write access must be aligned to the word size. Write access must be done for an integer number of words." access="RO" offset="0xC.28" size="0x0.4" />
	<field name="match_base_guid_mac" descr="The device only accepts updates for this component that explicitly lists its base MAC and/or base GUID" access="RW" offset="0x10.26" size="0x0.1" />
	<field name="check_user_timestamp" descr="A user defined timestamp (MVTS) is active for this component." access="RW" offset="0x10.27" size="0x0.1" />
	<field name="match_psid" descr="PSID is validated for this component update." access="RW" offset="0x10.28" size="0x0.1" />
	<field name="match_chip_id" descr="Chip ID (device_hw_revision) is validated for this component update." access="RW" offset="0x10.29" size="0x0.1" />
	<field name="signed_updates_only" descr="Only signed components are accepted." access="RW" offset="0x10.30" size="0x0.1" />
	<field name="rd_en" descr="When set, this components may be read" access="RO" offset="0x10.31" size="0x0.1" />
</node>

<node name="mcqi_clock_source_properties_ext" descr="" size="0x4.0" >
	<field name="image_version_minor" descr="Image Version Minor Number" access="RO" offset="0x0.0" size="0x0.4" />
	<field name="image_version_major" descr="Image Version Major Number" access="RO" offset="0x0.4" size="0x0.4" />
	<field name="vendor_id" descr="Clock Source Device Vendor Id\;0: Renesas\;1: SiTime 148\;2: SiTime 348\;3: TI\;4-255: Reserved" access="RO" offset="0x0.16" size="0x0.8" />
</node>

<node name="mcqi_linkx_properties_ext" descr="" size="0x7c.0" >
	<field name="fw_image_status_bitmap" descr="Bit 0: Image A is running\;Bit 1: Image A is committed, module boots from image A\;Bit 2: Image A is erased / empty\;Bit 3: Reserved\;Bit 4: Image B is running\;Bit 5: Image B is committed, module boots from image B\;Bit 6: Image B is erased / empty\;Bit 7: Reserved" access="RO" offset="0x0.0" size="0x0.8" />
	<field name="fw_image_info_bitmap" descr="Bit 0: FW image A is present \;Bit 1: FW image B is present\;Bit 2: Factory / boot image is present\;Bits 3-7: Reserved" access="RO" offset="0x0.16" size="0x0.8" />
	<field name="image_a_minor" descr="Image A FW minor version" access="RO" offset="0x4.0" size="0x0.8" />
	<field name="image_a_major" descr="Image A FW major version" access="RO" offset="0x4.8" size="0x0.8" />
	<field name="image_a_subminor" descr="Image A FW subminor number" access="RO" offset="0x8.0" size="0x0.16" />
	<field name="image_b_minor" descr="Image B FW minor version" access="RO" offset="0xC.0" size="0x0.8" />
	<field name="image_b_major" descr="Image B FW major version" access="RO" offset="0xC.8" size="0x0.8" />
	<field name="image_b_subminor" descr="Image B FW subminor number" access="RO" offset="0x10.0" size="0x0.16" />
	<field name="factory_image_minor" descr="Factory / boot image FW minor version" access="RO" offset="0x14.0" size="0x0.8" />
	<field name="factory_image_major" descr="Factory / boot image FW major version" access="RO" offset="0x14.8" size="0x0.8" />
	<field name="factory_image_subminor" descr="Factory / boot image FW subminor number" access="RO" offset="0x18.0" size="0x0.16" />
	<field name="management_interface_protocol" descr="0: Does not support either one of the FW update procedures defined below\;1: SFF-8636 management interface and pseudo-CMIS FW. Update is supported\;2: CMIS 4.0 is implemented" access="RO" offset="0x1C.0" size="0x0.6" />
	<field name="activation_type" descr="0: HW reset is required. Host should be prepared to power cycle a cable after sending a RunFWImage command.\;1: Self-activation with HW reset contained in the RunFWImage command. No additional actions required from the host.\;2:Self-activation with hitless reset contained in the RunFWImage command. No additional actions required from the host.\;3-15: Reserved" access="RO" offset="0x1C.10" size="0x0.4" />
	<field name="vendor_sn" descr="Vendor Serial Number" access="RO" offset="0x20.0" size="0x0.16" />
</node>

<node name="mcqi_reg_data_auto_ext" descr="" attr_is_union="1" size="0x7c.0" >
	<field name="mcqi_cap_ext" descr="" subnode="mcqi_cap_ext" offset="0x0.0" selected_by="CAPABILITIES" size="0x7c.0" />
	<field name="mcqi_version_ext" descr="" subnode="mcqi_version_ext" offset="0x0.0" selected_by="VERSION" size="0x7c.0" />
	<field name="mcqi_activation_method_ext" descr="" subnode="mcqi_activation_method_ext" offset="0x0.0" selected_by="ACTIVATION_METHOD" size="0x7c.0" />
	<field name="mcqi_linkx_properties_ext" descr="" subnode="mcqi_linkx_properties_ext" offset="0x0.0" selected_by="LINKX_PROPERTIES" size="0x7c.0" />
	<field name="mcqi_clock_source_properties_ext" descr="" subnode="mcqi_clock_source_properties_ext" offset="0x0.0" selected_by="CLOCK_SOURCE_PROPERTIES" size="0x4.0" />
</node>

<node name="mcqi_reg_ext" descr="" size="0x94.0" >
	<field name="component_index" descr="Component index gathered by &quot;MCQS - Management Component Query Status&quot;" access="INDEX" offset="0x0.0" size="0x0.16" />
	<field name="device_index" descr="Device number.\;For gearboxes, the index represents the gearbox die. \;For cables, the index represents the module index starting at index 1. Index 0 indicates the host device.\;\;For Clock Source EEPROM, the index represents the Clock Source Index, starting from 1" access="INDEX" offset="0x0.16" size="0x0.12" />
	<field name="read_pending_component" descr="When set, the register will return information about the pending component (if available)" access="INDEX" offset="0x0.31" size="0x0.1" />
	<field name="device_type" descr="Peripheral device type:\;0: Switch / NIC\;1: Gearbox" access="INDEX" offset="0x4.0" size="0x0.8" />
	<field name="info_type" descr="Component properties set.\;0x0: CAPABILITIES\;0x1: VERSION\;0x5: ACTIVATION_METHOD\;0x6: LINKX_PROPERTIES\;0x7: CLOCK_SOURCE_PROPERTIES\;Other values are reserved" access="RW" enum="CAPABILITIES=0x0,VERSION=0x1,ACTIVATION_METHOD=0x5,LINKX_PROPERTIES=0x6,CLOCK_SOURCE_PROPERTIES=0x7" offset="0x8.0" size="0x0.5" />
	<field name="info_size" descr="Properties set structure size, given in bytes." access="RO" offset="0xC.0" size="0x4.0" />
	<field name="offset" descr="The requested/returned data offset from the section start, given in bytes.\;Must be DWORD aligned.\;If offset is invalid, FW will return an error." access="RW" offset="0x10.0" size="0x4.0" />
	<field name="data_size" descr="The requested/returned data size, given in bytes.\;If data_size is not DWORD aligned, the last bytes are zero padded.\;If size is invalid, FW will return an error." access="RW" offset="0x14.0" size="0x0.16" />
	<field name="data" descr="Properties set structure according to info_type.\;CAPABILITIES - See Table 226, &quot;MCQI CAPABILITIES Info Layout,&quot; on page 267\;VERSION - See Table 228, &quot;MCQI VERSION Info Layout,&quot; on page 269\;ACTIVATION_METHOD - See Table 232, &quot;MCQI ACTIVATION_METHOD Info Layout,&quot; on page 271\;LINKX_PROPERTIES - See Table 234, &quot;MCQI LINKX_PROPERTIES Info Layout,&quot; on page 272\;CLOCK_SOURCE_PROPERTIES - See Table 236, &quot;MCQI CLOCK_SOURCE_PROPERTIES Layout,&quot; on page 274" subnode="mcqi_reg_data_auto_ext" access="RO" offset="0x18.0" size="0x7c.0" union_selector="$(parent).info_type" />
</node>

<node name="mcqi_version_ext" descr="" size="0x7c.0" >
	<field name="version_string_length" descr="" access="RW" offset="0x0.0" size="0x0.8" />
	<field name="user_defined_time_valid" descr="When set, the component has a valid user-defined version time-stamp in user_defined_time" access="RW" offset="0x0.28" size="0x0.1" />
	<field name="build_time_valid" descr="When set, the component has a valid creation time-stamp in build_time" access="RW" offset="0x0.29" size="0x0.1" />
	<field name="version" descr="Version number" access="RW" offset="0x4.0" size="0x4.0" />
	<field name="build_time" descr="Time of component creation. Valid only if build_time_valid is set. See Table 230, &quot;Date-Time Layout,&quot; on page 270" subnode="date_time_layout_ext" access="RW" offset="0x8.0" size="0x8.0" />
	<field name="user_defined_time" descr="User-defined time assigned to the component version. Valid only if user_defined_time_valid is set. See Table 230, &quot;Date-Time Layout,&quot; on page 270" subnode="date_time_layout_ext" access="RW" offset="0x10.0" size="0x8.0" />
	<field name="build_tool_version" descr="Build tool version number.\;Valid only when not equal to 0" access="RW" offset="0x18.0" size="0x4.0" />
	<field name="version_string" descr="NULL terminated string representing the version." access="RW" high_bound="91" low_bound="0" offset="0x20.24" size="0x5c.0" />
</node>

<node name="mcqs_reg_ext" descr="" size="0x10.0" >
	<field name="component_index" descr="Component Index. Values range from 0 to the last component indicated by last_index_flag." access="INDEX" offset="0x0.0" size="0x0.16" />
	<field name="device_index" descr="Device number.\;For gearboxes, the index represents the gearbox die. \;For cables, the index represents the module index starting at index 1. Index 0 indicates the host device.\;For Clock synchronizer, index is used to represent the clock sync&apos; device index. Starting from 1." access="INDEX" offset="0x0.16" size="0x0.12" />
	<field name="last_index_flag" descr="When set, this component is the last component (highest component_index)." access="RO" offset="0x0.31" size="0x0.1" />
	<field name="identifier" descr="This field uniquely identifies a specific component type. \;0x1: BOOT_IMG\;0x4: OEM_NVCONFIG\;0x5: MLNX_NVCONFIG\;0x6: CS_TOKEN\;0x7: DBG_TOKEN\;0xA: Gearbox\;0xB: CC_ALGO - Congestion Control Algorithm\;0xC: LINKX_IMG\;0xD: CRYPTO_TO_COMMISSIONING\;0xE: RMCS_TOKEN\;0xF: RMDT_TOKEN\;0x10: CRCS_TOKEN. \;0x11: CRDT_TOKEN. \;0x12: CLOCK_SYNC_EEPROM.  \;0x15: DIGITAL_CACERT - Certificate to be trusted by the device0x17: DIGITAL_CACERT_REMOVAL\;\;Other values are reserved\;" access="RO" enum="BOOT_IMG=0x1,OEM_NVCONFIG=0x4,MLNX_NVCONFIG=0x5,CS_TOKEN=0x6,DBG_TOKEN=0x7,Gearbox=0xa,CC_ALGO=0xb,LINKX_IMG=0xc,CRYPTO_TO_COMMISSIONING=0xd,RMCS_TOKEN=0xe,RMDT_TOKEN=0xf,CRCS_TOKEN_=0x10,CRDT_TOKEN_=0x11,CLOCK_SYNC_EEPROM_=0x12,DIGITAL_CACERT=0x15" offset="0x4.0" size="0x0.16" />
	<field name="component_update_state" descr="Component state in update flow\;0x0: IDLE\;0x1: IN_PROGRESS\;0x2: APPLIED\;0x3: ACTIVE \;0x4: ACTIVE_PENDING_RESET\;0x5: FAILED\;0x6: CANCELED\;0x7: BUSY\;\;Other values are reserved" access="RO" enum="IDLE=0x0,IN_PROGRESS=0x1,APPLIED=0x2,ACTIVE=0x3,ACTIVE_PENDING_RESET=0x4,FAILED=0x5,CANCELED=0x6,BUSY=0x7" offset="0x8.0" size="0x0.4" />
	<field name="component_status" descr="The status of the component:\;0x0: NOT_PRESENT - The component is supported by the device but, currently not present\;0x1: PRESENT - This component is present. For downstream devices link LinkX component, this is an indication that the binary image is present at the host device memory.\;0x2: IN_USE - The component is present and currently in use." access="RO" enum="NOT_PRESENT=0x0,PRESENT=0x1,IN_USE=0x2" offset="0x8.4" size="0x0.5" />
	<field name="progress" descr="Progress in percentage (from 0 to 100). This field is only relevant for cables." access="RO" offset="0x8.9" size="0x0.7" />
	<field name="device_type" descr="Peripheral device type:\;0: Switch_or_NIC\;1: Gearbox" access="INDEX" offset="0xC.0" size="0x0.8" />
	<field name="last_update_state_changer_host_id" descr="For last_update_state_changer_type BMC, command-interface and ICMD, indicates the identifier of the host of the handle owner. Otherwise reserved." access="RO" offset="0xC.24" size="0x0.4" />
	<field name="last_update_state_changer_type" descr="Indicates which entity was the last to change the component_update_state of this component.\;0x0: unspecified\;0x1: Chassis_BMC\;0x2: MAD\;0x3: BMC\;0x4: command_interface\;0x5: ICMD\;\;Other values are reserved" access="RO" enum="unspecified=0x0,Chassis_BMC=0x1,MAD=0x2,BMC=0x3,command_interface=0x4,ICMD=0x5" offset="0xC.28" size="0x0.4" />
</node>

<node name="mdir_reg_ext" descr="" size="0x40.0" >
	<field name="device_id" descr="Device ID" access="RO" high_bound="7" low_bound="0" offset="0x0.0" size="0x20.0" />
</node>

<node name="mdsr_reg_ext" descr="" size="0x30.0" >
	<field name="status" descr="0: The debug session ended successfully\;1: Failed to execute the operation. See additional_info for more details.\;2: Debug session active. See type_of_token for more details.\;3: No token applied\;4: Challenge provided, no token installed yet, see type_of_token for details.\;5: Timeout before token installed, see type_of_token for details\;6: Timeout of active token.\;7-15: Reserved\;\;Note: Status might be &apos;0&apos; even when debug query is not allowed and additional_info field will expose the reason." access="RO" offset="0x0.0" size="0x0.4" />
	<field name="additional_info" descr="0: No additional information available \;1: There is no debug session in progress\;2: FW is not secured, debug session cannot be ended\;3: Fail - Debug end request cannot be accepted. \;4: Fail - Host is not allowed to query debug session\;5: Debug session active" access="RO" offset="0x0.8" size="0x0.6" />
	<field name="type_of_token" descr="0: CS token \;1: Debug FW token \;2: FRC token \;3: RMCS token\;4: RMDT token \;5: CRCS token \;6: CRDT token" access="INDEX" offset="0x0.24" size="0x0.8" />
	<field name="end" descr="Set to &apos;1&apos; to end debug session.\;Setting to &apos;0&apos; will not trigger any operation." access="WO" offset="0x4.31" size="0x0.1" />
	<field name="time_left" descr="Time left in seconds.\;In case that status is 2 (debug session active) - time left for token operation\;In case that status is 4 (challenge provided, no token installed yet) - time left for token installation\;For any other status, field should be zero" access="RO" offset="0x8.0" size="0x4.0" />
</node>

<node name="meccc_ext" descr="" size="0x14.0" >
	<field name="slot_index" descr="Slot index\;0: Main board" access="INDEX" offset="0x0.0" size="0x0.4" />
	<field name="device_index" descr="Device index\;For gearboxes, the index represents the gearbox die" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="clr" descr="Clear counters\;" access="OP" offset="0x4.0" size="0x0.1" />
	<field name="ecc_crt_cnt" descr="ECC Correctable Counter\;Counter increments 1 time per each SRAM (including TCAM) which had 1 or more ECC correctable events. \;Cleared at: (1) reset (including soft_reset), (2) clear bit\;Counts from: (1) main, (2) all tiles" access="RO" offset="0xC.0" size="0x4.0" />
	<field name="ecc_ucrt_cnt" descr="ECC Uncorrectable Counter\;Cleared at: (1) reset (including soft_reset), (2) clear bit\;" access="RO" offset="0x10.0" size="0x0.8" />
</node>

<node name="mfde_event_params_auto_ext" descr="" attr_is_union="1" size="0xa0.0" >
	<field name="crspace_timeout_ext" descr="" subnode="crspace_timeout_ext" offset="0x0.0" selected_by="crspace_timeout" size="0xa0.0" />
	<field name="kvd_im_stop_ext" descr="" subnode="kvd_im_stop_ext" offset="0x0.0" selected_by="kvd_im_stop" size="0xa0.0" />
	<field name="test_ext" descr="" subnode="test_ext" offset="0x0.0" selected_by="test" size="0xa0.0" />
	<field name="fw_assert_ext" descr="" subnode="fw_assert_ext" offset="0x0.0" selected_by="fw_assert" size="0xa0.0" />
	<field name="fatal_cause_ext" descr="" subnode="fatal_cause_ext" offset="0x0.0" selected_by="fatal_cause" size="0xa0.0" />
	<field name="riscv_exception_ext" descr="" subnode="riscv_exception_ext" offset="0x0.0" selected_by="riscv_exception" size="0x18.0" />
	<field name="code_fetch_error_ext" descr="" subnode="code_fetch_error_ext" offset="0x0.0" selected_by="pager_code_fetch_error" size="0x18.0" />
</node>

<node name="mfde_ext" descr="" size="0xb0.0" >
	<field name="event_id" descr="1: crspace_timeout\;2: kvd_im_stop - KVD insertion machine stopped\;3: test\;4: fw_assert\;5: fatal_cause\;6: long_cmd_timeout\;7: riscv_exception\;8: pager_code_fetch_error\;" access="RO" enum="crspace_timeout=0x1,kvd_im_stop=0x2,test=0x3,fw_assert=0x4,fatal_cause=0x5,long_cmd_timeout=0x6,riscv_exception=0x7,pager_code_fetch_error=0x8" offset="0x0.0" size="0x0.16" />
	<field name="severity" descr="Severity:\;2: FATL - (fatal) Unrecoverable switch behavior\;3: NRML - (normal) Unexpected state with possible systemic Failure\;5: INTR - (debug) Unexpected state without systemic Failure" access="RO" enum="FATL=0x2,NRML=0x3,INTR=0x5" offset="0x0.16" size="0x0.8" />
	<field name="irisc_id" descr="Which RISC triggered the event" access="RO" offset="0x0.24" size="0x0.8" />
	<field name="reg_attr_id" descr="For access register flows: register id\;For MAD flow: attribute id\;For command interface other flows: opcode" access="RO" offset="0x4.0" size="0x0.16" />
	<field name="mgmt_class" descr="Reserved when packet_cmd_type !=1 (mad)\;0: access register over mad" access="RO" offset="0x4.16" size="0x0.8" />
	<field name="packet_state" descr="Packet state\;Current packet state:\;0: idle\;1: retry\;2: long process\;Else, reserved." access="RO" offset="0x4.27" size="0x0.2" />
	<field name="method" descr="0: Query\;1: Write" access="RO" enum="Query=0x0,Write=0x1" offset="0x4.29" size="0x0.1" />
	<field name="notify_fw_dump_completion" descr="When set, SDK should notify FW once upon completion of the FW dump taken due to this event." access="RO" offset="0x4.31" size="0x0.1" />
	<field name="packet_interface" descr="Packet interface identification used internally in the firmware, e.g., PCI, C MDIF_DRIVER, CMDIF_TOOLS, ICMD, INBAND RX0, INBAND RX1, etc...\;0: Buffer_OOB0 \;1: Buffer_OOB1 \;2: Buffer_RX0 \;3: Buffer_RX1 \;4: ICMD\;5: Buffer_PC0 \;6: CMD_IF_Driver \;7: CMD_IF_Tools \;8: Buffer_IPR0_QP0 \;9: Buffer_IPR0_QP1 \;10: Buffer_IPR0_N2N \;11: Buffer_IPR0_HW_Traps \;12: Buffer_IPR1_HW_Traps \;13: Buffer_SMA_Traps_PBG \;14: BMC \;100: Buffer_MNG_SL_Q0 \;101: Buffer_MNG_SL_Q1 \;102: Buffer_MNG_SL_Q2 \;103: Buffer_MNG_SL_Q3 \;104: MNOC0 \;105: MNOC1 \;" access="RO" enum="Buffer_OOB0=0x0,Buffer_OOB1=0x1,Buffer_RX0=0x2,Buffer_RX1=0x3,ICMD=0x4,Buffer_PC0=0x5,CMD_IF_Driver=0x6,CMD_IF_Tools=0x7,Buffer_IPR0_QP0=0x8,Buffer_IPR0_QP1=0x9,Buffer_IPR0_N2N=0xa,Buffer_IPR0_HW_Traps=0xb,Buffer_IPR1_HW_Traps=0xc,Buffer_SMA_Traps_PBG=0xd,BMC=0xe,Buffer_MNG_SL_Q0=0x64,Buffer_MNG_SL_Q1=0x65,Buffer_MNG_SL_Q2=0x66,Buffer_MNG_SL_Q3=0x67,MNOC0=0x68,MNOC1=0x69" offset="0x8.0" size="0x0.8" />
	<field name="packet_cmd_type" descr="Packet command type:\;0: access_register\;1: mad\;2: other\;Else, reserved." access="RO" offset="0x8.8" size="0x0.2" />
	<field name="tile_index" descr="[DWIP]\;When tile_v=1 the tile_index that caused the timeout.\;\;Note: Supersedes event params&apos; tile_index" access="RO" offset="0x8.16" size="0x0.6" />
	<field name="tile_v" descr="[DWIP]\;Tile valid:\;0: The timeout was from main\;1: The timeout was from a tile\;\;Note: Supersedes event params&apos; tile_v" access="RO" offset="0x8.23" size="0x0.1" />
	<field name="packet_state_sticky" descr="sticky indication of previous packet state (if at some point it was different then idle it will stick to that value):\;0: idle\;1: retry\;2: long process\;Else, reserved." access="RO" offset="0x8.27" size="0x0.2" />
	<field name="event_params" descr="event parameters - layout is according to event_id value:\;See Table 609, &quot;Event_params crspace_timeout Layout,&quot; on page 629\;See Table 611, &quot;Event_params kvd_im_stop Layout,&quot; on page 631\;See Table 613, &quot;Event_params test Layout,&quot; on page 632\;See Table 615, &quot;Event_params fw_assert Layout,&quot; on page 633\;See Table 617, &quot;Event_params fatal_cause Layout,&quot; on page 635\;See Table 619, &quot;RiscV Exception Layout,&quot; on page 636\;See Table 621, &quot;Pager Code Fetch Error Layout,&quot; on page 637" subnode="mfde_event_params_auto_ext" access="RW" offset="0x10.0" size="0xa0.0" union_selector="$(parent).event_id" />
</node>

<node name="mfmc_reg_ext" descr="" size="0x1c.0" >
	<field name="fs" descr="Flash select - selects the flash device.\;Only zero is supported for NICs with a single flash device. \;Range between 0 .. MFPA.flash_num -1" access="INDEX" offset="0x0.4" size="0x0.2" />
	<field name="wrp_block_count" descr="Power of 2 of the write protect block count\;0: 1 block\;1: 2 blocks\;2: 4 blocks\;3: 8 blocks etc.\;Range 0..5\;Note that per flash device there may be invalid configurations\;Reserved when wrp_en = 0" access="RW" offset="0x4.0" size="0x0.8" />
	<field name="block_size" descr="Block size\;0: write protect sub-sector blocks\;1: write protect sector blocks\;Reserved when wrp_en = 0\;Note that not all block sizes are supported on all flash device, need to check MFPA capabilities" access="RW" offset="0x4.16" size="0x0.2" />
	<field name="wrp_en" descr="Write protect enable\;Set write protect of flash device" access="RW" offset="0x4.31" size="0x0.1" />
	<field name="sub_sector_protect_size" descr="Power of 2 for sub_sector size in 4Kbytes.\;0: 4Kbyte.\;1: 8 Kbyte\;2: 16Kbyte.\;Etc." access="RO" offset="0x8.0" size="0x0.6" />
	<field name="sector_protect_size" descr="Power of 2 for sector size in 4Kbytes.\;0: 4Kbyte.\;1: 8 Kbyte\;2: 16Kbyte.\;Etc." access="RO" offset="0x8.8" size="0x0.6" />
	<field name="quad_en" descr="Quad enable IO bit in the device status register" access="RW" offset="0x10.24" size="0x0.1" />
	<field name="dummy_clock_cycles" descr="The number of dummy clock cycles subsequent to all FAST READ commands. \;Reserved if not supported by the device" access="RW" offset="0x18.0" size="0x0.4" />
</node>

<node name="mfsv_reg_ext" descr="" size="0x30.0" >
	<field name="efuses_prog_en" descr="When this bit is set, it indicates that it is allowed for the boot FW to program the FW security version related EFUSEs if needed. This bit is not relevant in case the FW operates in an automatically EFUSEs programming approach (set in the INI file). Once set to 1, this configuration will be relevant only for the upcoming boot, thus this configuration will be set back to 0 upon next boot.\;\;" access="RW" offset="0x0.0" size="0x0.1" />
	<field name="fw_sec_ver_stat" descr="Firmware security version status.0: EFUSEs value is equal to the currently running FW image value. No change is needed.1: EFUSEs value is smaller than the currently running FW image value. An update to the EFUSEs is required.2: There is pending image, MFSV is rejected\;3: Reserved\;\;" access="RO" offset="0x0.1" size="0x0.2" />
	<field name="efuses_prog_method" descr="EFUSEs programming method.0: manually. Upon boot, if FW indicates that FW_sec_ver_stat is 1 and only if EFUSEs_prog_en is 1, it will program the EFUSEs as needed.1: automatically. Upon boot, if FW indicates that FW_sec_ver_stat is 1, it will program the EFUSEs as needed.\;\;" access="RO" offset="0x0.3" size="0x0.1" />
	<field name="revoke_efuse_prog" descr="0: EFUSEs value is equal to the currently running FW image value. No change is needed. \;1: EFUSEs value is smaller than the currently running FW image value. An update to the EFUSEs is required. \;" access="RW" offset="0x0.4" size="0x0.1" />
	<field name="pending_efuse_prog" descr="0: No pending EFUSE programming command \;1: There is pending MFSV command \;\;" access="RO" offset="0x0.5" size="0x0.1" />
	<field name="dummy_ratchet_prog_en" descr="[Internal]\;Relevant only from CX8/QM3/ArcusE \;When this bit is set, device should increase dummy ratchet value (fuse_psc_reserved2_field_ratchet) \;\;In case that fuse_psc_reserved2_field_ratchet = 0xFFFF, return Fuse_failure = 2." access="RO" offset="0x0.6" size="0x0.1" />
	<field name="fuse_failure" descr="" access="RO" offset="0x0.8" size="0x0.2" />
	<field name="index" descr="Index\;0: NCORE FW\;1: PSC_BL1\;2: PSC_FW\;3: BCT\;4: reserved2_field_ratchet\;5-15: Reserved" access="INDEX" offset="0x0.16" size="0x0.4" />
	<field name="img_sec_ver" descr="Image security version value" access="RO" offset="0x4.0" size="0x4.0" />
	<field name="efuses_sec_ver" descr="EFUSEs security version value" access="RO" offset="0x8.0" size="0x4.0" />
</node>

<node name="mgcr_reg_ext" descr="" size="0x20.0" >
	<field name="segment" descr="The GPIO segment which the command&apos;s parameters apply" access="INDEX" offset="0x0.0" size="0x0.8" />
	<field name="segments_count" descr="Ceiling function of total number of GPIOs / 32 in the system." access="RO" offset="0x0.8" size="0x0.8" />
	<field name="GPIO_data_in" descr="Input value of accessible GPIO[i] signals.\;When GPIO_access_en[i] = 0, GPIO_data_in[i] always returns 0" access="RO" offset="0x4.0" size="0x4.0" />
	<field name="GPIO_data_out" descr="Output value of accessible GPIO signals.\;When GPIO_access_en[i] = 0, GPIO_data_out[i] always returns 0" access="RO" offset="0x8.0" size="0x4.0" />
	<field name="GPIO_set" descr="These 2 fields are used together to control GPIO signals in the following manner:\;GPIO_set[i]=0, GPIO_clear[i]=0 : GPIO_data_out[i] = No Change\;GPIO_set[i]=0, GPIO_clear[i]=1 : GPIO_data_out[i] = 0\;GPIO_set[i]=1, GPIO_clear[i]=0 : GPIO_data_out[i] = 1\;GPIO_set[i]=1, GPIO_clear[i]=1 : GPIO_data_out[i] = not(GPIO_data_out[i])\;Ignored for non-controllable GPIO signals." access="WO" offset="0xC.0" size="0x4.0" />
	<field name="GPIO_clear" descr="These 2 fields are used together to control GPIO signals in the following manner:\;GPIO_set[i]=0, GPIO_clear[i]=0 : GPIO_data_out[i] = No Change\;GPIO_set[i]=0, GPIO_clear[i]=1 : GPIO_data_out[i] = 0\;GPIO_set[i]=1, GPIO_clear[i]=0 : GPIO_data_out[i] = 1\;GPIO_set[i]=1, GPIO_clear[i]=1 : GPIO_data_out[i] = not(GPIO_data_out[i])\;Ignored for non-controllable GPIO signals." access="WO" offset="0x10.0" size="0x4.0" />
	<field name="GPIO_access_en" descr="Access allowance to the corresponding GPIO signal.\;0: GPIO[i] is not observable / controllable by the host SW.\;1: GPIO[i] is observable / controllable by the host SW." access="RO" offset="0x14.0" size="0x4.0" />
	<field name="direction" descr="0: GPIO[i] is an input only signal\;1: GPIO[i] is an output signal. Data out can be updates by the host SW and data in can be queried by the host SW.\;For non-accessible GPIOs, the corresponding value is 0." access="RO" offset="0x18.0" size="0x4.0" />
	<field name="drive_type" descr="0: GPIO[i] is an open drain output. The device can only drive the GPIO[i] output pin low when GPIO_data_out[i] is 0. When GPIO_data_out[i] is 1, GPIO[i] is in HighZ. \;1: GPIO[i] is a full-drive output pin\;When GPIO_access_en[i] =0, direction[i] and drive_type[i] are always read as 0." access="RO" offset="0x1C.0" size="0x4.0" />
</node>

<node name="mgir_dev_info_ext" descr="" size="0x1c.0" >
	<field name="dev_branch_tag" descr="The format of the string represented by ASCII." access="RO" high_bound="27" low_bound="0" offset="0x0.24" size="0x1c.0" />
</node>

<node name="mgir_ext" descr="" size="0xa0.0" >
	<field name="hw_info" descr="Hardware Information, see Table 250, &quot;Hardware Info Layout,&quot; on page 286" subnode="mgir_hardware_info_ext" access="RW" offset="0x0.0" size="0x20.0" />
	<field name="fw_info" descr="Firmware Information, see Table 253, &quot;Firmware Info Layout,&quot; on page 289" subnode="mgir_fw_info_ext" access="RW" offset="0x20.0" size="0x40.0" />
	<field name="sw_info" descr="Software Information, see Table 255, &quot;Software Info Layout,&quot; on page 292\;This field indicates the oldest software version compatible with the current firmware" subnode="mgir_sw_info_ext" access="RW" offset="0x60.0" size="0x20.0" />
	<field name="dev_info" descr="Development Information, see Table 259, &quot;Development Info Layout,&quot; on page 296" subnode="mgir_dev_info_ext" access="RW" offset="0x80.0" size="0x1c.0" />
</node>

<node name="mgir_fw_info_ext" descr="" size="0x40.0" >
	<field name="sub_minor" descr="Sub-minor firmware version number.\;Deprecated and returns &apos;0&apos;. \;Refer to extended_sub_minor." access="RO" offset="0x0.0" size="0x0.8" />
	<field name="minor" descr="Minor firmware version number.\;Deprecated and returns &apos;0&apos;. \;Refer to extended_minor." access="RO" offset="0x0.8" size="0x0.8" />
	<field name="major" descr="Major firmware version number.\;Deprecated and returns &apos;0&apos;. \;Refer to extended_major." access="RO" offset="0x0.16" size="0x0.8" />
	<field name="secured" descr="When set, the device is running firmware with secure-firmware updates capabilities." access="RO" offset="0x0.24" size="0x0.1" />
	<field name="signed_fw" descr="When set the device is running a signed FW binaries." access="RO" offset="0x0.25" size="0x0.1" />
	<field name="debug" descr="When set, the device is running a debug firmware. &apos;debug&apos; binary can only be installed on specific devices (identified by their &apos;Factory base MAC&apos;), which currently run a specific firmware version. These restrictions are expressed by a signed &apos;debug&apos; token that must be loaded to the device before installing the debug binary." access="RO" offset="0x0.26" size="0x0.1" />
	<field name="dev" descr="*NOTE* this field has diff meaning for Switch vs. NIC \;\;\;\;Switch &amp; Retimer:\;The device is running:\;0: regular FW branch\;1: development branch" access="RO" offset="0x0.27" size="0x0.1" />
	<field name="string_tlv" descr="When set, string-TLV is supported.\;For Retimer - always return 0 (not supported)." access="RO" offset="0x0.28" size="0x0.1" />
	<field name="dev_sc" descr="*NOTE* for NICs same as dev field\;Development-secure:\;The device is running:\;0: a regular-secure firmware version\;1: a development-secure firmware version" access="RO" offset="0x0.30" size="0x0.1" />
	<field name="build_id" descr="Firmware Build ID. Optional. \;Note: Deprecated for switches and returns &apos;0&apos;." access="RO" offset="0x4.0" size="0x4.0" />
	<field name="year" descr="Firmware installation date. \;\;For example: 3 May 2004 will be coded as Month= 0x05, Day= 0x03, and Year= 0x04" access="RO" offset="0x8.0" size="0x0.16" />
	<field name="day" descr="Firmware installation date. \;\;For example: 3 May 2004 will be coded as Month= 0x05, Day= 0x03, and Year= 0x04" access="RO" offset="0x8.16" size="0x0.8" />
	<field name="month" descr="Firmware installation date. \;\;For example: 3 May 2004 will be coded as Month= 0x05, Day= 0x03, and Year= 0x04" access="RO" offset="0x8.24" size="0x0.8" />
	<field name="hour" descr="Firmware installation hour.\;For example 17:43 will be coded as 0x1743" access="RO" offset="0xC.0" size="0x0.16" />
	<field name="psid" descr="FW PSID" access="RO" high_bound="15" low_bound="0" offset="0x10.24" size="0x10.0" />
	<field name="ini_file_version" descr="User-configured version number of the current INI file." access="RO" offset="0x20.0" size="0x4.0" />
	<field name="extended_major" descr="FW version&apos;s Major field in extended (32b) format." access="RO" offset="0x24.0" size="0x4.0" />
	<field name="extended_minor" descr="FW version&apos;s Minor field in extended (32b) format." access="RO" offset="0x28.0" size="0x4.0" />
	<field name="extended_sub_minor" descr="FW version&apos;s SubMinor field in extended (32b) format." access="RO" offset="0x2C.0" size="0x4.0" />
	<field name="isfu_major" descr="incremented by one when version is not ISSUable" access="RO" offset="0x30.0" size="0x0.16" />
	<field name="disabled_tiles_bitmap" descr="Bitmap representing the disabled tiles in the ASIC. Tile &apos;0&apos; is represented by the msb bit. \;0: tile is enabled\;1: tile is disabled\;\;The total number of tiles can be derived through MGPIR register." access="RO" offset="0x30.16" size="0x0.16" />
	<field name="life_cycle" descr="0: Production\;1: GA Secured\;2: GA Non-Secured\;3: RMA\;4: Pre Production\;Note: has also msb bits in life_cycle_msb.\;" access="RO" offset="0x34.0" size="0x0.2" />
	<field name="sec_boot" descr="0: Disable\;1: Enable" access="RO" offset="0x34.2" size="0x0.1" />
	<field name="encryption" descr="0: Disable\;1: Enable" access="RO" offset="0x34.3" size="0x0.1" />
	<field name="life_cycle_msb" descr="[DWIP]\;MSB of the life cycle.\;Supported in QM3, CX8 and on." access="RO" offset="0x34.4" size="0x0.3" />
	<field name="issu_able" descr="[DWIP]\;ISSU-able:\;0: not ISSUable\;1: ISSUable\;Supported from Quantum-3 and on\;Supported for Retimers\;Based on FW decisions: fuse, INI, NV and version on flash vs. running version" access="RO" offset="0x34.13" size="0x0.1" />
	<field name="pds" descr="[DWIP]\;0: PSC is not PDS mode\;1: PSC in PDS mode\;Supported in QM3,CX8 and on." access="RO" offset="0x34.14" size="0x0.1" />
</node>

<node name="mgir_hardware_info_ext" descr="" size="0x20.0" >
	<field name="device_id" descr="PCI device ID. For specific device IDs, see Table 14, &quot;Switch Supported PCI Device IDs,&quot; on page 299" access="RO" offset="0x0.0" size="0x0.16" />
	<field name="device_hw_revision" descr="See Table 252, &quot;Device HW Revision Descriptions,&quot; on page 288" access="RO" offset="0x0.16" size="0x0.16" />
	<field name="pvs" descr="Process Voltage Scaling\;Supported nominal V_CORE voltage (in 50mV units) for the device." access="RO" offset="0x4.0" size="0x0.5" />
	<field name="technology" descr="Process technology\;0: N/A\;1: 40nm\;2: 28nm\;3: 16nm\;4: 7nm\;5: 5nm\;6-31: Reserved" access="RO" offset="0x4.11" size="0x0.5" />
	<field name="num_ports" descr="Number of physical port the device supports.\;For Retimer: returns the number of data path \;" access="RO" offset="0x4.16" size="0x0.8" />
	<field name="ib_mad_gen" descr="[DWIP]\;IB MAD Protocol. Based on value from ConfigProfile\;0: IBg1\;1: IBg2\;2-7: Reserved" access="RO" offset="0x4.28" size="0x0.3" />
	<field name="hw_dev_id" descr="The PCI device-ID of the NIC/HCA in recovery (Livefish) mode." access="RO" offset="0x8.0" size="0x0.16" />
	<field name="development" descr="[DWIP]\;The device is running:\;0: a regular-secure firmware version\;1: a development-secure firmware version\;\;Supported in QM3,CX8 and on." access="RO" offset="0xC.30" size="0x0.1" />
	<field name="manufacturing_base_mac_47_32" descr="MSB of the &quot;base&quot; MAC address of the NIC that was allocate during manufacturing. The NIC derives the MAC addresses for the different PCI PFs from this MAC address. This parameter can be used as a canonical unique identifier of the NIC.\;manufacturing_base_mac of value 0 means field is not supported." access="RO" offset="0x10.0" size="0x0.16" />
	<field name="ga" descr="[DWIP]\;Geographical Address\;0: ASIC 0\;1: ASIC 1\;2: ASIC 2\;3: ASIC 3\;Valid for multi ASIC platforms only\;\;." access="RO" offset="0x10.16" size="0x0.6" />
	<field name="chip_type" descr="[DWIP]\;Chip Type\;0: Real chip\;1: Emulation\;2: ChipSim\;3: SimX \;Supported from Quantum-3 and ArcusE" access="RO" offset="0x10.24" size="0x0.4" />
	<field name="manufacturing_base_mac_31_0" descr="LSB of the &quot;base&quot; MAC address of the NIC that was allocate during manufacturing. The NIC derives the MAC addresses for the different PCI PFs from this MAC address. This parameter can be used as a canonical unique identifier of the NIC.\;manufacturing_base_mac of value 0 means field is not supported." access="RO" offset="0x14.0" size="0x4.0" />
	<field name="device_ticks_per_msec" descr="Device Ticks per msec\;Reserved when chip_type = Real chip (0)" access="RO" offset="0x18.0" size="0x4.0" />
	<field name="uptime" descr="Time (in secs.) since last reset0" access="RO" offset="0x1C.0" size="0x4.0" />
</node>

<node name="mgir_sw_info_ext" descr="" size="0x20.0" >
	<field name="sub_minor" descr="Sub-minor Driver version number.\;" access="RO" offset="0x0.0" size="0x0.8" />
	<field name="minor" descr="Minor Driver version number.\;" access="RO" offset="0x0.8" size="0x0.8" />
	<field name="major" descr="Major Driver version number.\;" access="RO" offset="0x0.16" size="0x0.8" />
	<field name="rom3_type" descr="ROM 3 type:\;0x0: none\;0x1: Flexboot\;0x2: UEFI\;0x3: UEFI-CLP\;0x4: NVME\;0x5: FCODE\;0x6: UEFI Virtio net\;0x7: UEFI Virtio blk\;0x8: PXE Virtio net\;0x9-0xF: Reserved" access="RO" offset="0x4.0" size="0x0.4" />
	<field name="rom3_arch" descr="Arch type of ROM 3:\;0x0: unspecified\;0x1: AMD64 - x86 64bit architecture\;0x2: AARCH64 - ARM Architecture 64 bits\;0x3: AMD64_AARCH64 - ROM code supporting both AMD64 and AARCH64 architectures\;0x4: IA32 - Intel Architecture 32 bits" access="RO" offset="0x4.4" size="0x0.4" />
	<field name="rom2_type" descr="ROM 2type:\;0x0: none\;0x1: Flexboot\;0x2: UEFI\;0x3: UEFI-CLP\;0x4: NVME\;0x5: FCODE\;0x6: UEFI Virtio net\;0x7: UEFI Virtio blk\;0x8: PXE Virtio net\;0x9-0xF: Reserved" access="RO" offset="0x4.8" size="0x0.4" />
	<field name="rom2_arch" descr="Arch type of ROM 2:\;0x0: unspecified\;0x1: AMD64 - x86 64bit architecture\;0x2: AARCH64 - ARM Architecture 64 bits\;0x3: AMD64_AARCH64 - ROM code supporting both AMD64 and AARCH64 architectures\;0x4: IA32 - Intel Architecture 32 bits" access="RO" offset="0x4.12" size="0x0.4" />
	<field name="rom1_type" descr="ROM 1type:\;0x0: none\;0x1: Flexboot\;0x2: UEFI\;0x3: UEFI-CLP\;0x4: NVME\;0x5: FCODE\;0x6: UEFI Virtio net\;0x7: UEFI Virtio blk\;0x8: PXE Virtio net\;0x9-0xF: Reserved" access="RO" offset="0x4.16" size="0x0.4" />
	<field name="rom1_arch" descr="Arch type of ROM 1:\;0x0: unspecified\;0x1: AMD64 - x86 64bit architecture\;0x2: AARCH64 - ARM Architecture 64 bits\;0x3: AMD64_AARCH64 - ROM code supporting both AMD64 and AARCH64 architectures\;0x4: IA32 - Intel Architecture 32 bits" access="RO" offset="0x4.20" size="0x0.4" />
	<field name="rom0_type" descr="ROM 0 type:\;0x0: none\;0x1: Flexboot\;0x2: UEFI\;0x3: UEFI-CLP\;0x4: NVME\;0x5: FCODE\;0x6: UEFI Virtio net\;0x7: UEFI Virtio blk\;0x8: PXE Virtio net\;0x9-0xF: Reserved" access="RO" offset="0x4.24" size="0x0.4" />
	<field name="rom0_arch" descr="Arch type of ROM 0:\;0x0: unspecified\;0x1: AMD64 - x86 64bit architecture\;0x2: AARCH64 - ARM Architecture 64 bits\;0x3: AMD64_AARCH64 - ROM code supporting both AMD64 and AARCH64 architectures\;0x4: IA32 - Intel Architecture 32 bits" access="RO" offset="0x4.28" size="0x0.4" />
	<field name="rom0_version" descr="ROM 0 version." subnode="rom_version_ext" access="RO" offset="0x8.0" size="0x4.0" />
	<field name="rom1_version" descr="ROM 1 version." subnode="rom_version_ext" access="RO" offset="0xC.0" size="0x4.0" />
	<field name="rom2_version" descr="ROM 2version." subnode="rom_version_ext" access="RO" offset="0x10.0" size="0x4.0" />
	<field name="rom3_version" descr="ROM 3 version." subnode="rom_version_ext" access="RO" offset="0x14.0" size="0x4.0" />
</node>

<node name="module_latched_flag_info_ext" descr="" size="0xf8.0" >
	<field name="rx_los_cap" descr="when set, indicates modules supports rx los indication" access="RO" offset="0x0.0" size="0x0.1" />
	<field name="dp_fw_fault" descr="Valid for CMIS based modules only\;Latched modules Datapath fw fault flag" access="RO" offset="0x0.22" size="0x0.1" />
	<field name="mod_fw_fault" descr="Valid for CMIS based modules only\;Latched module fw fault flag" access="RO" offset="0x0.23" size="0x0.1" />
	<field name="vcc_flags" descr="Latched VCC flags of module\;Bit 0: high_vcc_alarm\;Bit 1: low_vcc_alarm\;Bit 2: high_vcc_warning\;Bit 3: low_vcc_warning" access="RO" enum="high_vcc_alarm=0x1,low_vcc_alarm=0x2,high_vcc_warning=0x4,low_vcc_warning=0x8" offset="0x0.24" size="0x0.4" />
	<field name="temp_flags" descr="Latched temperature flags of module\;Bit 0: high_temp_alarm\;Bit 1: low_temp_alarm\;Bit 2: high_temp_warning\;Bit 3: low_temp_warning" access="RO" enum="high_temp_alarm=0x1,low_temp_alarm=0x2,high_temp_warning=0x4,low_temp_warning=0x8" offset="0x0.28" size="0x0.4" />
	<field name="tx_ad_eq_fault" descr="Reserved for SFP\;Bitmask for latched Tx adaptive equalization fault flag per lane.\;Bit 0 - lane 0... Bit 7 - lane 7" access="RO" offset="0x4.0" size="0x0.8" />
	<field name="tx_cdr_lol" descr="Bitmask for latched Tx cdr loss of lock flag per lane.\;Bit 0 - lane 0... Bit 7 - lane 7" access="RO" offset="0x4.8" size="0x0.8" />
	<field name="tx_los" descr="Reserved for SFP\;Bitmask for latched Tx loss of signal flag per lane.\;Bit 0 - lane 0... Bit 7 - lane 7" access="RO" offset="0x4.16" size="0x0.8" />
	<field name="tx_fault" descr="Bitmask for latched Tx fault flag per lane.\;Bit 0 - lane 0... Bit 7 - lane 7" access="RO" offset="0x4.24" size="0x0.8" />
	<field name="tx_power_lo_war" descr="Bitmask for latched Tx power low warning flag per lane.\;Bit 0 - lane 0... Bit 7 - lane 7" access="RO" offset="0x8.0" size="0x0.8" />
	<field name="tx_power_hi_war" descr="Bitmask for latched Tx power high warning flag per lane.\;Bit 0 - lane 0... Bit 7 - lane 7" access="RO" offset="0x8.8" size="0x0.8" />
	<field name="tx_power_lo_al" descr="Bitmask for latched Tx power low alarm flag per lane.\;Bit 0 - lane 0... Bit 7 - lane 7" access="RO" offset="0x8.16" size="0x0.8" />
	<field name="tx_power_hi_al" descr="Bitmask for latched Tx power high alarm flag per lane.\;Bit 0 - lane 0... Bit 7 - lane 7" access="RO" offset="0x8.24" size="0x0.8" />
	<field name="tx_bias_lo_war" descr="Bitmask for latched Tx bias low warning flag per lane.\;Bit 0 - lane 0... Bit 7 - lane 7" access="RO" offset="0xC.0" size="0x0.8" />
	<field name="tx_bias_hi_war" descr="Bitmask for latched Tx bias high warning flag per lane.\;Bit 0 - lane 0... Bit 7 - lane 7" access="RO" offset="0xC.8" size="0x0.8" />
	<field name="tx_bias_lo_al" descr="Bitmask for latched Tx bias low alarm flag per lane.\;Bit 0 - lane 0... Bit 7 - lane 7" access="RO" offset="0xC.16" size="0x0.8" />
	<field name="tx_bias_hi_al" descr="Bitmask for latched Tx bias high alarm flag per lane.\;Bit 0 - lane 0... Bit 7 - lane 7" access="RO" offset="0xC.24" size="0x0.8" />
	<field name="rx_cdr_lol" descr="Bitmask for latched Rx cir loss of lock flag per lane.\;Bit 0 - lane 0 .. Bit 7 - lane 7" access="RO" offset="0x10.16" size="0x0.8" />
	<field name="rx_los" descr="Bitmask for latched Rx loss of signal flag per lane.\;Bit 0 - lane 0... Bit 7 - lane 7" access="RO" offset="0x10.24" size="0x0.8" />
	<field name="rx_power_lo_war" descr="Bitmask for latched Rx power low warning flag per lane.\;Bit 0 - lane 0... Bit 7 - lane 7" access="RO" offset="0x14.0" size="0x0.8" />
	<field name="rx_power_hi_war" descr="Bitmask for latched Rx power high warning flag per lane.\;Bit 0 - lane 0... Bit 7 - lane 7" access="RO" offset="0x14.8" size="0x0.8" />
	<field name="rx_power_lo_al" descr="Bitmask for latched Rx power low alarm flag per lane.\;Bit 0 - lane 0... Bit 7 - lane 7" access="RO" offset="0x14.16" size="0x0.8" />
	<field name="rx_power_hi_al" descr="Bitmask for latched Rx power high alarm flag per lane.\;Bit 0 - lane 0... Bit 7 - lane 7" access="RO" offset="0x14.24" size="0x0.8" />
	<field name="rx_output_valid_change" descr="Bitmask for latched rx output valid change per lane.\;Bit 0 - lane 0... Bit 7 - lane 7" access="RO" offset="0x18.0" size="0x0.8" />
	<field name="laser_bias_lo_war" descr="Thresholds for ELS laser bias, in unit of 100  A" access="RO" offset="0x20.0" size="0x0.8" />
	<field name="laser_bias_hi_war" descr="Thresholds for ELS laser bias, in unit of 100  A" access="RO" offset="0x20.8" size="0x0.8" />
	<field name="laser_bias_lo_al" descr="Thresholds for ELS laser bias, in unit of 100  A" access="RO" offset="0x20.16" size="0x0.8" />
	<field name="laser_bias_hi_al" descr="Thresholds for ELS laser bias, in unit of 100  A" access="RO" offset="0x20.24" size="0x0.8" />
	<field name="laser_opt_pwr_lo_war" descr="Thresholds for ELS laser optical power, in unit of 10  W\;" access="RO" offset="0x24.0" size="0x0.8" />
	<field name="laser_opt_pwr_hi_war" descr="Thresholds for ELS laser optical power, in unit of 10  W\;" access="RO" offset="0x24.8" size="0x0.8" />
	<field name="laser_opt_pwr_lo_al" descr="Thresholds for ELS laser optical power, in unit of 10  W\;" access="RO" offset="0x24.16" size="0x0.8" />
	<field name="laser_opt_pwr_hi_al" descr="Thresholds for ELS laser optical power, in unit of 10  W\;" access="RO" offset="0x24.24" size="0x0.8" />
	<field name="laser3_error_code" descr="ELS laser &lt;i&gt; fault code\;0 - No error\;1 - Automatic Power Control (APC) control loop failure\;2 - Automatic Current Control (ACC) control loop failure\;9 - TEC ramping timeout failure\;all else reserved" access="RO" offset="0x28.0" size="0x0.8" />
	<field name="laser2_error_code" descr="ELS laser &lt;i&gt; fault code\;0 - No error\;1 - Automatic Power Control (APC) control loop failure\;2 - Automatic Current Control (ACC) control loop failure\;9 - TEC ramping timeout failure\;all else reserved" access="RO" offset="0x28.8" size="0x0.8" />
	<field name="laser1_error_code" descr="ELS laser &lt;i&gt; fault code\;0 - No error\;1 - Automatic Power Control (APC) control loop failure\;2 - Automatic Current Control (ACC) control loop failure\;9 - TEC ramping timeout failure\;all else reserved" access="RO" offset="0x28.16" size="0x0.8" />
	<field name="laser0_error_code" descr="ELS laser &lt;i&gt; fault code\;0 - No error\;1 - Automatic Power Control (APC) control loop failure\;2 - Automatic Current Control (ACC) control loop failure\;9 - TEC ramping timeout failure\;all else reserved" access="RO" offset="0x28.24" size="0x0.8" />
	<field name="laser7_error_code" descr="ELS laser &lt;i&gt; fault code\;0 - No error\;1 - Automatic Power Control (APC) control loop failure\;2 - Automatic Current Control (ACC) control loop failure\;9 - TEC ramping timeout failure\;all else reserved" access="RO" offset="0x2C.0" size="0x0.8" />
	<field name="laser6_error_code" descr="ELS laser &lt;i&gt; fault code\;0 - No error\;1 - Automatic Power Control (APC) control loop failure\;2 - Automatic Current Control (ACC) control loop failure\;9 - TEC ramping timeout failure\;all else reserved" access="RO" offset="0x2C.8" size="0x0.8" />
	<field name="laser5_error_code" descr="ELS laser &lt;i&gt; fault code\;0 - No error\;1 - Automatic Power Control (APC) control loop failure\;2 - Automatic Current Control (ACC) control loop failure\;9 - TEC ramping timeout failure\;all else reserved" access="RO" offset="0x2C.16" size="0x0.8" />
	<field name="laser4_error_code" descr="ELS laser &lt;i&gt; fault code\;0 - No error\;1 - Automatic Power Control (APC) control loop failure\;2 - Automatic Current Control (ACC) control loop failure\;9 - TEC ramping timeout failure\;all else reserved" access="RO" offset="0x2C.24" size="0x0.8" />
	<field name="laser_fault_summery" descr="ELS laser fault summery\;bit 2 - OR&apos;ed lane fault\;bit 3 - OR&apos;ed lane warning" access="RO" offset="0x30.8" size="0x0.8" />
	<field name="warn_flag_lane" descr="ELSFP warning condition in lanes 1 to 8bit 0 - lane 0, bit 1 - lane 1, ..., bit 7 lane 7" access="RO" offset="0x30.16" size="0x0.8" />
	<field name="fault_flag_lane" descr="ELSFP fault condition in lanes 1 to 8bit 0 - lane 0, bit 1 - lane 1, ..., bit 7 lane 7" access="RO" offset="0x30.24" size="0x0.8" />
</node>

<node name="mqis_reg_ext" descr="" size="0x18.0" >
	<field name="info_type" descr="Type of information string to be queried:\;0x0: VPD - Read the PCI Vital Product Data capability content.\;0x1: MODEL_NAME\;0x2: MODEL_DESCRIPTION\;0x3: IMAGE_VSD\;0x4: DEVICE_VSD\;0x5: ROM_INFO\;other values are reserved." access="INDEX" enum="MODEL_NAME=0x1,MODEL_DESCRIPTION=0x2,IMAGE_VSD=0x3,DEVICE_VSD=0x4,ROM_INFO=0x5" offset="0x0.0" size="0x0.8" />
	<field name="info_length" descr="Total size of the information string, according to info_type. Value given in bytes." access="RO" offset="0x4.0" size="0x0.16" />
	<field name="read_length" descr="Number of bytes requested. The device returns the number of bytes actually read." access="RW" offset="0x8.0" size="0x0.16" />
	<field name="read_offset" descr="Offset in bytes of the first byte requested to read." access="INDEX" offset="0x8.16" size="0x0.16" />
	<field name="info_string" descr="Information string accessed, according to info_type. If the information is not available, a NULL string is returned." access="RO" high_bound="7" low_bound="0" offset="0x10.24" size="0x8.0" />
</node>

<node name="mrsr_ext" descr="" size="0x8.0" >
	<field name="command" descr="Reset/shutdown command\;0: clear state of reset_at_pci_disable\;1: software reset immediate (switch soft reset).\;6: reset_at_pci_disable - reset will be done at PCI_DISABLE. See MCAM bit48. Note: when no PCI (e.g. unmanaged switches or for Retimers) will do reset without waiting for PCI_DISABLE\;7: fw_link_reset_at_pci_disable - PCIe FW Link Reset, core is up [DWIP]" access="WO" offset="0x0.0" size="0x0.4" />
</node>

<node name="mtcq_reg_ext" descr="" size="0x70.0" >
	<field name="device_index" descr="Device number.\;For gearboxes, the index represents the gearbox die.\;For cables, the index represents the module index starting at index 1 while index 0 indicates the host device." access="INDEX" offset="0x0.0" size="0x0.12" />
	<field name="status" descr="Indicates the status of the desired token we are generating the challenge for.\;0x0 - OK\;0x1 - TOKEN_ALREADY_APPLIED\;0x2 - TOKEN_NOT_SUPPORTED\;0x3 - NO_KEY_CONFIGURED (there is no public_key that can be used for this token) \;0x4 - INTERFACE_NOT_ALLOWED (asking for local token from remote interface, or remote token from local interface)" access="RO" offset="0x0.16" size="0x0.8" />
	<field name="token_opcode" descr="The token which a challenge is generated for.\;0: RMCS\;1: RMDT\;2: CRCS - supported from Spectrum-4 and above\;3: CRDT - supported from Spectrum-4 and above\;Other: Reserved" access="INDEX" offset="0x0.24" size="0x0.8" />
	<field name="keypair_uuid" descr="The UUID of the key used to generate the challenge." access="RO" high_bound="3" low_bound="0" offset="0x4.0" size="0x10.0" />
	<field name="base_mac" descr="Device base MAC address / unique identifier." subnode="uint64" access="RO" offset="0x14.0" size="0x8.0" />
	<field name="psid" descr="Device PSID" access="RO" high_bound="3" low_bound="0" offset="0x1C.0" size="0x10.0" />
	<field name="fw_version_39_32" descr="Device FW version" access="RO" offset="0x2C.0" size="0x0.8" />
	<field name="fw_version_31_0" descr="Device FW version" access="RO" offset="0x30.0" size="0x4.0" />
	<field name="source_address" descr="Source address of debug requester. DLID for Infiniband\;Valid only for RMCS/RMDT." access="RO" high_bound="3" low_bound="0" offset="0x34.0" size="0x10.0" />
	<field name="session_id" descr="Unique debug session identifier. \;See details in REMOTE_DEBUG_KEEP_ALIVE.\;Valid only for RMCS." access="RO" offset="0x44.0" size="0x0.16" />
	<field name="challenge_version" descr="Version of the challenge format." access="RO" offset="0x44.24" size="0x0.8" />
	<field name="challenge" descr="Random generated field. Used for randomness and replay-protection." access="RO" high_bound="7" low_bound="0" offset="0x48.0" size="0x20.0" />
</node>

<node name="mtecr_ext" descr="" size="0x60.0" >
	<field name="sensor_count" descr="Number of sensors supported by the ASIC+platform\;This includes the ASIC, ambient sensors, module sensors, Gearboxes etc. \;This actually is equal to sum of all &apos;1&apos; in sensor_map\;\;Known sensors:\;0: current asic temp, FW exposes current max(all diode temp sensors)\;1..62: ambient, supported only for unmanaged switch, defined by ini\;64..255: modules\;256..288: Gearbox\;289..704: reserved for future" access="RO" offset="0x0.0" size="0x0.12" />
	<field name="last_sensor" descr="Last sensor index that is available in the system to read from.\;e.g. when 32modules: 64+32-1 = 95" access="RO" offset="0x0.16" size="0x0.12" />
	<field name="internal_sensor_count" descr="Number of sensors supported by the device that are on the ASIC. \;Exposes how many ASIC diodes exist. \;The FW exposes all of them as sensor[0]" access="RO" offset="0x4.0" size="0x0.7" />
	<field name="slot_index" descr="Slot index\;0: Main board" access="INDEX" offset="0x4.28" size="0x0.4" />
	<field name="sensor_map" descr="Mapping of system sensors supported by the device. Each bit represents a sensor.\;This field is size variable based on the last_sensor field and in granularity of 32bits.\;Per bit:\;0: Not connected or not supported\;1: Supports temperature measurements\;\;In case of last_sensor = 704 (22*32):\;sensor_warning[0] bit31 is sensor_warning[703]\;sensor_warning[0] bit0 is sensor_warning[703-31]\;sensor_warning[21] bit31 is sensor_warning[31]\;sensor_warning[21] bit0 is sensor_warning[0]\;\;In case if last_sensor = 259 (22*32):\;Note: roundup(259,32)=288\;sensor_warning[0] bit31 is sensor_warning[287]\;sensor_warning[0] bit0 is sensor_warning[287-31=256]\;sensor_warning[8] bit31 is sensor_warning[31]\;sensor_warning[8] bit0 is sensor_warning[0]\;sensor_warning[9..21] are not used\;\;64-192 of sensor_index are mapped to the modules sequentially (module 0 is mapped to sensor_index 64, module 1 to sensor_index 65 and so on)." access="RO" high_bound="21" low_bound="0" offset="0x8.0" size="0x58.0" />
</node>

<node name="mtewe_ext" descr="" size="0x5c.0" >
	<field name="sensor_count" descr="Number of sensors supported by the device\;This includes the ASIC, ambient sensors, Gearboxes etc.\;\;Known sensors:\;0: current asic temp, FW exposes current max(all diode temp sensors)\;1..62: ambient, supported only for unmanaged switch, defined by ini\;64..255: modules\;256..288: Gearbox\;289..704: reserved for future" access="RO" offset="0x0.0" size="0x0.12" />
	<field name="slot_index" descr="Slot index\;0: Main board" access="INDEX" offset="0x0.12" size="0x0.4" />
	<field name="last_sensor" descr="Last sensor index that is available in the system to read from." access="RO" offset="0x0.16" size="0x0.12" />
	<field name="sensor_warning" descr="Bit vector indicating which of the sensor reading is above threshold.\;This field is size dependent and based on last_sensor field and in granularity of 32bits.\;\;In case of last_sensor = 704 (22*32):\;sensor_warning[0] bit31 is sensor_warning[703]\;sensor_warning[0] bit0 is sensor_warning[703-31]\;sensor_warning[21] bit31 is sensor_warning[31]\;sensor_warning[21] bit0 is sensor_warning[0]\;\;In case if last_sensor = 259 (22*32):\;Note: roundup(259,32)=288\;sensor_warning[0] bit31 is sensor_warning[287]\;sensor_warning[0] bit0 is sensor_warning[287-31=256]\;sensor_warning[8] bit31 is sensor_warning[31]\;sensor_warning[8] bit0 is sensor_warning[0]\;sensor_warning[9..21] are not used" access="RO" high_bound="21" low_bound="0" offset="0x4.0" size="0x58.0" />
</node>

<node name="mtmp_ext" descr="" size="0x20.0" >
	<field name="sensor_index" descr="Sensors index\;0: current asic temp, FW exposes current max(all diode temp sensors)\;1..62: ambient, supported only for unmanaged switch, defined by ini\;64..255: modules 256..288: Gearbox\;Others up to 704 are reserved" access="INDEX" offset="0x0.0" size="0x0.12" />
	<field name="slot_index" descr="Slot index\;0: Main board" access="INDEX" offset="0x0.16" size="0x0.4" />
	<field name="asic_index" descr="ASIC index. See ig field for more details." access="INDEX" offset="0x0.25" size="0x0.4" />
	<field name="ig" descr="Internal granularity.\;Used to query the internal diodes of the switch main ASIC and tiles. \;0: the &apos;i&apos; field may be used to query the entire ASIC internal diodes. Main + tile.\;1: The &apos;i&apos; field is ignored and only the main ASIC diodes are available to query and sensor_index is the index of the main ASIC diodes. \;2: The &apos;i&apos; field is ignored and only the tile ASIC diodes are available to query and sensor_index is the index of the tile ASIC diodes. To query a specific tile, asic_index field should be used.\;3: Reserved.\;Those sensors are not available externally and should only be used for debug." access="INDEX" offset="0x0.29" size="0x0.2" />
	<field name="i" descr="Used to query the internal diodes of the switch ASIC; for i=1, sensor_index is the index of the ASIC diode." access="INDEX" offset="0x0.31" size="0x0.1" />
	<field name="temperature" descr="Temperature reading from the sensor. \;Units of 0.125 Celsius degrees.\;For negative values 2&apos;s complement is used (for example: -3.25 Celsius will read as 0xFFE6)" access="RO" offset="0x4.0" size="0x0.16" />
	<field name="max_temperature" descr="The highest measured temperature from the sensor.\;Reserved when mte = 0\;Cleared by mtr = 1\;Valid only when i = 0\;" access="RO" offset="0x8.0" size="0x0.16" />
	<field name="sdme" descr="Shut Down Events Modify Set Enable:\;0: all fields are set\;1: only sdee field is set, all other fields reserved" access="OP" offset="0x8.28" size="0x0.1" />
	<field name="weme" descr="Warning Events Modify Set Enable:\;0: all fields are set\;1: only tee field is set, all other fields reserved" access="OP" offset="0x8.29" size="0x0.1" />
	<field name="mtr" descr="Max Temperature Reset:\;0: do not modify the value of the max temperature register\;1: clear the value of the max temperature register" access="OP" offset="0x8.30" size="0x0.1" />
	<field name="mte" descr="Max Temperature Enable:\;0: disable measuring the max temperature on a sensor\;1: enables measuring the max temperature on a sensor" access="RW" offset="0x8.31" size="0x0.1" />
	<field name="temperature_threshold_hi" descr="temperature_threshold_hi refers to the high threshold of Warning Event. \;If the sensor temperature measurement is above the threshold (and events are enabled), an event will be generated.\;threshold_hi and threshold_lo implements hysteresis mechanism of the threshold preventing toggling of the indication.\;Note that temperature_threshold_hi must be equal or lower than the system requirement.\;System requirement for module is the module warning temperature.\;System requirement for board/silicon sensors is according to product information parameters\;Note that the temperature threshold can be used to generate an event message or an interrupt using GPIO" access="RW" offset="0xC.0" size="0x0.16" />
	<field name="sdee" descr="Temperature Shut Down Event Enable (MTSDE Register)\;0: do_not_generate_event\;1: generate_event\;2: generate_single_event\;\;Supported in downstream devices (devices on slots)." access="RW" offset="0xC.28" size="0x0.2" />
	<field name="tee" descr="Temperature Warning Event Enable (MTEWE Register)\;0: do_not_generate_event\;1: generate_event\;2: generate_single_event\;\;" access="RW" enum="do_not_generate_event=0x0,generate_event=0x1,generate_single_event=0x2" offset="0xC.30" size="0x0.2" />
	<field name="temperature_threshold_lo" descr="temperature_threshold_lo refers to the low threshold of Warning Event. \;The offset threshold_lo implements the lower threshold for the hysteresis mechanism of over temperature alert. Once alert is set, if the temperature goes below this threshold, the alert is cleared.\;Note that temperature_threshold_lo must be at least 5 degrees lower than temperature_threshold_hi" access="RW" offset="0x10.0" size="0x0.16" />
	<field name="sensor_name_hi" descr="Sensor Name\;8 character long sensor name\;" access="RO" offset="0x18.0" size="0x4.0" />
	<field name="sensor_name_lo" descr="Sensor Name\;8 character long sensor name\;" access="RO" offset="0x1C.0" size="0x4.0" />
</node>

<node name="mvcr_ext" descr="" size="0x18.0" >
	<field name="sensor_index" descr="Sensors:\;- 0..max_system_sensors-1 are ambient sensors on the system (max_system_sensors from INI)\;\;\;" access="INDEX" offset="0x0.0" size="0x0.8" />
	<field name="slot_index" descr="Slot index\;0: Main board\;" access="INDEX" offset="0x0.16" size="0x0.4" />
	<field name="voltage_sensor_value" descr="Voltage reading from the sensor. \;Voltage units are 0.01V." access="RO" offset="0x4.0" size="0x0.16" />
	<field name="current_sensor_value" descr="Current reading from the sensor. \;" access="RO" offset="0x8.0" size="0x0.16" />
	<field name="current_sensor_value_msb" descr="Current reading from the sensor msb." access="RO" offset="0x8.16" size="0x0.16" />
	<field name="sensor_name" descr="Sensor Name\;8 character long sensor name.\;Reserved for index 64 - 127 (modules sensors)\;" subnode="uint64" access="RO" offset="0x10.0" size="0x8.0" />
</node>

<node name="pddr_c2p_link_enabled_eth_ext" descr="" size="0x4.0" >
	<field name="core_to_phy_link_eth_enabled" descr="Ethernet protocols admin state: see PTYS.ext_eth_proto_admin" access="RO" offset="0x0.0" size="0x4.0" />
</node>

<node name="pddr_c2p_link_enabled_ib_ext" descr="" size="0x4.0" >
	<field name="core_to_phy_link_proto_enabled" descr="bi link enabled speed:\;Bit 0: SDR\;Bit 1: DDR\;Bit 2: QDR\;Bit 3: FDR10\;Bit 4: FDR\;Bit 5: EDR\;Bit 6: HDR\;Bit 7: NDR\;Bit 8: XDR" access="RO" enum="SDR=0x1,DDR=0x2,QDR=0x4,FDR10=0x8,FDR=0x10,EDR=0x20,HDR=0x40,NDR=0x80,XDR=0x100" offset="0x0.0" size="0x0.16" />
	<field name="core_to_phy_link_width_enabled" descr="IB link enabled width:\;Bit 0: 1x\;Bit 1: 2x\;Bit 2: 4x\;\;Other - reserved" access="RO" offset="0x0.16" size="0x0.16" />
</node>

<node name="pddr_c2p_link_enabled_nvlink_ext" descr="" size="0x4.0" >
	<field name="core_to_phy_link_nvlink_enabled" descr="NVLink protocols admin state\;see: Table  668, &quot;PTYS - Extended Protocol NVLink - admin layout,&quot; on page  728" access="RO" offset="0x0.0" size="0x4.0" />
</node>

<node name="pddr_cable_cap_eth_ext" descr="" size="0x4.0" >
	<field name="cable_ext_eth_proto_cap" descr="Cable Ethernet protocols cap. If PTYS.ext_eth_proto_cap filed is supported, use for opcode definition PTYS.ext_eth_proto_capIf PTYS.ext_eth_proto_capability mask is empty, use For opcode definition PTYS.eth_proto_cap." access="RO" offset="0x0.0" size="0x4.0" />
</node>

<node name="pddr_cable_cap_ib_ext" descr="" size="0x4.0" >
	<field name="cable_link_speed_cap" descr="Cable support IB speed:\;Bit 0: SDR\;Bit 1: DDR\;Bit 2: QDR\;Bit 3: FDR10\;Bit 4: FDR\;Bit 5: EDR\;Bit 6: HDR\;Bit 7: NDR\;Bit 8: XDR" access="RO" enum="SDR=0x1,DDR=0x2,QDR=0x4,FDR10=0x8,FDR=0x10,EDR=0x20,HDR=0x40,NDR=0x80,XDR=0x100" offset="0x0.0" size="0x0.16" />
	<field name="cable_link_width_cap" descr="Cable support IB width:\;Bit 0: 1x\;Bit 1: 2x\;Bit 2: 4x\;\;Other - reserved" access="RO" offset="0x0.16" size="0x0.16" />
</node>

<node name="pddr_cable_cap_nvlink_ext" descr="" size="0x4.0" >
	<field name="cable_nvlink_proto_cap" descr="Cable NVLink protocols cap:\;See: Table  666, &quot;PTYS - Extended Protocol NVLink - cap/oper layout,&quot; on page  727" access="RO" offset="0x0.0" size="0x4.0" />
</node>

<node name="pddr_link_active_eth_ext" descr="" size="0x4.0" >
	<field name="link_eth_active" descr="Ethernet protocols active: see PTYS.ext_eth_proto_oper" access="RO" offset="0x0.0" size="0x4.0" />
</node>

<node name="pddr_link_active_ib_ext" descr="" size="0x4.0" >
	<field name="link_speed_active" descr="IB link active speed:\;Bit 0: SDR\;Bit 1: DDR\;Bit 2: QDR\;Bit 3: FDR10\;Bit 4: FDR\;Bit 5: EDR\;Bit 6: HDR\;Bit 7: NDR\;Bit 8: XDR" access="RO" enum="SDR=0x1,DDR=0x2,QDR=0x4,FDR10=0x8,FDR=0x10,EDR=0x20,HDR=0x40,NDR=0x80,XDR=0x100" offset="0x0.0" size="0x0.16" />
	<field name="link_width_active" descr="IB link active width:\;Bit 0: 1x\;Bit 1: 2x\;Bit 2: 4x\;\;Other - reserved" access="RO" offset="0x0.16" size="0x0.16" />
</node>

<node name="pddr_link_active_nvlink_ext" descr="" size="0x4.0" >
	<field name="link_nvlink_active" descr="NVLink protocols active\;See: Table  666, &quot;PTYS - Extended Protocol NVLink - cap/oper layout,&quot; on page  727" access="RO" offset="0x0.0" size="0x4.0" />
</node>

<node name="pddr_link_down_info_page_ext" descr="" size="0xf4.0" >
	<field name="down_blame" descr="Which receiver caused last link down: \;0: Unknown\;1: Local_phy\;2: Remote_phy" access="RO" enum="Unknown=0x0,Local_phy=0x1,Remote_phy=0x2" offset="0x0.0" size="0x0.4" />
	<field name="local_reason_opcode" descr="Opcode of link down reason for local / remote side: \;0: No_link_down_indication\;1: Unknown_reason\;2: Hi_SER_or_Hi_BER\;3: Block_Lock_loss\;4: Alignment_loss\;5: FEC_sync_loss\;6: PLL_lock_loss\;7: FIFO_overflow\;8: false_SKIP_condition\;9: Minor_Error_threshold_exceeded\;10: Physical_layer_retransmission_timeout\;11: Heartbeat_errors\;12: Link_Layer_credit_monitoring_watchdog\;13: Link_Layer_integrity_threshold_exceeded\;14: Link_Layer_buffer_overrun\;15: Down_by_outband_command_with_healthy_link\;16: Down_by_outband_command_for_link_with_hi_ber\;17: Down_by_inband_command_with_healthy_link\;18: Down_by_inband_command_for_link_with_hi_ber\;19: Down_by_verification_GW\;20: Received_Remote_Fault \;21: Received_TS1\;22: Down_by_management_command\;23: Cable_was_unplugged\;24: Cable_access_issue \;25: Thermal_shutdown \;26: Current_issue \;27: Power_budget\;28: Fast_recovery_raw_ber\;29: Fast_recovery_effective_ber\;30: Fast_recovery_symbol_ber\;31: Fast_recovery_credit_watchdog\;32: Peer_side_down_to_sleep_state\;33: Peer_side_down_to_disable_state\;34: Peer_side_down_to_disable_and_port_lock\;35: Peer_side_down_due_to_thermal_event\;36: Peer_side_down_due_to_force_event\;37: Peer_side_down_due_to_reset_event\;38: Reset_no_power_cycle\;39: Fast_recovery_tx_plr_trigger\;40: Down_due_to_HW_force_event" access="RO" enum="No_link_down_indication=0x0,Unknown_reason=0x1,Hi_SER_or_Hi_BER=0x2,Block_Lock_loss=0x3,Alignment_loss=0x4,FEC_sync_loss=0x5,PLL_lock_loss=0x6,FIFO_overflow=0x7,false_SKIP_condition=0x8,Minor_Error_threshold_exceeded=0x9,Physical_layer_retransmission_timeout=0xa,Heartbeat_errors=0xb,Link_Layer_credit_monitoring_watchdog=0xc,Link_Layer_integrity_threshold_exceeded=0xd,Link_Layer_buffer_overrun=0xe,Down_by_outband_command_with_healthy_link=0xf,Down_by_outband_command_for_link_with_hi_ber=0x10,Down_by_inband_command_with_healthy_link=0x11,Down_by_inband_command_for_link_with_hi_ber=0x12,Down_by_verification_GW=0x13,Received_Remote_Fault=0x14,Received_TS1=0x15,Down_by_management_command=0x16,Cable_was_unplugged=0x17,Cable_access_issue=0x18,Thermal_shutdown=0x19,Current_issue=0x1a,Power_budget=0x1b,Fast_recovery_raw_ber=0x1c,Fast_recovery_effective_ber=0x1d,Fast_recovery_symbol_ber=0x1e,Fast_recovery_credit_watchdog=0x1f,Peer_side_down_to_sleep_state=0x20,Peer_side_down_to_disable_state=0x21,Peer_side_down_to_disable_and_port_lock=0x22,Peer_side_down_due_to_thermal_event=0x23,Peer_side_down_due_to_force_event=0x24,Peer_side_down_due_to_reset_event=0x25,Reset_no_power_cycle=0x26,Fast_recovery_tx_plr_trigger=0x27,Down_due_to_HW_force_event=0x28" offset="0x4.0" size="0x0.8" />
	<field name="remote_reason_opcode" descr="Opcode of link down reason for local / remote side: \;0: No_link_down_indication\;1: Unknown_reason\;2: Hi_SER_or_Hi_BER\;3: Block_Lock_loss\;4: Alignment_loss\;5: FEC_sync_loss\;6: PLL_lock_loss\;7: FIFO_overflow\;8: false_SKIP_condition\;9: Minor_Error_threshold_exceeded\;10: Physical_layer_retransmission_timeout\;11: Heartbeat_errors\;12: Link_Layer_credit_monitoring_watchdog\;13: Link_Layer_integrity_threshold_exceeded\;14: Link_Layer_buffer_overrun\;15: Down_by_outband_command_with_healthy_link\;16: Down_by_outband_command_for_link_with_hi_ber\;17: Down_by_inband_command_with_healthy_link\;18: Down_by_inband_command_for_link_with_hi_ber\;19: Down_by_verification_GW\;20: Received_Remote_Fault \;21: Received_TS1\;22: Down_by_management_command\;23: Cable_was_unplugged\;24: Cable_access_issue \;25: Thermal_shutdown \;26: Current_issue \;27: Power_budget\;28: Fast_recovery_raw_ber\;29: Fast_recovery_effective_ber\;30: Fast_recovery_symbol_ber\;31: Fast_recovery_credit_watchdog\;32: Peer_side_down_to_sleep_state\;33: Peer_side_down_to_disable_state\;34: Peer_side_down_to_disable_and_port_lock\;35: Peer_side_down_due_to_thermal_event\;36: Peer_side_down_due_to_force_event\;37: Peer_side_down_due_to_reset_event\;38: Reset_no_power_cycle\;39: Fast_recovery_tx_plr_trigger\;40: Down_due_to_HW_force_event" access="RO" offset="0x8.0" size="0x0.8" />
	<field name="e2e_reason_opcode" descr="see local_reason_opcode for local reason opcode\;for remote reason opcode: local_reason_opcode+100" access="RO" offset="0xC.0" size="0x0.8" />
	<field name="ts1_opcode" descr="TS1 opcode describes the reason the peer requested to ramp down the link:\;0x8: TS1.Sleep\;0x9: TS1.Disable\;0xA: TS1.PortLock\;0xB: TS1.Thermal\;0xC: TS1.Clean \;0xD  : TS1.Force\;0xE: TS1.reset_req\;\;Note: This field is valid in case the local_reason_opcode = 21 or 32-38" access="RO" offset="0xC.12" size="0x0.4" />
	<field name="num_of_symbol_ber_alarms" descr="Number of Symbol BER Windows that crossed alarm threshold" access="RO" offset="0x10.0" size="0x0.16" />
	<field name="last_raw_ber_magnitude" descr="Last raw BER window calculated.\;\;Raw_BER = raw_ber_coef*10^(-raw_ber_magnitude)" access="RO" offset="0x10.16" size="0x0.8" />
	<field name="last_raw_ber_coef" descr="Last raw BER window calculated.\;\;Raw_BER = raw_ber_coef*10^(-raw_ber_magnitude)" access="RO" offset="0x10.24" size="0x0.4" />
	<field name="cons_raw_norm_ber" descr="Number of last consecutive normal Raw BER windows" access="RO" offset="0x10.28" size="0x0.4" />
	<field name="max_raw_ber_magnitude" descr="Maximal raw BER window calculated.\;\;Raw_BER = raw_ber_coef*10^(-raw_ber_magnitude)\;" access="RO" offset="0x14.0" size="0x0.8" />
	<field name="max_raw_ber_coef" descr="Maximal raw BER window calculated.\;\;Raw_BER = raw_ber_coef*10^(-raw_ber_magnitude)\;" access="RO" offset="0x14.8" size="0x0.4" />
	<field name="min_raw_ber_magnitude" descr="Minimal raw BER window calculated.\;\;Raw_BER = raw_ber_coef*10^(-raw_ber_magnitude)\;" access="RO" offset="0x14.16" size="0x0.8" />
	<field name="min_raw_ber_coef" descr="Minimal raw BER window calculated.\;\;Raw_BER = raw_ber_coef*10^(-raw_ber_magnitude)\;" access="RO" offset="0x14.24" size="0x0.4" />
	<field name="num_of_raw_ber_alarms" descr="Number of Raw BER Windows that crossed alarm threshold\;" access="RO" offset="0x18.0" size="0x0.16" />
	<field name="num_of_eff_ber_alarms" descr="Number of Effective BER Windows that crossed alarm threshold\;" access="RO" offset="0x18.16" size="0x0.16" />
	<field name="time_to_link_down_to_disable" descr="Time in msec to link down to disable state, once a paos down is set or a link down event occurs.\;If the phy manager state is different then disable the timer will return 0." access="RO" offset="0x1C.0" size="0x4.0" />
	<field name="time_to_link_down_to_rx_loss" descr="Time in msec to link down to rx disable state, once a link down event occurs.\;If the phy manager state is different then rx disable the timer will return 0.\;Internal: Only for NDR devices." access="RO" offset="0x20.0" size="0x4.0" />
	<field name="min_eff_ber_magnitude" descr="Minimal effective BER window calculated.\;\;Effective_BER = eff_ber_coef*10^(-eff_ber_magnitude)" access="RO" offset="0x24.0" size="0x0.8" />
	<field name="min_eff_ber_coef" descr="Minimal effective BER window calculated.\;\;Effective_BER = eff_ber_coef*10^(-eff_ber_magnitude)" access="RO" offset="0x24.8" size="0x0.4" />
	<field name="last_eff_ber_magnitude" descr="Last effective BER window calculated.\;\;Effective_BER = eff_ber_coef*10^(-eff_ber_magnitude)" access="RO" offset="0x24.16" size="0x0.8" />
	<field name="last_eff_ber_coef" descr="Last effective BER window calculated.\;\;Effective_BER = eff_ber_coef*10^(-eff_ber_magnitude)" access="RO" offset="0x24.24" size="0x0.4" />
	<field name="cons_eff_norm_ber" descr="Number of last consecutive normal Effective BER windows" access="RO" offset="0x24.28" size="0x0.4" />
	<field name="max_eff_ber_magnitude" descr="Maximal effective BER window calculated.\;\;Effective_BER = eff_ber_coef*10^(-eff_ber_magnitude)" access="RO" offset="0x28.0" size="0x0.8" />
	<field name="max_eff_ber_coef" descr="Maximal effective BER window calculated.\;\;Effective_BER = eff_ber_coef*10^(-eff_ber_magnitude)" access="RO" offset="0x28.8" size="0x0.4" />
	<field name="max_symbol_ber_magnitude" descr="Maximal symbol BER window calculated.\;\;Effective_BER = symbol_ber_coef*10^(-symbol_ber_magnitude)" access="RO" offset="0x28.16" size="0x0.8" />
	<field name="max_symbol_ber_coef" descr="Maximal symbol BER window calculated.\;\;Effective_BER = symbol_ber_coef*10^(-symbol_ber_magnitude)" access="RO" offset="0x28.24" size="0x0.4" />
	<field name="cons_symbol_norm_ber" descr="Number of last consecutive normal Symbol BER windows" access="RO" offset="0x28.28" size="0x0.4" />
	<field name="min_symbol_ber_magnitude" descr="Minimal symbol BER window calculated.\;\;Effective_BER = symbol_ber_coef*10^(-symbol_ber_magnitude)" access="RO" offset="0x2C.0" size="0x0.8" />
	<field name="min_symbol_ber_coef" descr="Minimal symbol BER window calculated.\;\;Effective_BER = symbol_ber_coef*10^(-symbol_ber_magnitude)" access="RO" offset="0x2C.8" size="0x0.4" />
	<field name="last_symbol_ber_magnitude" descr="Last symbol BER window calculated.\;\;Effective_BER = symbol_ber_coef*10^(-symbol_ber_magnitude)" access="RO" offset="0x2C.16" size="0x0.8" />
	<field name="last_symbol_ber_coef" descr="Last symbol BER window calculated.\;\;Effective_BER = symbol_ber_coef*10^(-symbol_ber_magnitude)" access="RO" offset="0x2C.24" size="0x0.4" />
	<field name="min_est_eff_ber_magnitude" descr="Minimal estimated effective BER window measured.\;\;Estimated_Effective_BER = min_est_eff_ber_coef*10^(-min_esteff_ber_magnitude)" access="RO" offset="0x30.0" size="0x0.8" />
	<field name="min_est_eff_ber_coef" descr="Minimal estimated effective BER window measured.\;\;Estimated_Effective_BER = min_est_eff_ber_coef*10^(-min_esteff_ber_magnitude)" access="RO" offset="0x30.8" size="0x0.4" />
	<field name="mean_est_eff_ber_magnitude" descr="Mean estimated effective BER window measured.\;\;Estimated_Effective_BER = mean_est_eff_ber_coef*10^(-mean_est_eff_ber_magnitude)" access="RO" offset="0x30.16" size="0x0.8" />
	<field name="mean_est_eff_ber_coef" descr="Mean estimated effective BER window measured.\;\;Estimated_Effective_BER = mean_est_eff_ber_coef*10^(-mean_est_eff_ber_magnitude)" access="RO" offset="0x30.24" size="0x0.4" />
	<field name="max_est_eff_ber_magnitude" descr="Maximal estimated effective BER window measured.\;\;Estimated_Effective_BER = max_est_eff_ber_coef*10^(-max_est_eff_ber_magnitude)" access="RO" offset="0x34.0" size="0x0.8" />
	<field name="max_est_eff_ber_coef" descr="Maximal estimated effective BER window measured.\;\;Estimated_Effective_BER = max_est_eff_ber_coef*10^(-max_est_eff_ber_magnitude)" access="RO" offset="0x34.8" size="0x0.4" />
	<field name="num_of_est_eff_ber_alarms" descr="Number of Estimated Effective BER Windows that crossed alarm threshold" access="RO" offset="0x38.0" size="0x0.16" />
	<field name="num_of_est_eff_ber_warnings" descr="Number of Estimated Effective BER Windows that crossed warning threshold\;" access="RO" offset="0x38.16" size="0x0.16" />
</node>

<node name="pddr_link_up_info_page_ext" descr="" size="0xf8.0" >
	<field name="up_reason_mng" descr="invalid port access severity\;0 - No down command / unknown\;1 - BMC force linkup\;2 - WOL force linkup\;\;3 - ASN.1 force link up" access="RO" offset="0x0.0" size="0x0.4" />
	<field name="up_reason_drv" descr="invalid port access severity\;0 - No down command / unknown\;1 - Up by at least one of the hosts" access="RO" offset="0x0.8" size="0x0.4" />
	<field name="up_reason_pwr" descr="invalid port access severity\;0 - No down command / unknown\;1 - Keep link up on boot \;2 - Keep link up Eth/IB\;3 - Keep link up on standby" access="RO" offset="0x0.16" size="0x0.4" />
	<field name="time_to_link_up" descr="Time in msec to link up from disable until phy up state.\;While the phy manager did not reach phy up state the timer will return 0.\;The timer resets to 0 in one of the following cases:\;1. When moving to disable or rx disable state.\;2. When moving from active or phy up to polling state, while working at force mode." access="RO" offset="0x4.0" size="0x4.0" />
	<field name="fast_link_up_status" descr="Indicates if fast link-up was performed in the link: \;0: Unknown\;1: Fast Link-UP was performed. \;2: Regular link-up flow was performed due to changes in cable\;3: Regular link-up flow was performed due to changes in protocol (speed or FEC)\;4: Regular link-up flow was performed due to a non-fastbootable FW version (PCNR is not supported)\;5: Regular link-up performed due to MLPN flow\;6: Regular link-up performed due to PCNR.tuning_override configuration while port was in &quot;down&quot; state.\;7: Invalid fastboot data struct (0xCAFECAFE magic value is not present. For example, SW reset was executed before finish saving data during PCNR flow)\;8: fast link-up timeout\;9: fast link-up flaps issue\;10: fast link-up failed during link-up" access="RO" offset="0x8.0" size="0x0.4" />
	<field name="time_to_link_up_phy_up_to_active" descr="Ethernet:\;Time in msec to link up from phy up until active state.\;While the phy manager did not reach active state the timer will return 0.\;The timer resets to 0 in one of the following cases:\;1. When moving to disable or rx disable state.\;2. When moving from active or phy up to polling state, while working at force mode.\;IB:\;Time in msec from entering recovery state until back to Active state in case of successful recovery" access="RO" offset="0xC.0" size="0x4.0" />
	<field name="time_to_link_up_sd_to_phy_up" descr="Ethernet only\;Time in msec to link up from signal detect until phy up state.\;While the phy manager did not reach phy up state the timer will return 0.\;The timer resets to 0 in one of the following cases:\;1. When moving to disable or rx disable state.\;2. When moving from active or phy up to polling state, while working at force mode." access="RO" offset="0x10.0" size="0x4.0" />
	<field name="time_to_link_up_disable_to_sd" descr="Ethernet:\;Time in msec to link up from disable until signal detect state.\;While the phy manager did not reach signal detect state the timer will return 0.\;The timer resets to 0 in one of the following cases:\;1. When moving to disable or rx disable state.\;2. When moving from active or phy up to polling state, while working at force mode.\; IB:\;Time in msec to link up from disable until partner is detected (exit of Signal detect/receiver detect states)." access="RO" offset="0x14.0" size="0x4.0" />
	<field name="time_to_link_up_disable_to_pd" descr="Ethernet only\;Time in msec to link up from disable until protocol detect state.\;While the phy manager did not reach protocol detect state the timer will return 0.\;The timer resets to 0 in one of the following cases:\;1. When moving to disable or rx disable state.\;2. When moving from active or phy up to polling state, while working at force mode.\;Internal: for HDR/EDR devices the timers: time_to_link_up_disable_to_sd, time_to_link_up_disable_to_pd will return the same value." access="RO" offset="0x18.0" size="0x4.0" />
	<field name="time_logical_init_to_active" descr="Time in mSec that it takes for the port logical state to transition from init to an active state.\;The timer reset to 0 ONLY when the logical port state goes down." access="RO" offset="0x24.0" size="0x4.0" />
	<field name="total_time_pcs_local_fault" descr="Total time in sec of PCS state of Local Fault" access="RO" offset="0x28.0" size="0x4.0" />
	<field name="total_time_pcs_remote_fault" descr="Total time in sec of PCS state of Remote Fault" access="RO" offset="0x2C.0" size="0x4.0" />
</node>

<node name="pddr_module_info_ext" descr="" size="0xcc.0" >
	<field name="ethernet_compliance_code" descr="QSFP:\;Ethernet Compliance Codes bit mask (10/40G/100G)\;Byte131 per SFF-8636 \;Bit 7 - Extended Specification Compliance valid\;Bit 6 - 10GBASE-LRM\;Bit 5 - 10GBASE-LR\;Bit 4 - 10GBASE-SR\;Bit 3 - 40GBASE-CR4\;Bit 2 - 40GBASE-SR4\;Bit 1 - 40GBASE-LR4\;Bit 0 - 40G Active Cable (XLPPI)\;\;SFP: \;10G Ethernet Compliance Codes\;Byte3 per SFF-8472:\;Bit 7 - 10G Base-ER \;Bit 6 - 10G Base-LRM \;Bit 5 - 10G Base-LR \;Bit 4 - 10G Base-SR\;\;CMIS based (QSFP-DD/ SFP-DD / OSFP/OE)\;Byte 87 - Module Media Interface" access="RW" offset="0x0.0" size="0x0.8" />
	<field name="ext_ethernet_compliance_code" descr="Extended Specification Compliance Codes \;for SFP:\;byte 36 per SFF-8472\;\;for QSFP:\;byte192 per SFF-8636 (QSFP28) \;\;for CMIS (SFP-DD / QSFP-DD/ OSFP/OE):\;Byte 86 - Host Electrical Interface" access="RW" offset="0x0.8" size="0x0.8" />
	<field name="cable_breakout" descr="Reserved for SFP. \;\;For QSFP:\;Byte113 per SFF-8636\;\;For CMIS based modules:\;\;XX naming is according to cable_identifier name\;For example: if cable_identifier = ,6 XX string is QSFP-DD\;\;0 - Unspecified\;1 - XX to XX\;2 - XX to 2xQSFP or 2xXX (depopulated / 4 lanes)\;3 - XX to 4xDSFP or 4xQSFP (depopulated / 2 lanes)\;4 - XX to 8xSFP\;5 - XX (depopulated / 4 lanes) to QSFP or XX (depopulated / 4 lanes)\;6 - XX (depopulated / 4 lanes) to 2xXX(depopulated / 2 lanes) or 2xSFP-DD\;7 - XX (depopulated / 4 lanes) to 4xSFP\;8 - XX(/ 2 lane module) to XX\;9 - XX(/ 2 lane module) to 2xSFP" access="RW" offset="0x0.16" size="0x0.8" />
	<field name="cable_technology" descr="QSFP: \;Byte 147 per SFF-8636.\;\;SFP:\;SFP+ Cable Technology: \;byte8 per SFF-8472:\;Bit 3 - Active Cable\;Bit 2 - Passive Cable\;\;CMIS based (QSFP-DD / OSFP/ SFP-DD/OE):\;Byte 212\;\;0x00: VCSEL_850nm\;0x01: VCSEL_1310nm\;0x02: VCSEL_1550nm\;0x03: FP_laser_1310nm\;0x04: DFB_laser_1310nm\;0x05: DFB_laser_1550nm\;0x06: EML_1310nm\;0x07: EML_1550nm\;0x08: others\;0x09: DFB_laser_1490nm\;0x0a: Passive_copper_cable_unequalized\;0x0b: Passive_copper_cable_equalized\;0x0c: Copper_cable_near_end_and_far_end_limiting_active_equailizer\;0x0d: Copper_cable_far_end_limiting_active_equailizer\;0x0e: Copper_cable_near_end_limiting_active_equializer\;0x0f: Copper_cable_linear_active_equalizers\;0x10: c_band_tunable_laser\;0x11: l_band_tunable_laser\;0x12: Copper_cable_near_end_and_far_end_linear_active_equalizers\;0x13: Copper_cable_far_end_linear_active_equalizers\;0x14:Copper_cable_near_end_linear_active_equalizers" access="RW" enum="VCSEL_850nm=0x0,VCSEL_1310nm=0x1,VCSEL_1550nm=0x2,FP_laser_1310nm=0x3,DFB_laser_1310nm=0x4,DFB_laser_1550nm=0x5,EML_1310nm=0x6,EML_1550nm=0x7,others=0x8,DFB_laser_1490nm=0x9,Passive_copper_cable_unequalized=0xa,Passive_copper_cable_equalized=0xb,Copper_cable_near_end_and_far_end_limiting_active_equailizer=0xc,Copper_cable_far_end_limiting_active_equailizer=0xd,Copper_cable_near_end_limiting_active_equializer=0xe,Copper_cable_linear_active_equalizers=0xf,c_band_tunable_laser=0x10,l_band_tunable_laser=0x11,Copper_cable_near_end_and_far_end_linear_active_equalizers=0x12,Copper_cable_far_end_linear_active_equalizers=0x13,Copper_cable_near_end_linear_active_equalizers=0x14" offset="0x0.24" size="0x0.8" />
	<field name="cable_power_class" descr="Module maximum power consumption for SFP/QSFP:\;0: Power_Class_0 - (1.0 W max)\;1: Power_Class_1 - (1.5 W max)\;2: Power_Class_2 - (2.0 W max)\;3: Power_Class_3 - (2.5 W max)\;4: Power_Class_4 - (3.5 W max)\;5: Power_Class_5 - (4.0 W max)\;6: Power_Class_6 - (4.5 W max)\;7: Power_Class_7 - (5.0 W max)\;8: Power_Class_8 - (power from max_power field)\;\;Module maximum power consumption for SFP-DD:\;0: Power_Class_0 - (0.5 W max)\;1: Power_Class_1 - (1.0 W max)\;2: Power_Class_2 - (1.5 W max)\;3: Power_Class_3 - (2.0 W max)\;4: Power_Class_4 - (3.5 W max)\;5: Power_Class_5 - (5.0 W max)\;6: reserved\;7: reserved\;8: Power_Class_8 - (power from max_power field)\;\;Module maximum power consumption for QSFP-DD/OSFP:\;1 - Power_Class_1 - (1.5 W max)\;2 - Power_Class_2 - (3.5 W max)\;3 - Power_Class_3 - (7.0 W max)\;4 - Power_Class_4 - (8.0 W max)\;5 - Power_Class_5 - (10 W max)\;6 - Power_Class_6 - (12 W max)\;7 - Power_Class_7 - (14 W max)\;8 - Power_Class_8 - (power from max_power field)" access="RO" offset="0x4.0" size="0x0.8" />
	<field name="cable_identifier" descr="0: QSFP28\;1: QSFP_Plus\;2: SFP28_or_SFP_Plus\;3: QSA - (QSFP-&gt;SFP)\;4: Backplane\;5: SFP_DD\;6: QSFP_DD\;7: QSFP_CMIS\;8: OSFP\;9: C2C\;10: DSFP\;11: QSFP_Split_Cable\;12: CPO\;13: OE\;14: ELS\;\;identifiers that are CMIS compliant are: 5,6,7,8,10" access="RO" offset="0x4.8" size="0x0.8" />
	<field name="cable_length" descr="Cable length in 1m units.\;\;For CMIS modules:\;bits 6:7 represent cable_length_multiplier for calculating cable length\;00 - 0.1 multiplier (0.1 to 6.3m)\;01- 1 multiplier (1 to 63m)\;10 - 10 multiplier (10 to 630m)\;11 - 100 multiplier (100 to 6300m)\;\;bits 0:5 represent cable_length_value for calculating cable length.\;length is calculated with cable_length_value * cable_length_multiplier" access="RO" offset="0x4.16" size="0x0.8" />
	<field name="cable_vendor" descr="Cable vendor:\;0: Other\;1: Mellanox\;2: Known_OUI\;3: NVIDIA\;" access="RO" enum="Other=0x0,Mellanox=0x1,Known_OUI=0x2,NVIDIA=0x3" offset="0x4.24" size="0x0.4" />
	<field name="cable_type" descr="Cable/module type:\;0: Unidentified\;1: Active_cable - (active copper / optics)\;2: Optical_Module - (separated)\;3: Passive_copper_cable\;4: Cable_unplugged\;5: Twisted_pair\;6: CPO\;7: OE\;8: ELS\;" access="RO" enum="Unidentified=0x0,Active_cable=0x1,Optical_Module=0x2,Passive_copper_cable=0x3,Cable_unplugged=0x4,Twisted_pair=0x5,CPO=0x6,OE=0x7,ELS=0x8" offset="0x4.28" size="0x0.4" />
	<field name="cable_tx_equalization" descr="" access="RO" offset="0x8.0" size="0x0.8" />
	<field name="cable_rx_emphasis" descr="For CMIS (QSFP-DD/ SFP-DD/ OSFP) field will represent Rx pre-emphasis." access="RO" offset="0x8.8" size="0x0.8" />
	<field name="cable_rx_amp" descr="Reserved for SFP\;" access="RO" offset="0x8.16" size="0x0.8" />
	<field name="max_power" descr="Reserved for SFP, QSFP\;Byte 201 for CMIS (QSFP-DD/ SFP-DD/ OSFP/ELS/OE)\;Other Cable ignore field." access="RO" offset="0x8.24" size="0x0.8" />
	<field name="cable_attenuation_5g" descr="Reserved for SFP" access="RO" offset="0xC.0" size="0x0.8" />
	<field name="cable_attenuation_7g" descr="Reserved for SFP" access="RO" offset="0xC.8" size="0x0.8" />
	<field name="cable_attenuation_12g" descr="Reserved for SFP" access="RO" offset="0xC.16" size="0x0.8" />
	<field name="cable_attenuation_25g" descr="Valid only for CMIS (QSFP-DD/ SFP-DD/ OSFP)\;Other Cable ignore field." access="RO" offset="0xC.24" size="0x0.8" />
	<field name="tx_cdr_state" descr="Reserved for SFP\;\;Bit 0 - TX CDR on/off on channel 0 \;Bit 1 - TX CDR on/off on channel 1 \;Bit 2 - TX CDR on/off on channel 2 \;Bit 3 - TX CDR on/off on channel 3 \;Bit 4 - TX CDR on/off on channel 4 \;Bit 5 - TX CDR on/off on channel 5 \;Bit 6 - TX CDR on/off on channel 6 \;Bit 7 - TX CDR on/off on channel 7 \;\;CDR on - when bit is set.\;CDR off - when bit is clear.\;" access="RO" offset="0x10.0" size="0x0.8" />
	<field name="rx_cdr_state" descr="Reserved for SFP\;\;Bit 0 - RX CDR on/off on channel 0 \;Bit 1 - RX CDR on/off on channel 1 \;Bit 2 - RX CDR on/off on channel 2 \;Bit 3 - RX CDR on/off on channel 3\;Bit 4 - RX CDR on/off on channel 4 \;Bit 5 - RX CDR on/off on channel 5 \;Bit 6 - RX CDR on/off on channel 6 \;Bit 7 - RX CDR on/off on channel 7 \;\;CDR on - when bit is set.\;CDR off - when bit is clear.\;" access="RO" offset="0x10.8" size="0x0.8" />
	<field name="tx_cdr_cap" descr="0 - No CDR\;1 - Build-in CDR with on/off control \;2 - Build-in CDR without on/off control" access="RO" offset="0x10.16" size="0x0.4" />
	<field name="rx_cdr_cap" descr="0 - No CDR\;1 - Build-in CDR with on/off control \;2 - Build-in CDR without on/off control" access="RO" offset="0x10.20" size="0x0.4" />
	<field name="cable_rx_post_emphasis" descr="Valid only for CMIS (QSFP-DD/ SFP-DD/ OSFP)\;Rx post-emphasis." access="RO" offset="0x10.24" size="0x0.8" />
	<field name="vendor_name" descr="ASCII Vendor name left-aligned and padded on the right with\;ASCII spaces (20h)" access="RO" high_bound="3" low_bound="0" offset="0x14.0" size="0x10.0" />
	<field name="vendor_pn" descr="Vendor Part Number left-aligned and padded on the right with ASCII spaces (20h)" access="RO" high_bound="3" low_bound="0" offset="0x24.0" size="0x10.0" />
	<field name="vendor_rev" descr="ASCII Vendor revision aligned to right padded with 0h on the left" access="RO" offset="0x34.0" size="0x4.0" />
	<field name="fw_version" descr="If information is not available by the module: set to 0" access="RO" offset="0x38.0" size="0x4.0" />
	<field name="vendor_sn" descr="Vendor Serial Number" access="RO" high_bound="3" low_bound="0" offset="0x3C.0" size="0x10.0" />
	<field name="voltage" descr="Internally measured supply voltage in 100uV" access="RO" offset="0x4C.00" size="0x0.16" />
	<field name="temperature" descr="module temperature in 1/256 C" access="RO" offset="0x4C.16" size="0x0.16" />
	<field name="rx_power_lane1" descr="RX measured power channel 1.\;measured in dBm/uW according to module_info_ext value" access="RO" offset="0x50.0" size="0x0.16" />
	<field name="rx_power_lane0" descr="RX measured power channel 0.\;measured in dBm/uW according to module_info_ext value" access="RO" offset="0x50.16" size="0x0.16" />
	<field name="rx_power_lane3" descr="RX measured power channel 3.\;measured in dBm/uW according to module_info_ext value" access="RO" offset="0x54.0" size="0x0.16" />
	<field name="rx_power_lane2" descr="RX measured power channel 2.\;measured in dBm/uW according to module_info_ext value" access="RO" offset="0x54.16" size="0x0.16" />
	<field name="rx_power_lane5" descr="RX measured power channel 5.\;measured in dBm/uW according to module_info_ext value" access="RO" offset="0x58.0" size="0x0.16" />
	<field name="rx_power_lane4" descr="RX measured power channel 4.\;measured in dBm/uW according to module_info_ext value" access="RO" offset="0x58.16" size="0x0.16" />
	<field name="rx_power_lane7" descr="RX measured power channel 7.\;measured in dBm/uW according to module_info_ext value" access="RO" offset="0x5C.0" size="0x0.16" />
	<field name="rx_power_lane6" descr="RX measured power channel 6.\;measured in dBm/uW according to module_info_ext value" access="RO" offset="0x5C.16" size="0x0.16" />
	<field name="tx_power_lane1" descr="TX measured power channel 1.\;measured in dBm/uW according to module_info_ext value" access="RO" offset="0x60.0" size="0x0.16" />
	<field name="tx_power_lane0" descr="TX measured power channel 0.\;measured in dBm/uW according to module_info_ext value" access="RO" offset="0x60.16" size="0x0.16" />
	<field name="tx_power_lane3" descr="TX measured power channel 3.\;measured in dBm/uW according to module_info_ext value" access="RO" offset="0x64.0" size="0x0.16" />
	<field name="tx_power_lane2" descr="TX measured power channel 2.\;measured in dBm/uW according to module_info_ext value" access="RO" offset="0x64.16" size="0x0.16" />
	<field name="tx_power_lane5" descr="TX measured power channel 5.\;measured in dBm/uW according to module_info_ext value" access="RO" offset="0x68.0" size="0x0.16" />
	<field name="tx_power_lane4" descr="TX measured power channel 4.\;measured in dBm/uW according to module_info_ext value" access="RO" offset="0x68.16" size="0x0.16" />
	<field name="tx_power_lane7" descr="TX measured power channel 7.\;measured in dBm/uW according to module_info_ext value" access="RO" offset="0x6C.0" size="0x0.16" />
	<field name="tx_power_lane6" descr="TX measured power channel 6.\;measured in dBm/uW according to module_info_ext value" access="RO" offset="0x6C.16" size="0x0.16" />
	<field name="tx_bias_lane1" descr="TX measured bias current on channel [i] in 2uA unit.\;\;The real sample value in uA units should be calculated as follows:\;tx_bias_lane[i] * 2 * tx_bias_scaling_factor[enum_value]" access="RO" offset="0x70.0" size="0x0.16" />
	<field name="tx_bias_lane0" descr="TX measured bias current on channel [i] in 2uA unit.\;\;The real sample value in uA units should be calculated as follows:\;tx_bias_lane[i] * 2 * tx_bias_scaling_factor[enum_value]" access="RO" offset="0x70.16" size="0x0.16" />
	<field name="tx_bias_lane3" descr="TX measured bias current on channel [i] in 2uA unit.\;\;The real sample value in uA units should be calculated as follows:\;tx_bias_lane[i] * 2 * tx_bias_scaling_factor[enum_value]" access="RO" offset="0x74.0" size="0x0.16" />
	<field name="tx_bias_lane2" descr="TX measured bias current on channel [i] in 2uA unit.\;\;The real sample value in uA units should be calculated as follows:\;tx_bias_lane[i] * 2 * tx_bias_scaling_factor[enum_value]" access="RO" offset="0x74.16" size="0x0.16" />
	<field name="tx_bias_lane5" descr="TX measured bias current on channel [i] in 2uA unit.\;\;The real sample value in uA units should be calculated as follows:\;tx_bias_lane[i] * 2 * tx_bias_scaling_factor[enum_value]" access="RO" offset="0x78.0" size="0x0.16" />
	<field name="tx_bias_lane4" descr="TX measured bias current on channel [i] in 2uA unit.\;\;The real sample value in uA units should be calculated as follows:\;tx_bias_lane[i] * 2 * tx_bias_scaling_factor[enum_value]" access="RO" offset="0x78.16" size="0x0.16" />
	<field name="tx_bias_lane7" descr="TX measured bias current on channel [i] in 2uA unit.\;\;The real sample value in uA units should be calculated as follows:\;tx_bias_lane[i] * 2 * tx_bias_scaling_factor[enum_value]" access="RO" offset="0x7C.0" size="0x0.16" />
	<field name="tx_bias_lane6" descr="TX measured bias current on channel [i] in 2uA unit.\;\;The real sample value in uA units should be calculated as follows:\;tx_bias_lane[i] * 2 * tx_bias_scaling_factor[enum_value]" access="RO" offset="0x7C.16" size="0x0.16" />
	<field name="temperature_low_th" descr="Alarm low temperature threshold in 1/256 C" access="RO" offset="0x80.0" size="0x0.16" />
	<field name="temperature_high_th" descr="Alarm high temperature threshold in 1/256 C" access="RO" offset="0x80.16" size="0x0.16" />
	<field name="voltage_low_th" descr="Alarm low Voltage threshold in 100uV" access="RO" offset="0x84.0" size="0x0.16" />
	<field name="voltage_high_th" descr="Alarm high Voltage threshold in 100uV" access="RO" offset="0x84.16" size="0x0.16" />
	<field name="rx_power_low_th" descr="Alarm low RX Power threshold in dBm. \;Taking only from channel 0." access="RO" offset="0x88.0" size="0x0.16" />
	<field name="rx_power_high_th" descr="Alarm high RX Power threshold in dBm. \;Taking only from channel 0." access="RO" offset="0x88.16" size="0x0.16" />
	<field name="tx_power_low_th" descr="Alarm low TX Power threshold in dBm. \;Taking only from channel 0." access="RO" offset="0x8C.0" size="0x0.16" />
	<field name="tx_power_high_th" descr="Alarm high TX Power threshold in dBm. \;Taking only from channel 0." access="RO" offset="0x8C.16" size="0x0.16" />
	<field name="tx_bias_low_th" descr="Alarm low TX Bias current threshold in 2 uA. \;\;The real threshold value in uA units should be calculated as follows:\;tx_bias_high_th * 2 * tx_bias_scaling_factor[enum_value]" access="RO" offset="0x90.0" size="0x0.16" />
	<field name="tx_bias_high_th" descr="Alarm high TX Bias current threshold in 2 uA.\;\;The real threshold value in uA units should be calculated as follows:\;tx_bias_high_th * 2 * tx_bias_scaling_factor[enum_value]" access="RO" offset="0x90.16" size="0x0.16" />
	<field name="wavelength" descr="Nominal laser wavelength in nm" access="RO" offset="0x94.0" size="0x0.16" />
	<field name="smf_length" descr="SMF link length\;SFP per byte 14,15.\;QSFP per byte 142\;for CMIS based modules, per byte 132\;\;bit 9:8 - 00 length base in 1 km units\;bit 9:8 - 01 length base in 100m units\;bits 7:0 - length base" access="RO" offset="0x94.16" size="0x0.10" />
	<field name="rx_output_valid_cap" descr="when set, indicates rx_output_valid is supported by the module" access="RW" offset="0x94.26" size="0x0.1" />
	<field name="did_cap" descr="set in case of Linear Direct Drive module" access="RO" offset="0x94.27" size="0x0.1" />
	<field name="rx_power_type" descr="rx power measurement type\;0: OMA\;1: Average_power" access="RO" enum="OMA=0x0,Average_power=0x1" offset="0x94.28" size="0x0.1" />
	<field name="module_st" descr="Valid for CMIS modules only.\;Module state:\;0: reserved\;1: LowPwr_state\;2: PwrUp_state\;3: Ready_state\;4: PwrDn_state\;5: Fault_state" access="RO" enum="reserved=0x0,LowPwr_state=0x1,PwrUp_state=0x2,Ready_state=0x3,PwrDn_state=0x4,Fault_state=0x5" offset="0x94.29" size="0x0.3" />
	<field name="ib_compliance_code" descr="Byte 164 of SFF-8636\;For CMIS modules IB Protocols:\;Bit 0: SDR\;Bit 1: DDR\;Bit 2: QDR\;Bit 3: FDR10\;Bit 4: FDR\;Bit 5: EDR\;Bit 6: HDR\;Bit 7: NDR\;Bit 8: XDR" access="RO" enum="SDR=0x1,DDR=0x2,QDR=0x4,FDR10=0x8,FDR=0x10,EDR=0x20,HDR=0x40,NDR=0x80,XDR=0x100" offset="0x98.0" size="0x0.10" />
	<field name="tx_bias_scaling_factor" descr="Valid for CMIS modules only.\;This field is relevant for the following fields: tx_bias_lane[7:0], tx_bias_high_th and tx_bias_low_th.\;The value of the above fields should be multiplied according to the tx_bias_scaling_factor value.\;0: multiply_1x\;1: multiply_2x\;2: multiply_4x\;" access="RO" enum="multiply_1x=0x0,multiply_2x=0x1,multiply_4x=0x2" offset="0x98.10" size="0x0.2" />
	<field name="active_set_media_compliance_code" descr="Valid for CMIS modules only.\;According to current Active set, value of Module Media Interface byte" access="RO" offset="0x98.16" size="0x0.8" />
	<field name="active_set_host_compliance_code" descr="Valid for CMIS modules only.\;According to current Active set, value of Host Electrical Interface byte" access="RO" offset="0x98.24" size="0x0.8" />
	<field name="ib_width" descr="Bitmask of width of IB Protocols" access="RO" offset="0x9C.0" size="0x0.6" />
	<field name="monitor_cap_mask" descr="monitoring capabilities mask\;Bit 0 - temperature monitoring implemented\;Bit 1 - voltage monitoring implemented\;Bit 2 - tx power monitoring implemented\;Bit 3 - rx power monitoring implemented\;Bit 4 - tx bias monitoring implemented" access="RO" offset="0x9C.8" size="0x0.8" />
	<field name="nbr100" descr="Nominal bit rate in units of 100Mb/s" access="RO" offset="0x9C.16" size="0x0.8" />
	<field name="nbr250" descr="Nominal bit rate in units of 250Mb/s" access="RO" offset="0x9C.24" size="0x0.8" />
	<field name="dp_st_lane" descr="DataPath state for lane&lt;i&gt;\;1: DPDeactivated\;2: DPInit\;3: DPDeinit\;4: DPActivated\;5: DPTxTurnOn\;6: DPTxTurnOff\;7: DPInitialized" access="RO" enum="DPDeactivated=0x1,DPInit=0x2,DPDeinit=0x3,DPActivated=0x4,DPTxTurnOn=0x5,DPTxTurnOff=0x6,DPInitialized=0x7" high_bound="7" low_bound="0" offset="0xA0.28" size="0x4.0" />
	<field name="length_om5" descr="OM5 fiber length supported in units of 2m" access="RO" offset="0xA4.0" size="0x0.8" />
	<field name="length_om4" descr="OM4 fiber length supported in units of 2m\;SFP in units of 10m" access="RO" offset="0xA4.8" size="0x0.8" />
	<field name="length_om3" descr="OM3 fiber length supported in units of 2m\;SFP in units of 10m" access="RO" offset="0xA4.16" size="0x0.8" />
	<field name="length_om2" descr="OM2 fiber length supported in units of 1m\;SFP in units of 10m" access="RO" offset="0xA4.24" size="0x0.8" />
	<field name="memory_map_rev" descr="memory map revision" access="RO" offset="0xA8.0" size="0x0.8" />
	<field name="wavelength_tolerance" descr="16-bit integer value for the laser wavelength tolerance in nm divided by 200 (units of 0.005nm)." access="RO" offset="0xA8.8" size="0x0.16" />
	<field name="length_om1" descr="OM1 fiber length supported in units of 10m" access="RO" offset="0xA8.24" size="0x0.8" />
	<field name="memory_map_compliance" descr="memory map compliance in ASCII.\;SFF-8472 / SFF-8636/ CMIS" access="RO" offset="0xAC.0" size="0x4.0" />
	<field name="date_code" descr="ASCII code for vendor&apos;s date code.\;63:48- 2 digit for date code year, 00 = year 2000\;47:32 - 2 digit for date code month.\;31:16 - 2 digit for day of the month code.\;15:0 - 2 digit LOT code." subnode="uint64" access="RO" offset="0xB0.0" size="0x8.0" />
	<field name="vendor_oui" descr="vendor oui" access="RO" offset="0xB8.0" size="0x0.24" />
	<field name="connector_type" descr="connector type based on SFF-8024" access="RO" offset="0xB8.24" size="0x0.8" />
	<field name="rx_output_valid" descr="Rx output status indication per lane" access="RO" offset="0xBC.0" size="0x0.8" />
	<field name="cable_attenuation_53g" descr="cable attenuation at 53GHz" access="RO" offset="0xBC.8" size="0x0.8" />
	<field name="tx_input_freq_sync" descr="Defines which Tx input lanes must be frequency synchronous.\;0: Tx_input_lanes_1_8\;1: Tx_input_lanes_1_4_and_5-8\;2: Tx_input_lanes_1_2_and_3_4_and_5_6_and_7_8\;3: Lanes_may_be_asynchronous_in_frequency" access="RO" enum="Tx_input_lanes_1_8=0x0,Tx_input_lanes_1_4_and_5=0x1,Tx_input_lanes_1_2_and_3_4_and_5_6_and_7_8=0x2,Lanes_may_be_asynchronous_in_frequency=0x3" offset="0xBC.16" size="0x0.2" />
	<field name="error_code" descr="Relevant for CMIS modules only\;Error Code response for ControlSet configuration of DataPath.\;0x0: ConfigUndefined\;0x1: ConfigSuccess\;0x2: ConfigRejected\;0x3: ConfigRejectedInvalidAppSel\;0x4: ConfigRejectedInvalidDataPath\;0x5: ConfigRejectedInvalidSI\;0x6: ConfigRejectedLanesInUse\;0x7: ConfigRejectedPartialDataPath\;0xC: ConfigInProgress" access="RO" enum="ConfigUndefined=0x0,ConfigSuccess=0x1,ConfigRejected=0x2,ConfigRejectedInvalidAppSel=0x3,ConfigRejectedInvalidDataPath=0x4,ConfigRejectedInvalidSI=0x5,ConfigRejectedLanesInUse=0x6,ConfigRejectedPartialDataPath=0x7,ConfigInProgress=0xc" offset="0xC0.0" size="0x0.4" />
	<field name="max_fiber_length" descr="Maximum length of allowed fiber in meters" access="RO" offset="0xC0.16" size="0x0.16" />
	<field name="laser_restriction" descr="Relevant for CPO product. Each bit represent the ELS&apos;s laser restriction. When restriction are on, the laser can operate only in restricted power mode, for the safety of the optical components. Restriction can be lifted only after fiber testing.\;0: laser_restriction_on\;1: laser_restriction_off" access="RO" enum="laser_restriction_on=0x0,laser_restriction_off=0x1" offset="0xC4.0" size="0x0.8" />
	<field name="laser_status" descr="Relevant for CPO product. Each bit represent the ELS&apos;s laser status CMIS name of field.\;0x00: laser_off\;0x01: laser_ramping\;0x10: laser_on" access="RO" enum="laser_on=0x10" offset="0xC4.8" size="0x0.16" />
	<field name="laser_enabled" descr="Relevant for CPO product. Each bit represent the ELS&apos;s laser. \;0: laser_disabled\;1: laser_enabled" access="RO" enum="laser_disabled=0x0,laser_enabled=0x1" offset="0xC4.24" size="0x0.8" />
	<field name="els_oper_state" descr="Indicate the ELS operative state\;0: ELS_module_ready\;1: Restriction_mode\;2: full_power_mode\;3: full_power_ramping_up_mode\;4: full_power_ramping_down_mode" access="RO" enum="ELS_module_ready=0x0,Restriction_mode=0x1,full_power_mode=0x2,full_power_ramping_up_mode=0x3,full_power_ramping_down_mode=0x4" offset="0xC8.24" size="0x0.8" />
</node>

<node name="pddr_monitor_opcode_ext" descr="" size="0x4.0" >
	<field name="monitor_opcode" descr="Status opcode: \;\;PHY FW indication (0 - 1023):\;0 - No issue observed\;1 - Port is close by command (see PAOS).\;2,3,4,38,39 - AN failure \;5,6,7,8 - Link training failure. \;9,10,11,12,13 - Logical mismatch between link partners\;14 - Remote fault received\;15,42,17,48,49,52, - Bad signal integrity \;16,24-32 - Cable compliance code mismatch (protocol mismatch between cable and port) \;23,22,19,18,50,55- Internal error\;34,35 - Speed degradation\;56 - module_lanes_frequency_not_synced\;57 - signal not detected\;60 - no partner detected for long time\;128 - Troubleshooting in process\;1023- Info not available\;\;MNG FW issues (1024 - 2047):\;1024 - Cable is unplugged\;1025 - Long Range for non Mellanox cable/module\;1026 - Bus stuck (I2C Data or clock shorted)\;1027 - Bad/unsupported EEPROM\;1028 - Part number list\;1029 - Unsupported cable\;1030 - Module temperature shutdown\;1031 - Shorted cable\;1032 - Power budget exceeded\;1033 - Management forced down the port\;1034 - Module is disabled by command\;1035 - System Power is Exceeded therefore the module is powered off.\;1036 - Module&apos;s PMD type is not enabled (see PMTPS).\;1040 - pcie system power slot Exceeded\;1042 - Module state machine fault\;1043,1044,1045,1046 - Module&apos;s stamping speed degeneration\;1047, 1048 - Modules DataPath FSM fault\;1050, 1051, 1052, 1053- Module Boot Error\;1054 - Module Forced to Low Power by command\;1055 - ELS laser fiber is contaminated\;1056 - ELS laser failure\;1057 - ELS cable unplugged\;Core/Driver (2048 - 3071):" access="RW" offset="0x0.0" size="0x0.16" />
</node>

<node name="pddr_operation_info_page_cable_proto_cap_auto_ext" descr="" attr_is_union="1" size="0x4.0" >
	<field name="pddr_cable_cap_ib_ext" descr="" subnode="pddr_cable_cap_ib_ext" offset="0x0.0" selected_by="InfiniBand" size="0x4.0" />
	<field name="pddr_cable_cap_eth_ext" descr="" subnode="pddr_cable_cap_eth_ext" offset="0x0.0" selected_by="Ethernet" size="0x4.0" />
	<field name="pddr_cable_cap_nvlink_ext" descr="" subnode="pddr_cable_cap_nvlink_ext" offset="0x0.0" selected_by="NVLink" size="0x4.0" />
</node>

<node name="pddr_operation_info_page_core_to_phy_link_enabled_auto_ext" descr="" attr_is_union="1" size="0x4.0" >
	<field name="pddr_c2p_link_enabled_ib_ext" descr="" subnode="pddr_c2p_link_enabled_ib_ext" offset="0x0.0" selected_by="InfiniBand" size="0x4.0" />
	<field name="pddr_c2p_link_enabled_eth_ext" descr="" subnode="pddr_c2p_link_enabled_eth_ext" offset="0x0.0" selected_by="Ethernet" size="0x4.0" />
	<field name="pddr_c2p_link_enabled_nvlink_ext" descr="" subnode="pddr_c2p_link_enabled_nvlink_ext" offset="0x0.0" selected_by="NVLink" size="0x4.0" />
</node>

<node name="pddr_operation_info_page_ext" descr="" size="0xf8.0" >
	<field name="neg_mode_active" descr="0: protocol_was_not_negotiated - (force mode)\;1: MLPN_rev0_negotiated\;2: CL73_Ethernet_negotiated\;3: Protocol_according_to_Parallel_detect - (remote port in force mode)\;4: Standard_IB_negotiated" access="RO" enum="protocol_was_not_negotiated=0x0,MLPN_rev0_negotiated=0x1,CL73_Ethernet_negotiated=0x2,Protocol_according_to_Parallel_detect=0x3,Standard_IB_negotiated=0x4" offset="0x0.16" size="0x0.4" />
	<field name="proto_active" descr="Active protocol:\;Bit 0: InfiniBand\;Bit 2: Ethernet\;Bit 3: NVLink" access="RO" enum="InfiniBand=0x1,Ethernet=0x4,NVLink=0x8" offset="0x0.20" size="0x0.4" />
	<field name="ib_phy_fsm_state" descr="FW IB state machine:\;0x0: IB_AN_FSM_DISABLED\;0x1: IB_AN_FSM_INITIALY\;0x2: IB_AN_FSM_RCVR_CFG\;0x3: IB_AN_FSM_CFG_TEST\;0x4: IB_AN_FSM_WAIT_RMT_TEST\;0x5: IB_AN_FSM_WAIT_CFG_ENHANCED\;0x6: IB_AN_FSM_CFG_IDLE\;0x7: IB_AN_FSM_LINK_UP\;0x8: IB_AN_FSM_POLLING" access="RO" enum="IB_AN_FSM_DISABLED=0x0,IB_AN_FSM_INITIALY=0x1,IB_AN_FSM_RCVR_CFG=0x2,IB_AN_FSM_CFG_TEST=0x3,IB_AN_FSM_WAIT_RMT_TEST=0x4,IB_AN_FSM_WAIT_CFG_ENHANCED=0x5,IB_AN_FSM_CFG_IDLE=0x6,IB_AN_FSM_LINK_UP=0x7,IB_AN_FSM_POLLING=0x8" offset="0x4.8" size="0x0.8" />
	<field name="eth_an_fsm_state" descr="Ethernet (CL73) Auto-negotiation FSM state:\;0x0: ETH_AN_FSM_ENABLE\;0x1: ETH_AN_FSM_XMIT_DISABLE\;0x2: ETH_AN_FSM_ABILITY_DETECT\;0x3: ETH_AN_FSM_ACK_DETECT\;0x4: ETH_AN_FSM_COMPLETE_ACK\;0x5: ETH_AN_FSM_AN_GOOD_CHECK\;0x6: ETH_AN_FSM_AN_GOOD\;0x7: ETH_AN_FSM_NEXT_PAGE_WAIT" access="RO" offset="0x4.16" size="0x0.8" />
	<field name="phy_mngr_fsm_state" descr="FW Phy Manager FSM state:\;0: Disabled \;1: Open_port\;2: Polling\;3: Active\;4: Close_port\;5: Phy_up\;6: Sleep\;7: Rx_disable\;8: Signal_detect\;9: Receiver_detect\;10: Sync_peer\;11: Negotiation\;12: Training\;13: SubFSM_active" access="RO" enum="Disabled=0x0,Open_port=0x1,Polling=0x2,Active=0x3,Close_port=0x4,Phy_up=0x5,Sleep=0x6,Rx_disable=0x7,Signal_detect=0x8,Receiver_detect=0x9,Sync_peer=0xa,Negotiation=0xb,Training=0xc,SubFSM_active=0xd" offset="0x4.24" size="0x0.8" />
	<field name="phy_manager_link_enabled" descr="For IB: Table  912, &quot;PDDR - Phy Manager Link Enabled IB layout,&quot; on page  1026\;For Ethernet: Table  914, &quot;PDDR - Phy Manager Link Enabled Eth layout,&quot; on page  1026\;For NVLink: Table  916, &quot;PDDR - Phy Manager Link Enable NVLink layout,&quot; on page  1027" subnode="pddr_operation_info_page_phy_manager_link_enabled_auto_ext" access="RO" offset="0x8.0" size="0x4.0" union_selector="$(parent).proto_active" />
	<field name="core_to_phy_link_enabled" descr="For IB: Table  918, &quot;PDDR - Core2phy Link Enabled IB layout,&quot; on page  1028\;For Ethernet: Table  920, &quot;PDDR - Core2phy Link Enabled Eth layout,&quot; on page  1029\;For NVLink: Table  922, &quot;PDDR - Core2phy Link Enabled NVLink layout,&quot; on page  1029" subnode="pddr_operation_info_page_core_to_phy_link_enabled_auto_ext" access="RO" offset="0xC.0" size="0x4.0" union_selector="$(parent).proto_active" />
	<field name="cable_proto_cap" descr="For IB: Table  924, &quot;PDDR - Cable Cap IB layout,&quot; on page  1030\;For Ethernet: Table  926, &quot;PDDR - Cable Cap Eth layout,&quot; on page  1031\;For NVLink: Table  928, &quot;PDDR - Cable Cap NVLink layout,&quot; on page  1031" subnode="pddr_operation_info_page_cable_proto_cap_auto_ext" access="RO" offset="0x10.0" size="0x4.0" union_selector="$(parent).proto_active" />
	<field name="link_active" descr="For IB: Table  930, &quot;PDDR - Link Active IB layout,&quot; on page  1032\;For Ethernet: Table  932, &quot;PDDR - Link Active Eth layout,&quot; on page  1032\;For NVLink: Table  934, &quot;PDDR - Link Active NVLink layout,&quot; on page  1033" subnode="pddr_operation_info_page_link_active_auto_ext" access="RO" offset="0x14.0" size="0x4.0" union_selector="$(parent).proto_active" />
	<field name="loopback_mode" descr="0: No_loopback_active\;1: Phy_remote_loopback \;2: Phy_local_loopback -When set the port&apos;s egress traffic is looped back to the receiver and the port transmitter is disabled. \;4: External_local_loopback -Enables the port&apos;s transmitter to link with the port&apos;s receiver using an external loopback connector." access="RO" enum="No_loopback_active=0x0,Phy_remote_loopback=0x1,Phy_local_loopback=0x2,External_local_loopback=0x4" offset="0x18.0" size="0x0.12" />
	<field name="fec_mode_request" descr="FEC mode request.\;See fec_mode_active." access="RO" offset="0x1C.0" size="0x0.16" />
	<field name="fec_mode_active" descr="FEC mode active\;0: No_FEC\;1: Firecode_FEC\;2: Standard_RS_FEC - RS(528,514)\;3: Standard_LL_RS_FEC - RS(271,257)\;4: Interleaved_Quad_RS_FEC - (544,514)   Quad_KP4_FEC\;5: Interleaved_Quad_RS_FEC_PLR - 546,516) Quad_KP4_FEC\;6: Interleaved_Standard_RS-FEC - (544,514)\;7: Standard_RS-FEC - (544,514)\;8: Interleaved_Octet_RS_FEC_PLR -(546,516) Octet_KP4_FEC\;9: Ethernet_Consortium_LL_50G_RS_FEC- (272,257+1)\;10: Interleaved_Ethernet_Consortium_LL_50G_RS_FEC - (272,257+1)\;11: Interleaved_Standard_RS_FEC_PLR - (544,514)- [Internal]\;12: RS-FEC - (544,514) + PLR- [Internal]\;13: LL-FEC - (271,257) + PLR- [Internal]\;14: Ethernet_Consortium_LL_50G_RS_FEC_PLR - (272,257+1) [Internal] \;15: Interleaved_Ethernet_Consortium_LL_50G_RS_FEC_PLR - (272,257+1) [Internal]" access="RO" enum="No_FEC=0x0,Firecode_FEC=0x1,Standard_RS_FEC=0x2,Standard_LL_RS_FEC=0x3,Interleaved_Quad_RS_FEC=0x4,Interleaved_Quad_RS_FEC_PLR=0x5,Interleaved_Standard_RS=0x6,Standard_RS=0x7,Interleaved_Octet_RS_FEC_PLR=0x8,Ethernet_Consortium_LL_50G_RS_FEC=0x9,Interleaved_Ethernet_Consortium_LL_50G_RS_FEC=0xa,Interleaved_Standard_RS_FEC_PLR=0xb,RS=0xc,LL=0xd,Ethernet_Consortium_LL_50G_RS_FEC_PLR=0xe,Interleaved_Ethernet_Consortium_LL_50G_RS_FEC_PLR=0xf" offset="0x1C.16" size="0x0.16" />
	<field name="eth_100g_fec_support" descr="FEC 100G (25Gb/s per lane) supported FEC include override masking, should reflect current phy configuration after link is up\;\;Bit 0 - No FEC\;Bit 2 - Standard RS-FEC - RS(528,514)\;" access="RO" offset="0x20.0" size="0x0.4" />
	<field name="eth_25g_50g_fec_support" descr="FEC 25G/50G (25Gb/s per lane) supported FEC include override masking, should reflect current phy configuration after link is up\;Bit 0 - No FEC\;Bit 1 - Firecode FEC\;Bit 2 - Standard RS-FEC - RS(528,514)\;" access="RO" offset="0x20.4" size="0x0.4" />
	<field name="profile_fec_in_use" descr="The profile that has been selected: \;Bit 0 - IB spec / legacy (See profiles description) \;Bit 1 - Internal ports (Backplane) \;Bit 2 - Passive copper - Short \;Bit 3 - Passive copper - Medium \;Bit 4 - Passive copper - Long \;Bit 5 - Active optics / copper short reach (&lt;20m) \;Bit 6 - Optics long reach (&gt;20m) \;Bit 7 - NO-FEC \;Bit 8 - FEC-ON" access="RO" offset="0x20.16" size="0x0.16" />
	<field name="pd_link_enabled" descr="For IB: Table  936, &quot;PDDR - Parallel Detect Link Enabled IB Layout,&quot; on page  1034\;For Ethernet: Table  938, &quot;PDDR - Parallel Detect Link Enabled Eth Layout,&quot; on page  1034" access="RO" offset="0x24.0" size="0x4.0" />
	<field name="phy_hst_link_enabled" descr="For IB: Table  940, &quot;PDDR - HST Link Enabled IB Layout,&quot; on page  1035\;For Ethernet: Table  942, &quot;PDDR - HST Link Enabled Eth Layout,&quot; on page  1036" access="RO" offset="0x28.0" size="0x4.0" />
	<field name="eth_an_link_enabled" descr="For IB: Table  944, &quot;PDDR - ETH AN Link Enabled Eth Layout,&quot; on page  1036" access="RO" offset="0x2C.0" size="0x4.0" />
</node>

<node name="pddr_operation_info_page_link_active_auto_ext" descr="" attr_is_union="1" size="0x4.0" >
	<field name="pddr_link_active_ib_ext" descr="" subnode="pddr_link_active_ib_ext" offset="0x0.0" selected_by="InfiniBand" size="0x4.0" />
	<field name="pddr_link_active_eth_ext" descr="" subnode="pddr_link_active_eth_ext" offset="0x0.0" selected_by="Ethernet" size="0x4.0" />
	<field name="pddr_link_active_nvlink_ext" descr="" subnode="pddr_link_active_nvlink_ext" offset="0x0.0" selected_by="NVLink" size="0x4.0" />
</node>

<node name="pddr_operation_info_page_phy_manager_link_enabled_auto_ext" descr="" attr_is_union="1" size="0x4.0" >
	<field name="pddr_phy_manager_link_enabled_ib_ext" descr="" subnode="pddr_phy_manager_link_enabled_ib_ext" offset="0x0.0" selected_by="InfiniBand" size="0x4.0" />
	<field name="pddr_phy_manager_link_enabled_eth_ext" descr="" subnode="pddr_phy_manager_link_enabled_eth_ext" offset="0x0.0" selected_by="Ethernet" size="0x4.0" />
	<field name="pddr_phy_manager_link_enabled_nvlink_ext" descr="" subnode="pddr_phy_manager_link_enabled_nvlink_ext" offset="0x0.0" selected_by="NVLink" size="0x4.0" />
</node>

<node name="pddr_phy_info_page_ext" descr="" size="0xf8.0" >
	<field name="port_notifications" descr="Port notifications bit mask\;Bit 0 - Link partner advertised capabilities \;Bit 1 - Speed degradation" access="RO" offset="0x0.0" size="0x0.8" />
	<field name="negotiation_mask" descr="Bit 0: eth_base_page\;Bit 1: ib_base_page\;Bit 2: ib_base_page_rev2 - XDR onwards\;Bit 3: Consortium\;Bit 4: MLPN_rev0\;Bit 5: MLPN_rev1\;Bit 6: NLPN_rev2" access="RO" offset="0x0.8" size="0x0.8" />
	<field name="remote_device_type" descr="Remote device type: \;0 - Unknown (3rd party, Force, legacy MLPN)\;1 - CX4\;2 - CX4_LX\;3 - CX5\;4 - CX5_LX\;5 - CX6\;6 - CX6_LX\;7 - CX6_DX\;8 - CX7\;9 - Bluefield-2\;10 - CX8\;11 - Bluefield-3\;12- CX9\;13-99 Reserved\;\;100 - SwitchIB\;101 - Spectrum \;102 - SwitchIB-2\;103 - Quantum\;104 - Spectrum-2\;105 - Spectrum-3\;106 - Quantum-2\;107 - Spectrum-4\;108 -Quantum-3\;109 - Quantum-4\;110 - Spectrum-5\;111 - Spectrum-6\;112-199 -Reserved\;\;200 - GBxxx (GB100/102/200)\;201 - GRxxx\;202-255 - Reserved" access="RO" offset="0x0.24" size="0x0.8" />
	<field name="lp_ib_revision" descr="Link partner IB TS revision \;\;" access="RO" offset="0x4.0" size="0x0.8" />
	<field name="ib_revision" descr="IB TS revision \;" access="RO" offset="0x4.8" size="0x0.8" />
	<field name="num_of_negotiation_attempts" descr="Negotiation attempt counter" access="RO" offset="0x4.16" size="0x0.16" />
	<field name="phy_manager_disable_mask" descr="Phy manager disable bit mask: \;Bit 0 - Module not present (module absence/cage power off)\;Bit 1 - PAOS command\;Bit 2 - MAD IB PortInfo down command\;Bit 3 - Long range cable (Non Mellanox) \;Bit 4 - Verification command\;Bit 5 - ekey command\;Bit 6 - High power - cable require higher power than allowed.\;Bit 7 - Unknown Identifier (Module)\;Bit 8 - PAOS up once \;Bit 9 - Stamping failure\;Bit 10 - Calibration not done\;Bit 11 - Module Locking\;Bit 13 - Power budget exceeded\;Bit 14 - Interrupt Event / Module Temp\;Bit 15 - TEC flow / module bring up issue" access="RO" offset="0x8.0" size="0x0.24" />
	<field name="hw_link_phy_state" descr="IBP HW FSM Reflected State:\;0x10: sleeping_delay\;0x11: sleeping_quiet\;0x20: polling_active\;0x21: polling_quiet\;0x30: disable\;0x40: config_debounce\;0x41: config_receiver\;0x42: config_wait_remote\;0x43: config_tx_reverse_lanes\;0x44: config_enhanced    \;0x45: config_test\;0x46: confg_wait_remote_test\;0x47: config_wait_cfg_enhanced\;0x48: config_idle\;0x50: linkup\;0x51: Linkup_Tx_Idle\;0x52: Linkup_Tx_Empty\;0x60: recover_retrain\;0x61: recover_wait_remote\;0x62: recover_idle\;0x70: test\;- Force Modes\;0x80: Force_send_ts1 - command may be given only on disable state\;0x90: Force_send_ts2\;0xA0: Force_Sent_Idle\;0xB0: Force_send_ts_Mlnx\;0xC0: Force_send_ts3\;0xD0: Force_LinkUp\;- L1\;0xE0: Go_To_Quiet\;0xE1: Retimer_Align\;0xE2: Quiet_Entry\;0xE3: Quiet\;0xE4: Wake\;0xE5: Wake_Tx_Sleep0\;0xE6: Send_Announce\;0xE7: Tx_HS\;0xE8: Wait_For_Cdr_Lock\;- L0\;0x53: L0_Tx_Idle\;0x54: L0_Tx_wake" access="RO" enum="sleeping_delay=0x10,sleeping_quiet=0x11,polling_active=0x20,polling_quiet=0x21,disable=0x30,config_debounce=0x40,config_receiver=0x41,config_wait_remote=0x42,config_tx_reverse_lanes=0x43,config_enhanced=0x44,config_test=0x45,confg_wait_remote_test=0x46,config_wait_cfg_enhanced=0x47,config_idle=0x48,linkup=0x50,Linkup_Tx_Idle=0x51,Linkup_Tx_Empty=0x52,recover_retrain=0x60,recover_wait_remote=0x61,recover_idle=0x62,test=0x70,Force_send_ts1=0x80,Force_send_ts2=0x90,Force_Sent_Idle=0xa0,Force_send_ts_Mlnx=0xb0,Force_send_ts3=0xc0,Force_LinkUp=0xd0,Go_To_Quiet=0xe0,Retimer_Align=0xe1,Quiet_Entry=0xe2,Quiet=0xe3,Wake=0xe4,Wake_Tx_Sleep0=0xe5,Send_Announce=0xe6,Tx_HS=0xe7,Wait_For_Cdr_Lock=0xe8,L0_Tx_Idle=0x53,L0_Tx_wake=0x54" offset="0x8.24" size="0x0.8" />
	<field name="pcs_phy_state" descr="PCS HW state:\;Bits 0-7: Block lock\;Bits 8-15: AM lock\;Bits 16-23: FEC lock\;Bits 24: Align_status\;Bits 25: Hi_BER\;Bits 26: Hi_SER" access="RO" offset="0xC.0" size="0x4.0" />
	<field name="lp_proto_enabled" descr="IB ports: \;Link partner advertised speeds (first TS3)\;See ib_link_speed_enabled encoding.\;\;Ethernet ports:\;Link partner advertised Ethernet protocols active state: see PTYS.lp_advertise" access="RO" offset="0x10.0" size="0x4.0" />
	<field name="lp_fec_mode_request" descr="Reserved when negotiation wasn&apos;t performed according to port_notifications.Link partner advertised capabilities value.\;Advertised link partner FEC mode request" access="RO" offset="0x14.0" size="0x0.16" />
	<field name="lp_fec_mode_support" descr="Reserved when negotiation wasn&apos;t performed according to port_notifications.Link partner advertised capabilities value.\;\;Advertised link partner FEC mode support\;Bit 0 - No FEC\;Bit 1 - Firecode FEC\;Bit 2 - Standard RS-FEC - RS(528,514)\;Bit 3 - Standard LL RS-FEC - RS(271,257)\;Bit 4 - Mellanox Strong RS-FEC - RS(277,257)\;Bit 5 - Mellanox LL RS-FEC - RS(163,155)\;Bit 6 - Reserved\;Bit 7 - Standard RS-FEC (544,514)\;Bit 8 - Zero Latency FEC\;Bit 12 - RS-FEC (544,514) + PLR\;Bit 13 - LL-FEC (271,257) + PLR\;\;" access="RO" offset="0x14.16" size="0x0.16" />
	<field name="ib_last_link_down_reason" descr="Bit 0 - heartbeat_ack_received\;Bit 1 - heartbeat_send_received\;Bit 2 - heartbeat_err\;Bit 3 - tx_width_reduction_done_1x\;Bit 4 - tx_width_reduction_done_full\;Bit 5 - rx_width_reduction_done_1x\;Bit 6 - rx_width_reduction_done_full\;Bit 7 - width_reduction_timeout\;Bit 8 - ibl_link_retrain\;Bit 9 - rx_comskp_timeout\;Bit 10 - fifo_full_err\;Bit 11 - ts_at_linkup\;Bit 12 - minor_threshold_reached\;Bit 13 - link_fail\;Bit 14 - rx_eb_full_r\;Bit 15 - rx_8_10_lane_err\;Bit 16 - llr_link_retrain_set\;Bit 17 - fc_timeout\;Bit 18 - phy_error\;Bit 19 - lli_err\;Bit 20 - excessive_buffer_err\;Bit 21 - remote_init\;Bit 22 - plr_retry_expired\;Bit 23 - port_didnt_exit_plr_sync\;Bit 24 - eq_failed\;Bits 31-24 - Reserved" access="RO" offset="0x18.0" size="0x4.0" />
	<field name="eth_last_link_down_lane" descr="Bit 0 - block_lock_failed\;Bit 1 - skip_detected\;Bit 2 - fec_sync_failed\;Bit 3 - fec_block_sync\;Bit 4 - fec_block_sync_lost" access="RO" high_bound="3" low_bound="0" offset="0x1C.24" size="0x4.0" />
	<field name="speed_deg_db" descr="Bit 0 - Speed degradation database Valid\;Bit 1 - Speed degradation SerDes Rx database valid\;BIts 3-2 - reserved\;Bit 4 - rx_reversal\;Bit 5 - tx_reversal\;Bit 7-6 - reserved\;Bits 11:8 - failed_qdr/fdr10 - bit per lane.\;Bits 15:12 - failed_fdr - bit per lane.\;Bits 19:16- failed_edr - bit per lane.\;Bits 24:20 - peer_failed_test\;Bits 26-25 - reserved\;Bit 27 - first_test_speed" access="RO" offset="0x24.0" size="0x4.0" />
	<field name="degrade_grade_lane0" descr="Valid only when port_notifications.Speed degradation is asserted \;" access="RO" offset="0x28.0" size="0x0.24" />
	<field name="degrade_grade_lane1" descr="Valid only when port_notifications.Speed degradation is asserted \;" access="RO" offset="0x2C.0" size="0x0.24" />
	<field name="degrade_grade_lane2" descr="Valid only when port_notifications.Speed degradation is asserted \;" access="RO" offset="0x30.0" size="0x0.24" />
	<field name="degrade_grade_lane3" descr="Valid only when port_notifications.Speed degradation is asserted \;" access="RO" offset="0x34.0" size="0x0.24" />
	<field name="num_of_presets_tested_lane7" descr="presets tested in TX tuning flow counter or in KR Startup" access="RO" offset="0x38.0" size="0x0.5" />
	<field name="num_of_presets_tested_lane6" descr="presets tested in TX tuning flow counter or in KR Startup" access="RO" offset="0x38.8" size="0x0.5" />
	<field name="num_of_presets_tested_lane5" descr="presets tested in TX tuning flow counter or in KR Startup" access="RO" offset="0x38.16" size="0x0.5" />
	<field name="num_of_presets_tested_lane4" descr="presets tested in TX tuning flow counter or in KR Startup" access="RO" offset="0x38.24" size="0x0.5" />
	<field name="kr_startup_debug_indications_5" descr="kr_startup_debug_indication_&lt;i&gt; bit mask:\;Bit 0 - Local_frame_lock\;Bit 1 - Remote_frame_lock\;Bit 2 - Local_Frame_lock_timer_expired\;Bit 3 - Remote_Frame_lock_timer_expired \;Bit 4 - Local_receiver_ready\;Bit 5 - Remote_receiver_ready\;Bit 6 - max_wait_timer_expired \;Bit 7 - Wait_timer_done\;Bit 8 - Hold_off_timer_expired\;Bit 9 - link_fail_inhibit_timer _expired" access="RO" offset="0x3C.0" size="0x0.16" />
	<field name="kr_startup_debug_indications_4" descr="kr_startup_debug_indication_&lt;i&gt; bit mask:\;Bit 0 - Local_frame_lock\;Bit 1 - Remote_frame_lock\;Bit 2 - Local_Frame_lock_timer_expired\;Bit 3 - Remote_Frame_lock_timer_expired \;Bit 4 - Local_receiver_ready\;Bit 5 - Remote_receiver_ready\;Bit 6 - max_wait_timer_expired \;Bit 7 - Wait_timer_done\;Bit 8 - Hold_off_timer_expired\;Bit 9 - link_fail_inhibit_timer _expired" access="RO" offset="0x3C.16" size="0x0.16" />
	<field name="kr_startup_debug_indications_7" descr="kr_startup_debug_indication_&lt;i&gt; bit mask:\;Bit 0 - Local_frame_lock\;Bit 1 - Remote_frame_lock\;Bit 2 - Local_Frame_lock_timer_expired\;Bit 3 - Remote_Frame_lock_timer_expired \;Bit 4 - Local_receiver_ready\;Bit 5 - Remote_receiver_ready\;Bit 6 - max_wait_timer_expired \;Bit 7 - Wait_timer_done\;Bit 8 - Hold_off_timer_expired\;Bit 9 - link_fail_inhibit_timer _expired" access="RO" offset="0x40.0" size="0x0.16" />
	<field name="kr_startup_debug_indications_6" descr="kr_startup_debug_indication_&lt;i&gt; bit mask:\;Bit 0 - Local_frame_lock\;Bit 1 - Remote_frame_lock\;Bit 2 - Local_Frame_lock_timer_expired\;Bit 3 - Remote_Frame_lock_timer_expired \;Bit 4 - Local_receiver_ready\;Bit 5 - Remote_receiver_ready\;Bit 6 - max_wait_timer_expired \;Bit 7 - Wait_timer_done\;Bit 8 - Hold_off_timer_expired\;Bit 9 - link_fail_inhibit_timer _expired" access="RO" offset="0x40.16" size="0x0.16" />
	<field name="num_of_presets_tested_lane3" descr="presets tested in TX tuning flow counter or in KR Startup" access="RO" offset="0x44.0" size="0x0.5" />
	<field name="num_of_presets_tested_lane2" descr="presets tested in TX tuning flow counter or in KR Startup" access="RO" offset="0x44.8" size="0x0.5" />
	<field name="num_of_presets_tested_lane1" descr="presets tested in TX tuning flow counter or in KR Startup" access="RO" offset="0x44.16" size="0x0.5" />
	<field name="num_of_presets_tested_lane0" descr="presets tested in TX tuning flow counter or in KR Startup" access="RO" offset="0x44.24" size="0x0.5" />
	<field name="kr_startup_fsm_lane" descr="Per lane KR startup state:\;0: KR_FSM_INITIALIZE\;1: KR_FSM_SEND_TRAINING\;2: KR_FSM_TRAIN_LOCAL_TX\;3: KR_FSM_TRAIN_LOCAL_RX\;4: KR_FSM_TRAIN_REMOTE\;5: KR_FSM_LINK_READY\;6: KR_FSM_SEND_DATA\;7: KR_FSM_NVLT\;8: KR_ABORT\;9: KR_TIMEOUT\;10: KR_FSM_IN_IDLE" access="RO" enum="KR_FSM_INITIALIZE=0x0,KR_FSM_SEND_TRAINING=0x1,KR_FSM_TRAIN_LOCAL_TX=0x2,KR_FSM_TRAIN_LOCAL_RX=0x3,KR_FSM_TRAIN_REMOTE=0x4,KR_FSM_LINK_READY=0x5,KR_FSM_SEND_DATA=0x6,KR_FSM_NVLT=0x7,KR_ABORT=0x8,KR_TIMEOUT=0x9,KR_FSM_IN_IDLE=0xa" high_bound="7" low_bound="0" offset="0x48.24" size="0x8.0" />
	<field name="eth_an_debug_indication" descr="eth_an_debug bit mask:\;Bit 0 - Force link up\;Bit 1 - No HCD\;Bit 2 - Entered ACK_detect\;Bit 3 - Entered Good\;Bit 4 - Entered Good_Check\;Bit 5 - Entered Extra_tune\;Bit 6 - Entered Fix_Reversals\;Bit 7 - Entered Next_Page\;Bit 8 - Entered Sub-FSM Fail\;Bit 9 - Tuning timeout\;Bit 10 - No markers detected (during Good check)\;Bit 11 - Do KR-startup\;Bits 15:18 - KR startup failure mask" access="RO" offset="0x50.0" size="0x4.0" />
	<field name="ib_phy_fsm_state_trace" descr="FW IB state machine:\;HDR Gen\;Bit 0 - entered IB_AN_FSM_DISABLED\;Bit 1 - entered IB_AN_FSM_INITIALY\;Bit 2 - entered IB_AN_FSM_RCVR_CFG\;Bit 3 - entered IB_AN_FSM_CFG_TEST\;Bit 4 - entered IB_AN_FSM_WAIT_RMT_TEST\;Bit 5 - entered IB_AN_FSM_WAIT_CFG_ENHANCED\;Bit 6 - entered IB_AN_FSM_CFG_IDLE\;Bit 7 - entered IB_AN_FSM_LINK_UP\;Bit 8 - Failed from CFG_IDLE\;\;NDR Gen:\;Bit 0 - entered IB_AN_FSM_DISABLED\;Bit 1 - entered IB_AN_FSM_POLLING\;Bit 2 - entered IB_AN_FSM_INITIALY\;Bit 3 - entered IB_AN_FSM_CFG_TEST\;Bit 4 - entered IB_AN_FSM_WAIT_RMT_TEST\;Bit 5 - entered IB_AN_FSM_WAIT_CFG_ENHANCED\;Bit 6 - entered IB_AN_FSM_CFG_IDLE\;Bit 7 - entered IB_AN_FSM_SYNC_CHECK\;Bit 8 - entered IB_AN_FSM_LINK_UP\;Bit 9 - Failed from CFG_IDLE\;Bit 10 - peer requested KR\;Bit 11 - speed degradation needed - &quot;best_grade&quot; didn&quot;t reach threshold\;\;" access="RO" offset="0x54.0" size="0x0.16" />
	<field name="rounds_waited_for_peer_to_end_test" descr="" access="RO" offset="0x54.16" size="0x0.5" />
	<field name="eth_an_watchdog_cnt" descr="counts ETH Watchdog was performed (and closed the IB fsm)." access="RO" offset="0x54.21" size="0x0.2" />
	<field name="fall_from_cfg_idle_cdr_cnt" descr="count falls from Cfg_idle (before linkup) due cdr not lock" access="RO" offset="0x54.23" size="0x0.3" />
	<field name="fall_from_cfg_idle_cnt" descr="count falls from Cfg_idle (before linkup) due amps lock on PLU" access="RO" offset="0x54.26" size="0x0.3" />
	<field name="cdr_not_locked_cnt" descr="count the cdr not locked after EQ" access="RO" offset="0x54.29" size="0x0.3" />
	<field name="kr_startup_debug_indications_1" descr="kr_startup_debug_indication_&lt;i&gt; bit mask:\;Bit 0 - Local_frame_lock\;Bit 1 - Remote_frame_lock\;Bit 2 - Local_Frame_lock_timer_expired\;Bit 3 - Remote_Frame_lock_timer_expired \;Bit 4 - Local_receiver_ready\;Bit 5 - Remote_receiver_ready\;Bit 6 - max_wait_timer_expired \;Bit 7 - Wait_timer_done\;Bit 8 - Hold_off_timer_expired\;Bit 9 - link_fail_inhibit_timer _expired" access="RO" offset="0x58.0" size="0x0.16" />
	<field name="kr_startup_debug_indications_0" descr="kr_startup_debug_indication_&lt;i&gt; bit mask:\;Bit 0 - Local_frame_lock\;Bit 1 - Remote_frame_lock\;Bit 2 - Local_Frame_lock_timer_expired\;Bit 3 - Remote_Frame_lock_timer_expired \;Bit 4 - Local_receiver_ready\;Bit 5 - Remote_receiver_ready\;Bit 6 - max_wait_timer_expired \;Bit 7 - Wait_timer_done\;Bit 8 - Hold_off_timer_expired\;Bit 9 - link_fail_inhibit_timer _expired" access="RO" offset="0x58.16" size="0x0.16" />
	<field name="kr_startup_debug_indications_3" descr="kr_startup_debug_indication_&lt;i&gt; bit mask:\;Bit 0 - Local_frame_lock\;Bit 1 - Remote_frame_lock\;Bit 2 - Local_Frame_lock_timer_expired\;Bit 3 - Remote_Frame_lock_timer_expired \;Bit 4 - Local_receiver_ready\;Bit 5 - Remote_receiver_ready\;Bit 6 - max_wait_timer_expired \;Bit 7 - Wait_timer_done\;Bit 8 - Hold_off_timer_expired\;Bit 9 - link_fail_inhibit_timer _expired" access="RO" offset="0x5C.0" size="0x0.16" />
	<field name="kr_startup_debug_indications_2" descr="kr_startup_debug_indication_&lt;i&gt; bit mask:\;Bit 0 - Local_frame_lock\;Bit 1 - Remote_frame_lock\;Bit 2 - Local_Frame_lock_timer_expired\;Bit 3 - Remote_Frame_lock_timer_expired \;Bit 4 - Local_receiver_ready\;Bit 5 - Remote_receiver_ready\;Bit 6 - max_wait_timer_expired \;Bit 7 - Wait_timer_done\;Bit 8 - Hold_off_timer_expired\;Bit 9 - link_fail_inhibit_timer _expired" access="RO" offset="0x5C.16" size="0x0.16" />
	<field name="tx_tuning_stages_lane" descr="Stages mask per lane:\;Bit 0 - Single preset stage\;Bit 1 - multiple preset stage\;Bit 2 - LMS" access="RO" high_bound="7" low_bound="0" offset="0x60.28" size="0x4.0" />
	<field name="plu_tx_pwrup" descr="PLU power up status per lane" access="RO" offset="0x64.0" size="0x0.8" />
	<field name="plu_rx_pwrup" descr="PLU power up status per lane" access="RO" offset="0x64.8" size="0x0.8" />
	<field name="plu_tx_polarity" descr="Configured PLU polarity per lane" access="RO" offset="0x64.16" size="0x0.8" />
	<field name="plu_rx_polarity" descr="Configured PLU polarity per lane" access="RO" offset="0x64.24" size="0x0.8" />
	<field name="irisc_status" descr="" access="RO" offset="0x68.0" size="0x0.4" />
	<field name="ib_cfg_delay_timeout" descr="0 - Default as defined in IB Spec.\;1 - Override default with 64msec timeout for all speeds.\;2 - Reserved\;3 - Reserved" access="RO" offset="0x68.4" size="0x0.2" />
	<field name="sd_valid" descr="when set, signal_detected has valid value." access="RO" offset="0x68.6" size="0x0.1" />
	<field name="plu_tx_speed" descr="PLU configured speed:\;" access="RO" offset="0x68.8" size="0x0.4" />
	<field name="plu_rx_speed" descr="PLU configured speed:\;" access="RO" offset="0x68.12" size="0x0.4" />
	<field name="plr_outstanding_cells" descr="" access="RO" offset="0x68.16" size="0x0.8" />
	<field name="signal_detected" descr="valid only when sd_valid is set\;Bitmask per lane.\;When set signal has been detected on the lane" access="RO" offset="0x68.24" size="0x0.8" />
	<field name="stamping_reason" descr="Bit 0 - com_codes_is_zero \;Bit 1 - rx_cdr_check_force_mode \;Bit 2 - com_code_compliance \;Bit 3 - eth_56g_stamped\;Bit 4 - non_mlx_qsfp_transceiver\;Bit 5 - non_mlx_sfp_transceiver\;Bit 6 - ib_comp_codes\;Bit 7 - edr_comp\;Bit 8 - fdr_comp" access="RO" offset="0x6C.0" size="0x4.0" />
	<field name="kr_frame_lock_tuning_failure_events_count" descr="Number of times that fast tuning (50ms) for KR lock failed to achieve frame lock." access="RO" offset="0x70.0" size="0x4.0" />
	<field name="kr_full_tuning_failure_count" descr="Number of times that full tuning (0.5sec/3sec) for KR full tuning flow failed to achieve desire SI performance" access="RO" offset="0x74.0" size="0x4.0" />
	<field name="pm_debug_indication" descr="Bit 0: phy_test_mode\;Bit 1: force_mode_en" access="RO" enum="phy_test_mode=0x1,force_mode_en=0x2" offset="0x78.0" size="0x0.16" />
	<field name="ib_debug_indication" descr="Bit 0: cause_plr_tx_max_outstanding_cells" access="RO" enum="cause_plr_tx_max_outstanding_cells=0x1" offset="0x78.16" size="0x0.16" />
	<field name="pm_catastrophic_enum" descr="Phy Manager catastrophic enum" access="RO" offset="0x7C.0" size="0x0.7" />
	<field name="pm_cat_val" descr="When set, indicates the pm_catastrophic_enum is valid" access="RO" offset="0x7C.7" size="0x0.1" />
	<field name="an_catastrophic_enum" descr="Auto-neg catastrophic enum" access="RO" offset="0x7C.8" size="0x0.7" />
	<field name="an_cat_val" descr="When set, indicates the an_catastrophic_enum is valid" access="RO" offset="0x7C.15" size="0x0.1" />
	<field name="hst_catastrophic_enum" descr="HST catastrophic enum" access="RO" offset="0x7C.16" size="0x0.7" />
	<field name="hst_cat_val" descr="When set, indicates the hst_catastrophic_enum is valid" access="RO" offset="0x7C.23" size="0x0.1" />
	<field name="pd_catastrophic_enum" descr="Parallel Detect catastrophic enum" access="RO" offset="0x7C.24" size="0x0.7" />
	<field name="pd_cat_val" descr="When set, indicates the pd_catastrophic_enum is valid" access="RO" offset="0x7C.31" size="0x0.1" />
	<field name="pd_debug_indication" descr="Bit 0: speed_change_high_speed_module\;Bit 1: False_positive_signal_detect\;Bit 2: Nv2nv_force\;Bit 3: bad_kr_mask \;Bit 4: kr_mlx_peer\;Bit 5: entered_signal_detect\;Bit 6: entered_rate_config\;Bit 7: entered_activate_sunfsm\;Bit 8: entered_done\;Bit 9: entered_subfsm_fail" access="RO" enum="speed_change_high_speed_module=0x1,False_positive_signal_detect=0x2,Nv2nv_force=0x4,bad_kr_mask=0x8,kr_mlx_peer=0x10,entered_signal_detect=0x20,entered_rate_config=0x40,entered_activate_sunfsm=0x80,entered_done=0x100,entered_subfsm_fail=0x200" offset="0x80.0" size="0x4.0" />
	<field name="pd_count" descr="Parallel detect cycles counter" access="RO" offset="0x84.0" size="0x0.6" />
	<field name="fp_signal_detect_count" descr="False Positive signal detect count" access="RO" offset="0x84.8" size="0x0.6" />
	<field name="hst_mismatch_reason" descr="0: speed\;1: FEC\;2: precoding\;3: Gray coding" access="RO" offset="0x84.16" size="0x0.2" />
	<field name="psi_collision2" descr="FSM 2 to call sub fsm of PSI that caused collision\;see fsm_mask in debug page for FSM numbering" access="RO" offset="0x84.22" size="0x0.5" />
	<field name="psi_collision1" descr="FSM 1 to call sub fsm of PSI that caused collision\;see fsm_mask in debug page for FSM numbering" access="RO" offset="0x84.27" size="0x0.5" />
	<field name="nlpn_debug_ind_mask" descr="Bit 0: nonce_match_fail\;Bit 1: timeout - rst cause idle in npln\;Bit 2: hs_neg\;Bit 3: dme_neg" access="RO" enum="nonce_match_fail=0x1,timeout=0x2,hs_neg=0x4,dme_neg=0x8" offset="0x88.0" size="0x0.8" />
	<field name="phy2mod_speed_req" descr="phy 2 module requested speed, aka speed_apsel_value\;bitmask according to PTYS.ext_ethernet_protocol for ETH speeds\;or ib_ext_protocols for IB speeds" access="RO" offset="0x8C.0" size="0x4.0" />
	<field name="phy2mod_deactivate_lanes" descr="Bitmask per lane for phy2mod deactivate request status.\;0 - allow DP activation\;1 - Deactivate module DP" access="RO" offset="0x90.0" size="0x0.8" />
	<field name="phy2mod_ack_lanes" descr="Bitmask per lane for phy2mod request status.\;0 - ack\;1 - nack" access="RO" offset="0x90.8" size="0x0.8" />
	<field name="one_pll_mod" descr="indicates module has one pll for all lanes of the module." access="RO" offset="0x90.29" size="0x0.1" />
	<field name="no_dme_mod" descr="no_dme_module indicates module doesn&apos;t support low speed signaling such as 312.5 MB/s for DME ETH AN signaling or SDR (2.5 GB/s) for IB low speed AN." access="RO" offset="0x90.30" size="0x0.1" />
	<field name="eeprom_prsnt" descr="eeprom present indication" access="RO" offset="0x90.31" size="0x0.1" />
	<field name="rx_bypass_mux_plt0" descr="1 bit per each split; 1-enabled; 0-Bypass (No MacSec)" access="RO" offset="0x94.0" size="0x0.2" />
	<field name="rx_bypass_mux_plt1" descr="1 bit per each split; 1-enabled; 0-Bypass (No MacSec)" access="RO" offset="0x94.2" size="0x0.2" />
	<field name="tx_bypass_mux_plt0" descr="1 bit per each split; 1-enabled; 0-Bypass (No MacSec)" access="RO" offset="0x94.4" size="0x0.2" />
	<field name="tx_bypass_mux_plt1" descr="1 bit per each split; 1-enabled; 0-Bypass (No MacSec)" access="RO" offset="0x94.6" size="0x0.2" />
	<field name="reconciliation_mux_plt0" descr="1 bit per each split; 1-enabled; 0-Bypass (No MacSec)" access="RO" offset="0x94.8" size="0x0.2" />
	<field name="reconciliation_mux_plt1" descr="1 bit per each split; 1-enabled; 0-Bypass (No MacSec)" access="RO" offset="0x94.10" size="0x0.2" />
	<field name="macsec_en_plt0_s0" descr="MacSec enabled plt0 split 0" access="RO" offset="0x94.12" size="0x0.1" />
	<field name="macsec_en_plt0_s1" descr="MacSec enabled plt0 split 1" access="RO" offset="0x94.13" size="0x0.1" />
	<field name="macsec_en_plt1_s0" descr="MacSec enabled plt1 split 0" access="RO" offset="0x94.14" size="0x0.1" />
	<field name="macsec_en_plt1_s1" descr="MacSec enabled plt1 split 1" access="RO" offset="0x94.15" size="0x0.1" />
	<field name="cnt_rx_frame_received_ok_s0" descr="MacSec Engine Wrapper, debug counter" access="RO" offset="0x94.16" size="0x0.4" />
	<field name="cnt_rx_frame_received_ok_s1" descr="MacSec Engine Wrapper, debug counter" access="RO" offset="0x94.20" size="0x0.4" />
	<field name="port_xmit_pkts_inc_s0" descr="MacSec Engine Wrapper, debug counter" access="RO" offset="0x94.24" size="0x0.4" />
	<field name="port_xmit_pkts_inc_s1" descr="MacSec Engine Wrapper, debug counter" access="RO" offset="0x94.28" size="0x0.4" />
	<field name="plr_rtt_ndr_threshold" descr="rtt threshold in 1 ns units for NDR speeds\;" access="RO" offset="0x98.0" size="0x0.16" />
	<field name="plr_rtt_hdr_threshold" descr="rtt threshold in 1 ns units for HDR speeds" access="RO" offset="0x98.16" size="0x0.16" />
	<field name="plr_rtt_xdr_threshold" descr="rtt threshold in 1 ns units for XDR speeds\;" access="RO" offset="0x9C.16" size="0x0.16" />
</node>

<node name="pddr_phy_manager_link_enabled_eth_ext" descr="" size="0x4.0" >
	<field name="phy_manager_link_eth_enabled" descr="Ethernet protocols admin state: see PTYS.ext_eth_proto_admin" access="RO" offset="0x0.0" size="0x4.0" />
</node>

<node name="pddr_phy_manager_link_enabled_ib_ext" descr="" size="0x4.0" >
	<field name="phy_manager_link_proto_enabled" descr="IB link enabled speed:\;Bit 0 - SDR\;Bit 1 - DDR\;Bit 2 - QDR\;Bit 3 - FDR10\;Bit 4 - FDR\;Bit 5 - EDR\;Bit 6 - HDR\;Bit 7 - NDR\;Bit 8 - XDR" access="RO" offset="0x0.0" size="0x0.16" />
	<field name="phy_manager_link_width_enabled" descr="IB link enabled width:\;Bit 0 - 1x\;Bit 1 - 2x\;Bit 2 - 4x\;Other - reserved" access="RO" offset="0x0.16" size="0x0.16" />
</node>

<node name="pddr_phy_manager_link_enabled_nvlink_ext" descr="" size="0x4.0" >
	<field name="phy_manager_link_nvlink_enabled" descr="NVLink protocols admin state: \;see: Table  668, &quot;PTYS - Extended Protocol NVLink - admin layout,&quot; on page  728" access="RO" offset="0x0.0" size="0x4.0" />
</node>

<node name="pddr_reg_ext" descr="" size="0x100.0" >
	<field name="port_type" descr="Supported only when indicated by PCAM \;0: Network_port\;1: Near_End_Port - (For Retimer/Gearbox - Host side)\;2: Internal_IC_LR_Port \;3: Far_End_Port - (For Retimer/Gearbox - Line side)\;Other values are reserved." access="INDEX" enum="Network_port=0x0,Near_End_Port=0x1,Internal_IC_LR_Port=0x2,Far_End_Port=0x3" offset="0x0.4" size="0x0.4" />
	<field name="plane_ind" descr="Reserved for non-planarized port.\;Plane port index of the aggregated port. A value of 0 refers to the aggregated port only." access="INDEX" offset="0x0.8" size="0x0.4" />
	<field name="lp_msb" descr="Local port number [9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="pnat" descr="Port number access type. determines the way local_port is interpreted:\;0: Local_port_number\;1: IB_port_number\;3: Out_of_band_or_PCI" access="INDEX" enum="Local_port_number=0x0,IB_port_number=0x1,Out_of_band_or_PCI=0x3" offset="0x0.14" size="0x0.2" />
	<field name="local_port" descr="Local port number." access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="module_ind_type" descr="Module index type selector:\;0: CPO_or_pluggable_modules\;1: OE\;2: ELS" access="INDEX" enum="CPO_or_pluggable_modules=0x0,OE=0x1,ELS=0x2" offset="0x0.24" size="0x0.2" />
	<field name="page_select" descr="page select index:\;0: Operational_info_page\;1: Troubleshooting_info_page\;2: Phy_info_page\;3: Module_info_page\;6: link_down_info\;8: Link_up_info\;9: Module_latched_flag_info_page" access="INDEX" enum="Operational_info_page=0x0,Troubleshooting_info_page=0x1,Phy_info_page=0x2,Module_info_page=0x3,link_down_info=0x6,Link_up_info=0x8,Module_latched_flag_info_page=0x9" offset="0x4.0" size="0x0.8" />
	<field name="module_info_ext" descr="Module info extended configurations.\;resolution for rx_power, rx_power_high_th, rx_power_low_th tx_power, tx_power_high_th, tx_power_low_th in module info page\;0: dbm\;1: uW" access="OP" enum="dbm=0x0,uW=0x1" offset="0x4.29" size="0x0.2" />
	<field name="page_data" descr="Table  910, &quot;Operation Info Page Layout,&quot; on page  1017\;Table  954, &quot;Troubleshooting info Page layout,&quot; on page  1073\;Table  946, &quot;Phy Info Page Layout,&quot; on page  1037\;Table  952, &quot;Module Info Page Layout,&quot; on page  1058\;Table  948, &quot;Link Down Info Page layout,&quot; on page  1052\;Table  964, &quot;Link Up Info Page Layout,&quot; on page  1088\;Table  966, &quot;Module Latched Flag Info Page Layout,&quot; on page  1092\;" subnode="pddr_reg_page_data_auto_ext" access="RO" offset="0x8.0" size="0xf8.0" union_selector="$(parent).page_select" />
</node>

<node name="pddr_reg_page_data_auto_ext" descr="" attr_is_union="1" size="0xf8.0" >
	<field name="pddr_operation_info_page_ext" descr="" subnode="pddr_operation_info_page_ext" offset="0x0.0" selected_by="Operational_info_page" size="0xf8.0" />
	<field name="pddr_troubleshooting_page_ext" descr="" subnode="pddr_troubleshooting_page_ext" offset="0x0.0" selected_by="Troubleshooting_info_page" size="0xf8.0" />
	<field name="pddr_phy_info_page_ext" descr="" subnode="pddr_phy_info_page_ext" offset="0x0.0" selected_by="Phy_info_page" size="0xf8.0" />
	<field name="pddr_module_info_ext" descr="" subnode="pddr_module_info_ext" offset="0x0.0" selected_by="Module_info_page" size="0xcc.0" />
	<field name="pddr_link_down_info_page_ext" descr="" subnode="pddr_link_down_info_page_ext" offset="0x0.0" selected_by="link_down_info" size="0xf4.0" />
	<field name="pddr_link_up_info_page_ext" descr="" subnode="pddr_link_up_info_page_ext" offset="0x0.0" selected_by="Link_up_info" size="0xf8.0" />
	<field name="module_latched_flag_info_ext" descr="" subnode="module_latched_flag_info_ext" offset="0x0.0" selected_by="Module_latched_flag_info_page" size="0xf8.0" />
</node>

<node name="pddr_troubleshooting_page_ext" descr="" size="0xf8.0" >
	<field name="group_opcode" descr="0: Monitor_opcodes" access="INDEX" enum="Monitor_opcodes=0x0" offset="0x0.0" size="0x0.16" />
	<field name="status_opcode" descr="Status opcode described in:\;Table  956, &quot;PDDR - Monitor opcodes layout,&quot; on page  1074" subnode="pddr_troubleshooting_page_status_opcode_auto_ext" access="RO" offset="0x4.0" size="0x4.0" union_selector="$(parent).group_opcode" />
	<field name="status_message" descr="ASCII code message\;All Messages are terminated by a Null character &apos;\0&apos;" access="RO" high_bound="58" low_bound="0" offset="0xC.0" size="0xec.0" />
</node>

<node name="pddr_troubleshooting_page_status_opcode_auto_ext" descr="" attr_is_union="1" size="0x4.0" >
	<field name="pddr_monitor_opcode_ext" descr="" subnode="pddr_monitor_opcode_ext" offset="0x0.0" selected_by="Monitor_opcodes" size="0x4.0" />
</node>

<node name="phy_error_cntrs_ext" descr="" size="0x64.0" >
	<field name="time_since_last_clear_high" descr="The time passed since the last counters clear event in msec." access="RO" offset="0x0.0" size="0x4.0" />
	<field name="time_since_last_clear_low" descr="The time passed since the last counters clear event in msec." access="RO" offset="0x4.0" size="0x4.0" />
	<field name="phy_received_bits_high" descr="This counter provides information on the total amount of traffic (bits) received." access="RO" offset="0x8.0" size="0x4.0" />
	<field name="phy_received_bits_low" descr="This counter provides information on the total amount of traffic (bits) received." access="RO" offset="0xC.0" size="0x4.0" />
	<field name="phy_raw_errors_lane0_high" descr="This counter provides information on error bits that were identified on lane 0. \;In PRBS test mode, indicates the number of PRBS errors\;on lane 0" access="RO" offset="0x10.0" size="0x4.0" />
	<field name="phy_raw_errors_lane0_low" descr="This counter provides information on error bits that were identified on lane 0. \;In PRBS test mode, indicates the number of PRBS errors\;on lane 0" access="RO" offset="0x14.0" size="0x4.0" />
	<field name="phy_raw_errors_lane1_high" descr="This counter provides information on error bits that were identified on lane 1. \;In PRBS test mode, indicates the number of PRBS errors\;on lane 1" access="RO" offset="0x18.0" size="0x4.0" />
	<field name="phy_raw_errors_lane1_low" descr="This counter provides information on error bits that were identified on lane 1. \;In PRBS test mode, indicates the number of PRBS errors\;on lane 1" access="RO" offset="0x1C.0" size="0x4.0" />
	<field name="phy_raw_errors_lane2_high" descr="This counter provides information on error bits that were identified on lane 2. \;In PRBS test mode, indicates the number of PRBS errors\;on lane 2" access="RO" offset="0x20.0" size="0x4.0" />
	<field name="phy_raw_errors_lane2_low" descr="This counter provides information on error bits that were identified on lane 2. \;In PRBS test mode, indicates the number of PRBS errors\;on lane 2" access="RO" offset="0x24.0" size="0x4.0" />
	<field name="phy_raw_errors_lane3_high" descr="This counter provides information on error bits that were identified on lane 3. \;In PRBS test mode, indicates the number of PRBS errors\;on lane 3" access="RO" offset="0x28.0" size="0x4.0" />
	<field name="phy_raw_errors_lane3_low" descr="This counter provides information on error bits that were identified on lane 3. \;In PRBS test mode, indicates the number of PRBS errors\;on lane 3" access="RO" offset="0x2C.0" size="0x4.0" />
	<field name="phy_raw_errors_lane4_high" descr="This counter provides information on error bits that were identified on lane 4. \;In PRBS test mode, indicates the number of PRBS errors\;on lane 4" access="RO" offset="0x30.0" size="0x4.0" />
	<field name="phy_raw_errors_lane4_low" descr="This counter provides information on error bits that were identified on lane 4. \;In PRBS test mode, indicates the number of PRBS errors\;on lane 4" access="RO" offset="0x34.0" size="0x4.0" />
	<field name="phy_raw_errors_lane5_high" descr="This counter provides information on error bits that were identified on lane 5. \;In PRBS test mode, indicates the number of PRBS errors\;on lane 5" access="RO" offset="0x38.0" size="0x4.0" />
	<field name="phy_raw_errors_lane5_low" descr="This counter provides information on error bits that were identified on lane 5. \;In PRBS test mode, indicates the number of PRBS errors\;on lane 5" access="RO" offset="0x3C.0" size="0x4.0" />
	<field name="phy_raw_errors_lane6_high" descr="This counter provides information on error bits that were identified on lane 6. \;In PRBS test mode, indicates the number of PRBS errors\;on lane 6" access="RO" offset="0x40.0" size="0x4.0" />
	<field name="phy_raw_errors_lane6_low" descr="This counter provides information on error bits that were identified on lane 6. \;In PRBS test mode, indicates the number of PRBS errors\;on lane 6" access="RO" offset="0x44.0" size="0x4.0" />
	<field name="phy_raw_errors_lane7_high" descr="This counter provides information on error bits that were identified on lane 7. \;In PRBS test mode, indicates the number of PRBS errors\;on lane 7" access="RO" offset="0x48.0" size="0x4.0" />
	<field name="phy_raw_errors_lane7_low" descr="This counter provides information on error bits that were identified on lane 7. \;In PRBS test mode, indicates the number of PRBS errors\;on lane 7" access="RO" offset="0x4C.0" size="0x4.0" />
	<field name="raw_ber_coef" descr="Raw_BER= raw_ber_coef*10^(-raw_ber_magnitude)" access="RO" offset="0x50.0" size="0x0.4" />
	<field name="raw_ber_coef_float" descr="Raw_BER= raw_ber_coef*10^(-raw_ber_magnitude)" access="RO" offset="0x50.4" size="0x0.4" />
	<field name="raw_ber_magnitude" descr="Raw_BER= raw_ber_coef*10^(-raw_ber_magnitude)" access="RO" offset="0x50.8" size="0x0.8" />
	<field name="fc_zero_hist" descr="Valid for links with RS FEC histograms only including test mode when histogram counters enabled.\;First histogram bin with value of 0 while all \;higher bins are only with 0 value as well.\;0 - No histogram active / N/A value" access="RO" offset="0x50.16" size="0x0.4" />
	<field name="raw_ber_coef_lane1" descr="Raw_BER_lan0 = raw_ber_coef_lane1*10^(-raw_ber_magnitude_lane1)" access="RO" offset="0x54.0" size="0x0.4" />
	<field name="raw_ber_coef_float_lane1" descr="Raw_BER_lan0 = raw_ber_coef_lane1*10^(-raw_ber_magnitude_lane1)" access="RO" offset="0x54.4" size="0x0.4" />
	<field name="raw_ber_magnitude_lane1" descr="Raw_BER_lan0 = raw_ber_coef_lane1*10^(-raw_ber_magnitude_lane1)" access="RO" offset="0x54.8" size="0x0.8" />
	<field name="raw_ber_coef_lane0" descr="Raw_BER_lan0 = raw_ber_coef_lane0*10^(-raw_ber_magnitude_lane0)" access="RO" offset="0x54.16" size="0x0.4" />
	<field name="raw_ber_coef_float_lane0" descr="Raw_BER_lan0 = raw_ber_coef_lane0*10^(-raw_ber_magnitude_lane0)" access="RO" offset="0x54.20" size="0x0.4" />
	<field name="raw_ber_magnitude_lane0" descr="Raw_BER_lan0 = raw_ber_coef_lane0*10^(-raw_ber_magnitude_lane0)" access="RO" offset="0x54.24" size="0x0.8" />
	<field name="raw_ber_coef_lane3" descr="Raw_BER_lan0 = raw_ber_coef_lane3*10^(-raw_ber_magnitude_lane3)" access="RO" offset="0x58.0" size="0x0.4" />
	<field name="raw_ber_coef_float_lane3" descr="Raw_BER_lan0 = raw_ber_coef_lane3*10^(-raw_ber_magnitude_lane3)" access="RO" offset="0x58.4" size="0x0.4" />
	<field name="raw_ber_magnitude_lane3" descr="Raw_BER_lan0 = raw_ber_coef_lane3*10^(-raw_ber_magnitude_lane3)" access="RO" offset="0x58.8" size="0x0.8" />
	<field name="raw_ber_coef_lane2" descr="Raw_BER_lan0 = raw_ber_coef_lane2*10^(-raw_ber_magnitude_lane2)" access="RO" offset="0x58.16" size="0x0.4" />
	<field name="raw_ber_coef_float_lane2" descr="Raw_BER_lan0 = raw_ber_coef_lane2*10^(-raw_ber_magnitude_lane2)" access="RO" offset="0x58.20" size="0x0.4" />
	<field name="raw_ber_magnitude_lane2" descr="Raw_BER_lan0 = raw_ber_coef_lane2*10^(-raw_ber_magnitude_lane2)" access="RO" offset="0x58.24" size="0x0.8" />
	<field name="raw_ber_coef_lane5" descr="Raw_BER_lan0 = raw_ber_coef_lane5*10^(-raw_ber_magnitude_lane5)" access="RO" offset="0x5C.0" size="0x0.4" />
	<field name="raw_ber_coef_float_lane5" descr="Raw_BER_lan0 = raw_ber_coef_lane5*10^(-raw_ber_magnitude_lane5)" access="RO" offset="0x5C.4" size="0x0.4" />
	<field name="raw_ber_magnitude_lane5" descr="Raw_BER_lan0 = raw_ber_coef_lane5*10^(-raw_ber_magnitude_lane5)" access="RO" offset="0x5C.8" size="0x0.8" />
	<field name="raw_ber_coef_lane4" descr="Raw_BER_lan0 = raw_ber_coef_lane4*10^(-raw_ber_magnitude_lane4)" access="RO" offset="0x5C.16" size="0x0.4" />
	<field name="raw_ber_coef_float_lane4" descr="Raw_BER_lan0 = raw_ber_coef_lane4*10^(-raw_ber_magnitude_lane4)" access="RO" offset="0x5C.20" size="0x0.4" />
	<field name="raw_ber_magnitude_lane4" descr="Raw_BER_lan0 = raw_ber_coef_lane4*10^(-raw_ber_magnitude_lane4)" access="RO" offset="0x5C.24" size="0x0.8" />
	<field name="raw_ber_coef_lane7" descr="Raw_BER_lan0 = raw_ber_coef_lane7*10^(-raw_ber_magnitude_lane7)" access="RO" offset="0x60.0" size="0x0.4" />
	<field name="raw_ber_coef_float_lane7" descr="Raw_BER_lan0 = raw_ber_coef_lane7*10^(-raw_ber_magnitude_lane7)" access="RO" offset="0x60.4" size="0x0.4" />
	<field name="raw_ber_magnitude_lane7" descr="Raw_BER_lan0 = raw_ber_coef_lane7*10^(-raw_ber_magnitude_lane7)" access="RO" offset="0x60.8" size="0x0.8" />
	<field name="raw_ber_coef_lane6" descr="Raw_BER_lan0 = raw_ber_coef_lane6*10^(-raw_ber_magnitude_lane6)" access="RO" offset="0x60.16" size="0x0.4" />
	<field name="raw_ber_coef_float_lane6" descr="Raw_BER_lan0 = raw_ber_coef_lane6*10^(-raw_ber_magnitude_lane6)" access="RO" offset="0x60.20" size="0x0.4" />
	<field name="raw_ber_magnitude_lane6" descr="Raw_BER_lan0 = raw_ber_coef_lane6*10^(-raw_ber_magnitude_lane6)" access="RO" offset="0x60.24" size="0x0.8" />
</node>

<node name="pphcr_bin_range_ext" descr="" size="0x4.0" >
	<field name="low_val" descr="low range of bin&apos;s measurement" access="RW" offset="0x0.0" size="0x0.4" />
	<field name="high_val" descr="high range of bin&apos;s measurement" access="RW" offset="0x0.16" size="0x0.4" />
</node>

<node name="pphcr_ext" descr="" size="0x50.0" >
	<field name="we" descr="Support of histogram bins configuration. \;In case this bit is cleared, the port doesn&apos;t support configuration of the histogram bins, for the specific hist_type." access="RO" offset="0x0.0" size="0x0.1" />
	<field name="plane_ind" descr="Reserved for non-planarized port.\;Plane port index of the aggregated port. A value of 0 refers to the aggregated port only." access="INDEX" offset="0x0.4" size="0x0.4" />
	<field name="port_type" descr="0 - Network Port\;1 - Near-End Port (For Retimer/Gearbox - Host side)\;3 - Far-End Port (For Retimer/Gearbox - Line side)\;Other values are reserved." access="INDEX" offset="0x0.8" size="0x0.4" />
	<field name="lp_msb" descr="Local port number [9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="pnat" descr="Port number access type:\;0: Local_port_number\;1: IB_port_number" access="INDEX" enum="Local_port_number=0x0,IB_port_number=0x1" offset="0x0.14" size="0x0.2" />
	<field name="local_port" descr="local_port or DataPath number" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="active_hist_type" descr="0 - Invalid (Link down / unsupported) \;1 - KP4 RS-FEC (544,514) errors \;2 - LL RS-FEC (271,257) / (272,257+1) errors\;3 - KR4 RS-FEC (528,514) errors\;4 - PRBS errors" access="RO" offset="0x0.28" size="0x0.4" />
	<field name="hist_type" descr="0: According to active link" access="INDEX" offset="0x4.0" size="0x0.4" />
	<field name="num_of_bins" descr="Available number of bins \;" access="RO" offset="0x4.16" size="0x0.8" />
	<field name="hist_min_measurement" descr="Lowest measurement/low limit of the histogram \;Example:\;In case of hist_type = 1, represent KP4 RS FEC symbol errors(= 0)\;In case of hist_type = 2, represent LL RS FEC symbol errors ( = 0)\;" access="RO" offset="0x8.0" size="0x0.8" />
	<field name="hist_max_measurement" descr="Highest measurement/high limit of the histogram:\;Example:\;In case of hist_type = 1, represent KP4 RS FEC symbol errors ( = 15)\;In case of hist_type = 2, represent LL RS FEC symbol errors ( = 7)" access="RO" offset="0x8.16" size="0x0.8" />
	<field name="bin_range_write_mask" descr="Valid only if we (write enable) = 1 \;Ignored on GET \;Write mask for the bin_range array. \;If bit X is set, bin_range [X] write should be execute\;Else if bit X is clear, ignored value in written to bin_range [X]" access="WO" offset="0xC.0" size="0x0.16" />
	<field name="bin_range" descr="Write to bin_range[x] is applicable only if we = 1 &amp; the corresponding bits in bin_range_write_mask is set.\;Mapping of measurement units to a bin.\;See Table 1002, &quot;PPHCR - Port Phy Bin Range Histogram Configuration Layout,&quot; on page 1159" subnode="pphcr_bin_range_ext" access="RW" high_bound="15" low_bound="0" offset="0x10.0" size="0x40.0" />
</node>

<node name="riscv_exception_ext" descr="" size="0x18.0" >
	<field name="mepc" descr="Machine Exception Program Counter (mepc).\;" subnode="uint64" access="RO" offset="0x0.0" size="0x8.0" />
	<field name="mcause" descr="Machine Cause Register (mcause).RiscV exception code." subnode="uint64" access="RO" offset="0x8.0" size="0x8.0" />
	<field name="mtval" descr="Machine Trap Value (mtval) Register.Holds exception-specific information to assist software in handling the trap." subnode="uint64" access="RO" offset="0x10.0" size="0x8.0" />
</node>

<node name="rom_version_ext" descr="" size="0x4.0" >
	<field name="build" descr="Build version" access="RO" offset="0x0.0" size="0x0.16" />
	<field name="minor" descr="Minor version" access="RO" offset="0x0.16" size="0x0.8" />
	<field name="major" descr="Major version" access="RO" offset="0x0.24" size="0x0.8" />
</node>

<node name="rtcap_reg_ext" descr="" size="0x14.0" >
	<field name="reg_group" descr="access register group ID \;0: RegID_0x5000_to_0x507F\;2: RegID_0x6C00_to_0x6C7F\;3: RegID_0x6C80_to_0x6CFF\;4: RegID_0x6D00_to_0x6D7F\;" access="INDEX" enum="RegID_0x5000_to_0x507F=0x0,RegID_0x6C00_to_0x6C7F=0x2,RegID_0x6C80_to_0x6CFF=0x3,RegID_0x6D00_to_0x6D7F=0x4" offset="0x0.0" size="0x0.4" />
	<field name="access_reg_cap_mask" descr="supported access registers bit-mask, if the bit is set, the register is supported\;\;for reg_group0:\;\;bit 0: 0x6C00 \;bit 1: 0x6C01 (RTFC)\;bit 2: 0x6C02 (RTXBCFG)\;...\;bit 127: 0x6C7F (RRAR)\;\;\;for reg_group1:\;bit 0: 0x5000\;bit 1: 0x5001 (PCAP)\;...\;bit 127: 0x507F (PCAM)" access="RO" high_bound="3" low_bound="0" offset="0x4.0" size="0x10.0" />
</node>

<node name="rtcc_lane_info_ext" descr="" size="0x4.0" >
	<field name="tx_line" descr="mapping the Physical lane for Data Path lane, rx host side\;\;for gearbox: tx_2\;(host side for even lane number, line side for odd lane number)" access="RW" offset="0x0.0" size="0x0.4" />
	<field name="rx_line" descr="mapping the Physical lane for Data Path lane, rx host side\;\;for gearbox: rx_2\;(host side for even lane number, line side for odd lane number)" access="RW" offset="0x0.5" size="0x0.4" />
	<field name="tx_host" descr="mapping the Physical lane for Data Path lane, rx host side\;\;for gearbox: tx_1\;(host side for even lane number, line side for odd lane number)" access="RW" offset="0x0.10" size="0x0.4" />
	<field name="rx_host" descr="mapping the Physical lane for Data Path lane, rx host side\;\;for gearbox: rx_1\;(host side for even line number, line side for odd line number)" access="RW" offset="0x0.15" size="0x0.4" />
	<field name="gearbox" descr="0: disable\;1: gearbox (2 -&gt;1)\;2: reversed gearbox (1-&gt;2)\;\;if gearboxing is enable, it needs to be on both near lanes.\;the even lane number will set the host side, \;and the odd lane number will set the line side" access="RW" offset="0x0.28" size="0x0.2" />
	<field name="override" descr="0: values stay the same, ignore all the parameters\;1: override crossbar values." access="RW" offset="0x0.31" size="0x0.1" />
</node>

<node name="rtcc_reg_ext" descr="" size="0x24.0" >
	<field name="error" descr="error return (bit-mask)\;bit 0: lane0_error\;bit 1: lane1_error\;bit 2: lane2_error\;bit 3: lane3_error\;bit 4: lane4_error\;bit 5: lane5_error\;bit 6: lane6_error\;bit 7: lane7_error" access="RO" enum="lane0_error=0x1,lane1_error=0x2,lane2_error=0x4,lane3_error=0x8,lane4_error=0x10,lane5_error=0x20,lane6_error=0x40,lane7_error=0x80" offset="0x0.0" size="0x0.8" />
	<field name="partial_retimed" descr="can be change only when all data paths are down.\;0x0: no_change\;0x1: full_retimed\;0x2: half_retimed_egress\;0x3: half_retimed_ingress" access="RW" enum="no_change=0x0,full_retimed=0x1,half_retimed_egress=0x2,half_retimed_ingress=0x3" offset="0x0.27" size="0x0.2" />
	<field name="lane" descr="configuration for lane 0-7" subnode="rtcc_lane_info_ext" access="RW" high_bound="7" low_bound="0" offset="0x4.0" size="0x20.0" />
</node>

<node name="rtcde_reg_ext" descr="" size="0x14.0" >
	<field name="data_path" descr="data path number. \;ignore if all_lanes=0x1" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="all_lanes" descr="0x0: return only the lanes relevant to the chosen data path. Lanes will be aligned to start from lane 0\;0x1: return the status on all of the retimer lanes at once (ignore data_path)." access="INDEX" offset="0x0.24" size="0x0.1" />
	<field name="cdr_no_lock_host" descr="CDR not locked indication on Rx host side.\;Lane bit mask\;0 - locked - valid only after link is initialized; RTPAOS &lt;&gt; Down\;1 - not locked\;Note: indicated current CDR lock status, does not save lock loss indication" access="RO" offset="0x4.0" size="0x0.8" />
	<field name="cdr_no_lock_line" descr="CDR not locked indication on Rx line side.\;Lane bit mask\;0 - locked - valid only after link is initialized; RTPAOS &lt;&gt; Down\;1 - not locked\;Note: indicated current CDR lock status, does not save lock loss indication" access="RO" offset="0x4.16" size="0x0.8" />
	<field name="output_valid_host" descr="transmitting pass-through valid data on ingress path. Line Rx to Host Tx\;Lane bit mask" access="RO" offset="0x8.0" size="0x0.8" />
	<field name="output_valid_line" descr="transmitting pass-through valid data on egress path. Host Rx to Line Tx\;Lane bit mask" access="RO" offset="0x8.16" size="0x0.8" />
	<field name="eq_retry_count_host" descr="Host / Line Rx EQ or LT number of retries\;0 - no EQ/LT was performed\;1 - EQ/LT was performed once\;...\;255 - EQ/LT was performed.\;Note: for each DP reset, counter will restart.\;When EQ done successfully, Output valid should raise." access="RO" offset="0xC.0" size="0x0.8" />
	<field name="eq_retry_count_line" descr="Host / Line Rx EQ or LT number of retries\;0 - no EQ/LT was performed\;1 - EQ/LT was performed once\;...\;255 - EQ/LT was performed.\;Note: for each DP reset, counter will restart.\;When EQ done successfully, Output valid should raise." access="RO" offset="0xC.16" size="0x0.8" />
	<field name="fec_am_lock_host" descr="AM FEC host side locked\;Lane bit mask" access="RO" offset="0x10.0" size="0x0.8" />
	<field name="fec_am_lock_line" descr="AM FEC line side locked\;Lane bit mask" access="RO" offset="0x10.16" size="0x0.8" />
</node>

<node name="rtdpc_reg_ext" descr="" size="0x8.0" >
	<field name="line_width" descr="0: unmap datapath\;1: x1 \;2: x2 \;4: x4 \;8: x8" access="RW" offset="0x0.0" size="0x0.4" />
	<field name="host_width" descr="0x0 : unmap datapath\;0x1: x1 \;0x2: x2 \;0x4: x4 \;0x8: x8" access="RW" offset="0x0.5" size="0x0.4" />
	<field name="status" descr="0x0: done\;0x1: data_path_already_mapped - in order to map datapath, need to be unmapped first.\;0x2: width_missmatch - width does not align with RTCC configuration, lane_sel doesn&apos;t match widths \;0x3: lanes_already_in_use\;0x4: invalid_gearbox\;0x5: datapath_index_out_of_bound" access="RO" enum="done=0x0,data_path_already_mapped=0x1,width_missmatch=0x2,lanes_already_in_use=0x3,invalid_gearbox=0x4,datapath_index_out_of_bound=0x5" offset="0x0.10" size="0x0.4" />
	<field name="data_path" descr="Data path number" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="lane_sel" descr="select the associated lanes to the data path (bit mask)" access="RW" offset="0x4.0" size="0x0.8" />
</node>

<node name="rtedc_reg_ext" descr="" size="0x14.0" >
	<field name="lane_sel" descr="select which logical lane on the data path set/get. ignored when lane_br is set." access="INDEX" offset="0x0.0" size="0x0.3" />
	<field name="data_path" descr="Data Path Number" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="gain" descr="resistive part of the differential predriver degeneration circuit" access="RW" offset="0x4.0" size="0x0.4" />
	<field name="gain_ov" descr="gain override\;0 - gain will determined according to default production value\;1 - gain will be determined from gain field" access="WO" offset="0x4.29" size="0x0.1" />
	<field name="lane_br" descr="lane broadcast\;when set, lane index is ignored and set is done on all data path related lanes" access="WO" offset="0x4.30" size="0x0.1" />
	<field name="en" descr="EML driver enable:\;0: disable\;1: enable" access="RW" offset="0x4.31" size="0x0.1" />
	<field name="power_mode" descr="power mode state:\;0x00: functional state\;0x01: state 1\;0x02: state 2\;...\;...\;0xf: state 15" access="RO" offset="0x8.0" size="0x0.5" />
	<field name="cas_top" descr="Voltage at top of the EML driver cascode stack. Valid range is 2.05 to 2.25V\;value is in mV\;" access="RO" offset="0x8.16" size="0x0.16" />
</node>

<node name="rtfcr_reg_ext" descr="" size="0x8.0" >
	<field name="data_path" descr="data path number." access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="fec_admin" descr="FEC set for AM lock mechanism.\;lock mechanism will do best effort to lock on FEC AM configured.\;The specific FEC alignment markers will be based on the fec_admin field, oper speed and width stated in RTPTYS\;\;0: No_fec_set - AM FEC will not try to lock\;1: Double_KP4_FEC\;2: Quad_KP4_FEC\;3: Double_ELL_FEC\;\;Status on FEC AM can be aquired via RTCDE register in fec_am_lock fields.\;When oper_speed is not supported by fec_cap fields. fec_admin is ignored.\;\;Note that when RTPAOS is toggled, from active state to down, default fec will be restored to fec_admin field." access="RW" enum="No_fec_set=0x0,Double_KP4_FEC=0x1,Quad_KP4_FEC=0x2,Double_ELL_FEC=0x3" offset="0x4.0" size="0x0.8" />
	<field name="xdr_fec_cap" descr="capability for XDR speed AM FEC lock\;Bit 0: XDR_1x_double_KP4_FEC\;Bit 1: XDR_1x_double_ELL_FEC\;Bit 2: XDR_1x_quad_KP4_FEC\;Bit 3: XDR_2x_double_KP4_FEC\;Bit 4: XDR_2x_double_ELL_FEC" access="RO" enum="XDR_1x_double_KP4_FEC=0x1,XDR_1x_double_ELL_FEC=0x2,XDR_1x_quad_KP4_FEC=0x4,XDR_2x_double_KP4_FEC=0x8,XDR_2x_double_ELL_FEC=0x10" offset="0x4.16" size="0x0.8" />
</node>

<node name="rtltc_reg_ext" descr="" size="0xc.0" >
	<field name="lane_mask" descr="for set operation, lane bitmask.\;for query operation, one-hot key." access="INDEX" offset="0x0.0" size="0x0.8" />
	<field name="data_path" descr="Data path number" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="side_sel" descr="select which side of the data path to address (bit- mask):\;bit 0: Ingress\;bit 1: Egress" access="INDEX" enum="Ingress=0x1,Egress=0x2" offset="0x0.24" size="0x0.2" />
	<field name="physical_lanes" descr="when set, ignore data_path and address the lanes on lane_mask by their physical numbers" access="INDEX" offset="0x0.29" size="0x0.1" />
	<field name="precoding_write_en" descr="precoding write enable\;While this bit is set to &apos;0&apos;- ignore all the precoding admin fields" access="INDEX" offset="0x0.30" size="0x0.1" />
	<field name="polarity_write_en" descr="Polarity write enable\;While this bit is set to &apos;0&apos;- ignore all the polarity admin fields" access="INDEX" offset="0x0.31" size="0x0.1" />
	<field name="precoding_cap" descr="Data Path precoding capability\;0x0 - no precoding available / no override capability\;Bit 0- tx precoding override possible via tx_precoding_admin field\;Bit 1- rx precoding override possible via rx_precoding_admin field" access="RO" offset="0x4.0" size="0x0.2" />
	<field name="rx_precoding_admin" descr="Data Path Rx precoding configuration override:\;0- Rx precoding disabled.\;1- Rx precoding enabled.\;2 - Auto mode. precoding will be set by the FW" access="RW" offset="0x4.3" size="0x0.2" />
	<field name="rx_precoding_oper" descr="Data Path Rx precoding operational mode\;0- Rx precoding disabled.\;1- Rx precoding enabled." access="RO" offset="0x4.6" size="0x0.2" />
	<field name="polarity_cap" descr="Data Path polarity capability\;0x0 - no tx polarity available / no override capability\;Bit 0- tx polarity override possible via tx_polarity_admin field\;Bit 1- rx polarity override possible via rx_polarity_admin field" access="RO" offset="0x4.16" size="0x0.2" />
	<field name="rx_polarity_admin" descr="Data Path Rx polarity configuration override:\;0 - Rx polarity disabled.\;1 - Rx polarity enabled." access="RW" offset="0x4.19" size="0x0.2" />
	<field name="rx_polarity_oper" descr="Data Path Rx polarity operational mode\;0 - Rx polarity disabled.\;1 - Rx polarity enabled." access="RO" offset="0x4.22" size="0x0.2" />
	<field name="tx_precoding_admin" descr="Data Path Tx precoding configuration override:\;0- Tx precoding disabled.\;1- Tx precoding enabled.\;2 - Auto mode. precoding will be set by the FW" access="RW" offset="0x8.3" size="0x0.2" />
	<field name="tx_precoding_oper" descr="Data Path Tx precoding operational mode\;0- Tx precoding disabled.\;1- Tx precoding enabled." access="RO" offset="0x8.6" size="0x0.2" />
	<field name="tx_polarity_admin" descr="Data Path Tx polarity configuration override:\;0 - Tx polarity disabled.\;1 - Tx polarity enabled." access="RW" offset="0x8.19" size="0x0.2" />
	<field name="tx_polarity_oper" descr="Data Path Tx polarity operational mode\;0 - Tx polarity disabled.\;1 - Tx polarity enabled." access="RO" offset="0x8.22" size="0x0.2" />
</node>

<node name="rtpaos_reg_ext" descr="" size="0xc.0" >
	<field name="data_path" descr="Data Path number" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="eg_in_sep_cap" descr="When set, Egress and Ingress admin fields can be separated to different configurations.\;Else, ingress_state_admin and egress_state_admin must contain same value in case of full retimed.\;\;Ignored in case of half retimed datapath." access="RO" offset="0x4.0" size="0x0.1" />
	<field name="retrain" descr="Valid only when oper_state is in active state, ignored otherwise.When set, retrains receiver\;Bit 0: retrain_egress - Host Rx train\;Bit 1: retrain_ingress - Line Rx train" access="WO" offset="0x4.8" size="0x0.2" />
	<field name="sleep_en" descr="Enable sleep state:\;0: start state is polling\;1: start state will be sleep instead of polling" access="RW" offset="0x4.12" size="0x0.1" />
	<field name="sleep_cap" descr="Sleep capability:\;0: Sleep state is not supported\;1: Sleep state supported" access="RO" offset="0x4.14" size="0x0.1" />
	<field name="egress_state_oper" descr="read the current operation state of the  requested datapath (egress side)\;0 - Line TX is deactivated; Host RX is deactivated\;1 - Line TX is activated; Host RX is deactivated\;2 - Line TX is deactivated; Host RX is activated\;3 -Line TX is activated; Host RX is activated\;5 - Test mode\;6 - Line Tx and Host Rx are in transient closing state\;7 - Line Tx and Host Rx are in transient opening state" access="RO" offset="0x8.0" size="0x0.4" />
	<field name="egress_state_admin" descr="Set the desired state of the interface (egress side)\;0 - no change\;1 - Activation of both host and line path - Mission mode\;2 - Deactivation of both host and line path - &quot;Down&quot;\;5 - Test mode" access="RW" offset="0x8.6" size="0x0.4" />
	<field name="ingress_state_oper" descr="Read the current operation state of the requested datapath (ingress side)\;0 -Host Tx is deactivated; Line RX is deactivated\;1- Host Tx is activated; Line RX is deactivated\;2- Host Tx is deactivated; RX is activated\;3- Host Tx is activated; RX is activated\;5 -Test mode\;6 - Host Tx and Line Rx are in transient closing state\;7 - Host Tx and Line Rx are in transient opening state" access="RO" offset="0x8.12" size="0x0.4" />
	<field name="ingress_state_admin" descr="Set the the desired state of the requested datapath (ingress side)\;0 - no change\;1 - Activation of both host and line path - Mission mode\;2 - Deactivation of both host and line path - &quot;Down&quot;\;5- Test mode" access="RW" offset="0x8.18" size="0x0.4" />
</node>

<node name="rtpcnt_debug_counters_ext" descr="" size="0x40.0" >
	<field name="cdr_loss_lock_lane0_high" descr="Number of CDR loss of lock for lane 0 after DP reached RTPAOS active state.\;Counter will be reset count on every RTPAOS active state" access="RO" offset="0x0.0" size="0x4.0" />
	<field name="cdr_loss_lock_lane0_low" descr="Number of CDR loss of lock for lane 0 after DP reached RTPAOS active state.\;Counter will be reset count on every RTPAOS active state" access="RO" offset="0x4.0" size="0x4.0" />
	<field name="cdr_loss_lock_lane1_high" descr="Number of CDR loss of lock for lane 1 after DP reached RTPAOS active state.\;Counter will be reset count on every RTPAOS active state" access="RO" offset="0x8.0" size="0x4.0" />
	<field name="cdr_loss_lock_lane1_low" descr="Number of CDR loss of lock for lane 1 after DP reached RTPAOS active state.\;Counter will be reset count on every RTPAOS active state" access="RO" offset="0xC.0" size="0x4.0" />
	<field name="cdr_loss_lock_lane2_high" descr="Number of CDR loss of lock for lane 2 after DP reached RTPAOS active state.\;Counter will be reset count on every RTPAOS active state" access="RO" offset="0x10.0" size="0x4.0" />
	<field name="cdr_loss_lock_lane2_low" descr="Number of CDR loss of lock for lane 2 after DP reached RTPAOS active state.\;Counter will be reset count on every RTPAOS active state" access="RO" offset="0x14.0" size="0x4.0" />
	<field name="cdr_loss_lock_lane3_high" descr="Number of CDR loss of lock for lane 3 after DP reached RTPAOS active state.\;Counter will be reset count on every RTPAOS active state" access="RO" offset="0x18.0" size="0x4.0" />
	<field name="cdr_loss_lock_lane3_low" descr="Number of CDR loss of lock for lane 3 after DP reached RTPAOS active state.\;Counter will be reset count on every RTPAOS active state" access="RO" offset="0x1C.0" size="0x4.0" />
	<field name="cdr_loss_lock_lane4_high" descr="Number of CDR loss of lock for lane 4 after DP reached RTPAOS active state.\;Counter will be reset count on every RTPAOS active state" access="RO" offset="0x20.0" size="0x4.0" />
	<field name="cdr_loss_lock_lane4_low" descr="Number of CDR loss of lock for lane 4 after DP reached RTPAOS active state.\;Counter will be reset count on every RTPAOS active state" access="RO" offset="0x24.0" size="0x4.0" />
	<field name="cdr_loss_lock_lane5_high" descr="Number of CDR loss of lock for lane 5 after DP reached RTPAOS active state.\;Counter will be reset count on every RTPAOS active state" access="RO" offset="0x28.0" size="0x4.0" />
	<field name="cdr_loss_lock_lane5_low" descr="Number of CDR loss of lock for lane 5 after DP reached RTPAOS active state.\;Counter will be reset count on every RTPAOS active state" access="RO" offset="0x2C.0" size="0x4.0" />
	<field name="cdr_loss_lock_lane6_high" descr="Number of CDR loss of lock for lane 6 after DP reached RTPAOS active state.\;Counter will be reset count on every RTPAOS active state" access="RO" offset="0x30.0" size="0x4.0" />
	<field name="cdr_loss_lock_lane6_low" descr="Number of CDR loss of lock for lane 6 after DP reached RTPAOS active state.\;Counter will be reset count on every RTPAOS active state" access="RO" offset="0x34.0" size="0x4.0" />
	<field name="cdr_loss_lock_lane7_high" descr="Number of CDR loss of lock for lane 7 after DP reached RTPAOS active state.\;Counter will be reset count on every RTPAOS active state" access="RO" offset="0x38.0" size="0x4.0" />
	<field name="cdr_loss_lock_lane7_low" descr="Number of CDR loss of lock for lane 7 after DP reached RTPAOS active state.\;Counter will be reset count on every RTPAOS active state" access="RO" offset="0x3C.0" size="0x4.0" />
</node>

<node name="rtpcnt_reg_counter_set_auto_ext" descr="" attr_is_union="1" size="0xe0.0" >
	<field name="phy_error_cntrs_ext" descr="" subnode="phy_error_cntrs_ext" offset="0x0.0" selected_by="Physical_Layer_Error_Counters" size="0x64.0" />
	<field name="l1_general_counters_data_low_ext" descr="" subnode="l1_general_counters_data_low_ext" offset="0x0.0" selected_by="L1_General_counters_Data_Low" size="0xe0.0" />
	<field name="l1_general_counters_data_high_ext" descr="" subnode="l1_general_counters_data_high_ext" offset="0x0.0" selected_by="L1_General_counters_Data_High" size="0xe0.0" />
	<field name="histogram_counters_ext" descr="" subnode="histogram_counters_ext" offset="0x0.0" selected_by="FEC_Histogram_group" size="0x50.0" />
	<field name="rtpcnt_debug_counters_ext" descr="" subnode="rtpcnt_debug_counters_ext" offset="0x0.0" selected_by="Debug_counters" size="0x40.0" />
</node>

<node name="rtpcnt_reg_ext" descr="" size="0xe8.0" >
	<field name="grp" descr="performance counter group:\;0x0: Physical_Layer_Error_Counters\;0x1: L1_General_counters_Data_Low\;0x2: L1_General_counters_Data_High\;0x3: FEC_Histogram_group\;0x4: Debug_counters" access="INDEX" enum="Physical_Layer_Error_Counters=0x0,L1_General_counters_Data_Low=0x1,L1_General_counters_Data_High=0x2,FEC_Histogram_group=0x3,Debug_counters=0x4" offset="0x0.0" size="0x0.3" />
	<field name="data_path" descr="Data Path number" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="side_sel" descr="0x00: host side\;0x01: line side" access="INDEX" offset="0x0.24" size="0x0.1" />
	<field name="l1_grp_support" descr="0x0: L1_v1_support - L1 General counters\;0x1: L1_v2_support - L1 General counters v2\;0x2: L1_v1_and_v2_support\;0x3: no_L1_counters_support" access="RO" enum="L1_v1_support=0x0,L1_v2_support=0x1,L1_v1_and_v2_support=0x2,no_L1_counters_support=0x3" offset="0x4.0" size="0x0.2" />
	<field name="clr" descr="Clear counters. Setting the clr bit will reset the counter value for all counters in the counter group. This bit can be set for both Set() and Get() operation." access="OP" offset="0x4.31" size="0x0.1" />
	<field name="counter_set" descr="Table 1223, &quot;Physical Layer Error Counters Fields Layout,&quot; on page 1394\;Table 1225, &quot;L1 General Counters Data Low Layout,&quot; on page 1399\;Table 1227, &quot;L1 General Counters Data High Layout,&quot; on page 1403\;Table 1229, &quot;FEC Histogram counters Layout,&quot; on page 1407\;Table 1231, &quot;Debug Counters Layout,&quot; on page 1407" subnode="rtpcnt_reg_counter_set_auto_ext" access="RO" offset="0x8.0" size="0xe0.0" union_selector="$(parent).grp" />
</node>

<node name="rtpplr_reg_ext" descr="" size="0xc.0" >
	<field name="data_path" descr="Data Path number" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="sim_cap" descr="This bit-mask indicates if there is a capability for simultaneous loopbacks on both host and line side\;0: not supported\;1: supported \;\;Bit 0: Crossbar_loopbacks\;" access="RO" offset="0x4.0" size="0x0.3" />
	<field name="lb_cap" descr="Loopback application capability (bit-mask)\;bit 0: Crossbar_Line_loopback\;bit 1: Crossbar_Host_loopback\;\;" access="RO" offset="0x4.16" size="0x0.16" />
	<field name="lb_admin" descr="Set Loopback application (bit-mask)\;multiple loopback configuration (more than one bit set) needs to be allowed by sim_cap field, else get error config\;bit 0: Crossbar_Line_loopback\;bit 1: Crossbar_Host_loopback\;" access="RW" offset="0x8.0" size="0x0.16" />
	<field name="lb_oper" descr="Loopback operational mode (bit-mask)\;if the bit is &apos;1&apos; then the loopback is active\;bit 0: Crossbar_Line_loopback\;bit 1: Crossbar_Host_loopback\;" access="RO" offset="0x8.16" size="0x0.16" />
</node>

<node name="rtpprt_reg_ext" descr="" size="0x34.0" >
	<field name="le" descr="ignore if ls=0\;0: No per lane configuration, all PPTT configurations are taking place on all lanes of this data path.\;1: Per lane configurations, configurations are taking place per lane based on lane index.\;\;Relevant for set operation only." access="OP" offset="0x0.3" size="0x0.1" />
	<field name="ls" descr="Per Lane configuration support/capability:\;0: No support of per lane configuration\;1: Support of per lane configuration" access="RO" offset="0x0.4" size="0x0.1" />
	<field name="en" descr="Enable PRBS test mode:\;0: PRBS Rx is disabled.\;1: PRBS Rx is enabled." access="RW" offset="0x0.5" size="0x0.1" />
	<field name="en_mis" descr="Relevant only if en_mis_cap is set.\;When set, PRBS checker is enabled in mission mode datapath after the link is up.\;Valid fields that are configurable in mission mode:\;prbs_lock_status, prbs_mode_admin, prbs_hist_enable, msb_lsb_cnt.\;Other fields are ignored." access="RW" offset="0x0.6" size="0x0.1" />
	<field name="en_mis_cap" descr="When set, en_mis field is configurable" access="RO" offset="0x0.7" size="0x0.1" />
	<field name="data_path" descr="Data Path number" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="direction_sel" descr="Select data path side:\;bit 0: Host \;bit 1: Line" access="INDEX" enum="Host=0x1,Line=0x2" offset="0x0.24" size="0x0.2" />
	<field name="lane" descr="Reserved when (le=0 or ls = 0)\;Logical lane number to configure" access="INDEX" offset="0x0.26" size="0x0.4" />
	<field name="prbs_config_cap" descr="PRBS configuration capabilities (bit-mask)\;\;bit 0: polarity\; PRBS TX polarity - (NOT gate in PRBS) (not on the Physical Polarity)\;\;bit 1: MSB&lt;-&gt;LSB swap\;\;Bit 2: precoding cap\;\;bit 3: modulation\;0: NRZ modulation\;1: PAM4 modulation\;\;bit 4: gray codding \;0: unable\;1: able \;\;bit 5: PRBS histogram\;0: not supported\;1: supported\;\;Bit 6: physical polarity\;0: no physical polarity change supported\;1: physical polarity change supported\;\;Bit 7: MSB, LSB counter capability\;When cap is set, msb_lsb_cnt set is valid." access="RO" offset="0x4.0" size="0x0.8" />
	<field name="prbs_config_admin" descr="Set configuration for the PRBS (bit-mask)\;0: disable; 1:enable\;\;bit 0: polarity\; PRBS TX polarity - (NOT gate in PRBS) (not on the Physical Polarity)\;\;bit 1: MSB&lt;-&gt;LSB swap\;(relevant for PAM4 only)\;\;bit 2: precoding\;(relevant for PAM4 only)\;\;bit 3: modulation\;0: NRZ modulation\;1: PAM4 modulation\;\;bit 4: gray codding \;0: disable gray codding\;1: enable gray codding\;\;bit 5: prbs_hist_enable\;0: enable\;1: disable\;if hist_all_lanes is 0 see prbs_hist_lane_sel for lane selection, else histogram will run on all lanes under the datapath\;\;bit 6: start tuning\; start RX_tuning based on PRBS pattern\;Note: assuming peer transmitting PRBS.\;cannot be set when prbs_rx_tuning_status = 1 (during tuning)\;" access="RW" offset="0x4.11" size="0x0.8" />
	<field name="prbs_hist_fec_int" descr="Number of FEC interleave engines to simulate when counting PRBS histograms.\;Ignored when PRBS hist is disable (prbs_config_admin).\;0 - 1 FEC engine\;1 - 2 FEC engines interleaved\;2 - 4 FEC engines interleaved\;3 - 8 FEC engines interleaved\;Note: MSB bits are under prbs_hist_fec_int_msb to support more options. This field represents bit [0], need to combine both fields." access="RW" offset="0x4.22" size="0x0.1" />
	<field name="prbs_hist_res" descr="Indicates if PRBS Histogram resource is available.\;When bit is not set, and PRBS hist(prbs_config_admin) is set, failure status will return." access="RO" offset="0x4.23" size="0x0.1" />
	<field name="prbs_hist_lane_sel" descr="Lane selector for PRBS histograms.\;Valid only when PRBS hist is enable (prbs_config_admin)\;For datapaths with more than one lane, select which lane shall count the PRBS histograms.\;Note: Histograms are mapped to RS-FEC Histogram counters\;" access="RW" offset="0x4.24" size="0x0.4" />
	<field name="prbs_mode_cap" descr="PRBS modes capabilities (bit-mask)\;bit 0: PRBS 31 - x^31 + x^28 + 1 \;bit 1: PRBS 23A - x^23 + x^18 + 1 \;bit 2: PRBS 23B - x^23 + x^18 + x^12 + x^6 +1 \;bit 3: PRBS 23C - x^23 + x^22 + x^19 + x^18 +1 \;bit 4: PRBS 23D - x^23 + x^19 + x^18 + x^11 +1 \;bit 5: PRBS 7 - x^7  + x^6  + 1 \;bit 6: PRBS 11 - x^11 + x^9  + 1 \;bit 7: PRBS 11A - x^11 + x^10 + x^6 + x^5 + 1 \;bit 8: PRBS 11B - x^11 + x^9 + x^6 + x^5 + 1 \;bit 9: PRBS 11C - x^11 + x^8 + x^6 + x^4 + 1 \;bit 10: PRBS 11D - x^11 + x^7 + x^6 + x^4 + 1 \;bit 11: PRBS 9 - x^9  + x^5  + 1 \;bit 12: reserved\;bit 13: Square Wave 8 (8 ones, 8 zeros)\;bit 14:Square Wave 4 (4 ones, 4 zeros)\;bit 15: Square Wave 2 (2 ones, 2 zeros)\;bit 16: Square Wave 1 (one, zero)\;bit 17: PRBS 13A - x^13+x^12+x^2+x+1 \;bit 18: PRBS 13B - x^13+x^7+x^3+x^2+1 \;bit 19: PRBS 13C - x^13+x^8+x^4+x^2+1 \;bit 20: PRBS 13D - x^13+x^9+x^5+x^2+1\;bit 21: reserved\;bit 22: SSPRQ\;bit 23: reserved\;bit 24: PRBS 15 - x^15 +x^14 + 1\;bit 25: reserved\;bit 26: Square Wave 3\;bit 27: Square Wave 13\;bit 28: Square Wave 30" access="RO" offset="0x8.0" size="0x4.0" />
	<field name="prbs_mode_cap_ex" descr="Extended PRBS modes capabilities (bit-mask)\;bit 1: send ones" access="RO" offset="0xC.0" size="0x4.0" />
	<field name="prbs_mode_admin" descr="Select PRBS application\;same encoding as prbs_modes_cap and prbs_modes_cap_ex" access="RW" offset="0x10.0" size="0x0.7" />
	<field name="ph_p" descr="Rx physical polarity flip (p/n flip).\;Valid only if prbs_config_cap bit 6 is set.\;0 - according to ini\;1 - no physical rx polarity flip\;2 - flip physical rx polarity" access="RW" offset="0x10.16" size="0x0.2" />
	<field name="msb_lsb_cnt" descr="PRBS counter for PAM4 modulation links.\;0 - PRBS counter counts both MSB and LSB symbols in \;same counter\;1 - PRBS counter counts MSB symbol\;2 - PRBS counter counts LSB symbol\;PRBS counter is presented in RTPRNT.Physical_Layer_Error_Counter" access="RW" offset="0x10.18" size="0x0.2" />
	<field name="cont_count" descr="PRBS error counters continuous counts.\;0 - when counter reaches overflow, the counter stops\;1 - counter will count continuously.\;Note: counting continuously when HW is not available is not atomic and may suffer from small loss of counts\;" access="RW" offset="0x10.20" size="0x0.1" />
	<field name="hist_all_lanes_cap" descr="Device supports PRBS histogram on all lanes. If set ignore prbs_hist_lane_sel and will always activate histograms on all lanes under the datapath.\;0: not supported\;1: supported" access="RO" offset="0x10.21" size="0x0.1" />
	<field name="lane_rate_cap" descr="Rate capability for PRBS (bit-mask):\;Bit 0 - 1GE (1.25 Gb/s)Bit 1 - SDR (2.5 Gb/s)Bit 2 - XAUI/2.5GE (3.125 Gb/s)Bit 3- DDR (5 Gb/s)Bit 4- QDR (10 Gb/s)Bit 5- FDR10 / 10GE/40GE (10.3125 Gb/s)Bit 6- FDR (14.0625 Gb/s)Bit 7- EDR / 25GE / 50GE / 100GE (25.78125 Gb/s)Bit 8 - 50GE-KR4 (12.89 Gb/s)Bit 9 - HDR /50GE / 100GE / 200GE / 400GE (26.5625Gbd /53.125Gb/s)Bit 10 - NDR /100GE / 200GE / 400GE / 800GE (53.125 Gbd /106.25Gb/s)Bit 11 - XDR (106.25Gbd / 212.5Gb/s)" access="RO" offset="0x14.0" size="0x0.16" />
	<field name="auto_pol_rev_fix_cap" descr="When set, Auto polarity and reversal fix flow is possible.\;In order to set if flow is enabled or not, set auto_pol_rev_-\;fix_en field" access="RO" offset="0x14.31" size="0x0.1" />
	<field name="lane_rate_admin" descr="Set rate for PRBS\;Same encoding as in lane rate_cap" access="RW" offset="0x18.0" size="0x0.16" />
	<field name="auto_pol_rev_fix_en" descr="0 - Auto polarity and reversal fix flow will be skipped.\;Field is ignored if auto_pol_rev_fix_cap is not set\;1 - Auto polarity and reversal fix flow will be performed prior to tuning.\;\;Note:\;Auto polarity and reversal process requires sync between both sides. Hence, it is required to set auto_pol_rev_fix_en in both sides for it to work.\;Requires both Rx and Tx to be set and work on both sides.\;auto polarity will fix physical board polarity, but not PRBS polarity. in order to control PRBS polarity manually set &apos;p&apos; field." access="RW" offset="0x18.31" size="0x0.1" />
	<field name="prbs_lock_status" descr="lock on PRBS pattern status for all the data path lanes\;i.e: if the data path is x4, then only bit 0-3 are relevant and ignore 4-7.\;0: no lock\;1: lock acquired" access="RO" offset="0x1C.0" size="0x0.8" />
	<field name="prbs_tuning_status" descr="Tuning status:\;0: PRBS mode tuning was not performed.\;1: Performing PRBS mode tuning.\;2: PRBS mode tuning completed.\;3: Signal Detect in progress\;Note: Once exiting prbs test mode the prbs_rx_tuning_status will return to 0." access="RO" offset="0x1C.8" size="0x0.4" />
	<field name="prbs_hist_fec_int_msb" descr="Represents bits [2:1] of the prbs_hist_fec_int field, configuring the number of FEC interleave engines to simulate when counting PRBS histograms." access="RW" offset="0x20.0" size="0x0.2" />
	<field name="prbs_hist_fec_int_cap" descr="Number of simulated FEC interleave engines capability:\;0: 1 and 2 FEC engines interleaved\;1: 4 FEC engines interleaved\;2: 8 FEC engines interleaved" access="RO" offset="0x20.8" size="0x0.4" />
</node>

<node name="rtpptt_reg_ext" descr="" size="0x1c.0" >
	<field name="le" descr="ignore if ls=0\;0: No per lane configuration, all PPTT configurations are taking place on all lanes of this data path.\;1: Per lane configurations, configurations are taking place per lane based on lane index.\;\;Relevant for set operation only." access="OP" offset="0x0.3" size="0x0.1" />
	<field name="ls" descr="Per Lane configuration support/capability:\;0: No support of per lane configuration\;1: Support of per lane configuration" access="RO" offset="0x0.4" size="0x0.1" />
	<field name="en" descr="Enable PRBS test mode bit:\;0: PRBS Tx is disabled.\;1: PRBS Tx is enabled." access="RW" offset="0x0.5" size="0x0.1" />
	<field name="en_mis" descr="Relevant only if en_mis_cap is set.\;When set, PRBS generator is enabled in mission mode datapath after the DataPath is up state.\;Clock taken for generator is the recovered clock of the receiver mapped in the lane of the DataPath.\;Valid fields that are configurable in mission mode:\;prbs_config_admin, prbs_mode_admin\;Other fields are ignored.\;\;RTPAOS down will disable the feature." access="RW" offset="0x0.6" size="0x0.1" />
	<field name="en_mis_cap" descr="When set, en_mis field is configurable" access="RO" offset="0x0.7" size="0x0.1" />
	<field name="data_path" descr="Data Path number" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="direction_sel" descr="Select data path side:\;bit 0: Host side\;bit 1: Line side" access="INDEX" offset="0x0.24" size="0x0.2" />
	<field name="lane" descr="Reserved when (le=0 or ls = 0)\;Logical lane number to configure" access="INDEX" offset="0x0.26" size="0x0.4" />
	<field name="prbs_config_cap" descr="PRBS configuration capabilities (bit-mask)\;\;0: disable; 1:enable\;\;bit 0: polarity\; PRBS TX polarity - (NOT gate in PRBS) (not on the Physical Polarity)\;\;bit 1: MSB&lt;-&gt;LSB swap\;\;bit 2: precoding\;\;bit 3: modulation\;0: NRZ modulation\;1: PAM4 modulation\;\;bit 4: gray codding\;0: unable\;1: able\;\;bit 6: physical polarity\;0: no physical polarity change supported\;1: physical polarity change supported\;" access="RO" offset="0x4.0" size="0x0.7" />
	<field name="prbs_config_admin" descr="Set configuration for the PRBS (bit-mask)\;0: disable; 1:enable\;\;bit 0: polarity\; PRBS TX polarity - (NOT gate in PRBS) (not on the Physical Polarity)\;\;bit 1: MSB&lt;-&gt;LSB swap\;(relevant for PAM4 only)\;\;bit 2: precoding\;(relevant for PAM4 only)\;\;bit 3: modulation\;0: NRZ modulation\;1: PAM4 modulation\;\;bit 4: gray codding \;0: disable gray codding\;1: enable gray codding\;\;" access="RW" offset="0x4.11" size="0x0.7" />
	<field name="prbs_mode_cap" descr="PRBS modes capabilities (bit-mask)\;bit 0: PRBS 31 - x^31 + x^28 + 1 \;bit 1: PRBS 23A - x^23 + x^18 + 1 \;bit 2: PRBS 23B - x^23 + x^18 + x^12 + x^6 +1 \;bit 3: PRBS 23C - x^23 + x^22 + x^19 + x^18 +1 \;bit 4: PRBS 23D - x^23 + x^19 + x^18 + x^11 +1 \;bit 5: PRBS 7 - x^7  + x^6  + 1 \;bit 6: PRBS 11 - x^11 + x^9  + 1 \;bit 7: PRBS 11A - x^11 + x^10 + x^6 + x^5 + 1 \;bit 8: PRBS 11B - x^11 + x^9 + x^6 + x^5 + 1 \;bit 9: PRBS 11C - x^11 + x^8 + x^6 + x^4 + 1 \;bit 10: PRBS 11D - x^11 + x^7 + x^6 + x^4 + 1 \;bit 11: PRBS 9 - x^9  + x^5  + 1 \;bit 12: reserved\;bit 13: Square Wave 8 (8 ones, 8 zeros)\;bit 14:Square Wave 4 (4 ones, 4 zeros)\;bit 15: Square Wave 2 (2 ones, 2 zeros)\;bit 16: Square Wave 1 (one, zero)\;bit 17: PRBS 13A - x^13+x^12+x^2+x+1 \;bit 18: PRBS 13B - x^13+x^7+x^3+x^2+1 \;bit 19: PRBS 13C - x^13+x^8+x^4+x^2+1 \;bit 20: PRBS 13D - x^13+x^9+x^5+x^2+1\;bit 21: reserved\;bit 22: SSPRQ\;bit 23: reserved\;bit 24: PRBS 15 - x^15 +x^14 + 1\;bit 25: reserved\;bit 26: Square Wave 3\;bit 27: Square Wave 13\;bit 28: Square Wave 30" access="RO" offset="0x8.0" size="0x4.0" />
	<field name="prbs_mode_cap_ex" descr="Extended PRBS modes capabilities (bit-mask)\;bit 1: send ones" access="RO" offset="0xC.0" size="0x4.0" />
	<field name="prbs_mode_admin" descr="Select PRBS application\;same encoding as prbs_modes_cap and prbs_modes_cap_ex" access="RW" offset="0x10.0" size="0x0.7" />
	<field name="ph_p" descr="Tx physical polarity flip (p/n flip).\;Valid only if prbs_config_cap bit 6 is set.\;0 - according to ini\;1 - no physical tx polarity flip\;2 - flip physical tx polarity" access="RW" offset="0x10.16" size="0x0.2" />
	<field name="lane_rate_cap" descr="Rate capability for PRBS (bit-mask):\;Bit 0 - 1GE (1.25 Gb/s)Bit 1 - SDR (2.5 Gb/s)Bit 2 - XAUI/2.5GE (3.125 Gb/s)Bit 3- DDR (5 Gb/s)Bit 4- QDR (10 Gb/s)Bit 5- FDR10 / 10GE/40GE (10.3125 Gb/s)Bit 6- FDR (14.0625 Gb/s)Bit 7- EDR / 25GE / 50GE / 100GE (25.78125 Gb/s)Bit 8 - 50GE-KR4 (12.89 Gb/s)Bit 9 - HDR /50GE / 100GE / 200GE / 400GE (26.5625Gbd /53.125Gb/s)Bit 10 - NDR /100GE / 200GE / 400GE / 800GE (53.125 Gbd /106.25Gb/s)Bit 11 - XDR (106.25Gbd / 212.5Gb/s)" access="RO" offset="0x14.0" size="0x0.16" />
	<field name="lane_rate_admin" descr="Set rate for PRBS\;Same encoding as in lane rate_cap" access="RW" offset="0x18.0" size="0x0.16" />
</node>

<node name="rtpsl_l1_configuration_ext" descr="" size="0x10.0" >
	<field name="write_en" descr="unless this bit is set to &apos;1&apos; no data can be written to the fields below (use for setting l1_en only):\;0x0: disable\;0x1: enable" access="RW" offset="0x0.0" size="0x0.1" />
	<field name="op_dr_comp" descr="optical driver L1 compliant mode:\;0 - Auto\;1 - L1 parameters will be adjusted for compliant optical driver\;2 - L1 parameters will be adjusted for participating optical driver" access="RW" offset="0x0.4" size="0x0.2" />
	<field name="l1_oper" descr="0: L1 is Disabled\;1: L1 is Active" access="RO" offset="0x0.30" size="0x0.1" />
	<field name="l1_en" descr="enable L1 feature:\;0x0: disable\;0x1: enable" access="RW" offset="0x0.31" size="0x0.1" />
	<field name="l1_peq_recal_period_cap" descr="The time gap between two consecutive periodic recalibration periods.\;Represents min between host tx/rx and line tx/rx side requirements\; 1024 nano sec resolution." access="RO" offset="0x4.0" size="0x0.16" />
	<field name="l1_min_linkup_time_cap" descr="This timer represents the minimum time required to stay in the Linkup state after the local port exits from the L1 state and before it can enter the L1 state again. \;Represents max between host and line side requirements.\;The timer is in 1024 nano sec resolution." access="RO" offset="0x4.16" size="0x0.16" />
	<field name="l1_peq_recal_duration_cap" descr="The time for a single PEQ duration capability. \;Represents max between host tx/rx and line tx/rx side requirements\;1024 nano sec resolution." access="RO" offset="0x8.0" size="0x0.16" />
	<field name="l1_peq_recal_period_admin" descr="The time gap between two consecutive periodic recalibration periods\; 1024 nano sec resolution." access="RW" offset="0xC.0" size="0x0.16" />
</node>

<node name="rtpsl_l1_debug_ext" descr="" size="0x24.0" >
	<field name="l1_fsm_stat_h0" descr="L1 state machine\;0x0: FORWARD_DATA\;0x1: PROPAGATE\;0x2: QUIET_ENTRY\;0x3: QUIET\;0x4: POKE\;0x5: WAKE\;0x6: WAIT_ANNONCE\;0x7: WAIT_DATA\;0x8 ENABLE_CDR\;0x9: WAIT_CDR\;0xA: RESET_CDR\;0xB: WAIT_CDR_RESET\;0xC: PWD_PROPAGATE\;0xD: DISABLED" access="RO" offset="0x0.0" size="0x0.4" />
	<field name="l1_fsm_stat_h1" descr="L1 state machine\;0x0: FORWARD_DATA\;0x1: PROPAGATE\;0x2: QUIET_ENTRY\;0x3: QUIET\;0x4: POKE\;0x5: WAKE\;0x6: WAIT_ANNONCE\;0x7: WAIT_DATA\;0x8 ENABLE_CDR\;0x9: WAIT_CDR\;0xA: RESET_CDR\;0xB: WAIT_CDR_RESET\;0xC: PWD_PROPAGATE\;0xD: DISABLED" access="RO" offset="0x0.4" size="0x0.4" />
	<field name="l1_fsm_stat_h2" descr="L1 state machine\;0x0: FORWARD_DATA\;0x1: PROPAGATE\;0x2: QUIET_ENTRY\;0x3: QUIET\;0x4: POKE\;0x5: WAKE\;0x6: WAIT_ANNONCE\;0x7: WAIT_DATA\;0x8 ENABLE_CDR\;0x9: WAIT_CDR\;0xA: RESET_CDR\;0xB: WAIT_CDR_RESET\;0xC: PWD_PROPAGATE\;0xD: DISABLED" access="RO" offset="0x0.8" size="0x0.4" />
	<field name="l1_fsm_stat_h3" descr="L1 state machine\;0x0: FORWARD_DATA\;0x1: PROPAGATE\;0x2: QUIET_ENTRY\;0x3: QUIET\;0x4: POKE\;0x5: WAKE\;0x6: WAIT_ANNONCE\;0x7: WAIT_DATA\;0x8 ENABLE_CDR\;0x9: WAIT_CDR\;0xA: RESET_CDR\;0xB: WAIT_CDR_RESET\;0xC: PWD_PROPAGATE\;0xD: DISABLED" access="RO" offset="0x0.12" size="0x0.4" />
	<field name="l1_fsm_stat_h4" descr="L1 state machine\;0x0: FORWARD_DATA\;0x1: PROPAGATE\;0x2: QUIET_ENTRY\;0x3: QUIET\;0x4: POKE\;0x5: WAKE\;0x6: WAIT_ANNONCE\;0x7: WAIT_DATA\;0x8 ENABLE_CDR\;0x9: WAIT_CDR\;0xA: RESET_CDR\;0xB: WAIT_CDR_RESET\;0xC: PWD_PROPAGATE\;0xD: DISABLED" access="RO" offset="0x0.16" size="0x0.4" />
	<field name="l1_fsm_stat_h5" descr="L1 state machine\;0x0: FORWARD_DATA\;0x1: PROPAGATE\;0x2: QUIET_ENTRY\;0x3: QUIET\;0x4: POKE\;0x5: WAKE\;0x6: WAIT_ANNONCE\;0x7: WAIT_DATA\;0x8 ENABLE_CDR\;0x9: WAIT_CDR\;0xA: RESET_CDR\;0xB: WAIT_CDR_RESET\;0xC: PWD_PROPAGATE\;0xD: DISABLED" access="RO" offset="0x0.20" size="0x0.4" />
	<field name="l1_fsm_stat_h6" descr="L1 state machine\;0x0: FORWARD_DATA\;0x1: PROPAGATE\;0x2: QUIET_ENTRY\;0x3: QUIET\;0x4: POKE\;0x5: WAKE\;0x6: WAIT_ANNONCE\;0x7: WAIT_DATA\;0x8 ENABLE_CDR\;0x9: WAIT_CDR\;0xA: RESET_CDR\;0xB: WAIT_CDR_RESET\;0xC: PWD_PROPAGATE\;0xD: DISABLED" access="RO" offset="0x0.24" size="0x0.4" />
	<field name="l1_fsm_stat_h7" descr="L1 state machine\;0x0: FORWARD_DATA\;0x1: PROPAGATE\;0x2: QUIET_ENTRY\;0x3: QUIET\;0x4: POKE\;0x5: WAKE\;0x6: WAIT_ANNONCE\;0x7: WAIT_DATA\;0x8 ENABLE_CDR\;0x9: WAIT_CDR\;0xA: RESET_CDR\;0xB: WAIT_CDR_RESET\;0xC: PWD_PROPAGATE\;0xD: DISABLED" access="RO" enum="FORWARD_DATA=0x0,PROPAGATE=0x1,QUIET_ENTRY=0x2,QUIET=0x3,POKE=0x4,WAKE=0x5,WAIT_ANNONCE=0x6,WAIT_DATA=0x7,WAIT_CDR=0x9,RESET_CDR=0xa,WAIT_CDR_RESET=0xb,PWD_PROPAGATE=0xc,DISABLED=0xd" offset="0x0.28" size="0x0.4" />
	<field name="l1_fsm_stat_l0" descr="L1 state machine\;0x0: FORWARD_DATA\;0x1: PROPAGATE\;0x2: QUIET_ENTRY\;0x3: QUIET\;0x4: POKE\;0x5: WAKE\;0x6: WAIT_ANNONCE\;0x7: WAIT_DATA\;0x8 ENABLE_CDR\;0x9: WAIT_CDR\;0xA: RESET_CDR\;0xB: WAIT_CDR_RESET\;0xC: PWD_PROPAGATE\;0xD: DISABLED" access="RO" offset="0x4.0" size="0x0.4" />
	<field name="l1_fsm_stat_l1" descr="L1 state machine\;0x0: FORWARD_DATA\;0x1: PROPAGATE\;0x2: QUIET_ENTRY\;0x3: QUIET\;0x4: POKE\;0x5: WAKE\;0x6: WAIT_ANNONCE\;0x7: WAIT_DATA\;0x8 ENABLE_CDR\;0x9: WAIT_CDR\;0xA: RESET_CDR\;0xB: WAIT_CDR_RESET\;0xC: PWD_PROPAGATE\;0xD: DISABLED" access="RO" offset="0x4.4" size="0x0.4" />
	<field name="l1_fsm_stat_l2" descr="L1 state machine\;0x0: FORWARD_DATA\;0x1: PROPAGATE\;0x2: QUIET_ENTRY\;0x3: QUIET\;0x4: POKE\;0x5: WAKE\;0x6: WAIT_ANNONCE\;0x7: WAIT_DATA\;0x8 ENABLE_CDR\;0x9: WAIT_CDR\;0xA: RESET_CDR\;0xB: WAIT_CDR_RESET\;0xC: PWD_PROPAGATE\;0xD: DISABLED" access="RO" offset="0x4.8" size="0x0.4" />
	<field name="l1_fsm_stat_l3" descr="L1 state machine\;0x0: FORWARD_DATA\;0x1: PROPAGATE\;0x2: QUIET_ENTRY\;0x3: QUIET\;0x4: POKE\;0x5: WAKE\;0x6: WAIT_ANNONCE\;0x7: WAIT_DATA\;0x8 ENABLE_CDR\;0x9: WAIT_CDR\;0xA: RESET_CDR\;0xB: WAIT_CDR_RESET\;0xC: PWD_PROPAGATE\;0xD: DISABLED" access="RO" offset="0x4.12" size="0x0.4" />
	<field name="l1_fsm_stat_l4" descr="L1 state machine\;0x0: FORWARD_DATA\;0x1: PROPAGATE\;0x2: QUIET_ENTRY\;0x3: QUIET\;0x4: POKE\;0x5: WAKE\;0x6: WAIT_ANNONCE\;0x7: WAIT_DATA\;0x8 ENABLE_CDR\;0x9: WAIT_CDR\;0xA: RESET_CDR\;0xB: WAIT_CDR_RESET\;0xC: PWD_PROPAGATE\;0xD: DISABLED" access="RO" offset="0x4.16" size="0x0.4" />
	<field name="l1_fsm_stat_l5" descr="L1 state machine\;0x0: FORWARD_DATA\;0x1: PROPAGATE\;0x2: QUIET_ENTRY\;0x3: QUIET\;0x4: POKE\;0x5: WAKE\;0x6: WAIT_ANNONCE\;0x7: WAIT_DATA\;0x8 ENABLE_CDR\;0x9: WAIT_CDR\;0xA: RESET_CDR\;0xB: WAIT_CDR_RESET\;0xC: PWD_PROPAGATE\;0xD: DISABLED" access="RO" offset="0x4.20" size="0x0.4" />
	<field name="l1_fsm_stat_l6" descr="L1 state machine\;0x0: FORWARD_DATA\;0x1: PROPAGATE\;0x2: QUIET_ENTRY\;0x3: QUIET\;0x4: POKE\;0x5: WAKE\;0x6: WAIT_ANNONCE\;0x7: WAIT_DATA\;0x8 ENABLE_CDR\;0x9: WAIT_CDR\;0xA: RESET_CDR\;0xB: WAIT_CDR_RESET\;0xC: PWD_PROPAGATE\;0xD: DISABLED" access="RO" offset="0x4.24" size="0x0.4" />
	<field name="l1_fsm_stat_l7" descr="L1 state machine\;0x0: FORWARD_DATA\;0x1: PROPAGATE\;0x2: QUIET_ENTRY\;0x3: QUIET\;0x4: POKE\;0x5: WAKE\;0x6: WAIT_ANNONCE\;0x7: WAIT_DATA\;0x8 ENABLE_CDR\;0x9: WAIT_CDR\;0xA: RESET_CDR\;0xB: WAIT_CDR_RESET\;0xC: PWD_PROPAGATE\;0xD: DISABLED" access="RO" offset="0x4.28" size="0x0.4" />
	<field name="announce_check_delay" descr="delay before checking for announce after detecting poke.\;64 nanosecond granularity." access="RO" offset="0x8.0" size="0x0.8" />
	<field name="propagation_delay" descr="delay before entering L1 after pattern is detected.\;64 nanosecond granularity." access="RO" offset="0x8.8" size="0x0.8" />
	<field name="pattern_sync_limit" descr="number of pattern sync frame matches to enter L1" access="RO" offset="0x8.16" size="0x0.8" />
	<field name="min_time_to_send_announce" descr="the minimum time that TX will send announce before sending high speed data. \;64 nanosecond granularity." access="RO" offset="0x8.24" size="0x0.8" />
	<field name="shutdown_propagation_delay" descr="Set the delay before shutting down the lane after pattern is detected\;64 nanosecond granularity." access="RO" offset="0xC.0" size="0x0.8" />
	<field name="cdr_lock_delay" descr="Allows for extra delay to be added before frac_n clock control loop starts locking" access="RO" offset="0xC.8" size="0x0.8" />
	<field name="l1_idle_status_annonce_limit" descr="Set number of cycle the idle status must be unset to be considred detected annonce pattern" access="RO" offset="0xC.16" size="0x0.8" />
	<field name="l1_idle_status_poke_limit" descr="Set number of cycle the idle status must be unset to be considered detected poke" access="RO" offset="0xC.24" size="0x0.8" />
	<field name="pattern_to_check" descr="configure the pattern to check" access="RO" offset="0x10.0" size="0x4.0" />
	<field name="cause_go_quit_host" descr="causes are lane bit-mask" access="RO" offset="0x14.0" size="0x0.8" />
	<field name="cause_go_quit_line" descr="causes are lane bit-mask" access="RO" offset="0x14.16" size="0x0.8" />
	<field name="cause_wake_host" descr="causes are lane bit-mask" access="RO" offset="0x18.0" size="0x0.8" />
	<field name="cause_wake_line" descr="causes are lane bit-mask" access="RO" offset="0x18.16" size="0x0.8" />
	<field name="cause_powergov_timeout_host" descr="causes are lane bit-mask" access="RO" offset="0x1C.0" size="0x0.8" />
	<field name="cause_powergov_timeout_line" descr="causes are lane bit-mask" access="RO" offset="0x1C.16" size="0x0.8" />
</node>

<node name="rtpsl_reg_ext" descr="" size="0x2c.0" >
	<field name="l1_cap" descr="L1 capability per speed\;Bit 0: xdr_l1_supported" access="RO" offset="0x0.0" size="0x0.4" />
	<field name="data_path" descr="data path number" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="page_sel" descr="page select:\;0x0: L1_Configurations\;0x1: L1_Debug" access="INDEX" enum="L1_Configurations=0x0,L1_Debug=0x1" offset="0x4.0" size="0x0.5" />
	<field name="page_data" descr="Table 1187, &quot;RTPSL - L1 Configurations Layout,&quot; on page 1348\;Table 1189, &quot;RTPSL - L1 Debug Layout,&quot; on page 1349" subnode="rtpsl_reg_page_data_auto_ext" access="RW" offset="0x8.0" size="0x24.0" union_selector="$(parent).page_sel" />
</node>

<node name="rtpsl_reg_page_data_auto_ext" descr="" attr_is_union="1" size="0x24.0" >
	<field name="rtpsl_l1_configuration_ext" descr="" subnode="rtpsl_l1_configuration_ext" offset="0x0.0" selected_by="L1_Configurations" size="0x10.0" />
	<field name="rtpsl_l1_debug_ext" descr="" subnode="rtpsl_l1_debug_ext" offset="0x0.0" selected_by="L1_Debug" size="0x24.0" />
</node>

<node name="rtptpr_reg_ext" descr="" size="0xc.0" >
	<field name="board_media_type" descr="Indication for the kind of medium for the data.\;For on board retimer\;0: C2C short\;1: C2C long \;2: C2M \;3: Backplane\;4: Passive_copper\;5: Optical_Media" access="RW" offset="0x0.0" size="0x0.3" />
	<field name="transceiver_media_type" descr="Indication for the kind of media medium (including peer side)\;For retimed transceiver \;0x0: C2M_short\;0x1: C2M_long\;0x2: Copper_retimed\;0x3: Optical_retimed\;0x4: Optical_Did" access="RW" enum="C2M_short=0x0,C2M_long=0x1,Copper_retimed=0x2,Optical_retimed=0x3,Optical_Did=0x4" offset="0x0.5" size="0x0.3" />
	<field name="laser_tec" descr="indicate the output optical technology on the current module\;0x0: N/A\;0x1: Vcsel\;0x2: EML\;0x3: Sip" access="RW" enum="N_A=0x0,Vcsel=0x1,EML=0x2,Sip=0x3" offset="0x0.9" size="0x0.2" />
	<field name="data_path" descr="Data Path number" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="side_sel" descr="select data path side \;0: host side\;1: line side" access="INDEX" offset="0x0.24" size="0x0.1" />
	<field name="attenuation_12g" descr="Attenuation - total channel attenuation @ 12GHz in db.\;A 0 value implies that attenuation_5g is used also for 12GHz" access="RW" offset="0x4.0" size="0x0.8" />
	<field name="attenuation_7g" descr="Attenuation - total channel attenuation @ 7GHz in db.\;A 0 value implies that attenuation_5g is used also for 7GHz" access="RW" offset="0x4.10" size="0x0.8" />
	<field name="attenuation_5g" descr="Attenuation - total channel attenuation @ 5GHz in db." access="RW" offset="0x4.20" size="0x0.8" />
	<field name="attenuation_53g" descr="Attenuation - total channel attenuation @ 53GHz in db.\;A 0 value implies that attenuation_5g is used also for 53GHz" access="RW" offset="0x8.10" size="0x0.8" />
	<field name="attenuation_25g" descr="Attenuation - total channel attenuation @ 25GHz in db.\;A 0 value implies that attenuation_5g is used also for 25GHz" access="RW" offset="0x8.20" size="0x0.8" />
</node>

<node name="rtptys_reg_ext" descr="" size="0x24.0" >
	<field name="data_path" descr="Data Path number" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="side_sel" descr="select which side of the data path to address (bit- mask):\;bit 0: Ingress\;bit 1: Egress" access="INDEX" enum="Ingress=0x1,Egress=0x2" offset="0x0.24" size="0x0.2" />
	<field name="lt_cap_xdr" descr="Link Training Capability (For 200GB/s only) (bit-mask)\;bit 0: host side\;bit 1: line side" access="RO" offset="0x4.0" size="0x0.2" />
	<field name="lt_en" descr="Link Training enable (bit-mask)\;bit 0: enable host side LT\;bit 1: enable line side LT\;ignore if the capability bit is 0." access="RW" offset="0x4.3" size="0x0.2" />
	<field name="operation_mode" descr="select operation mode:\;0x0: Firmware_autonomous\;The received command may trigger FW state machines and will execute additional commands. (will be used for operational mode)\;0x1: command_explicit\;The Retimer will execute only the received command. (will be used for debugging)" access="RW" enum="command_explicit=0x1" offset="0x4.14" size="0x0.1" />
	<field name="gb_rtm_sel" descr="Select operational mode\;0: No_Change\;1:Gearbox - ignore Retimer fields\;2: Retimer - ignore Gearbox fields" access="INDEX" enum="No_Change=0x0,Gearbox=0x1,Retimer=0x2" offset="0x4.16" size="0x0.2" />
	<field name="rtm_app_capability" descr="Retimer application supported (bit-mask):\;Bit 0: 1x_312.5_Mhz\;Bit 1: 2x_312.5_Mhz\;Bit 2: 4x_312.5_Mhz\;Bit 3: 8x_312.5_Mhz\;Bit 4: 1x_2.5Gb/s - (SDR port rate)\;Bit 5: 2x_2.5Gb/s - (SDR port rate)\;Bit 6: 4x_2.5Gb/s - (SDR port rate)\;Bit 7: 8x_2.5Gb/s - (SDR port rate)\;Bit 8: 1x_25.87125Gb/s - (25GE, EDR port rate)\;Bit 9: 2x_25.87125Gb/s - (25GE, EDR port rate)\;Bit 10: 4x_25.87125Gb/s - (25GE, EDR port rate)\;Bit 11: 8x_25.87125Gb/s - (25GE, EDR port rate)\;Bit 12: 1x_53.125Gb/s - 26.5625Gbd (50GE, HDR port rate)\;Bit 13: 2x_53.125Gb/s - 26.5625Gbd (50GE, HDR port rate)\;Bit 14: 4x_53.125Gb/s - 26.5625Gbd (50GE, HDR port rate)\;Bit 15: 8x_53.125Gb/s - 26.5625Gbd (50GE, HDR port rate)\;Bit 16: 1x_106.25Gb/s - 53.125Gbd (100GE, NDR port rate)\;Bit 17: 2x_106.25Gb/s - 53.125Gbd (100GE, NDR port rate)\;Bit 18: 4x_106.25Gb/s - 53.125Gbd (100GE, NDR port rate)\;Bit 19: 8x_106.25Gb/s - 53.125Gbd (100GE, NDR port rate)\;Bit 20: 1x_212.5Gb/s - 106.25Gbd (200GE, XDR port rate)\;Bit 21: 2x_212.5Gb/s - 106.25Gbd (200GE, XDR port rate)\;Bit 22: 4x_212.5Gb/s - 106.25Gbd (200GE, XDR port rate)\;Bit 23: 8x_212.5Gb/s - 106.25Gbd (200GE, XDR port rate)\;Bit 24: 1x_detection\;Bit 25: 2x_detection\;Bit 26: 4x_detection\;Bit 27: 8x_detection\;\;Note: the application indicate the rate per lane, and the amount of lanes. For example: 200G_4x is 800G on 4 lanes" access="RO" offset="0x8.0" size="0x4.0" />
	<field name="gb_app_capability" descr="Gearbox application supported (bit-mask)\;bit 0: GB_APP0: 1x200G &lt;-&gt; 2x100G" access="RO" offset="0x10.0" size="0x4.0" />
	<field name="rtm_app_admin" descr="Set the app of the datapath\;Same encoding as capability fields" access="RW" offset="0x14.0" size="0x4.0" />
	<field name="gb_app_admin" descr="Set the requested gearbox application for the datapath\;Same encoding as capability fields" access="RW" offset="0x18.0" size="0x4.0" />
	<field name="rtm_app_oper" descr="Read the current app of the datapath\;Same encoding as capability fields\;ignore if side_sel==0x3" access="RO" offset="0x1C.0" size="0x4.0" />
	<field name="gb_app_oper" descr="Read the current app of the datapath\;Same encoding as capability fields\;ignore if side_sel==0x3" access="RO" offset="0x20.0" size="0x4.0" />
</node>

<node name="rtsfc_reg_ext" descr="" size="0x20.0" >
	<field name="sfec_200g_cap" descr="Set when 200G per lane speed SFEC is supported" access="RO" offset="0x0.0" size="0x0.1" />
	<field name="data_path" descr="Data Path number" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="side_sel" descr="Select which side of the data path to address (bit- mask):\;bit 0: host_side\;bit 1: line_side" access="INDEX" enum="host_side=0x1,line_side=0x2" offset="0x0.24" size="0x0.2" />
	<field name="rxtx" descr="For set operation, side bitmask:\;bit 0: rx side\;bit 1: tx side\;for query operation, one-hot key (only one of them can be set)." access="INDEX" offset="0x0.30" size="0x0.2" />
	<field name="page_sel" descr="page select:\;0x00: SFEC_Configurations\;0x01: SFEC_Rx_Debug\;0x02: SFEC_Tx_Debug" access="INDEX" enum="SFEC_Configurations=0x0,SFEC_Rx_Debug=0x1,SFEC_Tx_Debug=0x2" offset="0x4.0" size="0x0.5" />
	<field name="page_data" descr="Table 1199, &quot;SFEC Configuration Layout,&quot; on page 1362\;Table 1201, &quot;SFEC Rx Debug Layout,&quot; on page 1363\;Table 1203, &quot;SFEC Tx Debug Layout,&quot; on page 1365" subnode="rtsfc_reg_page_data_auto_ext" access="RW" offset="0x8.0" size="0x18.0" union_selector="$(parent).page_sel" />
</node>

<node name="rtsfc_reg_page_data_auto_ext" descr="" attr_is_union="1" size="0x18.0" >
	<field name="rtsfc_sfec_configuration_ext" descr="" subnode="rtsfc_sfec_configuration_ext" offset="0x0.0" selected_by="SFEC_Configurations" size="0x8.0" />
	<field name="rtsfc_sfec_rx_debug_ext" descr="" subnode="rtsfc_sfec_rx_debug_ext" offset="0x0.0" selected_by="SFEC_Rx_Debug" size="0x18.0" />
	<field name="rtsfc_sfec_tx_debug_ext" descr="" subnode="rtsfc_sfec_tx_debug_ext" offset="0x0.0" selected_by="SFEC_Tx_Debug" size="0x8.0" />
</node>

<node name="rtsfc_sfec_configuration_ext" descr="" size="0x8.0" >
	<field name="decoding_type_cap" descr="Decoding type capability bit-mask\;Bit 0: soft decoding (SD FEC)\;Bit 1: hard decoding (HD FEC)" access="RO" offset="0x0.0" size="0x0.2" />
	<field name="decoding_type_admin" descr="set decoding type option:\;0x00: soft decoding (SD FEC)\;0x01: hard decoding (HD FEC)" access="RW" offset="0x0.5" size="0x0.2" />
	<field name="ham_inter_size_cap" descr="hamming interleaver size capability bit-mask:\;Bit 0: 1 way interleaver\;Bit 1: 8 ways interleaver" access="RO" offset="0x0.10" size="0x0.2" />
	<field name="ham_inter_size_admin" descr="set hamming interleaver size:\;0x00: 1 way interleaver\;0x01: 8 ways interleaver" access="RW" offset="0x0.15" size="0x0.2" />
	<field name="padding_blocks_cap" descr="padding block capability bit-mask:\;Bit 0: X2 code word size pad (2178 data blocks)\;Bit 1: X8 code word size pad (8712 data blocks)" access="RO" offset="0x0.20" size="0x0.2" />
	<field name="padding_blocks_admin" descr="set padding block option:\;0x01: X2 code word size pad (2178 data blocks)\;0x02: X8 code word size pad (8712 data blocks)" access="RW" offset="0x0.25" size="0x0.2" />
	<field name="en" descr="enable bit. once set to &apos;1&apos; SFEC engine is enabled" access="RW" offset="0x0.31" size="0x0.1" />
	<field name="align_ok" descr="Assert when SFEC alignment lock error rate below threshold." access="RO" offset="0x4.31" size="0x0.1" />
</node>

<node name="rtsfc_sfec_rx_debug_ext" descr="" size="0x18.0" >
	<field name="pll_ui_shift_cnt" descr="Number of PLL ui shift count in total (backward and forward)" access="RO" offset="0x0.0" size="0x0.10" />
	<field name="sfec_align_lock_state" descr="return the status of the SFEC align lock FSM:\;0x00: ALIGN_LOCK_IDLE\;0x01: ALIGN_CHK_RST_EN\;0x02: ALIGN_CHK_RST_DIS\;0x03: WAIT_ALIGN_CHK_END\;0x04: PLL_UI_SHIFT_ADD_EN\;0x05: PLL_UI_SHIFT_ADD_EN_EXT\;0x06: PLL_UI_SHIFT_ADD_DIS\;0x07: PLL_UI_SHIFT_MINUS_EN\;0x08: PLL_UI_SHIFT_MINUS_EN_EXT\;0x09: PLL_UI_SHIFT_MINUS_EN_PRE\;0x0A: PLL_UI_SHIFT_MINUS_EN_2PRE\;0x0B: PLL_UI_SHIFT_MINUS_EN_POST\;0x0C: PLL_UI_SHIFT_MINUS_EN_2POST\;0x0D: PLL_UI_SHIFT_MINUS_DIS\;0x0E: ALIGN_LOCK_OK\;0x0F: ALIGN_LOCK_FAIL" access="RO" enum="ALIGN_LOCK_IDLE=0x0,ALIGN_CHK_RST_EN=0x1,ALIGN_CHK_RST_DIS=0x2,WAIT_ALIGN_CHK_END=0x3,PLL_UI_SHIFT_ADD_EN=0x4,PLL_UI_SHIFT_ADD_EN_EXT=0x5,PLL_UI_SHIFT_ADD_DIS=0x6,PLL_UI_SHIFT_MINUS_EN=0x7,PLL_UI_SHIFT_MINUS_EN_EXT=0x8,PLL_UI_SHIFT_MINUS_EN_PRE=0x9,PLL_UI_SHIFT_MINUS_EN_2PRE=0xa,PLL_UI_SHIFT_MINUS_EN_POST=0xb,PLL_UI_SHIFT_MINUS_EN_2POST=0xc,PLL_UI_SHIFT_MINUS_DIS=0xd,ALIGN_LOCK_OK=0xe,ALIGN_LOCK_FAIL=0xf" offset="0x0.16" size="0x0.4" />
	<field name="align_ok" descr="Assert when SFEC alignment lock error rate below threshold." access="RO" offset="0x0.27" size="0x0.1" />
	<field name="align_lock_ok" descr="Assert when SFEC alignment lock finish and ok." access="RO" offset="0x0.28" size="0x0.1" />
	<field name="align_lock_fail" descr="Assert when SFEC alignment lock finish and failed." access="RO" offset="0x0.29" size="0x0.1" />
	<field name="align_lock_done" descr="Assert when SFEC alignment lock finish." access="RO" offset="0x0.30" size="0x0.1" />
	<field name="clear_flags" descr="when set, all flags clear" access="OP" offset="0x0.31" size="0x0.1" />
	<field name="no_correction" descr="An option to disable the correction of data even when error is detected.\;0x00: correction enable\;0x01: correction disable" access="RW" offset="0x4.0" size="0x0.1" />
	<field name="sfec_nblk_cnt_tc" descr="Total numbers of bit on a window to check the error threshold.\;(numbers of bits)" access="RW" offset="0x8.0" size="0x0.10" />
	<field name="sfec_nblk_cnt_th" descr="Threshold numbers of errors to acquire lock for a window." access="RW" offset="0x8.10" size="0x0.11" />
	<field name="sfec_nerr_cnt" descr="Number of errors. on the current window." access="RO" offset="0x8.21" size="0x0.11" />
	<field name="alignment_marker1" descr="set the alignment marker to look for.\;those are the first 32 bits" access="RW" offset="0xC.0" size="0x4.0" />
	<field name="alignment_marker2" descr="set the alignment marker to look for.\;those are the last 16 bits" access="RW" offset="0x10.0" size="0x0.16" />
	<field name="back_chanel" descr="data that can be inserted as part of the marker.\;the data that was retrieved from the marker (Read Only)" access="RO" offset="0x10.16" size="0x0.16" />
	<field name="bad_marker_count_th" descr="consecutive bad marker threshold for lose of lock\;relevant for Rx side only. for Tx ignore this field." access="RW" offset="0x14.24" size="0x0.4" />
	<field name="marker_detect_nibble_match_th" descr="Configure the amount of nibbles need to be correct from AM in order to be lock\;relevant for Rx side only. for Tx ignore this field." access="RW" offset="0x14.28" size="0x0.4" />
</node>

<node name="rtsfc_sfec_tx_debug_ext" descr="" size="0x8.0" >
	<field name="alignment_marker1" descr="set the alignment marker to insert.\;those are the first 32 bits" access="RW" offset="0x0.0" size="0x4.0" />
	<field name="alignment_marker2" descr="set the alignment marker to insert.\;those are the last 16 bits" access="RW" offset="0x4.0" size="0x0.16" />
	<field name="back_chanel" descr="data that can be inserted as part of the marker.\;enter the data to insert through the marker." access="RW" offset="0x4.16" size="0x0.16" />
</node>

<node name="rttspc_reg_ext" descr="" size="0x4.0" >
	<field name="squelch_ctrl" descr="The behavior of the TX when in TX squelched state:\;0: TX power off\;2: TX sends PRBS (PRBS31)" access="RW" offset="0x0.0" size="0x0.3" />
	<field name="data_path" descr="Data Path number" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="side_sel" descr="select which side of the data path to address (bit- mask):\;bit 0: Ingress\;bit 1: Egress" access="INDEX" enum="Ingress=0x1,Egress=0x2" offset="0x0.24" size="0x0.2" />
</node>

<node name="slrg_16nm_ext" descr="" size="0x24.0" >
	<field name="grade_lane_speed" descr="The lane speed on which the grade was measured:\;0 - SDR / PCIe Gen 1\;1 - DDR / PCIe Gen 2\;2 - QDR / PCIe Gen 3\;3 - FDR10 (10GE / 40GE)\;4 - FDR (56GE) / PCIe Gen 4\;5 - EDR (25GE / 50GE / 100GE) / PCIe Gen 5\;6 - HDR (50GE / 200GE / 400GE)\;7- 9 - reserved\;10 - 1GE\;11 - 2.5GE (XAUI)\;12 - 50GE-KR4\;13 - 15 - reserved" access="RO" offset="0x0.0" size="0x0.4" />
	<field name="grade" descr="The grade that the lane received based on a specific configuration.\;" access="RO" offset="0x4.0" size="0x0.24" />
	<field name="grade_version" descr="" access="RO" offset="0x4.24" size="0x0.8" />
	<field name="height_eo_neg_up" descr="Voltage offset from eye center to the negative side of the upper eye. Only applicable for PAM4 signal." access="RO" offset="0x8.0" size="0x0.16" />
	<field name="height_eo_pos_up" descr="Voltage offset from eye center to the positive side of the upper eye.\;Only applicable for PAM4 signal." access="RO" offset="0x8.16" size="0x0.16" />
	<field name="height_eo_pos_mid" descr="Voltage offset from eye center to the positive side of the middle eye." access="RO" offset="0xC.0" size="0x0.16" />
	<field name="phase_eo_neg_up" descr="The offset from the eye center to the negative (left) side of the upper eye. Only applicable for PAM4 signal." access="RO" offset="0xC.16" size="0x0.8" />
	<field name="phase_eo_pos_up" descr="The offset from the eye center to the positive (right) side of the upper eye. Only applicable for PAM4 signal." access="RO" offset="0xC.24" size="0x0.8" />
	<field name="phase_eo_neg_mid" descr="The offset from the eye center to the negative (left) side of the middle eye." access="RO" offset="0x10.0" size="0x0.8" />
	<field name="phase_eo_pos_mid" descr="The offset from the eye center to the positive (right) side of the middle eye." access="RO" offset="0x10.8" size="0x0.8" />
	<field name="height_eo_neg_mid" descr="Voltage offset from eye center to the negative side of the middle eye." access="RO" offset="0x10.16" size="0x0.16" />
	<field name="height_eo_neg_low" descr="Voltage offset from eye center to the negative side of the lower eye. Only applicable for PAM4 signal." access="RO" offset="0x14.0" size="0x0.16" />
	<field name="height_eo_pos_low" descr="Voltage offset from eye center to the positive side of the lower eye. Only applicable for PAM4 signal." access="RO" offset="0x14.16" size="0x0.16" />
	<field name="phase_eo_neg_low" descr="The offset from the eye center to the negative (left) side of the lower eye. Only applicable for PAM4 signal." access="RO" offset="0x18.16" size="0x0.8" />
	<field name="phase_eo_pos_low" descr="The offset from the eye center to the positive (right) side of the lower eye. Only applicable for PAM4 signal." access="RO" offset="0x18.24" size="0x0.8" />
	<field name="up_eye_grade" descr="upper eye grade" access="RO" offset="0x1C.0" size="0x0.16" />
	<field name="mid_eye_grade" descr="middle eye grade" access="RO" offset="0x1C.16" size="0x0.16" />
	<field name="dn_eye_grade" descr="lower eye grade" access="RO" offset="0x20.0" size="0x0.16" />
</node>

<node name="slrg_40nm_28nm_ext" descr="" size="0x24.0" >
	<field name="grade_lane_speed" descr="The lane speed on which the grade was measured:\;0 - SDR\;1 - DDR\;2 - QDR\;3 - FDR10 (10GE / 40GE)\;4 - FDR (56GE)\;5 - EDR (25GE / 50GE / 100GE)\;6 - 9 - reserved\;10 - 1GE\;11 - 2.5GE (XAUI)\;12 - 50GE-KR4\;13 - 15 - reserved" access="RO" offset="0x0.0" size="0x0.4" />
	<field name="grade" descr="" access="RO" offset="0x4.0" size="0x0.24" />
	<field name="grade_version" descr="" access="RO" offset="0x4.24" size="0x0.8" />
	<field name="height_eo_neg" descr="Voltage offset from eye center to the negative side." access="RO" offset="0x14.0" size="0x0.16" />
	<field name="height_eo_pos" descr="Voltage offset from eye center to the positive side." access="RO" offset="0x14.16" size="0x0.16" />
	<field name="phase_eo_neg" descr="The offset from the eye center to the negative side." access="RO" offset="0x1C.0" size="0x0.8" />
	<field name="phase_eo_pos" descr="The offset from the eye center to the positive side." access="RO" offset="0x1C.16" size="0x0.8" />
</node>

<node name="slrg_5nm_ext" descr="" size="0x18.0" >
	<field name="fom_measurement" descr="Bitmask for measurement activation\;Bit 0 - Upper eye\;Bit 1 - Middle eye\;Bit 2 - Lower eye\;Bit 3- Composite eye\;Note: NRZ only Bit 3 is valid" access="OP" offset="0x0.0" size="0x0.4" />
	<field name="initial_fom" descr="measured EOM status after FEQ.\;valid only when SLRG.status is &apos;1&apos;" access="RO" offset="0x4.0" size="0x0.16" />
	<field name="fom_mode" descr="fom mode:\;FOM eye mode to search\;0x0: FOM_MODE_EYE_OPEN\;0x1: FOM_MODE_EYEO_SNR\;0x2: FOM_MODE_NORM_SNR\;0x3: FOM_MODE_EYE_LVLN\;0x4: FOM_MODE_EYE_LVLP\;0x5: FOM_MODE_THRES_NERR\;0x6: FOM_MODE_CDR_NERR\;0x7: FOM_MODE_CSDET_NERR\;0x8: FOM_MODE_MLSE_NERR\;0x9: FOM_MODE_SFEC_NERR\;\;\;" access="RW" enum="FOM_MODE_EYE_OPEN=0x0,FOM_MODE_EYEO_SNR=0x1,FOM_MODE_NORM_SNR=0x2,FOM_MODE_EYE_LVLN=0x3,FOM_MODE_EYE_LVLP=0x4,FOM_MODE_THRES_NERR=0x5,FOM_MODE_CDR_NERR=0x6,FOM_MODE_CSDET_NERR=0x7,FOM_MODE_MLSE_NERR=0x8,FOM_MODE_SFEC_NERR=0x9" offset="0x4.16" size="0x0.4" />
	<field name="upper_eye" descr="last measured EOM-FOM status of upper eye.\;valid only if fom_measurement bit &apos;0&apos; is set" access="RO" offset="0x8.0" size="0x0.16" />
	<field name="last_fom" descr="last measured EOM-FOM status of composite eye.\;valid only if fom_measurement bit &apos;3&apos; is set" access="RO" offset="0x8.16" size="0x0.16" />
	<field name="lower_eye" descr="last measured EOM-FOM status of lower eye.\;valid only if fom_measurement bit &apos;2&apos; is set" access="RO" offset="0xC.0" size="0x0.16" />
	<field name="mid_eye" descr="last measured EOM-FOM status of middle eye.\;valid only if fom_measurement bit &apos;1&apos; is set" access="RO" offset="0xC.16" size="0x0.16" />
</node>

<node name="slrg_7nm_ext" descr="" size="0x18.0" >
	<field name="fom_measurement" descr="Bitmask for measurement activation\;Bit 0 - Upper eye\;Bit 1 - Middle eye\;Bit 2 - Lower eye\;Bit 3- Composite eye\;Note: NRZ only Bit 3 is valid" access="OP" offset="0x0.0" size="0x0.4" />
	<field name="initial_fom" descr="measured EOM status after FEQ.\;valid only when SLRG.status is &apos;1&apos;" access="RO" offset="0x4.0" size="0x0.8" />
	<field name="fom_mode" descr="fom mode:\;FOM eye mode to search\;0x0: FOM_MODE_EYEC\;0x1: FOM_MODE_EYEO\;0x2: FOM_MODE_EYEM\;0x3: FOM_MODE_BER\;0x4: FOM_MODE_EYEC_VN\;0x5: FOM_MODE_EYEC_VP\;0x6: FOM_MODE_EYEM_VN\;0x7: FOM_MODE_EYEM_VP\;\;" access="RW" enum="FOM_MODE_EYEC=0x0,FOM_MODE_EYEO=0x1,FOM_MODE_EYEM=0x2,FOM_MODE_BER=0x3,FOM_MODE_EYEC_VN=0x4,FOM_MODE_EYEC_VP=0x5,FOM_MODE_EYEM_VN=0x6,FOM_MODE_EYEM_VP=0x7" offset="0x4.16" size="0x0.3" />
	<field name="lower_eye" descr="last measured EOM-FOM status of lower eye.\;valid only if fom_measurement bit &apos;2&apos; is set" access="RO" offset="0x8.0" size="0x0.8" />
	<field name="mid_eye" descr="last measured EOM-FOM status of middle eye.\;valid only if fom_measurement bit &apos;1&apos; is set" access="RO" offset="0x8.8" size="0x0.8" />
	<field name="upper_eye" descr="last measured EOM-FOM status of upper eye.\;valid only if fom_measurement bit &apos;0&apos; is set" access="RO" offset="0x8.16" size="0x0.8" />
	<field name="last_fom" descr="last measured EOM-FOM status of composite eye.\;valid only if fom_measurement bit &apos;3&apos; is set" access="RO" offset="0x8.24" size="0x0.8" />
</node>

<node name="slrg_all_lanes_5nm_ext" descr="" size="0x14.0" >
	<field name="fom_mode" descr="FOM type measurement\;0: SNR - bit scale of 1/256 dB.\;The SNR value represents the electrical signal-to-noise ratio on an optical lane, and is defined as the minimum of the three individual eye SNR values." access="OP" offset="0x0.0" size="0x0.4" />
	<field name="fom_lane1" descr="FOM value on the media lane &lt;i&gt; According to fom_mode value" access="RO" offset="0x4.0" size="0x0.16" />
	<field name="fom_lane0" descr="FOM value on the media lane &lt;i&gt; According to fom_mode value" access="RO" offset="0x4.16" size="0x0.16" />
	<field name="fom_lane3" descr="FOM value on the media lane &lt;i&gt; According to fom_mode value" access="RO" offset="0x8.0" size="0x0.16" />
	<field name="fom_lane2" descr="FOM value on the media lane &lt;i&gt; According to fom_mode value" access="RO" offset="0x8.16" size="0x0.16" />
	<field name="fom_lane5" descr="FOM value on the media lane &lt;i&gt; According to fom_mode value" access="RO" offset="0xC.0" size="0x0.16" />
	<field name="fom_lane4" descr="FOM value on the media lane &lt;i&gt; According to fom_mode value" access="RO" offset="0xC.16" size="0x0.16" />
	<field name="fom_lane7" descr="FOM value on the media lane &lt;i&gt; According to fom_mode value" access="RO" offset="0x10.0" size="0x0.16" />
	<field name="fom_lane6" descr="FOM value on the media lane &lt;i&gt; According to fom_mode value" access="RO" offset="0x10.16" size="0x0.16" />
</node>

<node name="slrg_reg_ext" descr="" size="0x28.0" >
	<field name="all_lanes" descr="set 1 all lanes measurement page\;Supported if PCAM.feature_cap_mask bit 91 is set. \;Relevant only for 5nm\;0: per_lane_measurement\;1: all_lane_measurement" access="INDEX" enum="per_lane_measurement=0x0,all_lane_measurement=0x1" offset="0x0.1" size="0x0.1" />
	<field name="port_type" descr="For HCA supported only when indicated by PCAM \;0: Network_Port\;1: NearEnd_Port - (For Retimer/Gearbox - Host side)\;2: Internal_IC_LR_Port \;3: FarEnd_Port - (For Retimer/Gearbox - Line side)\;\;" access="INDEX" enum="Network_Port=0x0,NearEnd_Port=0x1,Internal_IC_LR_Port=0x2,FarEnd_Port=0x3" offset="0x0.4" size="0x0.4" />
	<field name="lane" descr="Logical lane number" access="INDEX" offset="0x0.8" size="0x0.4" />
	<field name="lp_msb" descr="Local port number [9:8] for Retimer: data path number" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="pnat" descr="Port number access type. \;0 - Local port number\;1 - IB port number\;3 - Out of band / PCI" access="INDEX" offset="0x0.14" size="0x0.2" />
	<field name="local_port" descr="Local port number.\;For Retimer, this is the data path number" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="version" descr="0: prod_40nm\;1: prod_28nm\;3: prod_16nm\;4: prod_7nm\;5: prod_5nm" access="RO" enum="prod_40nm=0x0,prod_28nm=0x1,prod_16nm=0x3,prod_7nm=0x4,prod_5nm=0x5" offset="0x0.24" size="0x0.4" />
	<field name="status" descr="0 - Invalid\;1 - Valid\;" access="RO" offset="0x0.28" size="0x0.4" />
	<field name="page_data" descr="Table 854, &quot;SLRG - SerDes Lane Receive Grade Register Layout for 40nm and 28nm,&quot; on page 974\;Table 856, &quot;SLRG - SerDes Lane Receive Grade Register Layout for 16nm,&quot; on page 976\;Table 858, &quot;SLRG - SerDes Lane Receive Grade Register Layout for 7nm,&quot; on page 978\;Table 860, &quot;SLRG - SerDes Lane Receive Grade Register Layout for 5nm,&quot; on page 979\;Table 868, &quot;SLRG all lanes FOM for 5nm- Layout,&quot; on page 983" subnode="slrg_reg_page_data_auto_ext" access="RO" condition="$(parent).all_lanes" offset="0x4.0" size="0x24.0" />
</node>

<node name="slrg_reg_page_data_auto_ext" descr="" attr_is_union="1" is_conditional="1" size="0x24.0" >
	<field name="slrg_40nm_28nm_ext" descr="" subnode="slrg_40nm_28nm_ext" condition="($(parent).port_type == Network_Port AND ($(parent).version == prod_40nm | $(parent).version == prod_28nm))" offset="0x0.0" size="0x24.0" />
	<field name="slrg_16nm_ext" descr="" subnode="slrg_16nm_ext" condition="($(parent).port_type == Network_Port AND ($(parent).version == prod_16nm))" offset="0x0.0" size="0x24.0" />
	<field name="slrg_7nm_ext" descr="" subnode="slrg_7nm_ext" condition="(($(parent).port_type == Network_Port | $(parent).port_type == NearEnd_Port  | $(parent).port_type == FarEnd_Port) AND ($(parent).version == prod_7nm))" offset="0x0.0" size="0x18.0" />
	<field name="slrg_5nm_ext" descr="" subnode="slrg_5nm_ext" condition="(($(parent).port_type == Network_Port | $(parent).port_type == Internal_IC_LR_Port  | $(parent).port_type == NearEnd_Port  | $(parent).port_type == FarEnd_Port) AND ($(parent).version == prod_5nm))" offset="0x0.0" size="0x18.0" />
	<field name="slrg_all_lanes_5nm_ext" descr="" subnode="slrg_all_lanes_5nm_ext" condition="(($(parent).port_type == Network_Port || $(parent).port_type == NearEnd_Port  || $(parent).port_type == FarEnd_Port) AND ($(parent).version == prod_5nm AND $(parent).all_lanes == all_lane_measurement))" offset="0x0.0" size="0x14.0" />
</node>

<node name="sltp_16nm_ext" descr="" size="0x48.0" >
	<field name="post_tap" descr="Value of each tap is between -96 to 96\;\;NOTE: The total sum of all absolute taps values should be 96 or smaller.\;" access="RW" offset="0x4.0" size="0x0.8" />
	<field name="main_tap" descr="Value of each tap is between -96 to 96\;\;NOTE: The total sum of all absolute taps values should be 96 or smaller.\;" access="RW" offset="0x4.8" size="0x0.8" />
	<field name="pre_tap" descr="Value of each tap is between -96 to 96\;\;NOTE: The total sum of all absolute taps values should be 96 or smaller.\;" access="RW" offset="0x4.16" size="0x0.8" />
	<field name="pre_2_tap" descr="Value of each tap is between -96 to 96\;\;NOTE: The total sum of all absolute taps values should be 96 or smaller.\;" access="RW" offset="0x4.24" size="0x0.8" />
	<field name="ob_alev_out" descr="Output common mode. Values can be set in the range of (0-30)" access="RW" offset="0x8.0" size="0x0.5" />
	<field name="ob_amp" descr="Output amplitude. Values can be set in the range of (10-100)." access="RW" offset="0x8.8" size="0x0.7" />
	<field name="ob_m2lp" descr="MSB to LSB proportion. \;Values can be set between -10 to 50. \;\;MSB emphasis achieved when value is between -10 to -1 \;LSB emphasis achieved when value is between 1 to 50. \;When set to 0 - equal proportion." access="RW" offset="0x8.25" size="0x0.7" />
	<field name="ob_bad_stat" descr="Bitmask for bad &apos;set&apos; status:\;0: configuration_warning - taps values can&apos;t be set to SerDes due to internal limitations. Actual TX configuration is modify internally with the same sum of taps weight.\;11: Illegal_ob_combination - ob_m2lp, ob_amp and ob_alev is in legal range each, but the total combination can&apos;t be set to SerDes due to internal limitations, the Set command is ignored.\;12: Illegal_ob_m2lp\;13: Illegal_ob_amp\;14: Illegal_ob_alev_out\;15: Illegal_taps\;\;Bit 12-0 - Reserved /Unknown" access="RO" enum="configuration_warning=0x0,Illegal_ob_combination=0xb,Illegal_ob_m2lp=0xc,Illegal_ob_amp=0xd,Illegal_ob_alev_out=0xe,Illegal_taps=0xf" offset="0xC.16" size="0x0.16" />
	<field name="regp_bfm1n" descr="Values can be set in the range of (0-200)." access="RW" offset="0x10.0" size="0x0.8" />
	<field name="regn_bfm1p" descr="Values can be set in the range of (0-200)." access="RW" offset="0x10.8" size="0x0.8" />
	<field name="obnlev" descr="Values can be set in the range of (0-200)." access="RW" offset="0x10.16" size="0x0.8" />
	<field name="obplev" descr="Values can be set in the range of (0-200)." access="RW" offset="0x10.24" size="0x0.8" />
</node>

<node name="sltp_28nm_40nm_ext" descr="" size="0x48.0" >
	<field name="ob_tap2" descr="\;" access="RW" offset="0x4.0" size="0x0.8" />
	<field name="ob_tap1" descr="\;" access="RW" offset="0x4.8" size="0x0.8" />
	<field name="ob_tap0" descr="\;" access="RW" offset="0x4.16" size="0x0.8" />
	<field name="polarity" descr="Tx lane polarity" access="RW" offset="0x4.24" size="0x0.1" />
	<field name="ob_bias" descr="" access="RW" offset="0x8.0" size="0x0.8" />
	<field name="ob_reg" descr="(ref_txcml100_reg)" access="RW" offset="0x8.8" size="0x0.8" />
	<field name="ob_preemp_mode" descr="Concatenation of taps polarity + preemp_sel" access="RW" offset="0x8.16" size="0x0.4" />
	<field name="ob_leva" descr="" access="RW" offset="0x8.20" size="0x0.4" />
	<field name="ob_bad_stat" descr="Bitmask for bad SET status:\;Bit 0 - Illegal ob_bais value\;Bit 1 - Illegal ob taps polarity (distance between taps)" access="RO" offset="0xC.29" size="0x0.2" />
	<field name="ob_norm" descr="OB Normalization status:\;0 - No Normalization was done\;1 - Normalization performed" access="RO" offset="0xC.31" size="0x0.1" />
</node>

<node name="sltp_5nm_ext" descr="" size="0x48.0" >
	<field name="ob_bad_stat" descr="Bitmask for bad &apos;set&apos; status:\;Bit 0: tap0_is_out_of_range\;Bit 1: tap1_is_out_of_range\;Bit 2: tap2_is_out_of_range\;Bit 3: tap3_is_out_of_range\;Bit 4: tap4_is_out_of_range\;Bit 5: tap5_is_out_of_range\;Bit 6: tap6_is_out_of_range\;Bit 7: tap7_is_out_of_range\;Bit 8: tap8_is_out_of_range\;Bit 9: tap9_is_out_of_range\;Bit 10: tap10_is_out_of_range\;Bit 11: tap11_is_out_of_range\;Bit 9: sum_of_taps_is_out_of_range" access="RO" enum="tap0_is_out_of_range=0x1,tap1_is_out_of_range=0x2,tap2_is_out_of_range=0x4,tap3_is_out_of_range=0x8,tap4_is_out_of_range=0x10,tap5_is_out_of_range=0x20,tap6_is_out_of_range=0x40,tap7_is_out_of_range=0x80,tap8_is_out_of_range=0x100,tap9_is_out_of_range=0x200,tap10_is_out_of_range=0x400,tap11_is_out_of_range=0x800,sum_of_taps_is_out_of_range=0x200" offset="0x0.0" size="0x0.16" />
	<field name="no_db_set" descr="supported only if PCAM bit 96 in feature_cap_mask is set.\;When set, Tx DB will not be written into HW on linkup phase.\;When cleared, Tx DB is written into HW on linkup phase." access="RW" offset="0x0.31" size="0x0.1" />
	<field name="tap0" descr="Signed value for TX FIR taps.\;tap scaling = fir_tap/63.\;Taps value must be under the following rules:\;\;taps [0-1, 6-11] valid ranges are [-8,8]\;And Also:\;|tap0| + | tap1| &lt;8\;|tap6| + | tap7| + | tap8|&lt;8\;|tap9| + | tap10| + | tap11| &lt;8\;taps [2-5] valid ranges are [-63, 63]\;\;For PAM4 links need to guarantee that the sum of the coefficient magnitude equals sum |c(i)| &lt;= 63. \;For NRZ links must guarantee sum|c(i)| = 63\;\;Note: Configured taps may get effective value of +/-1 from the value that has been set." access="RW" offset="0x4.0" size="0x0.8" />
	<field name="tap1" descr="Signed value for TX FIR taps.\;tap scaling = fir_tap/63.\;Taps value must be under the following rules:\;\;taps [0-1, 6-11] valid ranges are [-8,8]\;And Also:\;|tap0| + | tap1| &lt;8\;|tap6| + | tap7| + | tap8|&lt;8\;|tap9| + | tap10| + | tap11| &lt;8\;taps [2-5] valid ranges are [-63, 63]\;\;For PAM4 links need to guarantee that the sum of the coefficient magnitude equals sum |c(i)| &lt;= 63. \;For NRZ links must guarantee sum|c(i)| = 63\;\;Note: Configured taps may get effective value of +/-1 from the value that has been set." access="RW" offset="0x4.8" size="0x0.8" />
	<field name="tap2" descr="Signed value for TX FIR taps.\;tap scaling = fir_tap/63.\;Taps value must be under the following rules:\;\;taps [0-1, 6-11] valid ranges are [-8,8]\;And Also:\;|tap0| + | tap1| &lt;8\;|tap6| + | tap7| + | tap8|&lt;8\;|tap9| + | tap10| + | tap11| &lt;8\;taps [2-5] valid ranges are [-63, 63]\;\;For PAM4 links need to guarantee that the sum of the coefficient magnitude equals sum |c(i)| &lt;= 63. \;For NRZ links must guarantee sum|c(i)| = 63\;\;Note: Configured taps may get effective value of +/-1 from the value that has been set." access="RW" offset="0x4.16" size="0x0.8" />
	<field name="tap3" descr="Signed value for TX FIR taps.\;tap scaling = fir_tap/63.\;Taps value must be under the following rules:\;\;taps [0-1, 6-11] valid ranges are [-8,8]\;And Also:\;|tap0| + | tap1| &lt;8\;|tap6| + | tap7| + | tap8|&lt;8\;|tap9| + | tap10| + | tap11| &lt;8\;taps [2-5] valid ranges are [-63, 63]\;\;For PAM4 links need to guarantee that the sum of the coefficient magnitude equals sum |c(i)| &lt;= 63. \;For NRZ links must guarantee sum|c(i)| = 63\;\;Note: Configured taps may get effective value of +/-1 from the value that has been set." access="RW" offset="0x4.24" size="0x0.8" />
	<field name="tap4" descr="Signed value for TX FIR taps.\;tap scaling = fir_tap/63.\;Taps value must be under the following rules:\;\;taps [0-1, 6-11] valid ranges are [-8,8]\;And Also:\;|tap0| + | tap1| &lt;8\;|tap6| + | tap7| + | tap8|&lt;8\;|tap9| + | tap10| + | tap11| &lt;8\;taps [2-5] valid ranges are [-63, 63]\;\;For PAM4 links need to guarantee that the sum of the coefficient magnitude equals sum |c(i)| &lt;= 63. \;For NRZ links must guarantee sum|c(i)| = 63\;\;Note: Configured taps may get effective value of +/-1 from the value that has been set." access="RW" offset="0x8.0" size="0x0.8" />
	<field name="tap5" descr="Signed value for TX FIR taps.\;tap scaling = fir_tap/63.\;Taps value must be under the following rules:\;\;taps [0-1, 6-11] valid ranges are [-8,8]\;And Also:\;|tap0| + | tap1| &lt;8\;|tap6| + | tap7| + | tap8|&lt;8\;|tap9| + | tap10| + | tap11| &lt;8\;taps [2-5] valid ranges are [-63, 63]\;\;For PAM4 links need to guarantee that the sum of the coefficient magnitude equals sum |c(i)| &lt;= 63. \;For NRZ links must guarantee sum|c(i)| = 63\;\;Note: Configured taps may get effective value of +/-1 from the value that has been set." access="RW" offset="0x8.8" size="0x0.8" />
	<field name="tap6" descr="Signed value for TX FIR taps.\;tap scaling = fir_tap/63.\;Taps value must be under the following rules:\;\;taps [0-1, 6-11] valid ranges are [-8,8]\;And Also:\;|tap0| + | tap1| &lt;8\;|tap6| + | tap7| + | tap8|&lt;8\;|tap9| + | tap10| + | tap11| &lt;8\;taps [2-5] valid ranges are [-63, 63]\;\;For PAM4 links need to guarantee that the sum of the coefficient magnitude equals sum |c(i)| &lt;= 63. \;For NRZ links must guarantee sum|c(i)| = 63\;\;Note: Configured taps may get effective value of +/-1 from the value that has been set." access="RW" offset="0x8.16" size="0x0.8" />
	<field name="tap7" descr="Signed value for TX FIR taps.\;tap scaling = fir_tap/63.\;Taps value must be under the following rules:\;\;taps [0-1, 6-11] valid ranges are [-8,8]\;And Also:\;|tap0| + | tap1| &lt;8\;|tap6| + | tap7| + | tap8|&lt;8\;|tap9| + | tap10| + | tap11| &lt;8\;taps [2-5] valid ranges are [-63, 63]\;\;For PAM4 links need to guarantee that the sum of the coefficient magnitude equals sum |c(i)| &lt;= 63. \;For NRZ links must guarantee sum|c(i)| = 63\;\;Note: Configured taps may get effective value of +/-1 from the value that has been set." access="RW" offset="0x8.24" size="0x0.8" />
	<field name="tap8" descr="Signed value for TX FIR taps.\;tap scaling = fir_tap/63.\;Taps value must be under the following rules:\;\;taps [0-1, 6-11] valid ranges are [-8,8]\;And Also:\;|tap0| + | tap1| &lt;8\;|tap6| + | tap7| + | tap8|&lt;8\;|tap9| + | tap10| + | tap11| &lt;8\;taps [2-5] valid ranges are [-63, 63]\;\;For PAM4 links need to guarantee that the sum of the coefficient magnitude equals sum |c(i)| &lt;= 63. \;For NRZ links must guarantee sum|c(i)| = 63\;\;Note: Configured taps may get effective value of +/-1 from the value that has been set." access="RW" offset="0xC.0" size="0x0.8" />
	<field name="tap9" descr="Signed value for TX FIR taps.\;tap scaling = fir_tap/63.\;Taps value must be under the following rules:\;\;taps [0-1, 6-11] valid ranges are [-8,8]\;And Also:\;|tap0| + | tap1| &lt;8\;|tap6| + | tap7| + | tap8|&lt;8\;|tap9| + | tap10| + | tap11| &lt;8\;taps [2-5] valid ranges are [-63, 63]\;\;For PAM4 links need to guarantee that the sum of the coefficient magnitude equals sum |c(i)| &lt;= 63. \;For NRZ links must guarantee sum|c(i)| = 63\;\;Note: Configured taps may get effective value of +/-1 from the value that has been set." access="RW" offset="0xC.8" size="0x0.8" />
	<field name="tap10" descr="Signed value for TX FIR taps.\;tap scaling = fir_tap/63.\;Taps value must be under the following rules:\;\;taps [0-1, 6-11] valid ranges are [-8,8]\;And Also:\;|tap0| + | tap1| &lt;8\;|tap6| + | tap7| + | tap8|&lt;8\;|tap9| + | tap10| + | tap11| &lt;8\;taps [2-5] valid ranges are [-63, 63]\;\;For PAM4 links need to guarantee that the sum of the coefficient magnitude equals sum |c(i)| &lt;= 63. \;For NRZ links must guarantee sum|c(i)| = 63\;\;Note: Configured taps may get effective value of +/-1 from the value that has been set." access="RW" offset="0xC.16" size="0x0.8" />
	<field name="tap11" descr="Signed value for TX FIR taps.\;tap scaling = fir_tap/63.\;Taps value must be under the following rules:\;\;taps [0-1, 6-11] valid ranges are [-8,8]\;And Also:\;|tap0| + | tap1| &lt;8\;|tap6| + | tap7| + | tap8|&lt;8\;|tap9| + | tap10| + | tap11| &lt;8\;taps [2-5] valid ranges are [-63, 63]\;\;For PAM4 links need to guarantee that the sum of the coefficient magnitude equals sum |c(i)| &lt;= 63. \;For NRZ links must guarantee sum|c(i)| = 63\;\;Note: Configured taps may get effective value of +/-1 from the value that has been set." access="RW" offset="0xC.24" size="0x0.8" />
</node>

<node name="sltp_7nm_ext" descr="" size="0x48.0" >
	<field name="fir_pre2" descr="Signed value for TX FIR taps.\;tap scaling = fir_tap/63.\;for 100G per lane 5 taps, \;for 50G per lane 4 taps are used (no pre3),\;or 25G per lane 3 taps are used (no pre3,pre2)\;Valid values for taps:\;fir_main [34,63]\;fir_pre1 [-23,0]\;fir_pre2 [0,8]\;fir_pre3 [-5,0]\;fir_post1 [-21,0]\;\;Need to guarantee that the sum of the coefficient magnitude equals sum |c(i)| &lt;= 63.\;NRZ speeds must guarantee sum|c(i)| = 63\;Note: Configured taps may get effective value of +/-1 from the value that has been set." access="RW" offset="0x0.0" size="0x0.8" />
	<field name="fir_pre3" descr="Signed value for TX FIR taps.\;tap scaling = fir_tap/63.\;for 100G per lane 5 taps, \;for 50G per lane 4 taps are used (no pre3),\;or 25G per lane 3 taps are used (no pre3,pre2)\;Valid values for taps:\;fir_main [34,63]\;fir_pre1 [-23,0]\;fir_pre2 [0,8]\;fir_pre3 [-5,0]\;fir_post1 [-21,0]\;\;Need to guarantee that the sum of the coefficient magnitude equals sum |c(i)| &lt;= 63.\;NRZ speeds must guarantee sum|c(i)| = 63\;Note: Configured taps may get effective value of +/-1 from the value that has been set." access="RW" offset="0x0.8" size="0x0.8" />
	<field name="ob_bad_stat" descr="Bitmask for bad &apos;set&apos; status:\;Bit 0: pre3_is_out_of_range\;Bit 1: pre2_is_out_of_range\;Bit 2: pre1_is_out_of_range\;Bit 3: main_tap_is_out_of_range\;Bit 4: post1_is_out_of_range\;Bit 5: sum_of_taps_is_out_of_range\;Bit 6: taps_not_alinged_with_speed" access="RO" enum="pre3_is_out_of_range=0x1,pre2_is_out_of_range=0x2,pre1_is_out_of_range=0x4,main_tap_is_out_of_range=0x8,post1_is_out_of_range=0x10,sum_of_taps_is_out_of_range=0x20,taps_not_alinged_with_speed=0x40" offset="0x0.16" size="0x0.8" />
	<field name="drv_amp" descr="High speed output driver amplitude settings, default = 6&quot;d63.\; amplitude scaling = (AMP+1) / 64" access="RW" offset="0x0.24" size="0x0.6" />
	<field name="fir_post1" descr="Signed value for TX FIR taps.\;tap scaling = fir_tap/63.\;for 100G per lane 5 taps, \;for 50G per lane 4 taps are used (no pre3),\;or 25G per lane 3 taps are used (no pre3,pre2)\;Valid values for taps:\;fir_main [34,63]\;fir_pre1 [-23,0]\;fir_pre2 [0,8]\;fir_pre3 [-5,0]\;fir_post1 [-21,0]\;\;Need to guarantee that the sum of the coefficient magnitude equals sum |c(i)| &lt;= 63.\;NRZ speeds must guarantee sum|c(i)| = 63\;Note: Configured taps may get effective value of +/-1 from the value that has been set." access="RW" offset="0x4.8" size="0x0.8" />
	<field name="fir_main" descr="Signed value for TX FIR taps.\;tap scaling = fir_tap/63.\;for 100G per lane 5 taps, \;for 50G per lane 4 taps are used (no pre3),\;or 25G per lane 3 taps are used (no pre3,pre2)\;Valid values for taps:\;fir_main [34,63]\;fir_pre1 [-23,0]\;fir_pre2 [0,8]\;fir_pre3 [-5,0]\;fir_post1 [-21,0]\;\;Need to guarantee that the sum of the coefficient magnitude equals sum |c(i)| &lt;= 63.\;NRZ speeds must guarantee sum|c(i)| = 63\;Note: Configured taps may get effective value of +/-1 from the value that has been set." access="RW" offset="0x4.16" size="0x0.8" />
	<field name="fir_pre1" descr="Signed value for TX FIR taps.\;tap scaling = fir_tap/63.\;for 100G per lane 5 taps, \;for 50G per lane 4 taps are used (no pre3),\;or 25G per lane 3 taps are used (no pre3,pre2)\;Valid values for taps:\;fir_main [34,63]\;fir_pre1 [-23,0]\;fir_pre2 [0,8]\;fir_pre3 [-5,0]\;fir_post1 [-21,0]\;\;Need to guarantee that the sum of the coefficient magnitude equals sum |c(i)| &lt;= 63.\;NRZ speeds must guarantee sum|c(i)| = 63\;Note: Configured taps may get effective value of +/-1 from the value that has been set." access="RW" offset="0x4.24" size="0x0.8" />
</node>

<node name="sltp_reg_ext" descr="" size="0x4c.0" >
	<field name="c_db" descr="copy transmitter parameters to Data Base. \;" access="OP" offset="0x0.0" size="0x0.1" />
	<field name="port_type" descr="For HCA supported only when indicated by PCAM \;0: Network_Port\;1: NearEnd_Port - (For Retimer/Gearbox - Host side)\;2: Internal_IC_LR_Port \;3: FarEnd_Port - (For Retimer/Gearbox - Line side)\;" access="INDEX" enum="Network_Port=0x0,NearEnd_Port=0x1,Internal_IC_LR_Port=0x2,FarEnd_Port=0x3" offset="0x0.1" size="0x0.3" />
	<field name="lane_speed" descr="Reserved for PCIe.\;The lane speed for TX settings:\;0 - SDR / Gen1 (PCIe)\;1 - DDR / Gen2 (PCIe) / 5GBASE-R\;2 - QDR / Gen3 (PCIe)\;3 - FDR10 (10GE / 40GE)\;4 - FDR (56GE) / Gen4 (PCIe)\;5 - EDR (25GE / 50GE / 100GE) / Gen5 (PCIe)\;6 - HDR (50GE / 200GE / 400GE)\;7 - NDR /100GE / 200GE / 400GE / 800GE (53.125 Gbd / 106.25Gb/s)\;8 - XDR (106.25 Gbd / 212.5Gb/s)\;9 - Reserved\;10 - 1GE\;11 - 2.5GE (XAUI)\;12 - 50GE-KR4\;13-15 - Reserved" access="RW" offset="0x0.4" size="0x0.4" />
	<field name="lane" descr="Logical lane number" access="INDEX" offset="0x0.8" size="0x0.4" />
	<field name="tx_policy" descr="Configures Tx parameter set policy\;0 - Tx parameters will be set according to best possible configuration chosen by the system\;1 - Tx parameters will be set according to Data Base only and will not be overridden by link training (e.g KR-Startup)" access="RW" offset="0x0.13" size="0x0.1" />
	<field name="pnat" descr="Port number access type. determines the way local_port is interpreted:\;0 - Local port number\;1 - IB port number\;3 - Out of band / PCI" access="INDEX" offset="0x0.14" size="0x0.2" />
	<field name="local_port" descr="Local port number [7:0]for Retimer: data path number" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="version" descr="0: prod_40nm\;1: prod_28nm\;3: prod_16nm\;4: prod_7nm\;5: prod_5nm" access="RO" enum="prod_40nm=0x0,prod_28nm=0x1,prod_16nm=0x3,prod_7nm=0x4,prod_5nm=0x5" offset="0x0.24" size="0x0.4" />
	<field name="status" descr="Indicates that Tx setting readout is valid and active. In particular, for links that do AN/LT, valid will be set when link operational status is UP (PAOS.oper_status=0x1).\;For links without AN/LT, valid will be set when Tx is enabled.\;\;0 - Invalid\;1 - Valid\;\;Note: Get and Set operations can be set when status = invalid." access="RO" offset="0x0.28" size="0x0.1" />
	<field name="lp_msb" descr="Local port number [9:8]" access="INDEX" offset="0x0.30" size="0x0.2" />
	<field name="page_data" descr="Table  836, &quot;SLTP - SerDes Lane Transmit Parameters Register Layout for 28nm and 40nm,&quot; on page  958\;Table  838, &quot;SLTP - SerDes Lane Transmit Parameters Register Layout for 16nm,&quot; on page  959\;Table  842, &quot;SLTP - SerDes Lane Transmit Parameters Register Layout for 7nm,&quot; on page  961\;Table  846, &quot;SLTP - SerDes Lane Transmit Parameters Register Layout for 5nm,&quot; on page  966" subnode="sltp_reg_page_data_auto_ext" access="RW" condition="$(parent).version" offset="0x4.0" size="0x48.0" />
</node>

<node name="sltp_reg_page_data_auto_ext" descr="" attr_is_union="1" is_conditional="1" size="0x48.0" >
	<field name="sltp_28nm_40nm_ext" descr="" subnode="sltp_28nm_40nm_ext" condition="($(parent).port_type == Network_Port) AND ($(parent).version == prod_40nm | $(parent).version == prod_28nm)" offset="0x0.0" size="0x48.0" />
	<field name="sltp_16nm_ext" descr="" subnode="sltp_16nm_ext" condition="($(parent).port_type == Network_Port | $(parent).port_type == Internal_IC_LR_Port) AND ($(parent).version == prod_16nm)" offset="0x0.0" size="0x48.0" />
	<field name="sltp_7nm_ext" descr="" subnode="sltp_7nm_ext" condition="($(parent).port_type == Network_Port | $(parent).port_type == Internal_IC_LR_Port) AND ($(parent).version == prod_7nm)" offset="0x0.0" size="0x48.0" />
	<field name="sltp_5nm_ext" descr="" subnode="sltp_5nm_ext" condition="($(parent).port_type == Network_Port | $(parent).port_type == Internal_IC_LR_Port  | $(parent).port_type == NearEnd_Port  | $(parent).port_type == FarEnd_Port) AND ($(parent).version == prod_5nm)" offset="0x0.0" size="0x48.0" />
</node>

<node name="sltpv2_lut_5nm_ext" descr="" size="0x108.0" >
	<field name="ob_bad_stat" descr="Bitmask for bad &apos;set&apos; status:\;Bit 0:LUT_value_is_out_of_range\;Bit 1: delay_0_invalid\;Bit 2: delay_1_invalid\;Bit 3: delay_2_invalid" access="RO" enum="delay_2_invalid=0x8" offset="0x0.0" size="0x0.16" />
	<field name="lut_sel" descr="0: LUT_1 - taps 0-1 (16 entries), valid ranges per entry: [-16, 15]\;1: LUT_2 - taps 2-5 (256 entries), valid ranges per entry: [-64, 63]\;2: LUT_3 - taps 6-8 (64 entries), valid ranges per entry: [-16, 15]\;3: LUT_4 - taps 9-11 (64 entries), valid ranges per entry: [-16, 15]\;\;Note that only LUT_2 group has FW DB, hence c_db shall work only for LUT_2." access="INDEX" enum="LUT_1=0x0,LUT_2=0x1,LUT_3=0x2,LUT_4=0x3" offset="0x0.20" size="0x0.4" />
	<field name="no_db_set" descr="supported only if PCAM bit 96 in feature_cap_mask is set.\;When set, Tx DB will not be written into HW on linkup phase.\;When cleared, Tx DB is written into HW on linkup phase." access="RW" offset="0x0.31" size="0x0.1" />
	<field name="delay0" descr="relevant for LUT3 (taps6-8), LUT4 (taps9-11). ignore otherwise.\;even taps (6, 8. 10) can get even values\;odd taps (7, 9, 11) cam get odd values." access="RW" offset="0x4.0" size="0x0.6" />
	<field name="delay1" descr="relevant for LUT3 (taps6-8), LUT4 (taps9-11). ignore otherwise.\;even taps (6, 8. 10) can get even values\;odd taps (7, 9, 11) cam get odd values." access="RW" offset="0x4.6" size="0x0.6" />
	<field name="delay2" descr="relevant for LUT3 (taps6-8), LUT4 (taps9-11). ignore otherwise.\;even taps (6, 8. 10) can get even values\;odd taps (7, 9, 11) cam get odd values." access="RW" offset="0x4.12" size="0x0.6" />
	<field name="lut" descr="Lookup Table values per entry" access="RW" high_bound="255" low_bound="0" offset="0x8.24" size="0x100.0" />
</node>

<node name="sltpv2_reg_ext" descr="" size="0x10c.0" >
	<field name="c_db" descr="Copy transmitter parameters to Data Base. \;When set, for get operation shall return Data Base values\;otherwise will be written to HW directly.\;" access="OP" offset="0x0.0" size="0x0.1" />
	<field name="port_type" descr="For HCA supported only when indicated by PCAM \;0: Network_Port\;1: NearEnd_Port - (For Retimer/Gearbox - Host side)\;2: Internal_IC_LR_Port \;3: FarEnd_Port - (For Retimer/Gearbox - Line side)\;\;" access="INDEX" enum="Network_Port=0x0,NearEnd_Port=0x1,Internal_IC_LR_Port=0x2,FarEnd_Port=0x3" offset="0x0.1" size="0x0.3" />
	<field name="lane_speed" descr="Reserved for PCIe.\;The lane speed for TX settings:\;0 - SDR / Gen1 (PCIe)\;1 - DDR / Gen2 (PCIe) / 5GBASE-R\;2 - QDR / Gen3 (PCIe)\;3 - FDR10 (10GE / 40GE)\;4 - FDR (56GE) / Gen4 (PCIe)\;5 - EDR (25GE / 50GE / 100GE) / Gen5 (PCIe)\;6 - HDR (50GE / 200GE / 400GE)\;7 - NDR /100GE / 200GE / 400GE / 800GE (53.125 Gbd / 106.25Gb/s)\;8 - XDR (106.25 Gbd / 212.5Gb/s)\;9 - Reserved\;10 - 1GE\;11 - 2.5GE (XAUI)\;12 - 50GE-KR4\;13-15 - Reserved" access="RW" offset="0x0.4" size="0x0.4" />
	<field name="lane" descr="Logical lane number" access="INDEX" offset="0x0.8" size="0x0.4" />
	<field name="tx_policy" descr="Configures Tx parameter set policy\;0 - Tx parameters will be set according to best possible configuration chosen by the system\;1 - Tx parameters will be set according to Data Base only and will not be overridden by link training (e.g KR-Startup)" access="RW" offset="0x0.13" size="0x0.1" />
	<field name="pnat" descr="Port number access type. determines the way local_port is interpreted:\;0 - Local port number\;1 - IB port number" access="INDEX" offset="0x0.14" size="0x0.2" />
	<field name="local_port" descr="Local port number [7:0]for Retimer: data path number" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="version" descr="5: prod_5nm" access="RO" enum="prod_5nm=0x5" offset="0x0.24" size="0x0.4" />
	<field name="status" descr="Indicates that Tx setting readout is valid and active. In particular, for links that do AN/LT, valid will be set when link operational status is UP (PAOS.oper_status=0x1).\;For links without AN/LT, valid will be set when Tx is enabled.\;\;0 - Invalid\;1 - Valid\;\;Note: Get and Set operations can be set when status = invalid." access="RO" offset="0x0.28" size="0x0.1" />
	<field name="lp_msb" descr="Local port number [9:8]" access="INDEX" offset="0x0.30" size="0x0.2" />
	<field name="page_data" descr="Table  850, &quot;SLTPv2 - SerDes Lane Transmit Parameters v2 Register Layout for LUT 5nm,&quot; on page  971" subnode="sltpv2_reg_page_data_auto_ext" access="RW" condition="$(parent).version" offset="0x4.0" size="0x108.0" />
</node>

<node name="sltpv2_reg_page_data_auto_ext" descr="" attr_is_union="1" is_conditional="1" size="0x108.0" >
	<field name="sltpv2_lut_5nm_ext" descr="" subnode="sltpv2_lut_5nm_ext" condition="($(parent).port_type == Network_Port | $(parent).port_type == Internal_IC_LR_Port  | $(parent).port_type == NearEnd_Port  | $(parent).port_type == FarEnd_Port) AND ($(parent).version == prod_5nm)" offset="0x0.0" size="0x108.0" />
</node>

<node name="test_ext" descr="" size="0xa0.0" >
</node>

<node name="uint64" descr="" size="0x8.0" >
	<field name="hi" descr="" offset="0x0.0" size="0x4.0" />
	<field name="lo" descr="" offset="0x4.0" size="0x4.0" />
</node>

<node name="root" size="0x10c.0" descr="" >
	<field name="register_access_table_retimer_ext_Nodes" offset="0x0.0" size="0x10c.0" subnode="register_access_table_retimer_ext_Nodes" descr="" />
</node>

<node name="register_access_table_retimer_ext_Nodes" size="0x10c.0" attr_is_union="1" descr="" >
	<field name="access_reg_summary_selector_ext" offset="0x0.0" size="0x10c.0" subnode="access_reg_summary_selector_ext" descr="" />
</node>
</NodesDefinition>

