/*
 * Copyright (c) 2022-2023 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * Copyright (c) 2012-2020 Mellanox Technologies LTD. All rights reserved.
 *
 * This software is available to you under a choice of one of two
 * licenses.  You may choose to be licensed under the terms of the GNU
 * General Public License (GPL) Version 2, available from the file
 * COPYING in the main directory of this source tree, or the
 * OpenIB.org BSD license below:
 *
 *     Redistribution and use in source and binary forms, with or
 *     without modification, are permitted provided that the following
 *     conditions are met:
 *
 *      - Redistributions of source code must retain the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer.
 *
 *      - Redistributions in binary form must reproduce the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

/*
 * Abstract:
 * 	Declaration of osm_file_ids_enum.
 *	This object is part of the OpenSM family of objects.
 */

#ifndef _OSM_FILE_ID_H_
#define _OSM_FILE_ID_H_

#ifdef __cplusplus
#  define BEGIN_C_DECLS extern "C" {
#  define END_C_DECLS   }
#else				/* !__cplusplus */
#  define BEGIN_C_DECLS
#  define END_C_DECLS
#endif				/* __cplusplus */

BEGIN_C_DECLS

/****d* OpenSM: osm_file_ids_enum
* NAME
*	osm_file_ids_enum
*
* DESCRIPTION
*	Enumerates all FILE_IDs used for logging support.
*
* SYNOPSIS
*/
typedef enum _osm_file_ids_enum {
	OSM_FILE_MAIN_C = 0x00,
	OSM_FILE_CONSOLE_C = 0x01,
	OSM_FILE_CONSOLE_IO_C = 0x02,
	OSM_FILE_DB_FILES_C = 0x03,
	OSM_FILE_DB_PACK_C = 0x04,
	OSM_FILE_DROP_MGR_C = 0x05,
	OSM_FILE_DUMP_C = 0x06,
	OSM_FILE_EVENT_PLUGIN_C = 0x07,
	OSM_FILE_GUID_INFO_RCV_C = 0x08,
	OSM_FILE_GUID_MGR_C = 0x09,
	OSM_FILE_HELPER_C = 0x0A,
	OSM_FILE_INFORM_C = 0x0B,
	OSM_FILE_LID_MGR_C = 0x0C,
	OSM_FILE_LIN_FWD_RCV_C = 0x0D,
	OSM_FILE_LINK_MGR_C = 0x0E,
	OSM_FILE_LOG_C = 0x0F,
	OSM_FILE_MAD_POOL_C = 0x10,
	OSM_FILE_MCAST_FWD_RCV_C = 0x11,
	OSM_FILE_MCAST_MGR_C = 0x12,
	OSM_FILE_MCAST_TBL_C = 0x13,
	OSM_FILE_MCM_PORT_C = 0x14,
	OSM_FILE_MESH_C = 0x15,
	OSM_FILE_MLNX_EXT_PORT_INFO_RCV_C = 0x16,
	OSM_FILE_MTREE_C = 0x17,
	OSM_FILE_MULTICAST_C = 0x18,
	OSM_FILE_NODE_C = 0x19,
	OSM_FILE_NODE_DESC_RCV_C = 0x1A,
	OSM_FILE_NODE_INFO_RCV_C = 0x1B,
	OSM_FILE_OPENSM_C = 0x1C,
	OSM_FILE_PERFMGR_C = 0x1D,
	OSM_FILE_PERFMGR_DB_C = 0x1E,
	OSM_FILE_PKEY_C = 0x1F,
	OSM_FILE_PKEY_MGR_C = 0x20,
	OSM_FILE_PKEY_RCV_C = 0x21,
	OSM_FILE_PORT_C = 0x22,
	OSM_FILE_PORT_INFO_RCV_C = 0x23,
	OSM_FILE_PRTN_C = 0x24,
	OSM_FILE_PRTN_CONFIG_C = 0x25,
	OSM_FILE_QOS_C = 0x26,
	OSM_FILE_QOS_PARSER_L_L = 0x27,
	OSM_FILE_QOS_PARSER_Y_Y = 0x28,
	OSM_FILE_QOS_POLICY_C = 0x29,
	OSM_FILE_REMOTE_SM_C = 0x2A,
	OSM_FILE_REQ_C = 0x2B,
	OSM_FILE_RESP_C = 0x2C,
	OSM_FILE_ROUTER_C = 0x2D,
	OSM_FILE_SA_C = 0x2E,
	OSM_FILE_SA_CLASS_PORT_INFO_C = 0x2F,
	OSM_FILE_SA_GUIDINFO_RECORD_C = 0x30,
	OSM_FILE_SA_INFORMINFO_C = 0x31,
	OSM_FILE_SA_LFT_RECORD_C = 0x32,
	OSM_FILE_SA_LINK_RECORD_C = 0x33,
	OSM_FILE_SA_MAD_CTRL_C = 0x34,
	OSM_FILE_SA_MCMEMBER_RECORD_C = 0x35,
	OSM_FILE_SA_MFT_RECORD_C = 0x36,
	OSM_FILE_SA_MULTIPATH_RECORD_C = 0x37,
	OSM_FILE_SA_NODE_RECORD_C = 0x38,
	OSM_FILE_SA_PATH_RECORD_C = 0x39,
	OSM_FILE_SA_PKEY_RECORD_C = 0x3A,
	OSM_FILE_SA_PORTINFO_RECORD_C = 0x3B,
	OSM_FILE_SA_SERVICE_RECORD_C = 0x3C,
	OSM_FILE_SA_SLVL_RECORD_C = 0x3D,
	OSM_FILE_SA_SMINFO_RECORD_C = 0x3E,
	OSM_FILE_SA_SW_INFO_RECORD_C = 0x3F,
	OSM_FILE_SA_VLARB_RECORD_C = 0x40,
	OSM_FILE_SERVICE_C = 0x41,
	OSM_FILE_SLVL_MAP_RCV_C = 0x42,
	OSM_FILE_SM_C = 0x43,
	OSM_FILE_SMINFO_RCV_C = 0x44,
	OSM_FILE_SM_MAD_CTRL_C = 0x45,
	OSM_FILE_SM_STATE_MGR_C = 0x46,
	OSM_FILE_STATE_MGR_C = 0x47,
	OSM_FILE_SUBNET_C = 0x48,
	OSM_FILE_SW_INFO_RCV_C = 0x49,
	OSM_FILE_SWITCH_C = 0x4A,
	OSM_FILE_TORUS_C = 0x4B,
	OSM_FILE_TRAP_RCV_C = 0x4C,
	OSM_FILE_UCAST_CACHE_C = 0x4D,
	OSM_FILE_UCAST_DNUP_C = 0x4E,
	OSM_FILE_UCAST_FILE_C = 0x4F,
	OSM_FILE_UCAST_FTREE_C = 0x50,
	OSM_FILE_UCAST_LASH_C = 0x51,
	OSM_FILE_UCAST_MGR_C = 0x52,
	OSM_FILE_UCAST_UPDN_C = 0x53,
	OSM_FILE_VENDOR_IBUMAD_C = 0x54,
	OSM_FILE_VL15INTF_C = 0x55,
	OSM_FILE_VL_ARB_RCV_C = 0x56,
	OSM_FILE_ST_C = 0x57,
	OSM_FILE_UCAST_DFSSSP_C = 0x58,
	OSM_FILE_CONGESTION_CONTROL_C = 0x59,
	OSM_FILE_INFORM_MGR_C = 0x5A,
	OSM_FILE_UNHEALTHY_PORTS_C = 0x5B,
	OSM_FILE_RCH_MGR_C = 0x5C,
	OSM_FILE_PORT_GRP_MGR_C = 0x5D,
	OSM_FILE_RCH_PARSER_L_L = 0x5E,
	OSM_FILE_RCH_PARSER_Y_Y = 0x5F,
	OSM_FILE_PORT_GRP_PARSER_L_L = 0x60,
	OSM_FILE_PORT_GRP_PARSER_Y_Y = 0x61,
	OSM_FILE_TOPO_MGR_C = 0x62,
	OSM_FILE_TOPO_PARSER_L_L = 0x63,
	OSM_FILE_TOPO_PARSER_Y_Y = 0x64,
	OSM_FILE_PQFT_C = 0x65,
	OSM_FILE_VPORT_C = 0x66,
	OSM_FILE_VPORT_INFO_RCV_C = 0x67,
	OSM_FILE_VIRTUALIZATION_INFO_RCV_C = 0x68,
	OSM_FILE_VPORT_STATE_RCV_C = 0x69,
	OSM_FILE_GENERAL_INFO_RCV_C = 0x6A,
	OSM_FILE_VIRT_MGR_C = 0x6B,
	OSM_FILE_VNODE_INFO_RCV_C = 0x6C,
	OSM_FILE_VPKEY_RCV_C = 0x6D,
	OSM_FILE_VNODE_DESC_RCV_C = 0x6E,
	OSM_FILE_ROUTER_INFO_RCV_C = 0x6F,
	OSM_FILE_ROUTER_MGR_C = 0x70,
	OSM_FILE_ROUTER_TABLE_RCV_C = 0x71,
	OSM_FILE_ROUTER_NH_TABLE_RCV_C = 0x72,
	OSM_FILE_ROUTER_PARSER_L_L = 0x73,
	OSM_FILE_ROUTER_PARSER_Y_Y = 0x74,
	OSM_FILE_ROUTER_POLICY_C = 0x75,
	OSM_FILE_VERBOSE_BYPASS_C = 0x76,
	OSM_FILE_LOG_BYPASS_PARSER_L_L = 0x77,
	OSM_FILE_LOG_BYPASS_PARSER_Y_Y = 0x78,
	OSM_FILE_UCAST_DOR_C = 0x79,
	OSM_FILE_VLID_MGR_C = 0x7A,
	OSM_FILE_CAPABILITY_MGR_C = 0x7B,
	OSM_FILE_ACT_MGR_C = 0x7C,
	OSM_FILE_ENH_QOS_MGR_C = 0x7D,
	OSM_FILE_QOS_CONFIG_SL_RCV_C = 0x7E,
	OSM_FILE_AN2AN_C = 0x7F,
	OSM_FILE_SW_PORT_STATE_RCV_C = 0x80,
	OSM_FILE_ADVANCED_ROUTING_C = 0x81,
	OSM_FILE_AR_MAD_RCV_C = 0x82,
	OSM_FILE_RN_MAD_RCV_C = 0x83,
	OSM_FILE_UCAST_ARMGR_CPP = 0x84,
	OSM_FILE_ARMGR_CPP = 0x85,
	OSM_FILE_PARALLEL_PORT_GROUPS_CALCULATOR_CPP = 0x86,
	OSM_FILE_THREAD_POOL_CPP = 0x87,
	OSM_FILE_PLFT_MAD_RCV_C = 0x88,
	OSM_FILE_MLNX_EXT_NODE_INFO_RCV_C = 0x89,
	OSM_FILE_DFP_CPP = 0x8A,
	OSM_FILE_SA_SECURITY_REPORT_C = 0x8B,
	OSM_FILE_DFMGR_CPP = 0x8C,
	OSM_FILE_CC_PARSER_L_L = 0x8D,
	OSM_FILE_CC_PARSER_Y_Y = 0x8E,
	OSM_FILE_AR_SW_DB_ENTRY_CPP = 0x8F,
	OSM_FILE_AR_ALGORITHM_CPP = 0x90,
	OSM_FILE_AR_PLFT_BASED_ALGORITHM_CPP = 0x91,
	OSM_FILE_AR_KDOR_ALGORITHM_CPP = 0x92,
	OSM_FILE_AR_ENGINES_CPP = 0x93,
	OSM_FILE_AR_DFP_ALGORITHM_CPP = 0x94,
	OSM_FILE_CALCULATE_PORT_GROUPS_TASK_CPP = 0x95,
	OSM_FILE_MAX_FLOW_ALGORITHM_C = 0x96,
	OSM_FILE_KEY_MGR_C = 0x97,
	OSM_FILE_VENDOR_SPECIFIC_C = 0x98,
	OSM_FILE_DEVICE_CONF_PARSER_L_L = 0x99,
	OSM_FILE_DEVICE_CONF_PARSER_Y_Y = 0x9A,
	OSM_FILE_ROOT_DETECTION_C = 0x9B,
	OSM_FILE_N2N_C = 0x9C,
	OSM_FILE_UCAST_AUTO_C = 0x9D,
	OSM_FILE_CC_ALGO_PARSER_L_L = 0x9E,
	OSM_FILE_CC_ALGO_PARSER_Y_Y = 0x9F,
	OSM_FILE_HIERARCHY_INFO_C = 0xA0,
	OSM_FILE_FAST_RECOVERY_PARSER_L_L = 0xA1,
	OSM_FILE_FAST_RECOVERY_PARSER_Y_Y = 0xA2,
	OSM_FILE_PROFILES_CONFIG_RCV_C = 0xA3,
	OSM_FILE_FAST_RECOVERY_MAD_RCV_C = 0xA4,
	OSM_FILE_PLUGIN_C = 0xA5,
	OSM_FILE_SUBSCRIBER_C = 0xA6,
	OSM_FILE_FAST_RECOVERY_C = 0xA7,
	OSM_FILE_GPU_C = 0xA8,
	OSM_FILE_ROUTING_C = 0xA9,
	OSM_FILE_UCAST_MINHOP_C = 0xAA,
	OSM_FILE_NVLINK_C = 0xAB,
	OSM_FILE_NVLINK_MAD_RCV_C = 0xAC,
	OSM_FILE_RAIL_FILTER_CONFIG_RCV_C = 0xAD,
	OSM_FILE_TENANT_MGR_C = 0xAE,
	OSM_FILE_TENANT_PARSER_L_L = 0xAF,
	OSM_FILE_TENANT_PARSER_Y_Y = 0xB0,
	OSM_FILE_UCAST_ASYMTREE_C = 0xB1,
	OSM_FILE_MADS_ENGINE_C = 0xB2,
	OSM_FILE_PLANARIZED_MAD_RCV_C = 0xB3,
	OSM_FILE_PLANARIZED_C = 0xB4,
	OSM_FILE_EXTENDED_SWITCH_INFO_RCV_C = 0xB5,
	OSM_FILE_FABRIC_MODE_C = 0xB6,
	OSM_FILE_FABRIC_MODE_PARSER_L_L = 0xB7,
	OSM_FILE_FABRIC_MODE_PARSER_Y_Y = 0xB8,
	OSM_FILE_ISSU_MGR_C = 0xB9,
	OSM_FILE_CHASSIS_INFO_C = 0xBA,
	OSM_FILE_NVLINK_PRTN_C = 0xBB,
} osm_file_ids_enum;

/***********/

END_C_DECLS
#endif				/* _OSM_FILE_ID_H_ */
